<?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * Generates and displays a metabox tab that consists of collapsible sections.
 */
class WPSEO_Metabox_Collapsibles_Sections extends WPSEO_Abstract_Metabox_Tab_With_Sections {

	/**
	 * Holds the tab's collapsibles.
	 *
	 * @var WPSEO_Metabox_Collapsible[]
	 */
	private $collapsibles = [];

	/**
	 * Constructor.
	 *
	 * @param string $name         The name of the section, used as an identifier in the html.
	 *                             Can only contain URL safe characters.
	 * @param string $link_content The text content of the section link.
	 * @param array  $collapsibles The metabox collapsibles (`WPSEO_Metabox_Collapsible[]`) to be included in the section.
	 * @param array  $options      Optional link attributes.
	 */
	public function __construct( $name, $link_content, array $collapsibles = [], array $options = [] ) {
		parent::__construct( $name, $link_content, $options );

		$this->collapsibles = $collapsibles;
	}

	/**
	 * Outputs the section content if any tab has been added.
	 *
	 * @return void
	 */
	public function display_content() {
		if ( $this->has_sections() ) {
			printf( '<div id="%1$s" class="wpseo-meta-section">', esc_attr( 'wpseo-meta-section-' . $this->name ) );
			echo '<div class="wpseo_content_wrapper">';

			add_filter( 'wp_kses_allowed_html', [ 'WPSEO_Utils', 'extend_kses_post_with_forms' ] );
			add_filter( 'wp_kses_allowed_html', [ 'WPSEO_Utils', 'extend_kses_post_with_a11y' ] );
			foreach ( $this->collapsibles as $collapsible ) {
				echo wp_kses_post( $collapsible->content() );
			}
			remove_filter( 'wp_kses_allowed_html', [ 'WPSEO_Utils', 'extend_kses_post_with_forms' ] );
			remove_filter( 'wp_kses_allowed_html', [ 'WPSEO_Utils', 'extend_kses_post_with_a11y' ] );

			echo '</div></div>';
		}
	}

	/**
	 * Checks whether the tab has any sections.
	 *
	 * @return bool Whether the tab has any sections
	 */
	protected function has_sections() {
		return ! empty( $this->collapsibles );
	}
}
                           plugins/wordpress-seo-extended/admin/metabox/class-metabox-editor.php                               0000644                 00000004415 15122266555 0022142 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin\Metabox
 */

/**
 * Handles all things with the metabox in combination with the WordPress editor.
 */
class WPSEO_Metabox_Editor {

	/**
	 * Registers hooks to WordPress.
	 *
	 * @codeCoverageIgnore
	 *
	 * @return void
	 */
	public function register_hooks() {
		// For the Classic editor.
		add_filter( 'mce_css', [ $this, 'add_css_inside_editor' ] );
		// For the Block/Gutenberg editor.
		// See https://github.com/danielbachhuber/gutenberg-migration-guide/blob/master/filter-mce-css.md.
		add_action( 'enqueue_block_editor_assets', [ $this, 'add_editor_styles' ] );

		add_filter( 'tiny_mce_before_init', [ $this, 'add_custom_element' ] );
	}

	/**
	 * Adds our inside the editor CSS file to the list of CSS files to be loaded inside the editor.
	 *
	 * @param string $css_files The CSS files that WordPress wants to load inside the editor.
	 * @return string The CSS files WordPress wants to load and our CSS file.
	 */
	public function add_css_inside_editor( $css_files ) {
		$asset_manager = new WPSEO_Admin_Asset_Manager();
		$styles        = $asset_manager->special_styles();
		$inside_editor = $styles['inside-editor'];

		$asset_location = new WPSEO_Admin_Asset_SEO_Location( WPSEO_FILE );
		$url            = $asset_location->get_url( $inside_editor, WPSEO_Admin_Asset::TYPE_CSS );

		if ( $css_files === '' ) {
			$css_files = $url;
		}
		else {
			$css_files .= ',' . $url;
		}

		return $css_files;
	}

	/**
	 * Enqueues the CSS to use in the TinyMCE editor.
	 *
	 * @return void
	 */
	public function add_editor_styles() {
		$asset_manager = new WPSEO_Admin_Asset_Manager();
		$asset_manager->enqueue_style( 'inside-editor' );
	}

	/**
	 * Adds a custom element to the tinyMCE editor that we need for marking the content.
	 *
	 * @param array $tinymce_config The tinyMCE config as configured by WordPress.
	 *
	 * @return array The new tinyMCE config with our added custom elements.
	 */
	public function add_custom_element( $tinymce_config ) {
		if ( ! empty( $tinymce_config['custom_elements'] ) ) {
			$custom_elements = $tinymce_config['custom_elements'];

			$custom_elements .= ',~yoastmark';
		}
		else {
			$custom_elements = '~yoastmark';
		}

		$tinymce_config['custom_elements'] = $custom_elements;

		return $tinymce_config;
	}
}
                                                                                                                                                                                                                                                   plugins/wordpress-seo-extended/admin/metabox/class-metabox-form-tab.php                             0000644                 00000005440 15122266555 0022362 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * Generates the HTML for a metabox tab.
 */
class WPSEO_Metabox_Form_Tab implements WPSEO_Metabox_Tab {

	/**
	 * The tab identifier.
	 *
	 * @var string
	 */
	private $name;

	/**
	 * The tab content.
	 *
	 * @var string
	 */
	private $content;

	/**
	 * The tab link content.
	 *
	 * @var string
	 */
	private $link_content;

	/**
	 * Additional tab content class.
	 *
	 * @var string
	 */
	private $tab_class;

	/**
	 * Additional tab link class.
	 *
	 * @var string
	 */
	private $link_class;

	/**
	 * Title attribute on the link span.
	 *
	 * @var string
	 */
	private $link_title;

	/**
	 * Arial label attribute on the link span.
	 *
	 * @var string
	 */
	private $link_aria_label;

	/**
	 * Does it contain a single tab.
	 *
	 * @var bool
	 */
	private $single;

	/**
	 * Constructor.
	 *
	 * @param string $name         The name of the tab, used as an identifier in the html.
	 * @param string $content      The tab content.
	 * @param string $link_content The text content of the tab link.
	 * @param array  $options      Optional link attributes.
	 */
	public function __construct( $name, $content, $link_content, array $options = [] ) {
		$default_options = [
			'tab_class'       => '',
			'link_class'      => '',
			'link_title'      => '',
			'link_aria_label' => '',
			'single'          => false,
		];

		$options = array_merge( $default_options, $options );

		$this->name            = $name;
		$this->content         = $content;
		$this->link_content    = $link_content;
		$this->tab_class       = $options['tab_class'];
		$this->link_class      = $options['link_class'];
		$this->link_title      = $options['link_title'];
		$this->link_aria_label = $options['link_aria_label'];
		$this->single          = $options['single'];
	}

	/**
	 * Returns the html for the tab link.
	 *
	 * @return string
	 */
	public function link() {

		$html = '<li class="%1$s%2$s"><a class="wpseo_tablink%3$s" href="#wpseo_%1$s"%4$s%5$s>%6$s</a></li>';

		if ( $this->single ) {
			$html = '<li class="%1$s%2$s"><span class="wpseo_tablink%3$s"%4$s%5$s>%6$s</span></li>';
		}

		return sprintf(
			$html,
			esc_attr( $this->name ),
			( $this->tab_class !== '' ) ? ' ' . esc_attr( $this->tab_class ) : '',
			( $this->link_class !== '' ) ? ' ' . esc_attr( $this->link_class ) : '',
			( $this->link_title !== '' ) ? ' title="' . esc_attr( $this->link_title ) . '"' : '',
			( $this->link_aria_label !== '' ) ? ' aria-label="' . esc_attr( $this->link_aria_label ) . '"' : '',
			$this->link_content
		);
	}

	/**
	 * Returns the html for the tab content.
	 *
	 * @return string
	 */
	public function content() {
		return sprintf(
			'<div id="%1$s" class="wpseotab %2$s">%3$s</div>',
			esc_attr( 'wpseo_' . $this->name ),
			esc_attr( $this->name ),
			$this->content
		);
	}
}
                                                                                                                                                                                                                                plugins/wordpress-seo-extended/admin/metabox/class-metabox-null-tab.php                             0000644                 00000000651 15122266555 0022370 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * Generates the HTML for a metabox tab.
 */
class WPSEO_Metabox_Null_Tab implements WPSEO_Metabox_Tab {

	/**
	 * Returns the html for the tab link.
	 *
	 * @return string|null
	 */
	public function link() {
		return null;
	}

	/**
	 * Returns the html for the tab content.
	 *
	 * @return string|null
	 */
	public function content() {
		return null;
	}
}
                                                                                       plugins/wordpress-seo-extended/admin/metabox/class-metabox.php                                      0000644                 00000124110 15122266555 0020651 0                                                                                                    ustar 00                             