<?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin
 */

/**
 * Base class for metabox that consist of multiple sections.
 */
abstract class WPSEO_Abstract_Metabox_Tab_With_Sections implements WPSEO_Metabox_Section {

	/**
	 * Holds the name of the tab.
	 *
	 * @var string
	 */
	public $name;

	/**
	 * Holds the HTML of the tab header.
	 *
	 * @var string
	 */
	protected $link_content;

	/**
	 * Holds the name of the tab header.
	 *
	 * @var string
	 */
	protected $link_title;

	/**
	 * Holds the classname of the tab header.
	 *
	 * @var string
	 */
	protected $link_class;

	/**
	 * Holds the aria label of the tab header.
	 *
	 * @var string
	 */
	protected $link_aria_label;

	/**
	 * Constructor.
	 *
	 * @param string $name         The name of the section, used as an identifier in the html.
	 *                             Can only contain URL safe characters.
	 * @param string $link_content The text content of the section link.
	 * @param array  $options      Optional link attributes.
	 */
	public function __construct( $name, $link_content, array $options = [] ) {
		$default_options = [
			'link_title'      => '',
			'link_class'      => '',
			'link_aria_label' => '',
		];

		$options = array_merge( $default_options, $options );

		$this->name = $name;

		$this->link_content    = $link_content;
		$this->link_title      = $options['link_title'];
		$this->link_class      = $options['link_class'];
		$this->link_aria_label = $options['link_aria_label'];
	}

	/**
	 * Outputs the section link if any section has been added.
	 *
	 * @return void
	 */
	public function display_link() {
		if ( $this->has_sections() ) {
			printf(
				'<li role="presentation"><a role="tab" href="#wpseo-meta-section-%1$s" id="wpseo-meta-tab-%1$s" aria-controls="wpseo-meta-section-%1$s" class="wpseo-meta-section-link %2$s"%3$s%4$s>%5$s</a></li>',
				esc_attr( $this->name ),
				esc_attr( $this->link_class ),
				( $this->link_title !== '' ) ? ' title="' . esc_attr( $this->link_title ) . '"' : '',
				( $this->link_aria_label !== '' ) ? ' aria-label="' . esc_attr( $this->link_aria_label ) . '"' : '',
				$this->link_content
			);
		}
	}

	/**
	 * Checks whether the tab has any sections.
	 *
	 * @return bool Whether the tab has any sections
	 */
	abstract protected function has_sections();
}
                                                                                                                                                                                                                                                          plugins/wordpress-seo-extended/admin/metabox/class-metabox-analysis-inclusive-language.php          0000644                 00000003670 15122266555 0026261 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin\Metabox
 */

/**
 * Represents the inclusive language analysis.
 */
class WPSEO_Metabox_Analysis_Inclusive_Language implements WPSEO_Metabox_Analysis {

	/**
	 * Whether this analysis is enabled.
	 *
	 * @return bool Whether or not this analysis is enabled.
	 */
	public function is_enabled() {
		return $this->is_globally_enabled() && $this->is_user_enabled() && $this->is_current_version_supported()
				&& YoastSEO()->helpers->language->has_inclusive_language_support( WPSEO_Language_Utils::get_language( get_locale() ) );
	}

	/**
	 * Whether or not this analysis is enabled by the user.
	 *
	 * @return bool Whether or not this analysis is enabled by the user.
	 */
	public function is_user_enabled() {
		return ! get_the_author_meta( 'wpseo_inclusive_language_analysis_disable', get_current_user_id() );
	}

	/**
	 * Whether or not this analysis is enabled globally.
	 *
	 * @return bool Whether or not this analysis is enabled globally.
	 */
	public function is_globally_enabled() {
		return WPSEO_Options::get( 'inclusive_language_analysis_active', false );
	}

	/**
	 * Whether the inclusive language analysis should be loaded in Free.
	 *
	 * It should always be loaded when Premium is not active. If Premium is active, it depends on the version. Some Premium
	 * versions also have inclusive language code (when it was still a Premium only feature) which would result in rendering
	 * the analysis twice. In those cases, the analysis should be only loaded from the Premium side.
	 *
	 * @return bool Whether or not the inclusive language analysis should be loaded.
	 */
	private function is_current_version_supported() {
		$is_premium      = YoastSEO()->helpers->product->is_premium();
		$premium_version = YoastSEO()->helpers->product->get_premium_version();

		return ! $is_premium
			|| version_compare( $premium_version, '19.6-RC0', '>=' )
			|| version_compare( $premium_version, '19.2', '==' );
	}
}
                                                                        plugins/wordpress-seo-extended/admin/metabox/class-metabox-analysis-readability.php                 0000644                 00000001641 15122266555 0024764 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin\Metabox
 */

/**
 * Represents the readability analysis.
 */
class WPSEO_Metabox_Analysis_Readability implements WPSEO_Metabox_Analysis {

	/**
	 * Whether this analysis is enabled.
	 *
	 * @return bool Whether or not this analysis is enabled.
	 */
	public function is_enabled() {
		return $this->is_globally_enabled() && $this->is_user_enabled();
	}

	/**
	 * Whether or not this analysis is enabled by the user.
	 *
	 * @return bool Whether or not this analysis is enabled by the user.
	 */
	public function is_user_enabled() {
		return ! get_the_author_meta( 'wpseo_content_analysis_disable', get_current_user_id() );
	}

	/**
	 * Whether or not this analysis is enabled globally.
	 *
	 * @return bool Whether or not this analysis is en