<?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin\Menu
 */

/**
 * Renders a replacement variable editor.
 */
class WPSEO_Replacevar_Editor {

	/**
	 * Yoast Forms instance.
	 *
	 * @var Yoast_Form
	 */
	private $yform;

	/**
	 * The arguments required for the div to render.
	 *
	 * @var array {
	 *      @type string $title                   The title field id.
	 *      @type string $description             The description field id.
	 *      @type string $page_type_recommended   The page type for the context of the recommended replace vars.
	 *      @type string $page_type_specific      The page type for the context of the editor specific replace vars.
	 *      @type bool   $paper_style             Optional. Whether the editor has paper style.
	 *      @type string $label_title             Optional. The label to use for the title field.
	 *      @type string $label_description       Optional. The label to use for the description field.
	 *      @type string $description_placeholder Optional. The placeholder text to use for the description field.
	 *      @type bool   $has_new_badge           Optional. Whether to show the "New" badge.
	 *      @type bool   $has_premium_badge       Optional. Whether to show the "Premium" badge.
	 * }
	 */
	private $arguments;

	/**
	 * Constructs the object.
	 *
	 * @param Yoast_Form $yform     Yoast forms.
	 * @param array      $arguments {
	 *      The arguments that can be given.
	 *
	 *      @type string $title                   The title field id.
	 *      @type string $description             The description field id.
	 *      @type string $page_type_recommended   The page type for the context of the recommended replace vars.
	 *      @type string $page_type_specific      The page type for the context of the editor specific replace vars.
	 *      @type bool   $paper_style             Optional. Whether the editor has paper style.
	 *      @type string $label_title             Optional. The label to use for the title field.
	 *      @type string $label_description       Optional. The label to use for the description field.
	 *      @type string $description_placeholder Optional. The placeholder text to use for the description field.
	 *      @type bool   $has_new_badge           Optional. Whether to show the "New" badge.
	 *      @type bool   $has_premium_badge       Optional. Whether to show the "Premium" badge.
	 * }
	 */
	public function __construct( Yoast_Form $yform, $arguments ) {
		$arguments = wp_parse_args(
			$arguments,
			[
				'paper_style'             => true,
				'label_title'             => '',
				'label_description'       => '',
				'description_placeholder' => '',
				'has_new_badge'           => false,
				'is_disabled'             => false,
				'has_premium_badge'       => false,
			]
		);

		$this->validate_arguments( $arguments );

		$this->yform     = $yform;
		$this->arguments = [
			'title'                   => (string) $arguments['title'],
			'description'             => (string) $arguments['description'],
			'page_type_recommended'   => (string) $arguments['page_type_recommended'],
			'page_type_specific'      => (string) $arguments['page_type_specific'],
			'paper_style'             => (bool) $arguments['paper_style'],
			'label_title'             => (string) $arguments['label_title'],
			'label_description'       => (string) $arguments['label_description'],
			'description_placeholder' => (string) $arguments['description_placeholder'],
			'has_new_badge'           => (bool) $arguments['has_new_badge'],
			'is_disabled'             => (bool) $arguments['is_disabled'],
			'has_premium_badge'       => (bool) $arguments['has_premium_badge'],
		];
	}

	/**
	 * Renders a div for the react application to mount to, and hidden inputs where
	 * the app should store it's value so they will be properly saved when the form
	 * is submitted.
	 *
	 * @return void
	 */
	public function render() {
		$this->yform->hidden( $this->arguments['title'], $this->arguments['title'] );
		$this->yform->hidden( $this->arguments['description'], $this->arguments['description'] );

		printf(
			'<div
				data-react-replacevar-editor
				data-react-replacevar-title-field-id="%1$s"
				data-react-replacevar-metadesc-field-id="%2$s"
				data-react-replacevar-page-type-recommended="%3$s"
				data-react-replacevar-page-type-specific="%4$s"
				data-react-replacevar-paper-style="%5$s"
				data-react-replacevar-label-title="%6$s"
				data-react-replacevar-label-description="%7$s"
				data-react-replacevar-description-placeholder="%8$s"
				data-react-replacevar-has-new-badge="%9$s"
				data-react-replacevar-is-disabled="%10$s"
				data-react-replacevar-has-premium-badge="%11$s"
			></div>',
			esc_attr( $this->arguments['title'] ),
			esc_attr( $this->arguments['description'] ),
			esc_attr( $this->arguments['page_type_recommended'] ),
			esc_attr( $this->arguments['page_type_specific'] ),
			esc_attr( $this->arguments['paper_style'] ),
			esc_attr( $this->arguments['label_title'] ),
			esc_attr( $this->arguments['label_description'] ),
			esc_attr( $this->arguments['description_placeholder'] ),
			esc_attr( $this->arguments['has_new_badge'] ),
			esc_attr( $this->arguments['is_disabled'] ),
			esc_attr( $this->arguments['has_premium_badge'] )
		);
	}

	/**
	 * Validates the replacement variable editor arguments.
	 *
	 * @param array $arguments The arguments to validate.
	 *
	 * @throws InvalidArgumentException Thrown when not all required arguments are present.
	 *
	 * @return void
	 */
	protected function validate_arguments( array $arguments ) {
		$required_arguments = [
			'title',
			'description',
			'page_type_recommended',
			'page_type_specific',
			'paper_style',
		];

		foreach ( $required_arguments as $field_name ) {
			if ( ! array_key_exists( $field_name, $arguments ) ) {
				throw new InvalidArgumentException(
					sprintf(
						/* translators: %1$s expands to the missing field name.  */
						__( 'Not all required fields are given. Missing field %1$s', 'wordpress-seo' ),
						$field_name
					)
				);
			}
		}
	}
}
                                                              plugins/wordpress-seo-extended/admin/menu/class-replacevar-field.php                                0000644                 00000004167 15122266554 0021734 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin\Menu
 */

/**
 * Renders a single replacement variable field.
 */
class WPSEO_Replacevar_Field {

	/**
	 * Forms instance.
	 *
	 * @var Yoast_Form Yoast
	 */
	private $yform;

	/**
	 * The id for the hidden field.
	 *
	 * @var string
	 */
	private $field_id;

	/**
	 * The label for the field.
	 *
	 * @var string
	 */
	private $label;

	/**
	 * The page type for the context of the recommended replace vars.
	 *
	 * @var string
	 */
	private $page_type_recommended;

	/**
	 * The page type for the context of the editor specific replace vars.
	 *
	 * @var string
	 */
	private $page_type_specific;

	/**
	 * Constructs the object.
	 *
	 * @param Yoast_Form $yform                 Yoast forms.
	 * @param string     $field_id              The field id.
	 * @param string     $label                 The field label.
	 * @param string     $page_type_recommended The page type for the context of the recommended replace vars.
	 * @param string     $page_type_specific    The page type for the context of the editor specific replace vars.
	 */
	public function __construct( Yoast_Form $yform, $field_id, $label, $page_type_recommended, $page_type_specific ) {
		$this->yform                 = $yform;
		$this->field_id              = $field_id;
		$this->label                 = $label;
		$this->page_type_recommended = $page_type_recommended;
		$this->page_type_specific    = $page_type_specific;
	}

	/**
	 * Renders a div for the react application to mount to, and hidden inputs where
	 * the app should store it's value so they will be properly saved when the form
	 * is submitted.
	 *
	 * @return void
	 */
	public function render() {
		$this->yform->hidden( $this->field_id, $this->field_id );

		printf(
			'<div
				data-react-replacevar-field
				data-react-replacevar-field-id="%1$s"
				data-react-replacevar-field-label="%2$s"
				data-react-replacevar-page-type-recommended="%3$s"
				data-react-replacevar-page-type-specific="%4$s"></div>',
			esc_attr( $this->field_id ),
			esc_attr( $this->label ),
			esc_attr( $this->page_type_recommended ),
			esc_attr( $this->page_type_specific )
		);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                         plugins/wordpress-seo-extended/admin/menu/class-submenu-capability-normalize.php                    0000644                 00000001770 15122266554 0024317 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       <?php
/**
 * WPSEO plugin file.
 *
 * @package WPSEO\Admin\Menu
 */

/**
 * Normalize submenu capabilities to `wpseo_manage_options`.
 */
class WPSEO_Submenu_Capability_Normalize implements WPSEO_WordPress_Integration {

	/**
	 * Registers all hooks to WordPress.
	 *
	 * @return void
	 */
	public function register_hooks() {
		add_filter( 'wpseo_submenu_pages', [ $this, 'normalize_submenus_capability' ] );
	}

	/**
	 * Normalizes any `manage_options` to `wpseo_manage_options`.
	 *
	 * This is needed as the module plugins are not updated with the new capabilities directly,
	 * but they should not be shown as main menu items.
	 *
	 * @param array $submenu_pages List of subpages to convert.
	 *
	 * @return array Converted subpages.
	 */
	public function normalize_submenus_capability( $submenu_pages ) {
		foreach ( $submenu