                 'data' => array_keys( $this->imports[ $template ] ),
                );
            endif;
        endif;
        // break into @ segments
        foreach ( array(
            '#(\@media[^\{]+?)\{(\s*?)\}#', // get any placehoder (empty) media queries
            '#(\@media[^\{]+?)\{(.*?\})?\s*?\}#s', // get all other media queries
        ) as $regex ): // (((?!\@media).) backreference too memory intensive - rolled back in v 1.4.8.1
            preg_match_all( $regex, $this->styles, $matches );
            foreach ( $matches[ 1 ] as $segment ):
                $segment = $this->normalize_query( $segment );
                $ruleset[ $segment ] = array_shift( $matches[ 2 ] ) 
                    . ( isset( $ruleset[ $segment ] ) ?
                        $ruleset[ $segment ] : '' );
            endforeach;
            // stripping rulesets leaves base styles
            $this->styles = preg_replace( $regex, '', $this->styles );
        endforeach;
        $ruleset[ $basequery ] = $this->styles;
        $qsid = NULL;
        foreach ( $ruleset as $query => $segment ):
            // make sure there is a newline before the first selector
            $segment = LF . $segment;
            // make sure there is semicolon before closing brace
            $segment = preg_replace( '#(\})#', ";$1", $segment );
            // parses selectors and corresponding rules
            $regex = '#\n\s*([\[\.\#\:\w][\w\-\s\(\)\[\]\'\^\*\.\#\+\~:,"=>]+?)\s*\{(.*?)\}#s';  //[^\{] may be to expensive
            preg_match_all( $regex, $segment, $matches );
            foreach( $matches[ 1 ] as $sel ):
                $stuff  = array_shift( $matches[ 2 ] );
                $this->update_arrays(
                    'child' == $template ? 'c' : 'p',
                    $query,
                    $sel
                );
                // handle base64 data
                $stuff = preg_replace( '#data:([^;]+?);([^\)]+?)\)#s', "data:$1%%semi%%$2)", $stuff );
                // rule semaphore makes sure rules are only reset the first time they appear
                $resetrule = array(); 
                foreach ( explode( ';', $stuff ) as $ruleval ):
                    if ( FALSE === strpos( $ruleval, ':' ) ) continue;
                    list( $rule, $value ) = explode( ':', $ruleval, 2 );
                    $rule   = trim( $rule );
                    $rule   = preg_replace_callback( "/[^\w\-]/", array( $this, 'to_ascii' ), $rule );
                    // handle base64 data
                    $value  = trim( str_replace( '%%semi%%', ';', $value ) );
                    
                    $rules = $values = array();
                    // save important flag
                    $important = $this->is_important( $value );
                    // normalize color
                    $value = $this->normalize_color( $value );
                    // normalize font
                    if ( 'font' == $rule ):
                        $this->normalize_font( $value, $rules, $values );
                    // normalize background
                    elseif( 'background' == $rule ):
                        $this->normalize_background( $value, $rules, $values );
                    // normalize margin/padding
                    elseif ( 'margin' == $rule || 'padding' == $rule ):
                        $this->normalize_margin_padding( $rule, $value, $rules, $values );
                    else:
                        $rules[]    = $rule;
                        $values[]   = $value;
                    endif;
                    foreach ( $rules as $rule ):
                        $value = trim( array_shift( $values ) );
                        // normalize zero values
                        $value = preg_replace( '#\b0(px|r?em)#', '0', $value );
                        // normalize gradients
                        if ( FALSE !== strpos( $value, 'gradient' ) ):
                            if ( FALSE !== strpos( $rule, 'filter' ) ):
                                // treat as background-image, we'll add filter rule later
                                $rule = 'background-image';
                                continue; 
                            endif;
                            if ( FALSE !== strpos( $value, 'webkit-gradient' ) ) continue; // bail on legacy webkit, we'll add it later
                            $value = $this->encode_gradient( $value );
                        endif;
                        // normalize common vendor prefixes
                        $rule = preg_replace( '#(\-(o|ms|moz|webkit)\-)?(' . implode( '|', $this->vendorrule ) . ')#', "$3", $rule );
                        if ( 'parnt' == $template && 'background-image' == $rule && strstr( $value, 'url(' ) )
                            $value = $this->convert_rel_url( $value, $relpath );
                        /**
                         * The reset flag forces the values for a given property (rule) to be rewritten completely 
                         * when using the raw CSS input or when reading from a stylesheet.
                         * This permits complete blocks of style data to be entered verbatim, replacing existing styles.
                         * When entering individual values from the Query/Selector inputs, multiple fallback values for existing 
                         * properties can be added in the order they are entered (e.g., margin: 1rem; margin: 1em;)
                         */
                        if ( !$reset ) $resetrule[ $rule ] = TRUE; 
                        
                        $qsid = $this->update_arrays( 
                            'child' == $template ? 'c' : 'p',
                            $query, 
                            $sel, 
                            $rule, 
                            $value, 
                            $important, 
                            NULL, // no rulevalid is passed when parsing from css (vs post input data)
                            empty( $resetrule[ $rule ] ) // if rule semaphore is TRUE, reset will be FALSE
                        );
                        $resetrule[ $rule ] = TRUE; // set rule semaphore so if same rule occurs again, it is not reset
                    endforeach;
                endforeach;
            endforeach;
        endforeach;
        // if this is a raw css update pass the last selector back to the browser to update the form
        if ( $this->ctc()->cache_updates && $qsid ):
            $this->ctc()->updates[] = array(
                'obj'   => 'qsid',
                'key'   => $qsid,
                'data'  => $this->obj_to_utf8( $this->denorm_sel_val( $qsid ) ),
            );
            do_action( 'chld_thm_cfg_update_qsid', $qsid );                
        endif;
        
    }

    // converts relative path to absolute path for preview
    function convert_rel_url( $value, $relpath, $url = TRUE  ) {
        if ( preg_match( '/data:/', $value ) ) return $value;
        $path       = preg_replace( '%url\([\'" ]*(.+?)[\'" ]*\)%', "$1", $value );
        if ( preg_match( '%(https?:)?//%', $path ) ) return $value;
        $pathparts  = explode( '/', $path );
        $fileparts  = explode( '/', $relpath );
        $newparts   = array();
        while ( $pathpart = array_shift( $pathparts ) ):
            if ( '..' == $pathpart )
                array_pop( $fileparts );
            else array_push( $newparts, sanitize_text_field( $pathpart ) );
        endwhile;
        $newvalue = ( $url ? 'url(' : '' )
            . ( $fileparts ? trailingslashit( implode( '/', $fileparts ) ) : '' ) 
            . implode( '/', $newparts ) . ( $url ? ')' : '' );
        $this->ctc()->debug( 'converted ' . $value . ' to ' . $newvalue . ' with ' . $relpath, __FUNCTION__, __CLASS__ );
        return $newvalue;
    }
    
    /**
     * write_css
     * converts normalized CSS object data into stylesheet.
     * Preserves selector sequence and !important flags of parent stylesheet.
     * @media query blocks are sorted using internal heuristics (see sort_queries)
     * New selectors are appended to the end of each media query block.
     * FIXME - this function has grown too monolithic - refactor and componentize
     */
    function write_css() {
        $output  = '';
        foreach ( $this->sort_queries() as $query => $sort_order ):
            $has_selector = 0;
            $sel_output   = '';
            $selectors = $this->denorm_dict_qs( $query, FALSE );
            uasort( $selectors, array( $this, 'cmp_seq' ) );
            if ( 'base' != $query ) $sel_output .=  $query . ' {' . LF;
            foreach ( $selectors as $selid => $qsid ):
                if ( $valarr = $this->unpack_val_ndx( $qsid ) ):
                    $sel            = $this->detokenize( $this->get_dict_value( 'sel', $selid ) );
                    $shorthand      = array();
                    $rule_output    = array();
                    foreach ( $valarr as $ruleid => $temparr ):
                        // normalize values for backward compatability
                        if ( isset( $temparr[ 'c' ] ) && 
                            ( !isset( $temparr[ 'p' ] ) || $temparr[ 'p' ] != $temparr[ 'c' ] ) ):
                            foreach ( $temparr[ 'c' ] as $rulevalarr ):
                                $this->add_vendor_rules( 
                                    $rule_output,
                                    $shorthand,
                                    $this->get_dict_value( 'rule', $ruleid ),
                                    $this->get_dict_value( 'val', $rulevalarr[ 0 ] ),
                                    $rulevalarr[ 1 ],
                                    $rulevalarr[ 2 ]
                                );
                            endforeach;
                        /**
                         * for testing
                        else:
                            foreach ( $temparr[ 'parnt' ] as $rulevalarr ):
                                $this->add_vendor_rules( 
                                    $rule_output,
                                    $shorthand,
                                    $rulearr[ $ruleid ],
                                    $valarr[ $rulevalarr[ 0 ] ],
                                    $rulevalarr[ 1 ],
                                    $rulevalarr[ 2 ]
                                );
                            endforeach;
                          */
                        endif;
                    endforeach;
                    /** FIXME ** need better way to sort rules and multiple values ***/
                    $this->encode_shorthand( $shorthand, $rule_output );
                    if ( count( $rule_output ) ):
                        // show load order -- removed in v.1.7.6 by popular demand
                        //$sel_output .= isset( $this->dict_seq[ $qsid ] )?'/*' . $this->dict_seq[ $qsid ] . '*/' . LF:''; 
                        $sel_output .= $sel . ' {' . LF . $this->stringify_rule_output( $rule_output ) . '}' . LF; 
                        $has_selector = 1;
                    endif;
                endif;
            endforeach;
            if ( 'base' != $query ) $sel_output .= '}' . LF;
            if ( $has_selector ) $output .= $sel_output;
        endforeach;
        $output = $this->get_css_header_comment( $this->get_prop( 'handling' ) ) . LF . $output;
        $stylesheet = $this->get_stylesheet_path();
        $this->ctc()->debug( 'writing stylesheet: ' . $stylesheet, __FUNCTION__, __CLASS__ );
        //echo //print_r(debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS), true) . LF;
        if ( $stylesheet_verified = $this->is_file_ok( $stylesheet, 'write' ) ):
            global $wp_filesystem; // this was initialized earlier;
            $mode = 'direct' == $this->ctc()->fs_method ? FALSE : 0666;
            // write new stylesheet:
            // try direct write first, then wp_filesystem write
            // stylesheet must already exist and be writable by web server
            if ( $this->ctc()->is_ajax && is_writable( $stylesheet_verified ) ):
                if ( FALSE === @file_put_contents( $stylesheet_verified, $output ) ): 
                    $this->ctc()->debug( 'Ajax write failed.', __FUNCTION__, __CLASS__ );
                    return FALSE;
                endif;
            elseif ( FALSE === $wp_filesystem->put_contents( $this->ctc()->fspath( $stylesheet_verified ), $output, $mode ) ):
                $this->ctc()->debug( 'Filesystem write failed.', __FUNCTION__, __CLASS__ );
                return FALSE;
            endif;
            return TRUE;
        endif;   
        return FALSE;
    }
    
    function stringify_rule_output( &$rule_output ) {
        $output = '';
        asort( $rule_output );
        foreach ( $rule_output as $rule => $sortstr )
            $output .= '    ' . $rule . ";\n";
        return $output;
    }
    
    function sortstr( $rule, $rulevalid ) {
        return substr( "0000" . $this->get_dict_id( 'rule', $rule ), -4) . substr( "00" . $rulevalid, -2 );
    }

    /**
     * encode_shorthand
     * converts CTC long syntax into CSS shorthand
     * v1.7.5 refactored for multiple values per property
     * v2.1.0 to prevent incorrect rendering, do not use shorthand if multiple values exist for any side property.
     */
    function encode_shorthand( $shorthand, &$rule_output ) {
        foreach ( $shorthand as $property => $sides ):
            if ( isset( $sides[ 'top' ] ) && 1 == count( $sides[ 'top' ] ) ):
                foreach ( $sides[ 'top' ] as $tval => $tarr ):
                    if ( isset( $sides[ 'right' ] ) && 1 == count( $sides[ 'right' ] ) ):
                        $currseq = $tarr[ 1 ];
                        foreach ( $sides[ 'right' ] as $rval => $rarr ):
                            // value must exist from side and priority must match all sides
                            if ( isset( $sides[ 'bottom' ] ) && 1 == count( $sides[ 'bottom' ] ) && $tarr[ 0 ] == $rarr[ 0 ] ):
                                if ( $rarr[ 1 ] > $currseq ) $currseq = $rarr[ 1 ];
                                foreach ( $sides[ 'bottom' ] as $bval => $barr ):
                                    if ( isset( $sides[ 'left' ] ) && 1 == count( $sides[ 'left' ] ) && $tarr[ 0 ] == $barr[ 0 ] ):
                                        // use highest sort sequence of all sides
                                        if ( $barr[ 1 ] > $currseq ) $currseq = $barr[ 1 ];
                                        foreach ( $sides[ 'left' ] as $lval => $larr ):
                                            if ( $tarr[ 0 ] != $larr[ 0 ] ) continue;
                                            if ( $larr[ 1 ] > $currseq ) $currseq = $larr[ 1 ];

                                            $combo = array(
                                                $tval,
                                                $rval,
                                                $bval,
                                                $lval,
                                            );
                                            // echo 'combo before: ' . print_r( $combo, TRUE ) . LF;
                                            // remove from shorthand array
                                            unset( $shorthand[ $property ][ 'top' ][ $tval ] );
                                            unset( $shorthand[ $property ][ 'right' ][ $rval ] );
                                            unset( $shorthand[ $property ][ 'bottom' ][ $bval ] );
                                            unset( $shorthand[ $property ][ 'left' ][ $lval ] );
                                            
                                            // combine into shorthand syntax
                                            if ( $lval === $rval ):
                                                //echo 'left same as right, popping left' . LF;
                                                array_pop( $combo );
                                                if ( $bval === $tval ):
                                                    //echo 'bottom same as top, popping bottom' . LF;
                                                    array_pop( $combo );
                                                    if ( $rval === $tval ): // && $bval === $tval ):
                                                        //echo 'right same as top, popping right' . LF;
                                                        array_pop( $combo );
                                                    endif;
                                                endif;
                                            endif;
                                            //echo 'combo after: ' . print_r