 ( $this->ctc()->cache_updates )
                $this->ctc()->updates[] = array(
                    'obj'   => 'qsid',
                    'key'   => $qsid,
                    'data'  => $this->obj_to_utf8( $this->denorm_sel_val( $qsid ) ),
                );
        
            do_action( 'chld_thm_cfg_update_qsid', $qsid );                
        endif;

        // update enqueue function if imports have not been converted or new imports passed
        if (  isset( $_POST[ 'ms_theme_child_analysis' ] )||isset( $_POST[ 'ms_child_imports' ] ) || !$this->get_prop( 'converted' ) )
            add_action( 'chld_thm_cfg_addl_files',   array( $this->ctc(), 'enqueue_parent_css' ), 15, 2 );
    }
    
    
    function update_property(
        $newquery,
        $newselector,
        $query,
        $selector, 
        $rule,
        $value,
        $important,
        $rulevalid
    ){
        // If this is a renamed selector, add new selector to data
        // otherwise update existing selector
        $newqsid = $this->update_arrays( 
            'c',
            $newquery ? $newquery : $query,
            $newselector ? $newselector : $selector,
            $rule,
            trim( $value ),
            $important,
            $rulevalid
        );
        // if query or selector have been renamed, 
        // clear the original selector's value:
        if ( $newquery || $newselector ):
            $qsid = $this->update_arrays(
                'c',
                $query,
                $selector,
                $rule,
                '',
                0,
                $rulevalid
            );
            // add new sequence entry
            $seq = $this->get_dict_value( 'seq', $qsid );
            $this->set_dict_value( 'seq', $newqsid, $seq );
        endif;
        return $newqsid;
    }
    
    /**
     * parse_css_input
     * Normalize raw user CSS input so that the parser can read it.
     */
    function parse_css_input( $styles ) {
        return $this->repl_octal( stripslashes( $this->esc_octal( $styles ) ) );
    }
    
    // strips non printables and potential commands
    function sanitize( $styles ) {
        return sanitize_text_field( preg_replace( '/[^[:print:]]|[\{\}].*/', '', $styles ) );
    }
    
    // escapes octal values in input to allow for specific ascii strings in content rule
    function esc_octal( $styles ){
        return preg_replace( "#(['\"])\\\\([0-9a-f]{4})(['\"])#i", "$1##bs##$2$3", $styles );
    }
    
    // unescapes octal values for writing specific ascii strings in content rule
    function repl_octal( $styles ) {
        return str_replace( "##bs##", "\\", $styles );
    }
    
    /**
     * parse_css_file
     * reads stylesheet to get WordPress meta data and passes rest to parse_css 
     */
    function parse_css_file( $template, $file = 'style.css', $cfgtemplate = FALSE ) {
        if ( '' == $file ) $file = 'style.css';
        
        $this->ctc()->cache_updates = FALSE;
        $this->styles = ''; // reset styles
        $this->read_stylesheet( $template, $file );
        // get theme name
        $regex = '#Theme Name:\s*(.+?)\n#i';
        preg_match( $regex, $this->styles, $matches );
        $child_name = $this->get_prop( 'child_name' );
        if ( !empty( $matches[ 1 ] ) && 'child' == $template && empty( $child_name ) ) $this->set_prop( 'child_name', $matches[ 1 ] );
        $this->parse_css( 
            $cfgtemplate ? $cfgtemplate : $template, 
            NULL, 
            TRUE, 
            $this->ctc()->normalize_path( dirname( $file ) )
        );
    }

    // loads raw css file into local memory
    function read_stylesheet( $template = 'child', $file = 'style.css' ) {
        
        // these conditions support revert/restore option in 1.6.0+
        if ( 'all' == $file ) return;
        elseif ( '' == $file ) $file = 'style.css';
        // end revert/restore conditions
        
        $source = $this->get_prop( $template );
        if ( empty( $source ) || !is_scalar( $source ) ) return FALSE;
        $themedir = trailingslashit( get_theme_root() ) . $source;
        $stylesheet = apply_filters( 'chld_thm_cfg_' . $template, trailingslashit( $themedir ) 
            . $file , ( $this->ctc()->is_legacy() ? $this : $file ) ); // support for plugins extension < 2.0

        // read stylesheet
        
        if ( $stylesheet_verified = $this->is_file_ok( $stylesheet, 'read' ) ):
            
            $this->styles .= @file_get_contents( $stylesheet_verified ) . "\n";
            //echo 'count after get contents: ' . strlen( $this->styles ) . LF;
        else:
            //echo 'not ok!' . LF;
        endif;
    }

    /**
     * parse_css
     * Accepts raw CSS as text and parses into individual properties.
     * FIXME - this function has grown too monolithic - refactor and componentize
     * FIXME - migrate to event parser? handle comments?
     */
    function parse_css( $template, $basequery = NULL, $parse_imports = TRUE, $relpath = '', $reset = FALSE ) {
        //$this->load_config( 'sel_ndx' );
        $this->load_config( 'val_ndx' );
        $this->load_config( 'dict_query' );
        $this->load_config( 'dict_sel' );
        $this->load_config( 'dict_token' );
        $this->load_config( 'dict_qs' );
        $this->load_config( 'dict_val' );
        $this->load_config( 'dict_rule' );
        $this->load_config( 'dict_seq' );
        if($basequery==NULL){
            $basequery = 'base';
        }else{
            if ( FALSE === strpos( $basequery, '@' ) ):
                $basequery = 'base';
            endif;
        }
        $ruleset = array();
        // ignore commented code
        $this->styles = preg_replace( '#\/\*.*?\*\/#s', '', $this->styles );
        // space braces to ensure correct matching
        $this->styles 