s->get_dict_id( 'val', $value );
            /**
             * v2.1.0
             * pack/unpack val_ndx 
             */
            // create empty array IF value array does not exist
            if ( FALSE === ( $valarr = $this->unpack_val_ndx( $qsid ) ) )
                $valarr = array(
                    $ruleid => array(
                        $template => array(),
                    ),
                );
            // create empty array IF rule array does not exist
            if ( !isset( $valarr[ $ruleid ] ) )
                $valarr[ $ruleid ] = array(
                    $template => array(),
                );
            // create empty rule array if template is child and reset is TRUE 
            // or IF template array does not exist
            if ( ( $reset && 'child' == $template ) || !isset( $valarr[ $ruleid ][ $template ] ) )
                $valarr[ $ruleid ][ $template ] = array();

            // rulevalid passed            
            //$this->ctc()->debug( 'rule: ' . $rule . ' ' . $ruleid . ' value: ' . ( '' == $value? 'NULL' : '%' . $value . '%' ) . ' ' . ( FALSE == $valid ? 'FALSE' : $valid ) . ' valarr: ' . print_r( $valarr, TRUE ), __FUNCTION__, __CLASS__ );
            if ( isset( $rulevalid ) ):
                $this->unset_rule_value( $valarr[ $ruleid ][ $template ], $rulevalid );
                // value empty?
                if ( '' === $value ):
                // value exist?
                elseif ( $id = $this->rule_value_exists( $valarr[ $ruleid ][ $template ], $valid ) ):
                    $this->unset_rule_value( $valarr[ $ruleid ][ $template ], $id );
                    $this->update_rule_value( $valarr[ $ruleid ][ $template ], $rulevalid, $valid, $important );
                // update new value
                else:
                    $this->update_rule_value( $valarr[ $ruleid ][ $template ], $rulevalid, $valid, $important );
                endif;
            // rulevalid not passed
            else:
                // value exist?
                if ( $id = $this->rule_value_exists( $valarr[ $ruleid ][ $template ], $valid ) ):
                    $this->unset_rule_value( $valarr[ $ruleid ][ $template ], $id );
                    $this->update_rule_value( $valarr[ $ruleid ][ $template ], $id, $valid, $important );
                // get new id and update new value
                else:
                    $id = $this->get_rule_value_id( $valarr[ $ruleid ][ $template ] );
                    $this->update_rule_value( $valarr[ $ruleid ][ $template ], $id, $valid, $important );
                endif;
            endif;
        
            // moved call to prune_if_empty to parse_post_data v2.2.5
        
            $this->pack_val_ndx( $qsid, $valarr );
            // return query selector id   
            return $qsid;
        endif;
    }
    
    /**
     * rule_value_exists
     * Determine if a value already exists for a property
     * and return its id
     */
    function rule_value_exists( &$arr, $valid ) {
        foreach ( $arr as $valarr ):
            if ( isset( $valarr[ 0 ] ) && isset( $valarr[ 2 ] ) && $valid == $valarr[ 0 ] ):
                return $valarr[ 2 ];
            endif;
        endforeach;
        return FALSE;
    }
    
    /**
     * get_rule_value_id
     * Generate a new rulevalid by iterating existing ids
     * and returning the next in sequence
     */
    function get_rule_value_id( &$arr ) {
        $newid = 1;
        foreach ( $arr as $valarr )
            if ( isset( $valarr[ 2 ] ) && $valarr[ 2 ] >= $newid ) $newid = $valarr[ 2 ] + 1;
        return $newid;
    }
    
    /**
     * update_rule_value
     * Generate a new value subarray
     */
    function update_rule_value( &$arr, $id, $valid, $important ) {
        $arr[] = array(
            $valid,
            $important,
            $id,
        );
    }

    /** 
     * unset_rule_value
     * Delete (splice) old value subarray from values 
     */
    function unset_rule_value( &$arr, $id ) {
        $index = 0;
        foreach ( $arr as $valarr ):
            if ( $id == $valarr[ 2 ] ):
                array_splice( $arr, $index, 1 );
                break;
            endif;
            ++$index;
        endforeach;
    }
    
    /** 
     * prune_if_empty
     * Automatically cleans up hierarchies when no values exist 
     * in either parent or child for a given selector.
     */
    function prune_if_empty( $qsid ) {
        $empty = $this->get_dict_id( 'val', '' );
        if ( FALSE == ( $valarr = $this->unpack_val_ndx( $qsid ) ) ) return FALSE;
        foreach ( $valarr as $ruleid => $arr ):
            foreach ( array( 'c', 'p' ) as $template ):
                if ( isset( $arr[ $template ] ) ):
                    // v1.7.5: don't prune until converted to multi value format
                    if ( !is_array( $arr[ $template ] ) ) return FALSE; 
                    // otherwise check each value, if not empty return false
                    foreach ( $arr[ $template ] as $valarr ) 
                        if ( $empty != $valarr[ 0 ] ) return FALSE;
                endif;
            endforeach;
        endforeach;
        // no values, prune from sel index, val index and qs dict data ( keep other dictionary records )
        unset( $this->val_ndx[ $qsid ] );
        unset( $this->dict_qs[ $qsid ] );
        unset( $this->dict_seq[ $qsid ] );
        return TRUE;
    }
    
    
    function recurse_directory( $rootdir, $ext = 'css', $all = FALSE ) {
        // make sure we are only recursing theme and plugin files
        if ( !$this->is_file_ok( $rootdir, 'search' ) ) 
            return array(); 
        $files = array();
        $dirs = array( $rootdir );
        $loops = 0;
        if ( 'img' == $ext )
            $ext = '(' . implode( '|', array_keys( $this->ctc()->imgmimes ) ) . ')';
        while( count( $dirs ) && $loops < 2000 ): // failsafe valve
            $loops++;
            $dir = array_shift( $dirs );
            if ( $handle = opendir( $dir ) ):
                while ( FALSE !== ( $file = readdir( $handle ) ) ):
                    if ( preg_match( "/^\./", $file ) ) continue;
                    $filepath  = trailingslashit( $dir ) . $file;
                    if ( is_dir( $filepath ) ):
                        array_unshift( $dirs, $filepath );
                        if ( $all ):
                            $files[] = $filepath; 
                        endif;
                    elseif ( is_file( $filepath ) && ( $all || preg_match( "/\.".$ext."$/i", $filepath ) ) ):
                        $files[] = $filepath;
                    endif;
                endwhile;
                closedir( $handle );
            endif;
        endwhile;
        return $files;
    }
    
    /**
     * parse_post_data
     * Parse user form input into separate properties and pass to update_arrays
     * FIXME - this function has grown too monolithic - refactor and componentize
     */
    function parse_post_data() {
        $this->load_config( 'dict_query' );
        $this->load_config( 'dict_sel' );
        $this->load_config( 'dict_token' );
        $this->load_config( 'dict_rule' );
        $this->load_config( 'dict_val' );
        $this->load_config( 'val_ndx' );
        $this->load_config( 'dict_seq' );
        $this->load_config( 'dict_qs' );
        $this->cache_updates = TRUE;
        // process RAW CSS input
        if ( isset( $_POST[ 'ctc_new_selectors' ] ) ):
            $this->styles = $this->parse_css_input( LF . $_POST[ 'ctc_new_selectors' ] );
            $this->parse_css( 'child', 
                isset( $_POST[ 'ctc_sel_ovrd_query' ] ) ? trim( $_POST[ 'ctc_sel_ovrd_query' ] ) : NULL, 
                FALSE, 
                '', 
                TRUE
            );
        // process WEB FONTS & CSS inputs
        elseif ( isset( $_POST[ 'ms_child_imports' ] ) ):
            $this->imports[ 'child' ] = array();
            $this->styles = $this->parse_css_input( $_POST[ 'ms_child_imports' ] );
            $this->parse_css( 'child' );
        // process ANALYZER SIGNAL inputs
        elseif (isset( $_POST[ 'ms_theme_child_analysis' ] )):
            
            if ( $this->ctc()->cache_updates ):
                $this->ctc()->updates[] = array(
                    'obj'  => 'analysis',
                    'data' => array(),
                );
            endif;
            
            $this->ctc()->evaluate_signals( $this->get_prop( 'ignoreparnt' ) );
        // process CONFIGURE inputs
        elseif ( isset( $_POST[ 'ctc_configtype' ] ) ):
            ob_start();
            do_action( 'chld_thm_cfg_get_stylesheets' );
            $this->ctc()->updates[] = array(
                'obj'   => 'stylesheets',
                'key'   => '',
                'data'  => ob_get_contents(),
            );
            ob_end_clean();
            ob_start();
            do_action( 'chld_thm_cfg_get_backups' );
            $this->ctc()->updates[] = array(
                'obj'   => 'backups',
                'key'   => '',
                'data'  => ob_get_contents(),
            );
            ob_end_clean();
            return;
        // process SAVE inputs
        else:
            // New query added v2.3.0
            $newquery = isset( $_POST[ 'ctc_rewrite_query' ] ) ? 
                $this->sanitize( $this->parse_css_input( $_POST[ 'ctc_rewrite_query' ] ) ) : NULL;
            $newselector = isset( $_POST[ 'ctc_rewrite_selector' ] ) ? 
                $this->sanitize( $this->parse_css_input( $_POST[ 'ctc_rewrite_selector' ] ) ) : NULL;
            $newqsid = NULL;
        
            // set the custom sequence value
            foreach ( preg_grep( '#^ctc_ovrd_child_seq_#', array_keys( $_POST ) ) as $post_key ):
                if ( preg_match( '#^ctc_ovrd_child_seq_(\d+)$#', $post_key, $matches ) ):
                    $qsid = $matches[ 1 ];
                    $seq = intval( $_POST[ $post_key ] );
                    $this->ctc()->debug( 'set seq( ' . $qsid . ' ): custom: ' . $seq, __FUNCTION__, __CLASS__ );
                    if ( $seq != $qsid ):
                        $this->set_dict_value( 'seq', $seq, $qsid );
                    else:
                        unset( $this->dict_seq[ $seq ] );
                    endif;
                endif;
            endforeach;
        
            // iterate each property input
            $parts = array();
            foreach ( preg_grep( '#^ctc_(ovrd|\d+)_child#', array_keys( $_POST ) ) as $post_key ):
        
                // parse input key into individual components if it matches specific format, skip otherwise
                if ( preg_match( '#^ctc_(ovrd|\d+)_child_([\w\-]+?)_(\d+?)_(\d+?)(_(.+))?$#', $post_key, $matches ) ):
                    $valid      = $matches[ 1 ]; // this is used for inputs from property value tab
                    $rule       = $matches[ 2 ]; // property name 
                    if ( NULL == $rule || FALSE === $this->lookup_dict_value( 'rule', $rule ) )
                        continue;
                    $qsid       = $matches[ 3 ]; // query/selector id 
                    $rulevalid  = $matches[ 4 ]; // id to identify multiple values of same property
                    // normalize input value
                    $value      = $this->normalize_color( $this->sanitize( $this->parse_css_input( $_POST[ $post_key ] ) ) );
                    // set important flag
                    $important  = $this->is_important( $value ); // strip and set if !important passed in input
                    // set important if checkbox input is set 
                    if ( !empty( $_POST[ 'ctc_' . $valid . '_child_' . $rule . '_i_' . $qsid . '_' . $rulevalid ] ) ) $important = 1;
        
                    // get current values from query/selector id if it exists, skip this property otherwise
                    $selarr = $this->denorm_query_sel( $qsid );
                    if ( empty( $selarr ) ) continue;
        
                    // if there is a "rule-part" (e.g., border or gradient properties ), store in parts array and process separately.
                    if ( !empty( $matches[ 6 ] ) ):
                        $parts[ $qsid ][ $rule ][ 'values' ][ $rulevalid ][ $matches[ 6 ] ] = $value;
                        $parts[ $qsid ][ $rule ][ 'values' ][ $rulevalid ][ 'important' ]   = $important;
                        $parts[ $qsid ][ $rule ][ 'query' ]                                 = $selarr[ 'query' ];
                        $parts[ $qsid ][ $rule ][ 'selector' ]                              = $selarr[ 'selector' ];
                    // otherwise process this property
                    else:
                        $newqsid = $this->update_property(
                            $newquery,
                            $newselector,
                            $selarr[ 'query' ], 
                            $selarr[ 'selector' ], 
                            $rule, 
                            $value, 
                            $important, 
                            $rulevalid
                        );
                    endif;
                endif;
            endforeach;
            /** 
             * Inputs for border and background-image are broken into multiple "rule parts"
             * With the addition of multiple property values in v1.7.5, the parts loop 
             * has been modified to segment the parts into rulevalids under a new 'values' array. 
             * The important flag has also been moved into the parts array.
             */
            foreach ( $parts as $qsid => $rules ):
                foreach ( $rules as $rule => $rule_arr ):
                    // new 'values' array to segment parts into rulevalids
                    foreach ( $rule_arr[ 'values' ] as $rulevalid => $rule_part ):
                        if ( 'background' == $rule ):
                            $value = $rule_part[ 'background_url' ];
                        elseif ( 'background-image' == $rule ):
                            if ( empty( $rule_part[ 'background_url' ] ) ):
                                if ( empty( $rule_part[ 'background_color2' ] ) ):
                                    $value = '';
                                else:
                                    if ( empty( $rule_part[ 'background_origin' ] ) )
                                        $rule_part[ 'background_origin' ] = 'top';
                                    if ( empty( $rule_part[ 'background_color1' ] ) )
                                        $rule_part[ 'background_color1' ] = $rule_part[ 'background_color2' ];
                                    $value = implode( ':', array(
                                        $rule_part[ 'background_origin' ], 
                                        $rule_part[ 'background_color1' ], '0%', 
                                        $rule_part[ 'background_color2' ], '100%'
                                    ) );
                                endif;
                            else:
                                $value = $rule_part[ 'background_url' ];
                            endif;
                        elseif ( preg_match( '#^border(\-(top|right|bottom|left))?$#', $rule ) ):
                            if ( empty( $rule_part[ 'border_width' ] ) && !empty( $rule_part[ 'border_color' ] ) )
                                $rule_part[ 'border_width' ] = '1px';
                            if ( empty( $rule_part[ 'border_style' ] ) && !empty( $rule_part[ 'border_color' ] ) )
                                $rule_part[ 'border_style' ] = 'solid';
                            $value = implode( ' ', array(
                                $rule_part[ 'border_width' ], 
                                $rule_part[ 'border_style' ], 
                                $rule_part[ 'border_color' ]
                            ) );
                        else:
                            $value = '';
                        endif;
                        
 