  origval = $( '#' + input + '_orig' ).val();
                $( '#' + orig ).empty().text( origval );
                $( obj ).text( self.getxt( 'rename' ) );
            } else {
                origval = $( '#' + orig ).text();
                $( '#' + orig ).html( 
                    '<textarea id="' + input + '"' +
                    ' name="' + input + '" autocomplete="off"></textarea>' +
                    '<input id="' + input + '_orig" name="' + input + '_orig"' +
                    ' type="hidden" value="' + self.escquo( origval ) + '"/>' );
                $( '#' + input ).val( origval );
                $( obj ).text( self.getxt( 'cancel' ) );
            }
        },
            
        coalesce_inputs: function( obj ) {
           
            var self        = this,
                id          = $( obj ).attr( 'id' ),
                regex       = /^(ctc_(ovrd|\d+)_(parent|child)_([0-9a-z\-]+)_(\d+?)(_(\d+))?)(_\w+)?$/,
                container   = $( obj ).parents( '.ctc-selector-row, .ctc-parent-row' ).first(),
                swatch      = container.find( '.ctc-swatch' ).first(),
                cssrules    = { 'parent': {}, 'child': {} },
                gradient    = { 
                    'parent': {
                        'origin':   '',
                        'start':    '',
                        'end':      ''
                    }, 
                    'child': {
                        'origin':   '',
                        'start':    '',
                        'end':      ''
                    } 
                },
                has_gradient    = { 'child': false, 'parent': false },
                postdata        = {};
            // set up objects for all neighboring inputs
            container.find( '.ctc-parent-value, .ctc-child-value' ).each( function() {
                var inputid     = $( this ).attr( 'id' ),
                    inputparts  = inputid.toString().match( regex ),
                    inputseq    = inputparts[ 2 ],
                    inputtheme  = inputparts[ 3 ],
                    inputrule   = ( 'undefined' === typeof inputparts[ 4 ] ? '' : inputparts[ 4 ] ),
                    rulevalid   = inputparts[ 7 ],
                    qsid        = inputparts[ 5 ],
                    rulepart    = ( 'undefined' === typeof inputparts[ 7 ] ? '' : inputparts[ 8 ] ),
                    value       = ( 'parent' === inputtheme ? $( this ).text().replace( /!$/, '' ) : 
                                    ( 'seq' !== inputrule && 'ctc_delete_query_selector' === id ? '' : 
                                        $( this ).val() ) ), // clear values if delete was clicked
                    important   = ( 'seq' === inputrule ? false : 'ctc_' + inputseq + '_child_' + inputrule + '_i_' + qsid + '_' + rulevalid ),
                    parts, subparts;
                //**console.log( inputparts );
                //**console.log( 'value: ' + value );
                if ( 'child' === inputtheme ) {
                    if ( !self.is_empty( $( this ).data( 'color' ) ) ) {
                        value = self.color_text( $( this ).data( 'color' ) );
                        $( this ).data( 'color', null );
                    }
                    postdata[ inputid ]     = value;
                    if ( important ) {
                        postdata[ important ]   = ( $( '#' + important ).is( ':checked' ) ) ? 1 : 0;
                    }
                }
                if ( '' !== value ) {
                    // handle specific inputs
                    if ( !self.is_empty( rulepart ) ) {
                        switch( rulepart ) {
                            case '_border_width':
                                cssrules[ inputtheme ][ inputrule + '-width' ] = ( 'none' === value ? 0 : value );
                                break;
                            case '_border_style':
                                cssrules[ inputtheme ][ inputrule + '-style' ] = value;
                                break;
                            case '_border_color':
                                cssrules[ inputtheme ][ inputrule + '-color' ] = value;
                                break;
                            case '_background_url':
                                cssrules[ inputtheme ][ 'background-image' ] = self.image_url( inputtheme, value );
                                break;
                            case '_background_color':
                                cssrules[ inputtheme ][ 'background-color' ] = value; // was obj.value ???
                                break;
                            case '_background_color1':
                                gradient[ inputtheme ].start   = value;
                                has_gradient[ inputtheme ] = true;
                                break;
                            case '_background_color2':
                                gradient[ inputtheme ].end     = value;
                                has_gradient[ inputtheme ] = true;
                                break;
                            case '_background_origin':
                                gradient[ inputtheme ].origin  = value;
                                has_gradient[ inputtheme ] = true;
                                break;
                        }
                    } else {
                        // handle borders
                        if ( ( parts = inputrule.toString().match( /^border(\-(top|right|bottom|left))?$/ ) && !value.match( /none/ ) ) ) {
                            var borderregx = new RegExp( self.border_regx + self.color_regx, 'i' );
                            subparts = value.toString().match( borderregx );
                         
                            if ( !self.is_empty( subparts ) ) {
                                subparts.shift();
                                cssrules[ inputtheme ][ inputrule + '-width' ] = subparts.shift() || '';
                                subparts.shift();
                                cssrules[ inputtheme ][ inputrule + '-style' ] = subparts.shift() || '';
                                cssrules[ inputtheme ][ inputrule + '-color' ] = subparts.shift() || '';
                            }
                        // handle background images
                        } else if ( 'background-image' === inputrule && !value.match( /none/ ) ) {
                            if ( value.toString().match( /url\(/ ) ) {
                                cssrules[ inputtheme ][ 'background-image' ] = self.image_url( inputtheme, value );
                            } else {
                                var gradregex = new RegExp( self.grad_regx + self.color_regx + self.color_regx, 'i' );
                                subparts = value.toString().match( gradregex );
                          
                                if ( !self.is_empty( subparts ) && subparts.length > 2 ) {
                                    subparts.shift();
                                    gradient[ inputtheme ].origin = subparts.shift() || 'top';
                                    gradient[ inputtheme ].start  = subparts.shift() || 'transparent';
                                    gradient[ inputtheme ].end    = subparts.shift() || 'transparent';
                                    has_gradient[ inputtheme ] = true;
                                } else {
                                    cssrules[ inputtheme ][ 'background-image' ] = value;
                                }
                            }
                        } else if ( 'seq' !== inputrule ) {
                            cssrules[ inputtheme ][ inputrule ] = value;
                        }
                    }
                }
            } );
           
            if ( 'undefined' !== typeof swatch && !self.is_empty( swatch.attr( 'id' ) ) ) {
                swatch.removeAttr( 'style' );
                if ( has_gradient.parent ) {
                    swatch.ctcgrad( gradient.parent.origin, [ gradient.parent.start, gradient.parent.end ] );
                }
                
                swatch.css( cssrules.parent );  
                if ( !( swatch.attr( 'id' ).toString().match( /parent/ ) ) ) {
                    if ( has_gradient.child ) {
                        swatch.ctcgrad( gradient.child.origin, [ gradient.child.start, gradient.child.end ] );
                    }
                    
                    swatch.css( cssrules.child );
                }
                swatch.css( {'z-index':-1} );
            }
            return postdata;
        },
        
        decode_value: function( rule, value ) {
           
            value = ( 'undefined' === typeof value ? '' : value );
            var self = this,
                obj = { 
                    'orig':     value, 
                    'names':    [ '' ],
                    'values':   [ value ]
                },
                params;
            if ( rule.toString().match( /^border(\-(top|right|bottom|left))?$/ ) ) {
                var regex = new RegExp( self.border_regx + '(' + self.color_regx + ')?', 'i' ),
                    orig;
                params = value.toString().match( regex );
                if ( self.is_empty( params ) ) {
                    params = [];
                }
                obj.names = [
                    '_border_width',
                    '_border_style',
                    '_border_color',
                ];
                orig = params.shift();
               
                obj.values[ 0 ] = params.shift() || '';
                params.shift();
                obj.values[ 1 ] = params.shift() || '';
                params.shift();
                obj.values[ 2 ] = params.shift() || '';
            } else if ( rule.toString().match( /^background\-image/ ) ) {
                obj.names = [
                    '_background_url',
                    '_background_origin', 
                    '_background_color1', 
                    '_background_color2'
                ];
                obj.values = [ '', '', '', '' ];
                if ( !self.is_empty( value ) && !( value.toString().match( /(url|none)/ ) ) ) {
                    var    stop1, stop2;
                    params = value.toString().split( /:/ );
          
                    obj.values[ 1 ] = params.shift() || '';
                    obj.values[ 2 ] = params.shift() || '';
                    stop1 = params.shift() || '';
                    obj.values[ 3 ] = params.shift() || '';
                    stop2 = params.shift() || '';
                    obj.orig = [ 
                        obj.values[ 1 ],
                        obj.values[ 2 ],
                        obj.values[ 3 ] 
                    ].join( ' ' );
                } else {
                    obj.values[ 0 ] = value;
                }
            }
          
            return obj;
        },
        
        image_url: function( theme, value ) {
            var self = this,
                parts = value.toString().match( /url\(['" ]*(.+?)['" ]*\)/ ),
                path = self.is_empty( parts ) ? null : parts[ 1 ],
                url = window.ms_ajax.theme_uri + '/' + ( 'parent' === theme ? window.ms_ajax.parnt : window.ms_ajax.child ) + '/',
                image_url;
            if ( !path ) { 
                return false; 
            } else if ( path.toString().match( /^(data:|https?:|\/)/ ) ) { 
                image_url = value; 
            } else { 
                image_url = 'url(' + url + path + ')'; 
            }
            return image_url;
        },
    
        setup_menus: function() {
            var self = this;
           
            self.setup_query_menu();
            self.setup_selector_menu();
            self.setup_rule_menu();
            self.setup_new_rule_menu();
            self.load_queries();
            self.load_rules();
           
            self.set_query( self.currquery );
        },
        
        load_queries: function() {
            var self = this;
          
            self.query_css( 'queries', null );
        },
        
        load_selectors: function() {
            var self = this;
           
            self.query_css( 'selectors', self.currquery );
        },
        
        load_rules: function() {
            var self = this;
          
            self.query_css( 'rules', null );
        },
        
        load_selector_values: function() {
            var self = this;
           
            self.query_css( 'qsid', self.currqsid );
        },
        
        get_queries: function( request, response ) {
           
            var //self = this,
                arr = [], 
                matcher = new RegExp( $.ui.autocomplete.escapeRegex( request.term ), "i" );
            if ( $.ms_themeeditor.is_empty( this.element.data( 'menu' ) ) ) {
                arr.push( { 'label': window.ms_ajax.nosels_txt, 'value': null } );
            } else {
                // note: key = ndx, value = query name
                $.each( this.element.data( 'menu' ), function( key, val ) {
                    if ( matcher.test( val ) ) {
                        arr.push( { 'label': val, 'value': val } );
                    }
                } );
            }
            response( arr );
        },
        
        get_selectors: function( request, response ) {
			
				var //self = this,
				arr = [], 
				matcher = new RegExp( $.ui.autocomplete.escapeRegex( request.term ), "i" );
					
				if ( $.ms_themeeditor.is_empty( this.element.data( 'menu' ) ) ) {
					arr.push( { 'label': window.ms_ajax.nosels_txt, 'value': null } );
				} else {
				   
				$.each( this.element.data( 'menu' ), function( key, val ) {
				
					if ( matcher.test( key ) ) {
						arr.push( { 'label': key, 'value': val } );
					}
				
				} );
            }
            response( arr );
        },
        
        get_rules: function( request, response ) {
           
            var //self = this,
                arr = [], 
                matcher = new RegExp( $.ui.autocomplete.escapeRegex( request.term ), "i" );
            if ( $.ms_themeeditor.is_empty( this.element.data( 'menu' ) ) ) {
                arr.push( { 'label': window.ms_ajax.nosels_txt, 'value': null } );
            } else {
                // note: key = ruleid, value = rule name
                $.each( this.element.data( 'menu' ), function( key, val ) {
                    if ( matcher.test( key ) ) {
                        arr.push( { 'label': key, 'value': val } );
                    }
                } );
            }
            response( arr );
        },
                
        get_filtered_rules: function( request, response ) {
            //console.log( 'get_filtered_rules' );
            var arr = [],
                matcher = new RegExp( $.ui.autocomplete.escapeRegex( request.term ), "i" ); //,
            $.each( $( '#ctc_rule_menu' ).data( 'menu' ), function( key, val ) {
                //multiple versions of rule ok
                if ( matcher.test( key ) ) {
                    arr.push( { 'label': key, 'value': val } );
                }
            } );
            response( arr );
        },
        
        merge_ruleval_arrays: function( rule, value, isnew ) {
            //**console.log( 'merge_ruleval_arrays' );
            var self = this,
                valarr = {},
                nextval = isnew ? value.child.pop() : null; // if new rule, pop off the top before counting
            //**console.log( value );
            $.each( [ 'parnt', 'child' ], function( ndx, themetype ) {
                // iterate through parent and child val arrays and populate new assoc array with parent/child for each rulevalid
                if ( !self.is_empty( value[ themetype ] ) ) {
                    $.each( value[ themetype ], function( ndx2, val ) {
                        if ( isnew ) {
                            // if new rule, increment new rulevalid but do not add to parent/child assoc array
                            if ( parseInt( val[ 2 ] ) >= parseInt( nextval[ 2 ] ) ) {
                                nextval[ 2 ] = parseInt( val[ 2 ] ) + 1;
                            }
                        } else {
                            // add to parent/child assoc array with rulevalid as key
                            if ( self.is_empty( valarr[ val[ 2 ] ] ) ) {
                                valarr[ val[ 2 ] ] = {};
                            }
                            valarr[ val[ 2 ] ][ themetype ] = val;
                        }
                    } );
                }
            } );
            // if new rule, create new parent child assoc array element with new rulevalid as key
            if ( isnew ) {
                valarr[ nextval[ 2 ] ] = {
                    parnt: [],
                    child: nextval
                };
            }
            return valarr;
        },

        input_row: function( qsid, rule, seq, data, isnew ) {
            //console.log( 'in input_row' );
            var self = this,
                html = '';
            if ( !self.is_empty( data ) && !self.is_empty( data.value ) && !self.is_empty( data.value[ rule ] ) ) {
                var value = data.value[ rule ],
                    valarr = self.merge_ruleval_arrays( rule, value, isnew );
                $.each( valarr, function( ndx, val ) {
                    var pval = self.decode_value( rule, self.is_empty( val.parnt ) ? '' : val.parnt[ 0 ] ),
                        pimp = self.is_empty( val.parnt ) || self.is_empty( val.parnt[ 1 ], 1 ) ? 0 : 1,
                        cval = self.decode_value( rule, self.is_empty( val.child ) ? '' : val.child[ 0 ] ),
                        cimp = self.is_empty( val.child ) || self.is_empty( val.child[ 1 ], 1 ) ? 0 : 1;
                    html += '<div class="ctc-' + ( 'ovrd' === seq ? 'input' : 'selector' ) + '-row clearfix"><div class="ms-input-cell">';
                    if ( 'ovrd' === seq ) {
                        html += rule.replace( /\d+/g, self.frascii );
                    } else {
                        html += data.selector + '<br/><a href="#" class="ctc-selector-edit"' +
                            ' id="ctc_selector_edit_' + qsid + '" >' + self.getxt( 'edit' ) + '</a> ' +
                            ( self.is_empty( pval.orig ) ? self.getxt( 'child_only' ) : '' );
                    }
                    html += '</div><div class="ctc-parent-value ms-input-cell"' + ( 'ovrd' !== seq ? ' style="display:none"' : '' ) +
                        ' id="ctc_' + seq + '_parent_' + rule + '_' + qsid + '_' + ndx + '">' +
                        ( self.is_empty( pval.orig ) ? '[no value]' : pval.orig + ( pimp ? self.getxt( 'important' ) : '' ) ) +
                        '</div><div class="ms-input-cell">';
                    if ( !self.is_empty( pval.names ) ) {
                        $.each( pval.names, function( namendx, newname ) {
                            newname = ( self.is_empty( newname ) ? '' : newname );
                            html += '<div class="ctc-child-input-cell ctc-clear">';
                            var id = 'ctc_' + seq + '_child_' + rule + '_' + qsid + '_' + ndx + newname,
                                newval;
                            if ( false === ( newval = cval.values.shift() ) ) {
                                newval = '';
                            }
                                
                            html += ( self.is_empty( newname ) ? '' : self.getxt( newname ) + ':<br/>' ) +
                                '<input type="text" id="' + id + '" name="' + id + '" class="ctc-child-value' +
                                ( ( newname + rule ).toString().match( /color/ ) ? ' color-picker' : '' ) +
                                ( ( newname ).toString().match( /url/ ) ? ' ctc-input-wide' : '' ) +
                                '" value="' + self.escquo( newval ) + '" /></div>';
                        } );
                        var impid = 'ctc_' + seq + '_child_' + rule + '_i_' + qsid + '_' + ndx;
                        html += '<label style="visibility: hidden;" class="ms_hidden" for="' + impid + '"><input  type="checkbox"' +
                            ' id="' + impid + '" name="' + impid + '" value="1" ' +
                            ( cimp ? 'checked' : '' ) + ' />' +
                            self.getxt( 'important' ) + '</label>';
                    }
                    html += '</div>';
                    if ( 'ovrd' !== seq ) {
                        html += '<div class="ctc-swatch ctc-specific"' +
                            ' id="ctc_child_' + rule + '_' + qsid + '_' + ndx + '_swatch">' +
                            self.getxt( 'swatch' ) + '</div>' +
                            '<div class="ctc-child-input-cell ctc-button-cell"' +
                            ' id="ctc_save_' + rule + '_' + qsid + '_' + ndx + '_cell">' +
                            '<input type="button" class="button ctc-save-input"' +
                            ' id="ctc_save_' + rule + '_' + qsid + '_' + ndx + '"' +
                            ' name="ctc_save_' + rule + '_' + qsid + '_' + ndx + '"' +
                            ' value="Save" /></div>';
                    }
                    html += '</div><!-- end input row -->' + "\n";
                } );
            }
            return html;
        },
        
        scrolltop: function() {
            $('html, body, .ms-option-panel-container').animate( { scrollTop: 0 } );        
        },
        
        css_preview: function( theme ) {
            var self = this;
          //  console.log( 'css_preview: ' + theme );
            if ( !( theme = theme.match( /(child|parnt)/ )[ 1 ] ) ) {
                theme = 'child';
            }
           // console.log( 'css_preview: ' + theme );
            // retrieve raw stylesheet ( parent or child )
            self.query_css( 'preview', theme );
        },
        
        
        setup_iris: function( obj ) {
            // deprecated: using spectrum for alpha support
            var self = this;
            //self.setup_spectrum( obj );
        },        
        
        addhash: function( color ) {
            return color.replace( /^#?([a-f0-9]{3,6}.*)/, "#$1" );
        },
        color_text: function( color ) {
            var self = this;
            if ( self.is_empty( color ) ) {
                return '';
            } else if ( color.getAlpha() < 1 ) {
                return color.toRgbString();
            } else {
                return color.toHexString();
            }
        },
        
        setup_query_menu: function() {
            var self = this;
            //console.log( 'setup_query_menu' );
            try {
                $( '#ctc_sel_ovrd_query' ).autocomplete( {
                    source: self.get_queries,
                    minLength: 0,
                    selectFirst: true,
                    autoFocus: true,
                    select: function( e, ui ) {
                        if ( $( '#ctc_rewrite_query' ).length ){
                            // copy selected to rewrite input if active
                            $( '#ctc_rewrite_query' ).val( ui.item.value );
                            $( '#ctc_sel_ovrd_query' ).val( '' );
                        } else {
                            // otherwise set query
                            self.set_query( ui.item.value );
                            self.reset_qsid();
                        }
						//alert(ui.item.value);
                        return false;
                    },
                    focus: function( e ) { 
                        e.preventDefault(); 
                    }
                } ).data( 'menu' , {} );
            } catch ( exn ) {
                self.jquery_exception( exn, 'Query Menu' );
            }
        },
        
        setup_selector_menu: function() {
            var self = this;
            //console.log( 'setup_selector_menu' );
            try {
                $( '#ctc_sel_ovrd_selector' ).autocomplete( {
                    source: self.get_selectors,
                    selectFirst: true,
                    autoFocus: true,
                    select: function( e, ui ) {
                        if ( $( '#ctc_rewrite_selector' ).length ){
                            // copy selected to rewrite input if active
                            $( '#ctc_rewrite_selector' ).val( ui.item.label );
                            $( '#ctc_sel_ovrd_selector' ).val( '' );
                        } else {
                            // otherwise set selector
                            self.set_selector( ui.item.value, ui.item.label );
                        }
                        return false;
                    },
                    focus: function( e ) { 
                        e.preventDefault(); 
                    }
                } ).data( 'menu' , {} );
            } catch ( exn ) {
                self.jquery_exception( exn, 'Selector Menu' );
            }
        },
        
        setup_rule_menu: function() {
            var self = this;
            //console.log( 'setup_rule_menu' );
            try {
            $( '#ctc_rule_menu' ).autocomplete( {
                source: self.get_rules,
                //minLength: 0,
                selectFirst: true,
                autoFocus: true,
                select: function( e, ui ) {
                    self.set_rule( ui.item.value, ui.item.label );
                    return false;
                },
                focus: function( e ) { 
                    e.preventDefault(); 
                }
            } ).data( 'menu' , {} );
            } catch ( exn ) {
                self.jquery_exception( exn, 'Property Menu' );
            }
        },
        
        setup_new_rule_menu: function() {
            var self = this;
            try {
            $( '#ctc_new_rule_menu' ).autocomplete( {
                source: self.get_filtered_rules,
                //minLength: 0,
                selectFirst: true,
                autoFocus: true,
                select: function( e, ui ) {
                    //console.log( 'new rule selected' );
                    e.preventDefault();
                    var newrule = ui.item.label.replace( /[^\w\-]/g, self.toascii ),
                        row,
                        first;
                    //console.log( 'current qsdata before:' );
                    //console.log( self.currdata );
                    if ( self.is_empty( self.currdata.value ) ) {
                        self.currdata.value = {};
                    }
                    if ( self.is_empty( self.currdata.value[ ui.item.label ] ) ) {
                        self.currdata.value[ ui.item.label ] = {};
                    }
                    if ( self.is_empty( self.currdata.value[ ui.item.label ].child ) ) {
                        self.currdata.value[ ui.item.label ].child = [];
                    }
                    //console.log( 'current qsdata after:' );
                    //console.log( self.currdata );
                    // seed current qsdata with new blank value with id 1
                    // this will be modified during input_row function to be next id in order
                    self.currdata.value[ ui.item.label ].child.push( [ '', 0, 1, 1 ] );
                    row = $( self.input_row( self.currqsid, newrule, 'ovrd', self.currdata, true ) );
                    $( '#ctc_sel_ovrd_rule_inputs' ).append( row );
                    $( '#ctc_new_rule_menu' ).val( '' );
                    
                    row.find( 'input[type="text"]' ).each( function( ndx, el ) {
                        if (! first) {
                            first = el;
                        }
                        if ( $( el ).hasClass( 'color-picker' ) ){
                            //self.setup_spectrum( el );
                        }
                    } );
                    if ( first ){
                        $( first ).focus();
                    }
//                    if ( self.jqueryerr.length ) {
//                        self.jquery_notice( 'setup_new_rule_menu' );
//                    }
                    return false;
                },
                focus: function( e ) { 
                    e.preventDefault(); 
                }
            } ).data( 'menu' , {} );
            } catch ( exn ) {
                self.jquery_exception( exn, 'New Property Menu' );
            }
        },
        set_theme_params: function( themetype, themedir ) {
           			
			$( '#child_author' ).val( window.ms_ajax.themes[ themetype ][ themedir ].Author );
            $( '#child_version' ).val( window.ms_ajax.themes[ themetype ][ themedir ].Version );
            $( '#child_author_uri' ).val( window.ms_ajax.themes[ themetype ][ themedir ].AuthorURI );
            $( '#child_theme_uri' ).val( window.ms_ajax.themes[ themetype ][ themedir ].ThemeURI );
            $( '#child_descr' ).val( window.ms_ajax.themes[ themetype ][ themedir ].Descr );
            $( '#child_tags' ).val( window.ms_ajax.themes[ themetype ][ themedir ].Tags );
        },
        update_form: function() {
            var self        = this,
                themedir;
            $( '#input_row_stylesheet_handling_container,#input_row_parent_handling_container,#ctc_additional_css_files_container,#input_row_new_theme_slug,#input_row_duplicate_theme_slug,#ctc_copy_theme_mods,#ctc_child_header_parameters,#ctc_configure_submit,#input_row_theme_slug' ).slideUp( 'fast' );
            $( '#ctc_configure_submit .ctc-step' ).text( '9' );
            
			var ms_child_theme_action = $('#ms_theme_editor_action').val();
						
			//if ( $( '#ctc_theme_child' ).length && !$( '#ctc_child_type_new' ).is( ':checked' ) ) {
			if ( $( '#ctc_theme_child' ).length && ms_child_theme_action !='new' ) {	
			
                themedir    = $( '#ctc_theme_child' ).val();
				
                self.existing = 1;
                self.currparnt = window.ms_ajax.themes.child[ themedir ].Template;
				
                self.autogen_slugs();
                $( '#ctc_theme_parnt' ).val( self.currparnt );                
                self.set_theme_params( 'child', themedir );
                
				if ( ms_child_theme_action == 'duplicate') {	
                    $( '#ctc_child_template' ).val( self.testslug );
                    $( '#child_name' ).val( self.testname );
                    $( '.ctc-analyze-theme, .ctc-analyze-howto' ).show();
                    $( '#ctc_load_styles' ).val( 'Duplicate Child Theme' );
                } else if ( ms_child_theme_action == 'reset') {
                    $( '#ctc_configure_submit .ctc-step' ).text( '3' );
                    $( '#ctc_configure_submit' ).slideDown( 'fast' );
                    $( '#theme_slug_container' ).text( themedir );
                    $( '.ctc-analyze-theme, .ctc-analyze-howto' ).hide();
                    //$( '#in