<?php
/**
 * Entry meta part.
 *
 * @package Ef Practical
 */

if ( is_single() ) {
    $author_name     = get_theme_mod( 'practical_single_post_author_name', 0 );
    $date            = get_theme_mod( 'practical_single_post_date', 0 );
    $comments_number = get_theme_mod( 'practical_single_post_comments_number', 0 );
} elseif ( is_archive() ) {
    $author_name     = get_theme_mod( 'practical_archives_author_name', 0 );
    $date            = get_theme_mod( 'practical_archives_date', 0 );
    $comments_number = get_theme_mod( 'practical_archives_comments_number', 0 );
} elseif ( is_search() ) {
    $author_name     = get_theme_mod( 'practical_search_results_author_name', 0 );
    $date            = get_theme_mod( 'practical_search_results_date', 0 );
    $comments_number = get_theme_mod( 'practical_search_results_comments_number', 0 );
} else {
    $author_name     = get_theme_mod( 'practical_blog_posts_author_name', 0 );
    $date            = get_theme_mod( 'practical_blog_posts_date', 0 );
    $comments_number = get_theme_mod( 'practical_blog_posts_comments_number', 0 );
}

if ( 0 == $author_name || 0 == $date || ( 0 == $comments_number && ( get_comments_number() || comments_open() ) ) ) :

?>

<div class="entry-meta cf">
    
    <?php if ( 0 == $author_name ) : ?>
        <span class="entry-author author vcard"><i class="fa fa-user"></i><a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); /* WPCS: xss ok. */ ?>"><?php the_author(); ?></a></span>
    <?php endif; ?>
    
    <?php if ( 0 == $date ) : ?>
        <span class="entry-date"><i class="fa fa-calendar"></i><time class="published" datetime="<?php echo get_the_date( 'Y-m-d H:i:s' ); ?>"><?php echo get_the_date(); ?></time></span>
    <?php endif; ?>
    
    <?php if ( 0 == $comments_number && ( get_comments_number() || comments_open() ) ) : ?>
        <span class="comments-link">
            <i class="fa fa-comments-o"></i> <?php comments_popup_link( esc_html__( '0 Comments', 'ef-practical' ), esc_html__( '1 Comment', 'ef-practical' ), esc_html__( '% Comments', 'ef-practical' ), '', esc_html__( 'Comments Off', 'ef-practical' ) ); ?>
        </span>
    <?php endif; ?>
    
</div>

<?php endif; ?>