se, applies to certain designated libraries, and
is quite different from the ordinary General Public License.  We use
this license for certain libraries in order to permit linking those
libraries into non-free programs.

  When a program is linked with a library, whether statically or using
a shared library, the combination of the two is legally speaking a
combined work, a derivative of the original library.  The ordinary
General Public License therefore permits such linking only if the
entire combination fits its criteria of freedom.  The Lesser General
Public License permits more lax criteria for linking other code with
the library.

  We call this license the "Lesser" General Public License because it
does Less to protect the user's freedom than the ordinary General
Public License.  It also provides other free software developers Less
of an advantage over competing non-free programs.  These disadvantages
are the reason we use the ordinary General Public License for many
libraries.  However, the Lesser license provides advantages in certain
special circumstances.

  For example, on rare occasions, there may be a special need to
encourage the widest possible use of a certain library, so that it becomes
a de-facto standard.  To achieve this, non-free programs must be
allowed to use the library.  A more frequent case is that a free
library does the same job as widely used non-free libraries.  In this
case, there is little to gain by limiting the free library to free
software only, so we use the Lesser General Public License.

  In other cases, permission to use a particular library in non-free
programs enables a greater number of people to use a large body of
free software.  For example, permission to use the GNU C Library in
non-free programs enables many more people to use the whole GNU
operating system, as well as its variant, the GNU/Linux operating
system.

  Although the Lesser General Public License is Less protective of the
users' freedom, it does ensure that the user of a program that is
linked with the Library has the freedom and the wherewithal to run
that program using a modified version of the Library.

  The precise terms and conditions for copying, distribution and
modification follow.  Pay close attention to the difference between a
"work based on the library" and a "work that uses the library".  The
former contains code derived from the library, whereas the latter must
be combined with the library in order to run.

                  GNU LESSER GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License Agreement applies to any software library or other
program which contains a notice placed by the copyright holder or
other authorized party saying it may be distributed under the terms of
this Lesser General Public License (also called "this License").
Each licensee is addressed as "you".

  A "library" means a collection of software functions and/or data
prepared so as to be conveniently linked with application programs
(which use some of those functions and data) to form executables.

  The "Library", below, refers to any such software library or work
which has been distributed under these terms.  A "work based on the
Library" means either the Library or any derivative work under
copyright law: that is to say, a work containing the Library or a
portion of it, either verbatim or with modifications and/or translated
straightforwardly into another language.  (Hereinafter, translation is
included without limitation in the term "modification".)

  "Source code" for a work means the preferred form of the work for
making modifications to it.  For a library, complete source code means
all the source code for all modules it contains, plus any associated
interface definition files, plus the scripts used to control compilation
and installation of the library.

  Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running a program using the Library is not restricted, and output from
such a program is covered only if its contents constitute a work based
on the Library (independent of the use of the Library in a tool for
writing it).  Whether that is true depends on what the Library does
and what the program that uses the Library does.

  1. You may copy and distribute verbatim copies of the Library's
complete source code as you receive it, in any medium, provided that
you conspicuously and appropriately publish on each copy an
appropriate copyright notice and disclaimer of warranty; keep intact
all the notices that refer to this License and to the absence of any
warranty; and distribute a copy of this License along with the
Library.

  You may charge a fee for the physical act of transferring a copy,
and you may at your option offer warranty protection in exchange for a
fee.

  2. You may modify your copy or copies of the Library or any portion
of it, thus forming a work based on the Library, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) The modified work must itself be a software library.

    b) You must cause the files modified to carry prominent notices
    stating that you changed the files and the date of any change.

    c) You must cause the whole of the work to be licensed at no
    charge to all third parties under the terms of this License.

    d) If a facility in the modified Library refers to a function or a
    table of data to be supplied by an application program that uses
    the facility, other than as an argument passed when the facility
    is invoked, then you must make a good faith effort to ensure that,
    in the event an application does not supply such function or
    table, the facility still operates, and performs whatever part of
    its purpose remains meaningful.

    (For example, a function in a library to compute square roots has
    a purpose that is entirely well-defined independent of the
    application.  Therefore, Subsection 2d requires that any
    application-supplied function or table used by this function must
    be optional: if the application does not supply it, the square
    root function must still compute square roots.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Library,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Library, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote
it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Library.

In addition, mere aggregation of another work not based on the Library
with the Library (or with a work based on the Library) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may opt to apply the terms of the ordinary GNU General Public
License instead of this License to a given copy of the Library.  To do
this, you must alter all the notices that refer to this License, so
that they refer to the ordinary GNU General Public License, version 2,
instead of to this License.  (If a newer version than version 2 of the
ordinary GNU General Public License has appeared, then you can specify
that version instead if you wish.)  Do not make any other change in
these notices.

  Once this change is made in a given copy, it is irreversible for
that copy, so the ordinary GNU General Public License applies to all
subsequent copies and derivative works made from that copy.

  This option is useful when you wish to copy part of the code of
the Library into a program that is not a library.

  4. You may copy and distribute the Library (or a portion or
derivative of it, under Section 2) in object code or executable form
under the terms of Sections 1 and 2 above provided that you accompany
it with the complete corresponding machine-readable source code, which
must be distributed under the terms of Sections 1 and 2 above on a
medium customarily used for software interchange.

  If distribution of object code is made by offering access to copy
from a designated place, then offering equivalent access to copy the
source code from the same place satisfies the requirement to
distribute the source code, even though third parties are not
compelled to copy the source along with the object code.

  5. A program that contains no derivative of any portion of the
Library, but is designed to work with the Library by being compiled or
linked with it, is called a "work that uses the Library".  Such a
work, in isolation, is not a derivative work of the Library, and
therefore falls outside the scope of this License.

  However, linking a "work that uses the Library" with the Library
creates an executable that is a derivative of the Library (because it
contains portions of the Library), rather than a "work that uses the
library".  The executable is therefore covered by this License.
Section 6 states terms for distribution of such executables.

  When a "work that uses the Library" uses material from a header file
that is part of the Library, the object code for the work may be a
derivative work of the Library even though the source code is not.
Whether this is true is especially significant if the work can be
linked without the Library, or if the work is itself a library.  The
threshold for this to be true is not precisely defined by law.

  If such an object file uses only numerical parameters, data
structure layouts and accessors, and small macros and small inline
functions (ten lines or less in length), then the use of the object
file is unrestricted, regardless of whether it is legally a derivative
work.  (Executables containing this object code plus portions of the
Library will still fall under Section 6.)

  Otherwise, if the work is a derivative of the Library, you may
distribute the object code for the work under the terms of Section 6.
Any executables containing that work also fall under Section 6,
whether or not they are linked directly with the Library itself.

  6. As an exception to the Sections above, you may also combine or
link a "work that uses the Library" with the Library to produce a
work containing portions of the Library, and distribute that work
under terms of your choice, provided that the terms permit
modification of the work for the customer's own use and reverse
engineering for debugging such modifications.

  You must give prominent notice with each copy of the work that the
Library is used in it and that the Library and its use are covered by
this License.  You must supply a copy of this License.  If the work
during execution displays copyright notices, you must include the
copyright notice for the Library among them, as well as a reference
directing the user to the copy of this License.  Also, you must do one
of these things:

    a) Accompany the work with the complete corresponding
    machine-readable source code for the Library including whatever
    changes were used in the work (which must be distributed under
    Sections 1 and 2 above); and, if the work is an executable linked
    with the Library, with the complete machine-readable "work that
    uses the Library", as object code and/or source code, so that the
    user can modify the Library and then relink to produce a modified
    executable containing the modified Library.  (It is understood
    that the user who changes the contents of definitions files in the
    Library will not necessarily be able to recompile the application
    to use the modified definitions.)

    b) Use a suitable shared library mechanism for linking with the
    Library.  A suitable mechanism is one that (1) uses at run time a
    copy of the library already present on the user's computer system,
    rather than copying library functions into the executable, and (2)
    will operate properly with a modified version of the library, if
    the user installs one, as long as the modified version is
    interface-compatible with the version that the work was made with.

    c) Accompany the work with a written offer, valid for at
    least three years, to give the same user the materials
    specified in Subsection 6a, above, for a charge no more
    than the cost of performing this distribution.

    d) If distribution of the work is made by offering access to copy
    from a designated place, offer equivalent access to copy the above
    specified materials from the same place.

    e) Verify that the user has already received a copy of these
    materials or that you have already sent this user a copy.

  For an executable, the required form of the "work that uses the
Library" must include any data and utility programs needed for
reproducing the executable from it.  However, as a special exception,
the materials to be distributed need not include anything that is
normally distributed (in either source or binary form) with the major
components (compiler, kernel, and so on) of the operating system on
which the executable runs, unless that component itself accompanies
the executable.

  It may happen that this requirement contradicts the license
restrictions of other proprietary libraries that do not normally
accompany the operating system.  Such a contradiction means you cannot
use both them and the Library together in an executable that you
distribute.

  7. You may place library facilities that are a work based on the
Library side-by-side in a single library together with other library
facilities not covered by this License, and distribute such a combined
library, provided that the separate distribution of the work based on
the Library and of the other library facilities is otherwise
permitted, and provided that you do these two things:

    a) Accompany the combined library with a copy of the same work
    based on the Library, uncombined with any other library
    facilities.  This must be distributed under the terms of the
    Sections above.

    b) Give prominent notice with the combined library of the fact
    that part of it is a work based on the Library, and explaining
    where to find the accompanying uncombined form of the same work.

  8. You may not copy, modify, sublicense, link with, or distribute
the Library except as expressly provided under this License.  Any
attempt otherwise to copy, modify, sublicense, link with, or
distribute the Library is void, and will automatically terminate your
rights under this License.  However, parties who have received copies,
or rights, from you under this License will not have their licenses
terminated so long as such parties remain in full compliance.

  9. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Library or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Library (or any work based on the
Library), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Library or works based on it.

  10. Each time you redistribute the Library (or any work based on the
Library), the recipient automatically receives a license from the
original licensor to copy, distribute, link with or modify the Library
subject to these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties with
this License.

  11. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Library at all.  For example, if a patent
license would not permit royalty-free redistribution of the Library by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Library.

If any portion of this section is held invalid or unenforceable under any
particular circumstance, the balance of the section is intended to apply,
and the section as a whole is intended to apply in other circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  12. If the distribution and/or use of the Library is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Library under this License may add
an explicit geographical distribution limitation excluding those countries,
so that distribution is permitted only in or among countries not thus
excluded.  In such case, this License incorporates the limitation as if
written in the body of this License.

  13. The Free Software Foundation may publish revised and/or new
versions of the Lesser General Public License from time to time.
Such new versions will be similar in spirit to the present version,
but may differ in detail to address new problems or concerns.

Each version is given a distinguishing version number.  If the Library
specifies a version number of this License which applies to it and
"any later version", you have the option of following the terms and
conditions either of that version or of any later version published by
the Free Software Foundation.  If the Library does not specify a
license version number, you may choose any version ever published by
the Free Software Foundation.

  14. If you wish to incorporate parts of the Library into other free
programs whose distribution conditions are incompatible with these,
write to the author to ask for permission.  For software which is
copyrighted by the Free Software Foundation, write to the Free
Software Foundation; we sometimes make exceptions for this.  Our
decision will be guided by the two goals of preserving the free status
of all derivatives of our free software and of promoting the sharing
and reuse of software generally.

                            NO WARRANTY

  15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO
WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW.
EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR
OTHER PARTIES PROVIDE THE LIBRARY "AS IS" WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE
LIBRARY IS WITH YOU.  SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME
THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

  16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY
AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU
FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR
CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES.

                     END OF TERMS AND CONDITIONS

           How to Apply These Terms to Your New Libraries

  If you develop a new library, and you want it to be of the greatest
possible use to the public, we recommend making it free software that
everyone can redistribute and change.  You can do so by permitting
redistribution under these terms (or, alternatively, under the terms of the
ordinary General Public License).

  To apply these terms, attach the following notices to the library.  It is
safest to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least the
"copyright" line and a pointer to where the full notice is found.

    <one line to give the library's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

Also add information on how to contact you by electronic and paper mail.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the library, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the
  library `Frob' (a library for tweaking knobs) written by James Random Hacker.

  <signature of Ty Coon>, 1 April 1990
  Ty Coon, President of Vice

That's all there is to it!
PK      j[ߋ^  ^  *  author-template-1753462753/woocommerce.cssnu [        /*!
Woo-Commerce Stylesheet
Version: 1.2.0
Designed by A$ad!!
*/

/* PopularFX header menu start*/
.pfx-menu-cart.cart-customlocation{
	display: none;
}

header .pfx-menu-cart.cart-customlocation{
	display: inline-block;
}

.cart-customlocation sup{
	top: -12px;
	line-height: 1.5em;
	font-size: 80%;
}

#customize-preview body #site-navigation .customize-partial-edit-shortcut-button{
	left: -10px !important;
}

/* PopularFX header menu ends*/

.woocommerce main,
.woocommerce-page main{
	margin: 40px auto;
	border: 1px solid #eaeaea;
	box-shadow: 0px 0px 30px 0 #0000000a;
	padding: 15px;
}

.woocommerce-shop main .woocommerce-products-header__title{
	margin: 0px;	
}

.woocommerce-shop main .woocommerce-ordering select{
	padding: 6px;
	border: 1px solid #ccc;
	border-radius: 4px;
	box-shadow: 0px 0px 10px 0px #0000000f;
	color: #666;
	font-size: 14px;
	outline: none !important;
}

.woocommerce ul.products li.product .star-rating {
	display: none;
}

.woocommerce ul.products li.product .pfx-star-rating-container {
	padding: 0px 5px;
}

.woocommerce ul.products li.product .star-rating.pfx-star-rating:hover span{
	width: 100% !important;
}
.woocommerce .products ul, .woocommerce ul.products {
    display: flex;
    flex-wrap: wrap;
}
.woocommerce .site-main ul.products li.product, .woocommerce-page .site-main ul.products li.product{
	margin: 0 2% 2% 0;
	border-radius: 5px;
	flex: 1 1 0;
}

.woocommerce ul.products.columns-1 li.product,
.woocommerce-page ul.products.columns-1 li.product {
	width: 100%;
	max-width: 100%;
	min-width: 100%;
}

.woocommerce ul.products.columns-2 li.product,
.woocommerce-page ul.products.columns-2 li.product {
	width: 49%;
	max-width: 49%;
	min-width: 49%;
}

.woocommerce ul.products.columns-3 li.product,
.woocommerce-page ul.products.columns-3 li.product {    
	width: 32%;
	max-width: 32%;
	min-width: 32%;
}

.woocommerce ul.products.columns-4 li.product,
.woocommerce-page ul.products.columns-4 li.product {
	width: 23.5%;
	max-width: 23.5%;
	min-width: 23.5%;
}

.woocommerce ul.products.columns-5 li.product,
.woocommerce-page ul.products.columns-5 li.product {
	width: 18.4%;
	max-width: 18.4%;
	min-width: 18.4%;
}

.woocommerce ul.products.columns-6 li.product,
.woocommerce-page ul.products.columns-6 li.product{
	width: 15%;
	max-width: 15%;
	min-width: 15%;
}

.woocommerce ul.products.columns-2 li.product:nth-child(2n),
.woocommerce-page ul.products.columns-2 li.product:nth-child(2n),
.woocommerce ul.products.columns-3 li.product:nth-child(3n),
.woocommerce-page ul.products.columns-3 li.product:nth-child(3n),
.woocommerce ul.products.columns-4 li.product:nth-child(4n),
.woocommerce-page ul.products.columns-4 li.product:nth-child(4n),
.woocommerce ul.products.columns-5 li.product:nth-child(5n),
.woocommerce-page ul.products.columns-5 li.product:nth-child(5n),
.woocommerce ul.products.columns-6 li.product:nth-child(6n),
.woocommerce-page ul.products.columns-6 li.product:nth-child(6n) {
	margin-right: 0;
	clear: right;
}

.woocommerce ul.products li.product a img{
	border-radius: 5px 5px 0px 0px;
}

.woocommerce ul.products li.product .woocommerce-loop-product__title,
.woocommerce ul.products li.product .woocommerce-loop-category__title{
	padding: 0px 5px 5px;
}

.woocommerce ul.products li.product .price {
	padding: 0px 5px;
}

.woocommerce ul.products li.product .button {
	margin-left: 5px;
	margin-bottom: 1em;
}

.woocommerce #respond input#submit, .woocommerce a.button,
.woocommerce button.button, .woocommerce input.button,
.woocommerce #respond input#submit.alt, .woocommerce a.button.alt,
.woocommerce button.button.alt, .woocommerce input.button.alt {
	font-family: inherit;
	font-size: 80%;
	-webkit-font-smoothing: subpixel-antialiased;
}

.woocommerce .product #respond input#submit, .woocommerce .product a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce .product button.button, .woocommerce .product input.button, .woocommerce .product #respond input#submit.alt, .woocommerce .product a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt .woocommerce .product button.button.alt, .woocommerce .product input.button.alt{
	border: solid;
}

.woocommerce a.added_to_cart {
	padding: .5em;
	font-size: 70%;
}

.woocommerce nav.woocommerce-pagination {
	text-align: left;
}

.woocommerce nav.woocommerce-pagination ul {
	border: 0px;
}

.woocommerce nav.woocommerce-pagination ul li {
	margin: 0 5px 5px 0;
	border: 0px;
}

.woocommerce nav.woocommerce-pagination ul li a,
.woocommerce nav.woocommerce-pagination ul li span {
	padding: .75em;
	min-width: 2.5em;
	text-align: center;
}

.woocommerce span.onsale {
	min-height: 3.736em;
	min-width: 3.736em;
	font-size: 80% !important;
	font-weight: 500 !important;
	box-shadow: 1px -1px 10px 0px #0000001f;
}

/* Shop Page design end */

/* Product Page design start */

.product-template-default.single-product aside{
	display: none;
	width: 0px;
}

.woocommerce div.product .product_title {
	margin: 0.5em 0px 10px;
}

.woocommerce div.product .woocommerce-product-rating .woocommerce-review-link:hover{
	color: #000000;
}

.woocommerce .quantity .qty {
	height: 30.8px;
}

.woocommerce div.product p.price, .woocommerce div.product span.price {
	margin: 0px;
	text-decoration: none !important;
}

.woocommerce div.product p.price ins, .woocommerce div.product span.price ins {
	text-decoration: none;
}

.woocommerce div.product form.cart {
	margin-bottom: 0.5em;
	padding-bottom: 10px;
	border-bottom: 1px solid #eee;
}

.posted_in a{
	color: inherit;
	font-weight: bold;
	font-style: italic;
}

.posted_in a:hover{
	color: #000000;
}

.woocommerce div.product .woocommerce-tabs ul.tabs li {
	border: 0px;
}

.woocommerce div.product .woocommerce-tabs ul.tabs li:hover,
.woocommerce div.product .woocommerce-tabs ul.tabs li.active {
	background-color: #5C7AEA;
}

.woocommerce div.product .woocommerce-tabs ul.tabs li:hover a,
.woocommerce div.product .woocommerce-tabs ul.tabs li.active a{
	color: #ffffff;
	outline: 0px;
}

.product section.up-sells.upsells.products {
    clear: both;
}

.woocommerce div.product .woocommerce-tabs .panel {
	padding: 10px 50px;
	min-width: 100%;
}

.woocommerce div.product .woocommerce-tabs .panel h2,
.woocommerce div.product .woocommerce-tabs .panel p{
	margin: 5px 0px;
}

.woocommerce div.product .woocommerce-tabs .panel .woocommerce-Reviews #comments{
	width: 50%;
	float: left;
}

.woocommerce div.product .woocommerce-tabs .panel .woocommerce-Reviews #comments .woocommerce-Reviews-title{
	font-size: 35px;
	padding-bottom: 10px;
}

.woocommerce div.product .woocommerce-tabs .panel .woocommerce-Reviews #comments .commentlist{
	padding-left: 0px;
}

.woocommerce #reviews #comments ol.commentlist li img.avatar {
	width: 45px;
	border-radius: 50%;
	padding: 0px;
	top: 5px;
}

.woocommerce div.product .woocommerce-tabs .panel .woocommerce-Reviews #review_form_wrapper{
	width: 50%;
	float: right;
}

.woocommerce #review_form #respond {
	margin: 15px 15px 0px;
	width: 100%;
	padding: 30px 25px;
	border: 1px solid #eee;
}

.woocommerce #review_form #respond *{
	padding: 2px 5px;
}

/* Woocommerce Product page Ends */

/* Woocommerce Cart Start*/
.woocommerce-page .entry-content{
	min-width: 100%;
}

.woocommerce table.shop_table thead{
	background: #000000;
	color: #ffffff;
}

.woocommerce table.shop_table th {
	padding: 15px 10px;
}

.woocommerce table.shop_table tbody tr:nth-child(odd),
.woocommerce table.shop_table tbody tr:last-child,
.woocommerce table.shop_table tbody tr:last-child:hover{
	background: #ffffff !important;
}

.woocommerce table.shop_table tbody tr:nth-child(even){
	background: #f7f6f7;
}

.woocommerce table.shop_table tbody tr:hover{
	background: #f7f6f7 !important;
}

.woocommerce table.shop_table td {
	border-top: 0px;
	padding: 10px 10px;
}

.woocommerce table.shop_table tr {
	outline: 1px solid #eee;
}

.woocommerce a.remove{
	font-weight: 200;
	border: 1px solid;
	margin: auto;
	line-height: 0.8em;
}

.woocommerce-cart table.cart img, .woocommerce-checkout table.cart img {
	width: 60px;
	height: 60px;
	vertical-align: middle;
}

.woocommerce table.shop_table .product-name *{
	color: #444444;
	text-decoration: underline;
}

.woocommerce #content table.cart td.actions, .woocommerce table.cart td.actions,
.woocommerce-page #content table.cart td.actions, .woocommerce-page table.cart td.actions {
	padding: 20px 20px 20px;
}

.woocommerce-cart table.cart td.actions .coupon .input-text,
.woocommerce-checkout table.cart td.actions .coupon .input-text {
	width: 250px;
	height: 36px;
	border-radius: 4px;
	box-shadow: 0px 0px 10px 0px #0000000f;
}

.woocommerce .cart .button, .woocommerce .cart input.button,
.woocommerce .button.wc-backward, .woocommerce .cart .button.wc-backward {
	padding: 12px 20px !important;
}

.cart-collaterals .cart_totals {
	margin-top: 20px;
	box-shadow: 0px 0px 10px 0px #0000000f;
	padding: 20px;
}

.cart-collaterals .cross-sells h2 {
	margin: 40px 0px 10px;
	font-size: 30px;
}

.cart-collaterals .cart_totals h2{
	margin: 0px;
	font-size: 20px;
	padding: 15px 10px;
	background: #000000;
	color: #ffffff;
	text-transform: uppercase;
}

.woocommerce .cart-collaterals .cart_totals th,
.woocommerce-page .cart-collaterals .cart_totals th,
.woocommerce .cart-collaterals .cart_totals td,
.woocommerce-page .cart-collaterals .cart_totals td{
	padding: 15px 10px;
}

#add_payment_method .wc-proceed-to-checkout , .woocommerce-cart .wc-proceed-to-checkout, .woocommerce-checkout .wc-proceed-to-checkout {
	padding-bottom: 0px !important;
}

#add_payment_method .wc-proceed-to-checkout a.checkout-button, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-checkout .wc-proceed-to-checkout a.checkout-button {
	padding: 18px !important;
	margin-bottom: 0px;
}

/* Cart Page Ends*/

/* Checkout Page Start*/

.woocommerce-checkout .checkout.woocommerce-checkout{
	overflow: auto;
}

.woocommerce-checkout .checkout.woocommerce-checkout h3{
	margin: 10px 0px 5px;
}

.woocommerce .col2-set, .woocommerce-page .col2-set{
	width: 56%;
	float: left;
	margin-right: 4%;
	clear: left;
}
.woocommerce .col2-set .col-1, .woocommerce-page .col2-set .col-1,
.woocommerce .col2-set .col-2, .woocommerce-page .col2-set .col-2 {
	width: 100%;
}

.woocommerce form .form-row input.input-text,
.woocommerce form .form-row .select2-container .select2-selection--single{
	padding: 5px 10px;
	height: 40px;
}
.woocommerce form .form-row input.input-text::placeholder{
	text-transform: capitalize;
}

.select2-container .select2-selection--single .select2-selection__rendered{
	padding-left: 0px;
}

.woocommerce form .form-row .select2-container .select2-selection__arrow{
	height: 38px;
}
.woocommerce #order_review_heading, .woocommerce-page #order_review_heading,
.woocommerce #order_review, .woocommerce-page #order_review{
	width: 40%;
	float: right;
	clear: right;
}

.woocommerce-checkout form #order_review_heading {
	border: 2px solid #ebebeb;
	border-bottom: 0px;
	margin: 0;
	padding: 1.5em 1.5em 0.6em;
}

.woocommerce-checkout form #order_review .woocommerce-checkout-review-order-table .product-total{
	text-align:right;
}
.woocommerce-checkout form #order_review {
	padding: 0 2em 2em;
	border-width: 0 2px 2px;
	border-style: solid;
	border-color: #ebebeb;
}

#add_payment_method #payment, .woocommerce-cart #payment, .woocommerce-checkout #payment {
	background: #ffffff;
}

#add_payment_method #payment ul.payment_methods, .woocommerce-cart #payment ul.payment_methods,
.woocommerce-checkout #payment ul.payment_methods, #add_payment_method #payment div.form-row,
.woocommerce-cart #payment div.form-row, .woocommerce-checkout #payment div.form-row{
	padding: 0px;
	border-bottom: 0px;
}

.woocommerce-checkout #payment #place_order {
	width: 100%;
	height: 48px;
}

.cart_totals.calculated_shipping .shop_table tbody td,
.woocommerce-checkout-review-order-table tfoot .cart-subtotal td,
.woocommerce-checkout-review-order-table tfoot .woocommerce-shipping-totals td,
.woocommerce-checkout-review-order-table tfoot .cart-discount td,
.woocommerce-checkout-review-order-table tfoot .order-total td{
	text-align: right;
}

.woocommerce .woocommerce-form-coupon .form-row-last, .woocommerce-page .woocommerce-form-coupon .form-row-last {
	float: left;
}

.woocommerce form .form-row-last button, .woocommerce-page form .form-row-last button{
	padding: 0px 20px !important;
	height: 40px;
}

.woocommerce form .form-row-first, .woocommerce form .form-row-last,
.woocommerce-page form .form-row-first, .woocommerce-page form .form-row-last {
	width: 49%;
}

/* Checkout Page End*/

/* Order Page Start*/
.woocommerce-order .woocommerce-notice--success{
	background: #6ecb63;
	color: #000000;
	Padding: 8px;
	border-radius: 5px;
	margin-bottom: 2em;
}

.woocommerce ul.order_details{
	padding : 0px;
}

.woocommerce-order .woocommerce-order-details .woocommerce-order-details__title,
.woocommerce-order .woocommerce-customer-details .woocommerce-column__title{
	margin: 10px;
}
/* Order Page End*/

/* My Account Start*/

.woocommerce-account .woocommerce{
	border: 1px solid #ebebeb;
	box-shadow: 0px 0px 30px 0 #0000000a;
	margin: 40px auto;
}

.woocommerce-account .woocommerce-MyAccount-navigation {
	width: 25%;
	border: 1px solid #eeeeee;
	border-left: 0px;
	height: 100%;
}

.woocommerce-MyAccount-navigation ul {
	padding: 0px;
	text-transform: uppercase;
	font-size: 14px;
}

.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link{
	border: 0px;
}

.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link *{
	color: #444444 !important;
}

.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link.is-active,
.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link:hover{
	background-color: #5c7aea;
}

.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link.is-active *,
.woocommerce-MyAccount-navigation ul li.woocommerce-MyAccount-navigation-link:hover *{
	color: #ffffff !important;
}

.woocommerce-account .woocommerce-MyAccount-content {
	padding: 30px;
	width: 75%;
}

.woocommerce-MyAccount-content table.shop_table th,
.woocommerce-MyAccount-content table.shop_table td {
	padding: 10px 15px;
}

.woocommerce .woocommerce-MyAccount-content table.shop_table tbody tr:last-child {
	background: revert;
}

.woocommerce-MyAccount-content .col2-set {
	width: 100%;
	margin-right: 0px;
}

.woocommerce-MyAccount-content .col2-set h3 {
	margin: 10px 0px;
}
.woocommerce-MyAccount-content .col2-set address {
	padding: 10px;
	border: 1px solid #eee;
	border-radius: 10px;
	background: #f7f7f744;
	box-shadow: 0px 0px 30px 0 #0000000a;
}
.woocommerce-MyAccount-content button.button{
	padding: 10px 12px !important;
	margin-top: 15px;
}

/* My Account End*/

@media only screen and (max-width: 901px) and (min-width: 501px){

	.woocommerce .site-main,
	.woocommerce-page .site-main {
		padding: 1.5em !important;
	}

	.woocommerce ul.products.columns-4 li.product,
	.woocommerce-page ul.products.columns-4 li.product,
	.woocommerce ul.products.columns-5 li.product,
	.woocommerce-page ul.products.columns-5 li.product,
	.woocommerce ul.products.columns-6 li.product,
	.woocommerce-page ul.products.columns-6 li.product,
	.related.products ul.products.columns-3 li.product,
	.related.products ul.products.columns-3 li.product{
		width: 32%;
		max-width: 32%;
		min-width: 32%;
	}

	.woocommerce ul.products.columns-4 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-4 li.product:nth-child(3n),
	.woocommerce ul.products.columns-5 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-5 li.product:nth-child(3n),
	.woocommerce ul.products.columns-6 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-6 li.product:nth-child(3n),
	.related.products ul.products.columns-3 li.product:nth-child(3n),
	.related.products ul.products.columns-3 li.product:nth-child(3n){
		margin-right: 0 !important;
		clear: right;
	}	

	.woocommerce ul.products.columns-4 li.product:nth-child(4n),
	.woocommerce-page ul.products.columns-4 li.product:nth-child(4n),
	.woocommerce ul.products.columns-5 li.product:nth-child(5n),
	.woocommerce-page ul.products.columns-5 li.product:nth-child(5n),
	.woocommerce ul.products.columns-6 li.product:nth-child(6n),
	.woocommerce-page ul.products.columns-6 li.product:nth-child(6n) {
		margin-right: auto !important;
	}

	.woocommerce #content div.product div.summary, .woocommerce div.product div.summary,
	.woocommerce-page #content div.product div.summary, .woocommerce-page div.product div.summary,
	.woocommerce div.product div.images {
		width: 100%;
	}

	.woocommerce div.product div.images {
		margin-bottom: 1em;
	}

	.woocommerce div.product .woocommerce-tabs .panel {
		padding: 10px;
	}

	.woocommerce div.product .woocommerce-tabs .panel .woocommerce-Reviews #comments,
	.woocommerce div.product .woocommerce-tabs .panel .woocommerce-Reviews #review_form_wrapper{
		width: 100%;
	}

	.woocommerce table.shop_table th {
		padding: 10px 5px;
	}

	.woocommerce table.shop_table td {
		padding: 8px 5px;
		font-size: 15px;
	}

	.woocommerce a.remove {
		font-size: 20px;
	}

	#add_payment_method table.cart img, .woocommerce-cart table.cart img, .woocommerce-checkout table.cart img {
		width: 40px;
		height: 40px;
	}

	.woocommerce .cart-collaterals .cart_totals, .woocommerce-page .cart-collaterals .cart_totals {
		width: 100%;
		padding: 10px;
	}

	.woocommerce #content table.cart td.actions, .woocommerce table.cart td.actions, .woocommerce-page #content table.cart td.actions, .woocommerce-page table.cart td.actions {
		padding: 10px;
	}

	.woocommerce #content table.cart td.actions .button, .woocommerce table.cart td.actions .button, .woocommerce-page #content table.cart td.actions .button, .woocommerce-page table.cart td.actions .button {
		float: right;
		width: auto;
	}

	.woocommerce .col2-set, .woocommerce-page .col2-set,
	.woocommerce #order_review_heading, .woocommerce-page #order_review_heading,
	.woocommerce #order_review, .woocommerce-page #order_review	{
		width: 100%;
		margin-right: 0px;
		margin-bottom: 2em;	
	}

	.woocommerce-page.woocommerce-checkout form #order_review_heading, .woocommerce.woocommerce-checkout form #order_review_heading {
		padding: 1em 1em 0.5em;
	}

	.woocommerce-page.woocommerce-checkout form #order_review, .woocommerce.woocommerce-checkout form #order_review {
		padding: 0 1em 1em;
	}

	.woocommerce ul.order_details li {
		padding: 1em 1.5em 1em 1em;
		width: 100%;
	}

	.woocommerce .widget-area {
		width: 100%;
		float: right;
		margin: 30px 0px 0px;
		height: auto;
	}

	.woocommerce-account .woocommerce-MyAccount-navigation,
	.woocommerce-account .woocommerce-MyAccount-content	{
		width: 100%;
	}

}

@media only screen and (max-width: 768px){

	.woocommerce table.shop_table tr {
		margin: 10px 0px;
	}

	.woocommerce table.shop_table td.product-remove {
		background: #000000 !important;
	}

	.woocommerce table.shop_table td.product-remove *{
		color: #ffffff !important;
	}

	.woocommerce table.shop_table td {
		padding: 10px 10px;
	}
}

@media only screen and (max-width: 701px){

	.woocommerce ul.products.columns-3 li.product,
	.woocommerce-page ul.products.columns-3 li.product,
	.woocommerce ul.products.columns-4 li.product,
	.woocommerce-page ul.products.columns-4 li.product,
	.woocommerce ul.products.columns-5 li.product,
	.woocommerce-page ul.products.columns-5 li.product,
	.woocommerce ul.products.columns-6 li.product,
	.woocommerce-page ul.products.columns-6 li.product,
	.related.products ul.products.columns-3 li.product,
	.related.products ul.products.columns-3 li.product{
		width: 49%;
		max-width: 49%;
		min-width: 49%;
	}

	.woocommerce ul.products.columns-4 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-4 li.product:nth-child(3n),
	.woocommerce ul.products.columns-5 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-5 li.product:nth-child(3n),
	.woocommerce ul.products.columns-6 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-6 li.product:nth-child(3n){
		margin-right: auto !important;
	}

	.woocommerce ul.products.columns-3 li.product:nth-child(2n),
	.woocommerce-page ul.products.columns-3 li.product:nth-child(2n),
	.woocommerce ul.products.columns-4 li.product:nth-child(2n),
	.woocommerce-page ul.products.columns-4 li.product:nth-child(2n),
	.woocommerce ul.products.columns-5 li.product:nth-child(2n),
	.woocommerce-page ul.products.columns-5 li.product:nth-child(2n),
	.woocommerce ul.products.columns-6 li.product:nth-child(2n),
	.woocommerce-page ul.products.columns-6 li.product:nth-child(2n){
		margin-right: 0 !important;
		clear: right;
	}

	.woocommerce #review_form #respond {
		margin: 5px 5px 0px;
		width: 100%;
		padding: 10px 5px;
	}

	.woocommerce #review_form #respond .comments-title,
	.woocommerce #review_form #respond .comment-reply-title {
		font-size: 15px;
	}

	.woocommerce-account .woocommerce-MyAccount-content {
		padding: 1em;
	}

}

@media only screen and (max-width: 501px){

	.woocommerce-ordering,.woocommerce-ordering select {
		width: 100%;
	}
	
	.woocommerce ul.products.columns-2 li.product,
	.woocommerce-page ul.products.columns-2 li.product,
	.woocommerce ul.products.columns-3 li.product,
	.woocommerce-page ul.products.columns-3 li.product,
	.woocommerce ul.products.columns-4 li.product,
	.woocommerce-page ul.products.columns-4 li.product,
	.woocommerce ul.products.columns-5 li.product,
	.woocommerce-page ul.products.columns-5 li.product,
	.woocommerce ul.products.columns-6 li.product,
	.woocommerce-page ul.products.columns-6 li.product,
	.related.products ul.products.columns-3 li.product,
	.related.products ul.products.columns-3 li.product {
		width: 100%;
		max-width: 100%;
		min-width: 100%;
	}
	
	.woocommerce ul.products.columns-3 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-3 li.product:nth-child(3n),
	.woocommerce ul.products.columns-4 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-4 li.product:nth-child(3n),
	.woocommerce ul.products.columns-5 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-5 li.product:nth-child(3n),
	.woocommerce ul.products.columns-6 li.product:nth-child(3n),
	.woocommerce-page ul.products.columns-6 li.product:nth-child(3n),
	.woocommerce ul.products.columns-3 li.product:nth-child(2n),
	.woocommerce-page ul.products.columns-3 li.product:nth-child(2n),
	.woocommerce ul.products.columns-4 li.product:nth-child(2n),
	.woocommerce-page ul.products.columns-4 li.product:nth-child(2n),
	.woocommerce ul.products.columns-5 li.product:nth-child(2n),
	.woocommerce-page ul.products.columns-5 li.product:nth-child(2n),
	.woocommerce ul.products.columns-6 li.product:nth-child(2n),
	.woocommerce-page ul.products.columns-6 li.product:nth-child(2n) {
		margin-right: auto !important;
	}
	
	.woocommerce ul.products.columns-3 li.product,
	.woocommerce-page ul.products.columns-3 li.product,
	.woocommerce ul.products.columns-4 li.product,
	.woocommerce-page ul.products.columns-4 li.product,
	.woocommerce ul.products.columns-5 li.product,
	.woocommerce-page ul.products.columns-5 li.product,
	.woocommerce ul.products.columns-6 li.product,
	.woocommerce-page ul.products.columns-6 li.product{
		margin-right: 0 !important;	
		margin-bottom: 1em !important;	
	}
	
	.woocommerce main,
	.woocommerce-page main {
		padding: 1em !important;
	}
	
	.woocommerce #content table.cart td.actions .coupon, .woocommerce table.cart td.actions .coupon,
	.woocommerce-page #content table.cart td.actions .coupon, .woocommerce-page table.cart td.actions .coupon,
	.woocommerce-cart table.cart td.actions .coupon .input-text,
	.woocommerce table.cart td.actions .coupon .input-text+.button{
		width: 100%;
	}
	
	.woocommerce-page table.cart td.actions .button{
		width: 100%;
		margin-top: 10px;
	}

}

@media only screen and (max-width: 301px){

	.woocommerce ul.products li.product .woocommerce-loop-product__title {
		padding: 0px 10px 5px;
	}
	
	.woocommerce ul.products li.product .price {
		padding: 0px 10px;
	}
	
	.woocommerce ul.products li.product .button {
		margin-left: 10px;
		margin-bottom: 1.5em;
	}
	
}PK      j[    '  author-template-1753462753/comments.phpnu [        <?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package PopularFX
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>
		<h2 class="comments-title">
			<?php
			$popularfx_comment_count = get_comments_number();
			if ( '1' === $popularfx_comment_count ) {
				printf(
					/* translators: 1: title. */
					esc_html__( 'One thought on &ldquo;%1$s&rdquo;', 'popularfx' ),
					'<span>' . wp_kses_post( get_the_title() ) . '</span>'
				);
			} else {
				printf( 
					/* translators: 1: comment count number, 2: title. */
					esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $popularfx_comment_count, 'comments title', 'popularfx' ) ),
					number_format_i18n( $popularfx_comment_count ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					'<span>' . wp_kses_post( get_the_title() ) . '</span>'
				);
			}
			?>
		</h2><!-- .comments-title -->

		<?php the_comments_navigation(); ?>

		<ol class="comment-list">
			<?php
			wp_list_comments(
				array(
					'style'      => 'ol',
					'short_ping' => true,
				)
			);
			?>
		</ol><!-- .comment-list -->

		<?php
		the_comments_navigation();

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() ) :
			?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'popularfx' ); ?></p>
			<?php
		endif;

	endif; // Check for have_comments().

	comment_form();
	?>

</div><!-- #comments -->
PK      j[D*    %  author-template-1753462753/header.phpnu [        <?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package PopularFX
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'popularfx' ); ?></a>

	<header id="masthead" class="site-header">
		<div class="site-branding">
			<?php
			the_custom_logo();
			if ( is_front_page() && is_home() ) :
				?>
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php
			else :
				?>
				<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
			endif;
			$popularfx_description = get_bloginfo( 'description', 'display' );
			if ( $popularfx_description || is_customize_preview() ) :
				?>
				<p class="site-description"><?php echo $popularfx_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
			<?php endif; ?>
		</div><!-- .site-branding -->
		<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><span class="dashicons dashicons-menu-alt2"></span></button>
		<nav id="site-navigation" class="main-navigation hidden-mobile">
			
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'primary',
					'menu_id'        => 'primary-menu',
				)
			);
			?>
		</nav><!-- #site-navigation -->
	</header><!-- #masthead -->
PK      j[T<  <  5  custom_functions_1753793507/images/popularfx-logo.pngnu [        PNG

   
IHDR   <   <   :r   sRGB,   	pHYs  .#  .#x?v  IDATxݚlEǇJ)"bD-JQ1 U			!QDCPGF 1Q+*B %RyD0AP(Ҏv:77{%Pٝw;=Bn[F- [^DK(00\B	H<\B	>΃QJ@cNpE{0{[9
105
D#uN䈯%fPoPdT&n4}o+ԗ&ج+X2W_b@"|<,cǙ	ւws!n9%)em6
En{i7`@JY QeboQQ \L?,
Xel6Z&vmO |hYh6vfj%V hapc: sfV9LOz̐n{@E[^oc'"	+$b#c0 {f$_Y& <Z02y^ڇcHcgy,] $ay>ŗdOpkY+;.SQglV"&[S0BO@#n##ɵ, ^Fٶǅ, .7Xخ={e\P61(ֳ1T&*hӖuikx V+M]s|΍cl"֖,FxoϺlV
*»u;'Y&o~aVd2i:Z鿯ဦIGeZa]Q[baz
=Y7PȞMI
uunckD$r
,ظ *H`i< _)A7.<_#LԀfĝA)xTXG]kʢRM|,.\4'ZiPJg~X> ցAY@h'
OCR"Ap8"`(4xކPg Lh>M|pXq	-lFJ@,5;J^g)ޞE@Sat+Bוm\n,nz߾$<0x%0JI54g
A_&epG)<t%HiU`ǁv=t1!;Kͅ)N M]7@h@d28!]K@X.yW
|?'K `ݸph߁YTM#+3A~ಒtxc#ց|$7;/ԒO$NJ%FKsnD~hALM6Iwdi_3
! ,h;6 V!y?,Bn1!`A.xv놷siG`]|o7tghs?
交n9zF<H56vFYjv%ʝm*-f%;oK՝3ڥl"t8ŧ~0q5ysPW3QEŮK+oG5O]PI"BH?!6	i尗F/!A,;~0L}1M[)}S$]ȭ	Hbr9rhvД;X-BaDFMsC쥃ߴq万Q
    IENDB`PK      j[G$χX  X  8  custom_functions_1753793507/images/loginizer-product.pngnu [        PNG

   
IHDR  @   L   %ne   sRGB,   	pHYs  .#  .#x?v  IDATx]	xUuoQGM@QqA}DpƍE&J"C	6	 dA ˝wUvU]	ם]]u.xy߀-G'W!6ΡM`gp,+@f
5
*kK`op
xB4

D F1`'+%3"+v
u^E0c3*0YrB@@@{ \
Wglex@e`}Y
x	{`A1QXҒnn#̌Tݱ%|5ҷ+OgvaakBH%"E뛑9~$- ~߯8q,KM{搕עH);ot	k:Gl26lB6w_Bx|P{~D"~v!fjŎn5Ww1oa+DXpUh³z{~`({lvoRvk!=	o}XC4@#XYl.[=9}b8,  `EbJ*B4<[XkjK_VCzIن]L{SGcn>*ﮡHf#,bӳsP@dCvUI$rGY= u$IAqqq-.`-^{\ 9~E&:
:= n2|"6 }>1{:הI"^>]#u߲S
OY؃`wxެ'I)ٻsfDEd/k,6%+zhnpc1.u)Ao ʟ*߾uZn.
 Y4|2}*^ʼ\%̈́IoK=Y+ّBW΁=U쟟-Gi~FO'&^[S hڷvY6~% k	ii(b	WP**dOe#lBRi(v~Cd3z@!񒎐|]ViHm}[veO?bϝƒ30yWnG&=Ȝy,+u{vXס4֟o@>([-[9l]Vev	\߂+ G7/g-[y[mڛ~fKJة3gXˢg;^RӾ|[y#]6pA Px6^@o_9[#"!.
$f* YwYg(E5C$*+ѧ=iO!CR<1d
E }c$ҞfO	
F0hխhO!d] S& 	<^C(xmZƀσ3NuP~[SݵoS111͈4͓i؄t4y.5J5?7:}n$sz	Ýsu_ރkJ	
-hQc~E}{=9K
   Fhӥ<]fϟЁ u FVۅ$4^Ul̳.ɶ:w>/`nag<?"OՇzĹ萮u+x/Bw[<R[fVݏ`E.H_I{@~|;5kS8|x<?-ɫY
\uE^B@WzJ;%x|twúa~
ZBmFi9EW0])ݠ,M[=d!h<׃en`ϴcs_@rquHܢ(c<hu\Rx)$I[auCkg0\sn vf6:?-wWi A:csvCG srkw$کK+Pj ]E EY _$)t@I7E#i!)[i
ickC\~^v27GW[
-;7sz929
`3MOjEC iXVIp9Wi=to]w)M%e^y}vX ^7ͷj2M*8[ztB .5q+'*+()ѥ\}%eTE:Y .VC
N.
׷J<CRz}rܪ~.P櫪M᳞V$e
WErIV?:Hl,)1LKE^C u[=; &!.
dQ-#1X
/h_7>%jxj%v?SƗV!(J)t<
4])wؖ֜0i'1$7|_	n&nm4vz2aSW
CpI\O7։iyሐk^nkTWMru䁒E>Z<˴M-X+2V?Xɞn- )bkң,z.H[;pIʘjMDivJ{.V^^cxFS>=jORS6(4^Lp7G:K H'Y>@v-Sh3')\M}F2<.`XKi,rܽdZrv%)ohH q-]x~Xfh[a)[mE8 Iĕܤ׹߅Q'/K(vWujc ?ck׊1;[СFi
"66Y N=?uN)J )鯷DK %`4")?<ijԥ!6%Nl[;ni6Dri82̾#.M1Jk ­7
 &x¶:F)@i@ޭ
 մW}IRa>Qtz
05
<e] 5L i*DQ l
>-Ss?!`mX6%i`()sn|˖Sv%W\\aR FlR<z, ]Ew`XmIR!$}ڊުI.?ry
狸n	t; "P<ڥIHC@[CV` `J]'EH @&^(_Ke6B1IO:K M)J
.֞ZyP{+|iYf:*Lno7 dFQ  a4e;EP` +I5*I%<,n#ntUyKsx_,DzD
ڲ9 5T WնQ\#-S
Td1@4t5Z o)WNn<LǦ))@:s_P෶B-Npڶh	 mTHQfLh>IU:gIJq}6XS"kˠ6^A
-fuF ~gfss=tV/76ؑ&N[/vJJ&}8%t	֟%e.HDڛ%e:A[HsD?(c1WHʳ_v3a蓖rVH>[̖ 
8xU?Lsz`JJ+tE|,-ORVDvapm(qJ>>|Xd;fJ~HP2VaM8+&2>Sj)@~)-eͷ%o2%nkPkWϜpM2WmK")U+z+SM@=aM!\KkRG* 1HVlԈIخUiWp56Vmm&	GcFY tIqLlmSkP0`$µ]:Mq&P݀Hl9ӃzNcQ	/9Z::Ǭ8aZoyE?fgN5?:ĵ(0 0wAtCzZ	AYbD#AM@DͼR./fFjz#w
JA=C?
Qѩrv}2w?|\w6#;L \D4P).7oȉj<T7)9=>> t:I9^vm.3AR`Ls-ve%Ԁ+tN_	5mQHaH!eLP9SM/$$׆Z :B}ÈE	_ō2M&)Gy7:^3IBS0V[sZ5H ғZ);CKnV΢UJkK6*	uYW(f[Uyg.5kK7oZnmZLD5HxQjOʛ#
gB꩑K/ qr$̸a=uα C;+tb ?E٭~zYymF D#X1Ճ_f~]+S&ܽFGaz{1%!h_.ȇ7ܴv:$E>ZEᐎa4g!ں^#:f@0HW5Omdw|>k:t0`?lV3?'PS?	ȷQ.SPǝAW}q0љ4lX<s
 z+@Vʯ7IC
kX +L\H|Y_įIA4m&~ozَi.ÎT@RhKQ[ٱ3-\')ko
(߶_%mGRhD2yHښ')m;$eFۦձ!N;1C?0|*nZ&_@R)D3$ǅ\ٌG.<h{u@ꀙFu:k#7g
;VTU;t'Q_7Uˎ4
Gjvrk7\N(W9Hp?Պ^ qi6Y^.A"XO?FEhAG=lޏ]v1_Mn{8l7`Eu
8Dɑy؛_~l=/Ȧ=Bz~:)*[/(7UZZ
E-plrj\Ɩ$ъrEvٱxXP}O=fGQ/[8r٥rsI, ) WDi!"o6/x
_"~}RٷG:8WPiX` 3,ؐXĎ)#YI:MRvs茥o2q s7 NvLZ
>TW o&vn="!Dn.KfeeeďҏC/9euXj8[v1ԽkAywKi@؀\βEv$mI\}s*1;91̗ظal-VG~İHy|Tr~mx
mP^_-J߁b3Y5L'ss,yKq>~XHm`e[rďV{_V{~7yѓ؃n rF00
^T'+HU[ߩkCb==i\BV
:`eHa!pk9gH	Xǉch&l.{ahvvxND
ui(JBݦ$>02K5@<Y=JJBI.S(EiKbG@d\6r 9Mϒ׳>Of?WKe%xx|Bll,ӧú_[tq0zXGpc?~)><v0rŇk/yK!p84# P
a3#Y9iMWVc8!!&@LiXPŐ:KV
SFKQ`rnFD@@@ *PLh_C`/YٓTWmep' ++6})UOjW}T    IENDB`PK      j[~f    /  custom_functions_1753793507/images/progress.svgnu [        <?xml version="1.0" encoding="UTF-8" standalone="no"?><svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.0" width="32px" height="32px" viewBox="0 0 128 128" xml:space="preserve"><g><linearGradient id="linear-gradient"><stop offset="0%" stop-color="#ffffff" fill-opacity="0"/><stop offset="100%" stop-color="#00557d" fill-opacity="1"/></linearGradient><path d="M63.85 0A63.85 63.85 0 1 1 0 63.85 63.85 63.85 0 0 1 63.85 0zm.65 19.5a44 44 0 1 1-44 44 44 44 0 0 1 44-44z" fill="url(#linear-gradient)" fill-rule="evenodd"/><animateTransform attributeName="transform" type="rotate" from="0 64 64" to="360 64 64" dur="1320ms" repeatCount="indefinite"></animateTransform></g></svg>PK      j[VD  D  /  custom_functions_1753793507/inc/woocommerce.phpnu [        <?php
/**
 * WooCommerce Compatibility File
 *
 * @link https://woocommerce.com/
 *
 * @package PopularFX
 */


/**
 * WooCommerce specific scripts & stylesheets.
 *
 * @return void
 */
function popularfx_woocommerce_scripts() {
	$inline = '.popularfx-body.woocommerce-page main{
padding: 15px;
}';

	wp_add_inline_style( 'popularfx-style', $inline );
}
add_action( 'wp_enqueue_scripts', 'popularfx_woocommerce_scripts' );

/**
 * Disable the default WooCommerce stylesheet.
 *
 * Removing the default WooCommerce stylesheet and enqueing your own will
 * protect you during WooCommerce core updates.
 *
 * @link https://docs.woocommerce.com/document/disable-the-default-stylesheet/
 */
//add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

/**
 * Add 'woocommerce-active' class to the body tag.
 *
 * @param  array $classes CSS classes applied to the body tag.
 * @return array $classes modified to include 'woocommerce-active' class.
 */
function popularfx_woocommerce_active_body_class( $classes ) {
	$classes[] = 'woocommerce-active';

	return $classes;
}
add_filter( 'body_class', 'popularfx_woocommerce_active_body_class' );

/**
 * Related Products Args.
 *
 * @param array $args related products args.
 * @return array $args related products args.
 */
function popularfx_woocommerce_related_products_args( $args ) {
	$defaults = array(
		'posts_per_page' => 3,
		'columns'        => 3,
	);

	$args = wp_parse_args( $defaults, $args );

	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'popularfx_woocommerce_related_products_args' );

/**
 * Remove default WooCommerce wrapper.
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

if ( ! function_exists( 'popul