     <?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package PopularFX
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function popularfx_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'popularfx_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function popularfx_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'popularfx_pingback_header' );
PK      k[	    +  custom-file-4-1753968290/inc/customizer.phpnu [        <?php
/**
 * PopularFX Theme Customizer
 *
 * @package PopularFX
 */

add_action( 'wp_head', 'popularfx_global_styles', 4 );
function popularfx_global_styles(){
	
	global $pagelayer, $popularfx;
	
	$settings = ['body', 'p', 'button', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'color', 'max_width' => 'content_width', 'tablet_breakpoint', 'mobile_breakpoint', 'template'];
	
	foreach($settings as $k => $v){
		
		$set = get_theme_mod('popularfx_'