
		// Woocommerce Sidebar
		$wp_customize->add_setting( 'popularfx_sidebar_woocommerce', array(
			'capability' => 'edit_theme_options',
			'transport' => 'refresh',
			'default' => 0,
			'sanitize_callback' => 'sanitize_text_field',
			) );
		
		$wp_customize->add_control( 'popularfx_sidebar_woocommerce', array(
			'type' => 'select',
			'section' => 'popularfx_sidebar',
			'settings' => 'popularfx_sidebar_woocommerce',
			'label' => __( 'Woocommerce Shop Page Sidebar', 'popularfx' ),
			'choices' => array(
				'default' => __( 'Default', 'popularfx' ),
				'0' => __( 'No Sidebar', 'popularfx' ),
				'left' => __( 'Left Sidebar', 'popularfx' ),
				'right' => __( 'Right Sidebar', 'popularfx' ),
			),
		) );
	
	}
		
	// Sidebar Width
	$wp_customize->add_setting( 'popularfx_sidebar_width', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => 20,
		'sanitize_callback' => 'absint',
	) );
		
	$wp_customize->add_control( 'popularfx_sidebar_width', array(
		'type' => 'number',
		'section' => 'popularfx_sidebar',
		'settings' => 'popularfx_sidebar_width',
		'label' => __( 'Sidebar Width', 'popularfx' ),
		'description' => __( 'Set the width of the Sidebar in percentage','popularfx'),
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	) );
		
	//---------------------------------
	// Scroll to Top
	//---------------------------------
	
	$wp_customize->add_section( 'popularfx_scrolltop', array(
		'capability' => 'edit_theme_options',
		'priority'   => 5,
		'title'      => __( 'Scroll to Top Button','popularfx'),
		'panel'      => 'popularfx_global'
	) );
	
	$wp_customize->add_setting( 'pfx_enable_scrolltop', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => 0,
		'sanitize_callback' => 'popularfx_switch_sanitization',
	) );
	
	$wp_customize->add_control( 'pfx_enable_scrolltop', array(
		'type' => 'checkbox',
		'section' => 'popularfx_scrolltop',
		'priority' => 1,
		'settings' => 'pfx_enable_scrolltop',
		'label' => __('Enable Scroll to Top', 'popularfx' ),
		'input_attrs' => array(
			'class' => 'popularfx-customizer-checkbox',
			'style' => 'border: 1px solid #900',
		),
	) );
	
	$wp_customize->add_setting( 'pfx_scrolltop_position', array(
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
		'sanitize_callback' => 'absint',
		'default' => 95,
	) );
		
	$wp_customize->add_control( 'pfx_scrolltop_position', array(
		'type' => 'number',
		'section' => 'popularfx_scrolltop',
		'settings' => 'pfx_scrolltop_position',
		'label' => __( 'Button Position ', 'popularfx' ),
		'description' => __( 'Set button position for scroll top button in %', 'popularfx' ),
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	) );
	
	$wp_customize->add_setting( 'pfx_scrolltop_padding', array(
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
		'sanitize_callback' => 'absint',
		'default' => 10,
	) );
		
	$wp_customize->add_control( 'pfx_scrolltop_padding', array(
		'type' => 'number',
		'section' => 'popularfx_scrolltop',
		'settings' => 'pfx_scrolltop_padding',
		'label' => __( 'Button Spacing ', 'popularfx' ),
		'description' => __( 'Set button spacing for scroll top button in px', 'popularfx' ),
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	) );
	
	$wp_customize->add_setting( 'pfx_scrolltop_iconsize', array(
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
		'sanitize_callback' => 'absint',
		'default' => 15,
	) );
		
	$wp_customize->add_control( 'pfx_scrolltop_iconsize', array(
		'type' => 'number',
		'section' => 'popularfx_scrolltop',
		'settings' => 'pfx_scrolltop_iconsize',
		'label' => __( 'Icon Size', 'popularfx' ),
		'description' => __( 'Set icon size for scroll top button in px', 'popularfx' ),
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	) );
	
	$wp_customize->add_setting( 'pfx_scrolltop_borderwidth', array(
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
		'sanitize_callback' => 'absint',
		'default' => 2,
	) );
		
	$wp_customize->add_control( 'pfx_scrolltop_borderwidth', array(
		'type' => 'number',
		'section' => 'popularfx_scrolltop',
		'settings' => 'pfx_scrolltop_borderwidth',
		'label' => __( 'Border Width', 'popularfx' ),
		'description' => __( 'Set border width for scroll top button in px', 'popularfx' ),
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	) );
	
	$wp_customize->add_setting( 'pfx_scrolltop_borderradius', array(
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
		'sanitize_callback' => 'absint',
		'default' => 15,
	) );
		
	$wp_customize->add_control( 'pfx_scrolltop_borderradius', array(
		'type' => 'number',
		'section' => 'popularfx_scrolltop',
		'settings' => 'pfx_scrolltop_borderradius',
		'label' => __( 'Border Radius', 'popularfx' ),
		'description' => __( 'Set border radius for scroll top button in px', 'popularfx' ),
		'input_attrs' => array(
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
	) );
	
	$wp_customize->add_setting('pfx_scrolltop_bg_color', array(
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
		'default' => '#ffffff',
		'sanitize_callback' => 'popularfx_hex_rgba_sanitization',
	) );
	
	$wp_customize->add_control( new Popularfx_Customize_Alpha_Color_Control(
		$wp_customize, 'pfx_scrolltop_bg_color', array(
			'section' => 'popularfx_scrolltop',
			'description' => __('Set background color for scrolltop', 'popularfx'),
			'settings' => 'pfx_scrolltop_bg_color',
			'label' => __('Background Color', 'popularfx' ),
			'show_opacity' => true
		)
	) );
	
	$wp_customize->add_setting('pfx_scrolltop_color', array(
		'capability' => 'edit_theme_options',
		'transport' => 'postMessage',
		'default' => '#000000',
		'sanitize_callback' => 'popularfx_hex_rgba_sanitization',
	));
	
	$wp_customize->add_control( new Popularfx_Customize_Alpha_Color_Control(
		$wp_customize, 'pfx_scrolltop_color', array(
			'section' => 'popularfx_scrolltop',
			'description' => __('Set icon color for scrolltop', 'popularfx'),
			'settings' => 'pfx_scrolltop_color',
			'label' => __('Icon Color', 'popularfx' ),
			'show_opacity' => true
		)
	) );
	
	$wp_customize->add_setting('pfx_scrolltop_bg_hover_color', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => '#000000',
		'sanitize_callback' => 'popularfx_hex_rgba_sanitization',
	) );
	
	$wp_customize->add_control( new Popularfx_Customize_Alpha_Color_Control(
		$wp_customize, 'pfx_scrolltop_bg_hover_color', array(
			'section' => 'popularfx_scrolltop',
			'description' => __('Set hover background color for scrolltop', 'popularfx'),
			'settings' => 'pfx_scrolltop_bg_hover_color',
			'label' => __('On Hover Background Color', 'popularfx' ),
			'show_opacity' => true
		)
	) );
	
	$wp_customize->add_setting('pfx_scrolltop_hover_color', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => '#ffffff',
		'sanitize_callback' => 'popularfx_hex_rgba_sanitization',
	) );
	
	$wp_customize->add_control( new Popularfx_Customize_Alpha_Color_Control(
		$wp_customize, 'pfx_scrolltop_hover_color', array(
			'section' => 'popularfx_scrolltop',
			'description' => __('Set hover color for scrolltop', 'popularfx'),
			'settings' => 'pfx_scrolltop_hover_color',
			'label' => __('On Hover Icon Color', 'popularfx' ),
			'show_opacity' => true
		)
	) );
	
	$wp_customize->add_setting('pfx_scrolltop_border_color', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => '#000000',
		'sanitize_callback' => 'popularfx_hex_rgba_sanitization',
	) );
	
	$wp_customize->add_control( new Popularfx_Customize_Alpha_Color_Control(
		$wp_customize, 'pfx_scrolltop_border_color', array(
			'section' => 'popularfx_scrolltop',
			'description' => __('Set border color for scrolltop', 'popularfx'),
			'settings' => 'pfx_scrolltop_border_color',
			'label' => __('Border Color', 'popularfx' ),
			'show_opacity' => true
		)
	) );
	
	$wp_customize->add_setting('pfx_scrolltop_hover_border_color', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => '#000000',
		'sanitize_callback' => 'popularfx_hex_rgba_sanitization',
	) );
	
	$wp_customize->add_control( new Popularfx_Customize_Alpha_Color_Control(
		$wp_customize, 'pfx_scrolltop_hover_border_color', array(
			'section' => 'popularfx_scrolltop',
			'description' => __('Set hover border color for scrolltop', 'popularfx'),
			'settings' => 'pfx_scrolltop_hover_border_color',
			'label' => __('On Hover Border Color', 'popularfx' ),
			'show_opacity' => true
		)
	) );
	
	//---------------------------------
	// Container
	//---------------------------------
	$wp_customize->add_section( 'popularfx_container', array(
		'capability' => 'edit_theme_options',
		'priority'   => 5,
		'title'      => __( 'Container', 'popularfx'),
		'panel'      => 'popularfx_global'
	) );
		
	// Container Width
	$wp_customize->add_setting( 'popularfx_content_width', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => get_option('pagelayer_content_width', 1170),
		'sanitize_callback' => 'absint',
		) );
		
	$wp_customize->add_control( 'popularfx_content_width', array(
		'type' => 'number',
		'section' => 'popularfx_container',
		'settings' => 'popularfx_content_width',
		'label' => __( 'Content Width', 'popularfx' ),
		'description' => __( 'The width of the content container. Default is 1170px', 'popularfx' ),
		'input_attrs' => array(
			'min' => 800,
			'step' => 1,
			'placeholder' => 1170
		),
	) );
		
	// Tablet Breakpoint
	$wp_customize->add_setting( 'popularfx_tablet_breakpoint', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => get_option('pagelayer_tablet_breakpoint', 768),
		'sanitize_callback' => 'absint',
		) );
		
	$wp_customize->add_control( 'popularfx_tablet_breakpoint', array(
		'type' => 'number',
		'section' => 'popularfx_container',
		'settings' => 'popularfx_tablet_breakpoint',
		'label' => __( 'Tablet Breakpoint', 'popularfx' ),
		'description' => __( 'Set the breakpoint for tablet devices. The default breakpoint for tablet layout is 768px.','popularfx'),
		'input_attrs' => array(
			'min' => 500,
			'step' => 1,
			'placeholder' => 768
		),
	) );
		
	// Mobile Breakpoint
	$wp_customize->add_setting( 'popularfx_mobile_breakpoint', array(
		'capability' => 'edit_theme_options',
		'transport' => 'refresh',
		'default' => get_option('pagelayer_mobile_breakpoint', 360),
		'sanitize_callback' => 'absint',
		) );
		
	$wp_customize->add_control( 'popularfx_mobile_breakpoint', array(
		'type' => 'number',
		'section' => 'popularfx_container',
		'settings' => 'popularfx_mobile_breakpoint',
		'label' => __( 'Mobile Breakpoint', 'popularfx' ),
		'description' => __( 'Set the breakpoint for mobile devices. The default breakpoint for mobile layout is 360px.','popularfx'),
		'input_attrs' => array(
			'min' => 200,
			'step' => 1,
			'placeholder' => 360
		),
	) );

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'popularfx_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'popularfx_customize_partial_blogdescription',
			)
		);
	}
}
add_action( 'customize_register', 'popularfx_customize_register', 10);

// Shows the font settings
function popularfx_customize_font($prefix, $text, &$wp_customize){
	
	global $pagelayer, $pl_error;
	
	$popularfx_styles['font-weight'] = ['100', '200', '300', '400', '500', '600', '700', '800', '900', 'normal', 'lighter', 'bold', 'bolder', 'inherit'];
	
	$popularfx_styles['transform'] = ['inherit', 'initial', 'capitalize', 'uppercase', 'lowercase', 'none'];
	
	$popularfx_styles['font-family'] = ['Inherit','ABeeZee', 'Abel', 'Abhaya Libre', 'Abril Fatface', 'Aclonica', 'Acme', 'Actor', 'Adamina', 'Advent Pro', 'Aguafina Script', 'Akaya Kanadaka', 'Akaya Telivigala', 'Akronim', 'Aladin', 'Alata', 'Alatsi', 'Aldrich', 'Alef', 'Alegreya', 'Alegreya Sans', 'Alegreya Sans SC', 'Alegreya SC', 'Aleo', 'Alex Brush', 'Alfa Slab One', 'Alice', 'Alike', 'Alike Angular', 'Allan', 'Allerta', 'Allerta Stencil', 'Allison', 'Allura', 'Almarai', 'Almendra', 'Almendra Display', 'Almendra SC', 'Alumni Sans', 'Amarante', 'Amaranth', 'Amatic SC', 'Amethysta', 'Amiko', 'Amiri', 'Amita', 'Anaheim', 'Andada Pro', 'Andika', 'Andika New Basic', 'Angkor', 'Annie Use Your Telescope', 'Anonymous Pro', 'Antic', 'Antic Didone', 'Antic Slab', 'Anton', 'Antonio', 'Arapey', 'Arbutus', 'Arbutus Slab', 'Architects Daughter', 'Archivo', 'Archivo Black', 'Archivo Narrow', 'Are You Serious', 'Aref Ruqaa', 'Arima Madurai', 'Arimo', 'Arizonia', 'Armata', 'Arsenal', 'Artifika', 'Arvo', 'Arya', 'Asap', 'Asap Condensed', 'Asar', 'Asset', 'Assistant', 'Astloch', 'Asul', 'Athiti', 'Atkinson Hyperlegible', 'Atma', 'Atomic Age', 'Aubrey', 'Audiowide', 'Autour One', 'Average', 'Average Sans', 'Averia Gruesa Libre', 'Averia Libre', 'Averia Sans Libre', 'Averia Serif Libre', 'Azeret Mono', 'B612', 'B612 Mono', 'Bad Script', 'Bahiana', 'Bahianita', 'Bai Jamjuree', 'Ballet', 'Baloo 2', 'Baloo Bhai 2', 'Baloo Bhaina 2', 'Baloo Chettan 2', 'Baloo Da 2', 'Baloo Paaji 2', 'Baloo Tamma 2', 'Baloo Tammudu 2', 'Baloo Thambi 2', 'Balsamiq Sans', 'Balthazar', 'Bangers', 'Barlow', 'Barlow Condensed', 'Barlow Semi Condensed', 'Barriecito', 'Barrio', 'Basic', 'Baskervville', 'Battambang', 'Baumans', 'Bayon', 'Be Vietnam', 'Be Vietnam Pro', 'Bebas Neue', 'Belgrano', 'Bellefair', 'Belleza', 'Bellota', 'Bellota Text', 'BenchNine', 'Benne', 'Bentham', 'Berkshire Swash', 'Besley', 'Beth Ellen', 'Bevan', 'Big Shoulders Display', 'Big Shoulders Inline Display', 'Big Shoulders Inline Text', 'Big Shoulders Stencil Display', 'Big Shoulders Stencil Text', 'Big Shoulders Text', 'Bigelow Rules', 'Bigshot One', 'Bilbo', 'Bilbo Swash Caps', 'BioRhyme', 'BioRhyme Expanded', 'Birthstone', 'Birthstone Bounce', 'Biryani', 'Bitter', 'Black And White Picture', 'Black Han Sans', 'Black Ops One', 'Blinker', 'Bodoni Moda', 'Bokor', 'Bona Nova', 'Bonbon', 'Bonheur Royale', 'Boogaloo', 'Bowlby One', 'Bowlby One SC', 'Brawler', 'Bree Serif', 'Brygada 1918', 'Bubblegum Sans', 'Bubbler One', 'Buda', 'Buenard', 'Bungee', 'Bungee Hairline', 'Bungee Inline', 'Bungee Outline', 'Bungee Shade', 'Butcherman', 'Butterfly Kids', 'Cabin', 'Cabin Condensed', 'Cabin Sketch', 'Caesar Dressing', 'Cagliostro', 'Cairo', 'Caladea', 'Calistoga', 'Calligraffitti', 'Cambay', 'Cambo', 'Candal', 'Cantarell', 'Cantata One', 'Cantora One', 'Capriola', 'Caramel', 'Carattere', 'Cardo', 'Carme', 'Carrois Gothic', 'Carrois Gothic SC', 'Carter One', 'Castoro', 'Catamaran', 'Caudex', 'Caveat', 'Caveat Brush', 'Cedarville Cursive', 'Ceviche One', 'Chakra Petch', 'Changa', 'Changa One', 'Chango', 'Charm', 'Charmonman', 'Chathura', 'Chau Philomene One', 'Chela One', 'Chelsea Market', 'Chenla', 'Cherish', 'Cherry Cream Soda', 'Cherry Swash', 'Chewy', 'Chicle', 'Chilanka', 'Chivo', 'Chonburi', 'Cinzel', 'Cinzel Decorative', 'Clicker Script', 'Coda', 'Coda Caption', 'Codystar', 'Coiny', 'Combo', 'Comfortaa', 'Comic Neue', 'Coming Soon', 'Commissioner', 'Concert One', 'Condiment', 'Content', 'Contrail One', 'Convergence', 'Cookie', 'Copse', 'Corben', 'Cormorant', 'Cormorant Garamond', 'Cormorant Infant', 'Cormorant SC', 'Cormorant Unicase', 'Cormorant Upright', 'Courgette', 'Courier Prime', 'Cousine', 'Coustard', 'Covered By Your Grace', 'Crafty Girls', 'Creepster', 'Crete Round', 'Crimson Pro', 'Crimson Text', 'Croissant One', 'Crushed', 'Cuprum', 'Cute Font', 'Cutive', 'Cutive Mono', 'Damion', 'Dancing Script', 'Dangrek', 'Darker Grotesque', 'David Libre', 'Dawning of a New Day', 'Days One', 'Dekko', 'Dela Gothic One', 'Delius', 'Delius Swash Caps', 'Delius Unicase', 'Della Respira', 'Denk One', 'Devonshire', 'Dhurjati', 'Didact Gothic', 'Diplomata', 'Diplomata SC', 'DM Mono', 'DM Sans', 'DM Serif Display', 'DM Serif Text', 'Do Hyeon', 'Dokdo', 'Domine', 'Donegal One', 'Doppio One', 'Dorsa', 'Dosis', 'DotGothic16', 'Dr Sugiyama', 'Duru Sans', 'Dynalight', 'Eagle Lake', 'East Sea Dokdo', 'Eater', 'EB Garamond', 'Economica', 'Eczar', 'El Messiri', 'Electrolize', 'Elsie', 'Elsie Swash Caps', 'Emblema One', 'Emilys Candy', 'Encode Sans', 'Encode Sans Condensed', 'Encode Sans Expanded', 'Encode Sans SC', 'Encode Sans Semi Condensed', 'Encode Sans Semi Expanded', 'Engagement', 'Englebert', 'Enriqueta', 'Ephesis', 'Epilogue', 'Erica One', 'Esteban', 'Euphoria Script', 'Ewert', 'Exo', 'Exo 2', 'Expletus Sans', 'Explora', 'Fahkwang', 'Fanwood Text', 'Farro', 'Farsan', 'Fascinate', 'Fascinate Inline', 'Faster One', 'Fasthand', 'Fauna One', 'Faustina', 'Federant', 'Federo', 'Felipa', 'Fenix', 'Festive', 'Finger Paint', 'Fira Code', 'Fira Mono', 'Fira Sans', 'Fira Sans Condensed', 'Fira Sans Extra Condensed', 'Fjalla One', 'Fjord One', 'Flamenco', 'Flavors', 'Fleur De Leah', 'Fondamento', 'Fontdiner Swanky', 'Forum', 'Francois One', 'Frank Ruhl Libre', 'Fraunces', 'Freckle Face', 'Fredericka the Great', 'Fredoka One', 'Freehand', 'Fresca', 'Frijole', 'Fruktur', 'Fugaz One', 'Fuggles', 'Gabriela', 'Gaegu', 'Gafata', 'Galada', 'Galdeano', 'Galindo', 'Gamja Flower', 'Gayathri', 'Gelasio', 'Gemunu Libre', 'Gentium Basic', 'Gentium Book Basic', 'Geo', 'Georama', 'Geostar', 'Geostar Fill', 'Germania One', 'GFS Didot', 'GFS Neohellenic', 'Gideon Roman', 'Gidugu', 'Gilda Display', 'Girassol', 'Give You Glory', 'Glass Antiqua', 'Glegoo', 'Gloria Hallelujah', 'Glory', 'Gluten', 'Goblin One', 'Gochi Hand', 'Goldman', 'Gorditas', 'Gothic A1', 'Gotu', 'Goudy Bookletter 1911', 'Gowun Batang', 'Gowun Dodum', 'Graduate', 'Grand Hotel', 'Grandstander', 'Gravitas One', 'Great Vibes', 'Grechen Fuemen', 'Grenze', 'Grenze Gotisch', 'Grey Qo', 'Griffy', 'Gruppo', 'Gudea', 'Gugi', 'Gupter', 'Gurajada', 'Habibi', 'Hachi Maru Pop', 'Hahmlet', 'Halant', 'Hammersmith One', 'Hanalei', 'Hanalei Fill', 'Handlee', 'Hanuman', 'Happy Monkey', 'Harmattan', 'Headland One', 'Heebo', 'Henny Penny', 'Hepta Slab', 'Herr Von Muellerhoff', 'Hi Melody', 'Hina Mincho', 'Hind', 'Hind Guntur', 'Hind Madurai', 'Hind Siliguri', 'Hind Vadodara', 'Holtwood One SC', 'Homemade Apple', 'Homenaje', 'Ibarra Real Nova', 'IBM Plex Mono', 'IBM Plex Sans', 'IBM Plex Sans Arabic', 'IBM Plex Sans Condensed', 'IBM Plex Sans Devanagari', 'IBM Plex Sans Hebrew', 'IBM Plex Sans KR', 'IBM Plex Sans Thai', 'IBM Plex Sans Thai Looped', 'IBM Plex Serif', 'Iceberg', 'Iceland', 'IM Fell Double Pica', 'IM Fell Double Pica SC', 'IM Fell DW Pica', 'IM Fell DW Pica SC', 'IM Fell English', 'IM Fell English SC', 'IM Fell French Canon', 'IM Fell French Canon SC', 'IM Fell Great Primer', 'IM Fell Great Primer SC', 'Imbue', 'Imprima', 'Inconsolata', 'Inder', 'Indie Flower', 'Inika', 'Inknut Antiqua', 'Inria Sans', 'Inria Serif', 'Inter', 'Irish Grover', 'Istok Web', 'Italiana', 'Italianno', 'Itim', 'Jacques Francois', 'Jacques Francois Shadow', 'Jaldi', 'JetBrains Mono', 'Jim Nightshade', 'Jockey One', 'Jolly Lodger', 'Jomhuria', 'Jomolhari', 'Josefin Sans', 'Josefin Slab', 'Jost', 'Joti One', 'Jua', 'Judson', 'Julee', 'Julius Sans One', 'Junge', 'Jura', 'Just Another Hand', 'Just Me Again Down Here', 'K2D', 'Kadwa', 'Kaisei Decol', 'Kaisei HarunoUmi', 'Kaisei Opti', 'Kaisei Tokumin', 'Kalam', 'Kameron', 'Kanit', 'Kantumruy', 'Karantina', 'Karla', 'Karma', 'Katibeh', 'Kaushan Script', 'Kavivanar', 'Kavoon', 'Kdam Thmor', 'Keania One', 'Kelly Slab', 'Kenia', 'Khand', 'Khmer', 'Khula', 'Kirang Haerang', 'Kite One', 'Kiwi Maru', 'Klee One', 'Knewave', 'Kodchasan', 'Koh Santepheap', 'KoHo', 'Kosugi', 'Kosugi Maru', 'Kotta One', 'Koulen', 'Kranky', 'Kreon', 'Kristi', 'Krona One', 'Krub', 'Kufam', 'Kulim Park', 'Kumar One', 'Kumar One Outline', 'Kumbh Sans', 'Kurale', 'La Belle Aurore', 'Lacquer', 'Laila', 'Lakki Reddy', 'Lalezar', 'Lancelot', 'Langar', 'Lateef', 'Lato', 'League Script', 'Leckerli One', 'Ledger', 'Lekton', 'Lemon', 'Lemonada', 'Lexend', 'Lexend Deca', 'Lexend Exa', 'Lexend Giga', 'Lexend Mega', 'Lexend Peta', 'Lexend Tera', 'Lexend Zetta', 'Libre Barcode 128', 'Libre Barcode 128 Text', 'Libre Barcode 39', 'Libre Barcode 39 Extended', 'Libre Barcode 39 Extended Text', 'Libre Barcode 39 Text', 'Libre Barcode EAN13 Text', 'Libre Baskerville', 'Libre Caslon Display', 'Libre Caslon Text', 'Libre Franklin', 'Life Savers', 'Lilita One', 'Lily Script One', 'Limelight', 'Linden Hill', 'Literata', 'Liu Jian Mao Cao', 'Livvic', 'Lobster', 'Lobster Two', 'Londrina Outline', 'Londrina Shadow', 'Londrina Sketch', 'Londrina Solid', 'Long Cang', 'Lora', 'Love Ya Like A Sister', 'Loved by the King', 'Lovers Quarrel', 'Luckiest Guy', 'Lusitana', 'Lustria', 'M PLUS 1p', 'M PLUS Rounded 1c', 'Ma Shan Zheng', 'Macondo', 'Macondo Swash Caps', 'Mada', 'Magra', 'Maiden Orange', 'Maitree', 'Major Mono Display', 'Mako', 'Mali', 'Mallanna', 'Mandali', 'Manjari', 'Manrope', 'Mansalva', 'Manuale', 'Marcellus', 'Marcellus SC', 'Marck Script', 'Margarine', 'Markazi Text', 'Marko One', 'Marmelad', 'Martel', 'Martel Sans', 'Marvel', 'Mate', 'Mate SC', 'Maven Pro', 'McLaren', 'Meddon', 'MedievalSharp', 'Medula One', 'Meera Inimai', 'Megrim', 'Meie Script', 'Merienda', 'Merienda One', 'Merriweather', 'Merriweather Sans', 'Metal', 'Metal Mania', 'Metamorphous', 'Metrophobic', 'Michroma', 'Milonga', 'Miltonian', 'Miltonian Tattoo', 'Mina', 'Miniver', 'Miriam Libre', 'Mirza', 'Miss Fajardose', 'Mitr', 'Modak', 'Modern Antiqua', 'Mogra', 'Molengo', 'Molle', 'Monda', 'Monofett', 'Monoton', 'Monsieur La Doulaise', 'Montaga', 'MonteCarlo', 'Montez', 'Montserrat', 'Montserrat Alternates', 'Montserrat Subrayada', 'Moul', 'Moulpali', 'Mountains of Christmas', 'Mouse Memoirs', 'Mr Bedfort', 'Mr Dafoe', 'Mr De Haviland', 'Mrs Saint Delafield', 'Mrs Sheppards', 'Mukta', 'Mukta Mahee', 'Mukta Malar', 'Mukta Vaani', 'Mulish', 'MuseoModerno', 'Mystery Quest', 'Nanum Brush Script', 'Nanum Gothic', 'Nanum Gothic Coding', 'Nanum Myeongjo', 'Nanum Pen Script', 'Nerko One', 'Neucha', 'Neuton', 'New Rocker', 'New Tegomin', 'News Cycle', 'Newsreader', 'Niconne', 'Niramit', 'Nixie One', 'Nobile', 'Nokora', 'Norican', 'Nosifer', 'Notable', 'Nothing You Could Do', 'Noticia Text', 'Noto Kufi Arabic', 'Noto Music', 'Noto Naskh Arabic', 'Noto Nastaliq Urdu', 'Noto Rashi Hebrew', 'Noto Sans', 'Noto Sans Adlam', 'Noto Sans Adlam Unjoined', 'Noto Sans Anatolian Hieroglyphs', 'Noto Sans Arabic', 'Noto Sans Armenian', 'Noto Sans Avestan', 'Noto Sans Balinese', 'Noto Sans Bamum', 'Noto Sans Bassa Vah', 'Noto Sans Batak', 'Noto Sans Bengali', 'Noto Sans Bhaiksuki', 'Noto Sans Brahmi', 'Noto Sans Buginese', 'Noto Sans Buhid', 'Noto Sans Canadian Aboriginal', 'Noto Sans Carian', 'Noto Sans Caucasian Albanian', 'Noto Sans Chakma', 'Noto Sans Cham', 'Noto Sans Cherokee', 'Noto Sans Coptic', 'Noto Sans Cuneiform', 'Noto Sans Cypriot', 'Noto Sans Deseret', 'Noto Sans Devanagari', 'Noto Sans Display', 'Noto Sans Duployan', 'Noto Sans Egyptian Hieroglyphs', 'Noto Sans Elbasan', 'Noto Sans Elymaic', 'Noto Sans Georgian', 'Noto Sans Glagolitic', 'Noto Sans Gothic', 'Noto Sans Grantha', 'Noto Sans Gujarati', 'Noto Sans Gunjala Gondi', 'Noto Sans Gurmukhi', 'Noto Sans Hanifi Rohingya', 'Noto Sans Hanunoo', 'Noto Sans Hatran', 'Noto Sans Hebrew', 'Noto Sans Hong Kong', 'Noto Sans Imperial Aramaic', 'Noto Sans Indic Siyaq Numbers', 'Noto Sans Inscriptional Pahlavi', 'Noto Sans Inscriptional Parthian', 'Noto Sans Japanese', 'Noto Sans Javanese', 'Noto Sans Kaithi', 'Noto Sans Kannada', 'Noto Sans Kayah Li', 'Noto Sans Kharoshthi', 'Noto Sans Khmer', 'Noto Sans Khojki', 'Noto Sans Khudawadi', 'Noto Sans Korean', 'Noto Sans Lao', 'Noto Sans Lepcha', 'Noto Sans Limbu', 'Noto Sans Linear A', 'Noto Sans Linear B', 'Noto Sans Lisu', 'Noto Sans Lycian', 'Noto Sans Lydian', 'Noto Sans Mahajani', 'Noto Sans Malayalam', 'Noto Sans Mandaic', 'Noto Sans Manichaean', 'Noto Sans Marchen', 'Noto Sans Masaram Gondi', 'Noto Sans Math', 'Noto Sans Mayan Numerals', 'Noto Sans Medefaidrin', 'Noto Sans Meroitic', 'Noto Sans Miao', 'Noto Sans Modi', 'Noto Sans Mongolian', 'Noto Sans Mono', 'Noto Sans Mro', 'Noto Sans Multani', 'Noto Sans Myanmar', 'Noto Sans Nabataean', 'Noto Sans New Tai Lue', 'Noto Sans Newa', 'Noto Sans Nüshu', 'Noto Sans Ogham', 'Noto Sans Ol Chiki', 'Noto Sans Old Hungarian', 'Noto Sans Old Italic', 'Noto Sans Old North Arabian', 'Noto Sans Old Permic', 'Noto Sans Old Persian', 'Noto Sans Old Sogdian', 'Noto Sans Old South Arabian', 'Noto Sans Old Turkic', 'Noto Sans Oriya', 'Noto Sans Osage', 'Noto Sans Osmanya', 'Noto Sans Pahawh Hmong', 'Noto Sans Palmyrene', 'Noto Sans Pau Cin Hau', 'Noto Sans Phags Pa', 'Noto Sans Phoenician', 'Noto Sans Psalter Pahlavi', 'Noto Sans Rejang', 'Noto Sans Runic', 'Noto Sans Samaritan', 'Noto Sans Saurashtra', 'Noto Sans Sharada', 'Noto Sans Shavian', 'Noto Sans Siddham', 'Noto Sans Simplified Chinese', 'Noto Sans Sinhala', 'Noto Sans Sogdian', 'Noto Sans Sora Sompeng', 'Noto Sans Soyombo', 'Noto Sans Sundanese', 'Noto Sans Syloti Nagri', 'Noto Sans Symbols', 'Noto Sans Symbols 2', 'Noto Sans Syriac', 'Noto Sans Tagalog', 'Noto Sans Tagbanwa', 'Noto Sans Tai Le', 'Noto Sans Tai Tham', 'Noto Sans Tai Viet'