e_templates')){
	
function popularfx_page_templates() {

	include_once(dirname(__FILE__).'/popularfx-templates.php');
	
	popularfx_templates();

}

}

if(!function_exists('popularfx_page_handler')){
	
function popularfx_page_handler() {

	include_once(dirname(__FILE__).'/popularfx-dashboard.php');
	
	popularfx_dashboard();

}

}

////////////////
// Some vars
////////////////
$popularfx['www_url'] = esc_url('https://popularfx.com');
$popularfx['support_url'] = esc_url('https://popularfx.deskuss.com');
$popularfx['slug'] = popularfx_get_current_theme_slug();

// Show the theme import notice if not shown
if(file_exists(dirname(dirname(__FILE__)).'/pagelayer.conf')){
	
	if(!function_exists('pagelayer_theme_import_notices')){
		//add_action('admin_notices', 'popularfx_pagelayer_required');
	}else{
		add_action('admin_notices', 'pagelayer_theme_import_notices');
	}
	
}PK      h[	    +  custom-file-1-1753437830/inc/customizer.phpnu [        <?php
/**
 * PopularFX Theme Customizer
 *
 * @package PopularFX
 */

add_action( 'wp_head', 'popularfx_global_styles', 4 );
function popularfx_global_styles(){
	
	global $pagelayer, $popularfx;
	
	$settings = ['body', 'p', 'button', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'color', 'max_width' => 'content_width', 'tablet_breakpoint', 'mobile_breakpoint', 'template'];
	
	foreach($settings as $k => $v){
		
		$set = get_theme_mod('popularfx_'.$v);
		
		if(empty($set)){
			continue;
		}
		
		$css[$v] = $set;
		
		$key = is_numeric($k) ? $v : $k;
		
		// We override pagelayer settings for widths and breakpoint
		if(defined('PAGELAYER_VERSION') && in_array($v, ['content_width', 'tablet_breakpoint', 'mobile_breakpoint'])){
			$pagelayer->settings[$key] = $set;
		}
		
	}
	
	$styles = '<style id="popularfx-global-styles" type="text/css">'.PHP_EOL;
	
	$pfx_template_dir = popularfx_templates_dir();
	
	// Add the max width only when we have no template
	if( empty($css['template']) && !file_exists($pfx_template_dir.'/pagelayer.conf') ){
		$styles .= '.entry-content{ max-width: '.(empty($css['content_width']) ? 1170 : esc_attr($css['content_width'])).'px; margin-left: auto !important; margin-right: auto !important;}'.PHP_EOL;
	}
	
	// Colors
	if(!empty($css['color']['background'])){
		$css['body']['background-color'] = $css['color']['background'];
	}
	
	if(!empty($css['color']['text'])){
		$css['body']['color'] = $css['color']['text'];
	}
	
	// Global CSS settings
	$css_settings = ['body', 'p', 'button', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
	
	// PX suffix
	$pxs = ['font-size', 'letter-spacing', 'word-spacing'];
	
	foreach($css_settings as $k => $v){
		
		$key = is_numeric($k) ? $v : $k;
		$r = [];
			
		if(empty($css[$key])){
			continue;
		}
		
		if(!empty($css[$v]['font-family']) && strtolower($css[$v]['font-family']) == 'inherit'){
			unset($css[$v]['font-family']);
		}
	
		// Fetch body font if given
		if(!empty($css[$v]['font-family'])){
			$val = $css[$v]['font-family'];			
			$font_weight = empty($css[$v]['font-weight']) ? 400 : $css[$v]['font-weight'];
			$font_style = empty($css[$v]['font-style']) ? 'normal' : $css[$v]['font-style'];
			$font_style = in_array($font_style, ['italic', 'oblique']) ? 'i' : '';			
			$popularfx['runtime_fonts'][$val][$font_weight.$font_style] = $font_weight.$font_style;
		}
		
		foreach($css[$key] as $kk => $vv){
			
			if(empty($vv)){
				continue;
			}
			
			$r[] = $kk.':'.$vv.(in_array($kk, $pxs) ? 'px' : '');
			
		}
		
		if(empty($r)){
			continue;
		}
		
		$styles .= 'body.popularfx-body '.esc_attr($v == 'body' ? '' : $v).'{'.esc_attr(implode(';', $r))."}\n";
	}
	
	// Link Color
	if(!empty($css['color']['link'])){
		$styles .= 'body.popularfx-body a{color: '.esc_attr($css['color']['link']).'}'.PHP_EOL;
	}
	
	// Link Hover Color
	if(!empty($css['color']['link-hover'])){
		$styles .= 'body.popularfx-body a:hover{color: '.esc_attr($css['color']['link-hover']).'}'.PHP_EOL;
	}
	
	// Heading Color
	if(!empty($css['color']['heading'])){
		$styles .= 'body.popularfx-body h1,h2,h3,h4,h5,h6{color: '.esc_attr($css['color']['heading']).'}'.PHP_EOL;
	}
	
	// Header Background Color
	$header_bg_color = get_theme_mod('popularfx_header_bg_color', '#ffffff');
	$styles .= '.site-header {background-color:'.esc_attr($header_bg_color).'!important;}'.PHP_EOL;
	
	// Site Title Color
	$site_title_color = get_theme_mod('popularfx_site_title_color', '#171