r_Sanitize', 'sanitize_radio' ),
						),
						'control' => array(
							'type'            => 'radio',
							'priority'        => 58,
							'is_default_type' => true,
							'label'           => esc_html__( 'Magazine Header Menu Alignment', 'consultstreet' ),
							'section'         => 'title_tagline',
							'choices'         => array(
								'm-left-auto'  => esc_html__( 'Left', 'consultstreet' ),
								'm-right-left-auto' => esc_html__( 'Center', 'consultstreet' ),
							),
						),
			    ),
				
					
				'consultstreet_custom_logo_size' => array(
					'setting' => array(
						'default'           => array(
							'slider' => 257,
							'suffix' => 'px',
						),
						'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_slider' ),
					),
					'control' => array(
						'type'        => 'slider',
						'priority'    => 52,
						'label'       => esc_html__( 'Logo Width', 'consultstreet' ),
						'section'     => 'title_tagline',
						'input_attrs' => array(
							'min'  => 0,
							'max'  => 600,
							'step' => 3,
						),
					),
				),
				

			);

		}

	}

	new ConsultStreet_Other_General_Option();

endif;
PK      l[Ú    q  consultstreet/inc/customizer/customizer-settings/theme-settings/consultstreet-page-header-customizer-settings.phpnu [        <?php
/**
 * Page Header Settings.
 *
 * @package consultstreet
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
* Page Header Settings.
*/

if ( ! class_exists( 'ConsultStreet_Customize_Page_Header_Option' ) ) :

	class ConsultStreet_Customize_Page_Header_Option extends ConsultStreet_Customize_Base_Option {
		

		public function elements() {
			

			return array(
			
			    'consultstreet_page_header_heading'     => array(
					'setting' => array(),
					'control' => array(
						'type'    => 'heading',
						'priority'        => 1,
						'label'   => esc_html__( 'Page Header', 'consultstreet' ),
						'section' => 'header_image',
					),
				),
			
				'consultstreet_page_header_disabled'            => array(
					'setting' => array(
						'default'           => true,
						'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_checkbox' ),
					),
					'control' => array(
						'type'     => 'toggle',
						'priority' => 5,
						'label'    => esc_html__( 'Page Header Enable/Disable', 'consultstreet' ),
						'section'  => 'header_image',
					),
				),
				
								
				'consultstreet_page_header_background_color' => array(
					'setting' => array(
						'default'           => '',
						'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_alpha_color' ),
					),
					'control' => array(
						'type'            => 'color',
						'priority'        => 7,
						'label'           => esc_html__( 'Background color', 'consultstreet' ),
						'section'         => 'header_image',
						'choices'         => array(
							'alpha' => true,
						),
					),
				),
			  

			);

		}

	}

	new ConsultStreet_Customize_Page_Header_Option();

endif;
PK      l[V  V  p  consultstreet/inc/customizer/customizer-settings/theme-settings/consultstreet-typography-customizer-settings.phpnu [        <?php
/**
 * Typography.
 * @package     consultstreet
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/*========================================== TYPOGRAPHY ==========================================*/
if ( ! class_exists( 'ConsultStreet_Customize_Theme_Typography_Option' ) ) :

	/**
	 * Theme Typography option.
	 */
	class ConsultStreet_Customize_Theme_Typography_Option extends ConsultStreet_Customize_Base_Option {

		public function elements() {

			return array(
			
		/* ---------- Enable/Disable TYPOGRAPHY -------------- */		
			
			    'consultstreet_typography_disabled'            => array(
					'setting' => array(
						'default'           => false,
						'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_checkbox' ),
					),
					'control' => array(
						'type'     => 'toggle',
						'priority' => 2,
						'label'    => esc_html__( 'Enable Typography', 'consultstreet' ),
						'section'  => 'consultstreet_enable_disable_typography',
					),
				),
            );	
			
		}

	}

	new ConsultStreet_Customize_Theme_Typography_Option();

endif;
PK      l[q5    e  consultstreet/inc/customizer/customizer-settings/consultstreet-customize-base-customizer-settings.phpnu [        <?php
/** 
 * Header top options.
 *
 * @package consultstreet
 */

defined( 'ABSPATH' ) || exit;

/**
 * Class ConsultStreet_Customize_Base_Option
 */
class ConsultStreet_Customize_Base_Option {

	/**
	 * Array to create customizer options.
	 *
	 * @var array
	 */
	protected $elements = array();

	/**
	 * Active callback array provided in $elements array.
	 *
	 * @var array
	 */
	protected $active_callback_old = array();

	/**
	 * Record the count of array provided for active callback.
	 *
	 * @var int
	 */
	protected $ac_arr_count = 0;

	/**
	 * Record the count of evaluate() method called.
	 *
	 * @var int
	 */
	private $count_evaluate = 0;

	/**
	 * Setting's default values.
	 *
	 * @var array
	 */
	protected $ac_default = array();

	/**
	 * ConsultStreet_Customize_Base_Option constructor.
	 */
	public function __construct() {

		// Register customizer options.
		add_action( 'customize_register', array( $this, 'consultstreet_customizer_options' ) );
		// Get array of elements for particular class.
		$this->elements = $this->elements();

	}

	/**
	 * Provides an array of Menu slug => name for dropdown.
	 *
	 * @return array
	 */
	protected function get_menu_options() {

		$all_menus            = get_terms( array(
			'taxonomy'   => 'nav_menu',
			'hide_empty' => true,
		) );
		$menu_options         = array();
		$menu_options['none'] = esc_html__( 'None', 'consultstreet' );

		foreach ( $all_menus as $menu_item ) {
			$menu_options[ $menu_item->slug ] = esc_html( $menu_item->name );
		}

		return $menu_options;

	}

	/**
	 * Register customizer option.
	 *
	 * @param WP_Customize_Manager $wp_customize Manager instance.
	 */
	public function consultstreet_customizer_options( $wp_customize ) {

		// Loop through array elements.
		foreach ( $this->elements as $el_key => $el_data ) :

			/**
			 * Setting.
			 */
			$setting_args      = $el_data['setting'];
			$default           = isset( $setting_args['default'] ) ? $setting_args['default'] : '';
			$option_type       = isset( $el_data['setting']['type'] ) ? $el_data['setting']['type'] : 'theme_mod';
			$sanitize_callback = isset( $setting_args['sanitize_callback'] ) ? $setting_args['sanitize_callback'] : '';

			$wp_customize->add_setting(
				$el_key,
				array(
					'default'           => $default,
					'type'              => $option_type,
					'capability'        => 'edit_theme_options',
					'sanitize_callback' => $sanitize_callback,
				)
			);

			/**
			 * Control.
			 */
			$control_args = $el_data['control'];
			$control_type = $control_args['type'];
			// Is custom control?
			$is_custom_control       = ( isset( $control_args['is_default_type'] ) && true === $control_args['is_default_type'] ) ? $control_args['is_default_type'] : 0;
			$control_args['setting'] = $el_key;

			// If array provided for active callback modify it to function reference.
			if ( isset( $control_args['active_callback'] ) && is_array( $control_args['active_callback'] ) ) {
				$this->active_callback_old[] = $control_args['active_callback'];
				$cb_setting_id               = $this->active_callback_old[ $this->ac_arr_count ][0]['setting'];
				

				if ( 'consultstreet_pro' === substr( $cb_setting_id, 0, 9 ) && function_exists( 'consultstreet_pro_options' ) ) {
					$this->ac_default[] = $wp_customize->get_setting( 'consultstreet_pro[' . $cb_setting_id . ']' )->default;

				} else {
					$this->ac_default[] = $wp_customize->get_setting( $cb_setting_id )->default;
				}

				$control_args['active_callback'] = array( $this, 'evaluate' );
				$this->ac_arr_count++;
			}

			// If custom control, unset type and use object, else...
			if ( ! $is_custom_control ) {
				unset( $control_args['type'] );
				$control_type_uc = implode( '_', array_map( 'ucfirst', explode( '_', $control_type ) ) );
				$control_type    = 'ConsultStreet_Customize_' . $control_type_uc . '_Control';
				$wp_customize->add_control( new $control_type( $wp_customize, $el_key, $control_args ) );
			} else {
				$wp_customize->add_control( $el_key, $control_args );
			}

		endforeach;

	}

	/**
	 * Evaluates the active callback array.
	 *
	 * @return bool
	 */
	public function evaluate() {
		foreach ( $this->active_callback_old[ ( $this->count_evaluate ) ] as $count => $ruleset ) :

			$ac_setting_id = $ruleset['setting'];
			$operator      = $ruleset['operator'];

			if ( 'consultstreet_pro' === substr( $ac_setting_id, 0, 9 ) && function_exists( 'consultstreet_pro_options' ) ) {
				$option_val = consultstreet_pro_options( $ac_setting_id, 'text_html' );
			} else {
				$option_val = get_theme_mod( $ac_setting_id, 'text_html' );
			}
			$check_val = $ruleset['value'];

			switch ( $operator ) {
				case '===':
					$show[] = ( $option_val === $check_val ) ? true : false;
					break;
				case '==':
					$show[] = ( $option_val == $check_val ) ? true : false;
					break;

				case '!==':
					$show[] = ( $option_val !== $check_val ) ? true : false;
					break;

				case '!=':
					$show[] = ( $option_val != $check_val ) ? true : false;
					break;

				default:
					$show[] = ( $option_val == $check_val ) ? true : false;
					break;
			}

		endforeach;

		// Evaluate final result.
		if ( isset( $show ) ) {
			$this->count_evaluate++;
			foreach ( $show as $result ) {
				if ( ! $result ) {
					return false;
				}
			}
		}

		return true;

	}

}PK      l[    A  consultstreet/inc/customizer/consultstreet-customizer-options.phpnu [        <?php
/**
 * Extend default customizer section.
 *
 * @package consultstreet
 *
 * @see     WP_Customize_Section
 * @access  public
 */

require CONSULTSTREET_PARENT_INC_DIR . '/customizer/webfont.php';
require CONSULTSTREET_PARENT_INC_DIR . '/customizer/controls/code/consultstreet-customize-typography-control.php';
require CONSULTSTREET_PARENT_INC_DIR . '/customizer/controls/code/consultstreet-customize-plugin-control.php';
require CONSULTSTREET_PARENT_INC_DIR . '/customizer/controls/code/consultstreet-customize-category-control.php';
require CONSULTSTREET_PARENT_INC_DIR . '/customizer/customizer-repeater/functions.php';

function consultstreet_customizer_theme_settings( $wp_customize ){
	
	$active_callback    	= isset( $array['active_callback'] ) ? $array['active_callback'] : null;
	$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	
	$wp_customize->get_section( 'header_image' )->panel = 'consultstreet_theme_settings';
	$wp_customize->get_section( 'header_image' )->title    = __( 'Page Header', 'consultstreet' );
    $wp_customize->get_section( 'header_image' )->priority = 40;
	
	// Sticky Bar Logo
	$wp_customize->add_setting( 'consultstreet_sticky_bar_logo', array(
			'sanitize_callback' => 'esc_url_raw',
		)
	);
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'consultstreet_sticky_bar_logo',
     	array(
			'label'    => esc_html__( 'Set Sticky Bar Logo', 'consultstreet' ),
			'description'    => esc_html__( 'You can Upload the Standrad size of logo (210px*39px)', 'consultstreet' ),
			'section'  => 'consultstreet_theme_menu_bar',
			'settings' => 'consultstreet_sticky_bar_logo',
			'priority'        => 15,
		)
	));	
	
	
		$wp_customize->add_setting( 'consultstreet_typography_base_font_family',array(
            'sanitize_callback' => 'consultstreet_sanitize_select',		
			'capability'     => 'edit_theme_options', 
			'default' => 'Open Sans', 
		) );	
	    $wp_customize->add_control( new ConsultStreet_Customizer_Typography_Control( $wp_customize, 'consultstreet_typography_base_font_family', array(
			'label'   => esc_html__( 'Font Family', 'consultstreet' ),
			'section' => 'consultstreet_base_typography',
			'settings'   => 'consultstreet_typography_base_font_family',
			'priority' 			=> 10,
		) ) );

	    $wp_customize->add_setting( 'consultstreet_typography_base_font_size',
		array(
            'default' => '1rem',
			'sanitize_callback' => 'consultstreet_sanitize_text',
		));	
		$wp_customize->add_control( 'consultstreet_typography_base_font_size',
		array(
			'label'   => esc_html__( 'Font Size', 'consultstreet' ),
			'description'           => esc_html__( 'You can enter font-size in px or rem ', 'consultstreet' ),
			'section' => 'consultstreet_base_typography',
			'priority'        => 15,
			'type' => 'text',
		));	

        $wp_customize->add_setting( 'consultstreet_typography_h1_font_family',array(
			'sanitize_callback' => 'consultstreet_sanitize_select',
			'capability'     => 'edit_theme_options',
			'default' => 'Montserrat', 
		) );	
	    $wp_customize->add_control( new ConsultStreet_Customizer_Typography_Control( $wp_customize, 'consultstreet_typography_h1_font_family', array(
			'label'   => esc_html__( 'Font Family', 'consultstreet' ),
			'section' => 'consultstreet_headings1_typography',
			'settings'   => 'consultstreet_typography_h1_font_family',
			'priority' 			=> 10,
		) ) );
		
		
		$wp_customize->add_setting( 'consultstreet_typography_h2_font_family',array(
			'sanitize_callback' => 'consultstreet_sanitize_select',
			'capability'     => 'edit_theme_options', 
			'default' => 'Montserrat', 
		) );	
	    $wp_customize->add_control( new ConsultStreet_Customizer_Typography_Control( $wp_customize, 'consultstreet_typography_h2_font_family', array(
			'label'   => esc_html__( 'Font Family', 'consultstreet' ),
			'section' => 'consultstreet_headings2_typography',
			'settings'   => 'consultstreet_typography_h2_font_family',
			'priority' 			=> 10,
		) ) );
		
		$wp_customize->add_setting( 'consultstreet_typography_h3_font_family',array(
			'sanitize_callback' => 'consultstreet_sanitize_select',
			'capability'     => 'edit_theme_options', 
			'default' => 'Montserrat',
		) );	
	    $wp_customize->add_control( new ConsultStreet_Customizer_Typography_Control( $wp_customize, 'consultstreet_typography_h3_font_family', array(
			'label'   => esc_html__( 'Font Family', 'consultstreet' ),
			'section' => 'consultstreet_headings3_typography',
			'settings'   => 'consultstreet_typography_h3_font_family',
			'priority' 			=> 10,
		) ) );
		
		$wp_customize->add_setting( 'consultstreet_typography_h4_font_family',array(
            'sanitize_callback' => 'consultstreet_sanitize_select',
			'capability'     => 'edit_theme_options',
			'default' => 'Montserrat', 
		) );	
	    $wp_customize->add_control( new ConsultStreet_Customizer_Typography_Control( $wp_customize, 'consultstreet_typography_h4_font_family', array(
			'label'   => esc_html__( 'Font Family', 'consultstreet' ),
			'section' => 'consultstreet_headings4_typography',
			'settings'   => 'consultstreet_typography_h4_font_family',
			'priority' 			=> 10,
		) ) );	

		$wp_customize->add_setting( 'consultstreet_typography_h5_font_family',array( 
		   'sanitize_callback' => 'consultstreet_sanitize_select',
		   'capability'     => 'edit_theme_options',  
		   'default' => 'Montserrat',
		) );	
	    $wp_customize->add_control( new ConsultStreet_Customizer_Typography_Control( $wp_customize, 'consultstreet_typography_h5_font_family', array(
			'label'   => esc_html__( 'Font Family', 'consultstreet' ),
			'section' => 'consultstreet_headings5_typography',
			'settings'   => 'consultstreet_typography_h5_font_family',
			'priority' 			=> 10,
		) ) );				

        $wp_customize->add_setting( 'consultstreet_typography_h6_font_family',array( 
			'sanitize_callback' => 'consultstreet_sanitize_select',
			'capability'     => 'edit_theme_options', 
			'default' => 'Montserrat',
		) );	
	    $wp_customize->add_control( new ConsultStreet_Customizer_Typography_Control( $wp_customize, 'consultstreet_typography_h6_font_family', array(
			'label'   => esc_html__( 'Font Family', 'consultstreet' ),
			'section' => 'consultstreet_headings6_typography',
			'settings'   => 'consultstreet_typography_h6_font_family',
			'priority' 			=> 10,
		) ) );
		
		// Footer copyright
		
		$wp_customize->add_setting(
			'consultstreet_footer_copright_text',
			array(
				'sanitize_callback' =>  'consultstreet_sanitize_text',
				'default' => __('Copyright &copy; 2025 | Powered by <a href="//wordpress.org/">WordPress</a> <span class="sep"> | </span> ConsultStreet theme by <a target="_blank" href="//themearile.com/">ThemeArile</a>', 'consultstreet'),
				'transport'         => $selective_refresh,
			)	
		);
		$wp_customize->add_control('consultstreet_footer_copright_text', array(
				'label' => esc_html__('Footer Copyright','consultstreet'),
				'section' => 'consultstreet_footer_copyright',
				'priority'        => 10,
				'type'    =>  'textarea'
		));
		
}
add_action( 'customize_register', 'consultstreet_customizer_theme_settings' );PK      l[z"  "  B  consultstreet/inc/customizer/consultstreet-customizer-partials.phpnu [        <?php
/**
 * ConsultStreet Customizer partials.
 *
 * @package consultstreet
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'ConsultStreet_Customizer_Partials' ) ) {

	/**
	 * Customizer Partials.
	 */
	class ConsultStreet_Customizer_Partials {

		/**
		 * Instance.
		 *
		 * @access private
		 * @var object
		 */
		private static $instance;

		/**
		 * Initiator.
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		// site title
		public static function customize_partial_blogname() {
			return get_bloginfo( 'name' );
		}

		// Site tagline
		public static function customize_partial_blogdescription() {
			return get_bloginfo( 'description' );
		}
		
		// service title
		public static function customize_partial_consultstreet_service_area_title() {
			return get_theme_mod( 'consultstreet_service_area_title' );
		}
		
		// service description
		public static function customize_partial_consultstreet_service_area_des() {
			return get_theme_mod( 'consultstreet_service_area_des' );
		}
		
		// project title
		public static function customize_partial_consultstreet_project_area_title() {
			return get_theme_mod( 'consultstreet_project_area_title' );
		}
		
		// project description
		public static function customize_partial_consultstreet_project_area_des() {
			return get_the