alValue } );
				// Set the toggle button span element text.
				self.toggler.find( '.wp-color-result-text' ).text( wpColorPickerL10n.pick );
				// Set up the Iris container and insert it after the wrapping label.
				self.pickerContainer = $( _after ).insertAfter( self.wrappingLabel );
				// Store a reference to the Clear/Default button.
				self.button = $( _button );
			}

			// Set up the Clear/Default button.
			if ( self.options.defaultColor ) {
				self.button.addClass( 'wp-picker-default' ).val( wpColorPickerL10n.defaultString );
				if ( ! _deprecated ) {
					self.button.attr( 'aria-label', wpColorPickerL10n.defaultAriaLabel );
				}
			} else {
				self.button.addClass( 'wp-picker-clear' ).val( wpColorPickerL10n.clear );
				if ( ! _deprecated ) {
					self.button.attr( 'aria-label', wpColorPickerL10n.clearAriaLabel );
				}
			}

			if ( _deprecated ) {
				el.wrap( '<span class="wp-picker-input-wrap" />' ).after( self.button );
			} else {
				// Wrap the wrapping label in its wrapper and append the Clear/Default button.
				self.wrappingLabel
					.wrap( '<span class="wp-picker-input-wrap hidden" />' )
					.after( self.button );

				/*
				 * The input wrapper now contains the label+input+Clear/Default button.
				 * Store a reference to the input wrapper: we'll use this to toggle
				 * the controls visibility.
				 */
				self.inputWrapper = el.closest( '.wp-picker-input-wrap' );
			}

			el.iris( {
				target: self.pickerContainer,
				hide: self.options.hide,
				width: self.options.width,
				mode: self.options.mode,
				palettes: self.options.palettes,
				/**
				 * @summary Handles the onChange event if one has been defined in the options.
				 *
				 * Handles the onChange event if one has been defined in the options and additionally
				 * sets the background color for the toggler element.
				 *
				 * @since 3.5.0
				 *
				 * @param {Event} event    The event that's being called.
				 * @param {HTMLElement} ui The HTMLElement containing the color picker.
				 *
				 * @returns {void}
				 */
				change: function( event, ui ) {
					if ( self.options.alpha ) {
						self.toggler.css( { 'background-image' : 'url(' + image + ')' } );
						if ( _deprecated ) {
							self.toggler.html( '<span class="color-alpha" />' );
						} else {
							self.toggler.css( {
								'position' : 'relative'
							} );
							if ( self.toggler.find('span.color-alpha').length == 0 ) {
								self.toggler.append('<span class="color-alpha" />');
							}
						}

						self.toggler.find( 'span.color-alpha' ).css( {
							'width'                     : '30px',
							'height'                    : '28px',
							'position'                  : 'absolute',
							'top'                       : 0,
							'left'                      : 0,
							'border-top-left-radius'    : '2px',
							'border-bottom-left-radius' : '2px',
							'background'                : ui.color.toString()
						} );
					} else {
						self.toggler.css( { backgroundColor : ui.color.toString() } );
					}

					if ( $.isFunction( self.options.change ) ) {
						self.options.change.call( this, event, ui );
					}
				}
			} );

			el.val( self.initialValue );
			self._addListeners();

			// Force the color picker to always be closed on initial load.
			if ( ! self.options.hide ) {
				self.toggler.click();
			}
		},
		/**
		 * @summary Binds event listeners to the color picker.
		 *
		 * @since 3.5.0
		 *
		 * @access private
		 *
		 * @returns {void}
		 */
		_addListeners: function() {
			var self = this;

			/**
			 * @summary Prevent any clicks inside this widget from leaking to the top and closing it.
			 *
			 * @since 3.5.0
			 *
			 * @param {Event} event The event that's being called.
			 *
			 * @returs {void}
			 */
			self.wrap.on( 'click.wpcolorpicker', function( event ) {
				event.stopPropagation();
			});

			/**
			 * @summary Open or close the color picker depending on the class.
			 *
			 * @since 3.5
			 */
			self.toggler.click( function(){
				if ( self.toggler.hasClass( 'wp-picker-open' ) ) {
					self.close();
				} else {
					self.open();
				}
			});

			/**
			 * @summary Checks if value is empty when changing the color in the color picker.
			 *
			 * Checks if value is empty when changing the color in the color picker.
			 * If so, the background color is cleared.
			 *
			 * @since 3.5.0
			 *
			 * @param {Event} event The event that's being called.
			 *
			 * @returns {void}
			 */
			self.element.on( 'change', function( event ) {
				// Empty or Error = clear
				if ( $( this ).val() === '' || self.element.hasClass( 'iris-error' ) ) {
					if ( self.options.alpha ) {
						if ( _deprecated ) {
							self.toggler.removeAttr( 'style' );
						}
						self.toggler.find( 'span.color-alpha' ).css( 'backgroundColor', '' );
					} else {
						self.toggler.css( 'backgroundColor', '' );
					}

					// fire clear callback if we have one
					if ( $.isFunction( self.options.clear ) )
						self.options.clear.call( this, event );
				}
			} );

			/**
			 * @summary Enables the user to clear or revert the color in the color picker.
			 *
			 * Enables the user to either clear the color in the color picker or revert back to the default color.
			 *
			 * @since 3.5.0
			 *
			 * @param {Event} event The event that's being called.
			 *
			 * @returns {void}
			 */
			self.button.on( 'click', function( event ) {
				if ( $( this ).hasClass( 'wp-picker-clear' ) ) {
					self.element.val( '' );
					if ( self.options.alpha ) {
						if ( _deprecated ) {
							self.toggler.removeAttr( 'style' );
						}
						self.toggler.find( 'span.color-alpha' ).css( 'backgroundColor', '' );
					} else {
						self.toggler.css( 'backgroundColor', '' );
					}

					if ( $.isFunction( self.options.clear ) )
						self.options.clear.call( this, event );

					self.element.trigger( 'change' );
				} else if ( $( this ).hasClass( 'wp-picker-default' ) ) {
					self.element.val( self.options.defaultColor ).change();
				}
			});
		},
	});

	/**
	 * Overwrite iris
	 */
	$.widget( 'a8c.iris', $.a8c.iris, {
		_create: function() {
			this._super();

			// Global option for check is mode rbga is enabled
			this.options.alpha = this.element.data( 'alpha' ) || false;

			// Is not input disabled
			if ( ! this.element.is( ':input' ) )
				this.options.alpha = false;

			if ( typeof this.options.alpha !== 'undefined' && this.options.alpha ) {
				var self       = this,
					el         = self.element,
					_html      = '<div class="iris-strip iris-slider iris-alpha-slider"><div class="iris-slider-offset iris-slider-offset-alpha"></div></div>',
					aContainer = $( _html ).appendTo( self.picker.find( '.iris-picker-inner' ) ),
					aSlider    = aContainer.find( '.iris-slider-offset-alpha' ),
					controls   = {
						aContainer : aContainer,
						aSlider    : aSlider
					};

				if ( typeof el.data( 'custom-width' ) !== 'undefined' ) {
					self.options.customWidth = parseInt( el.data( 'custom-width' ) ) || 0;
				} else {
					self.options.customWidth = 100;
				}

				// Set default width for input reset
				self.options.defaultWidth = el.width();

				// Update width for input
				if ( self._color._alpha < 1 || self._color.toString().indexOf('rgb') != -1 )
					el.width( parseInt( 88 ) );

				// Push new controls
				$.each( controls, function( k, v ) {
					self.controls[k] = v;
				} );

				// Change size strip and add margin for sliders
				self.controls.square.css( { 'margin-right': '0' } );
				var emptyWidth   = ( self.picker.width() - self.controls.square.width() - 20 ),
					stripsMargin = ( emptyWidth / 6 ),
					stripsWidth  = ( ( emptyWidth / 2 ) - stripsMargin );

				$.each( [ 'aContainer', 'strip' ], function( k, v ) {
					self.controls[v].width( stripsWidth ).css( { 'margin-left' : stripsMargin + 'px' } );
				} );

				// Add new slider
				self._initControls();

				// For updated widget
				self._change();
			}
		},
		_initControls: function() {
			this._super();

			if ( this.options.alpha ) {
				var self     = this,
					controls = self.controls;

				controls.aSlider.slider({
					orientation : 'vertical',
					min         : 0,
					max         : 100,
					step        : 1,
					value       : parseInt( self._color._alpha * 100 ),
					slide       : function( event, ui ) {
						// Update alpha value
						self._color._alpha = parseFloat( ui.value / 100 );
						self._change.apply( self, arguments );
					}
				});
			}
		},
		_change: function() {
			this._super();

			var self = this,
				el   = self.element;

			if ( this.options.alpha ) {
				var	controls     = self.controls,
					alpha        = parseInt( self._color._alpha * 100 ),
					color        = self._color.toRgb(),
					gradient     = [
						'rgb(' + color.r + ',' + color.g + ',' + color.b + ') 0%',
						'rgba(' + color.r + ',' + color.g + ',' + color.b + ', 0) 100%'
					],
					defaultWidth = self.options.defaultWidth,
					customWidth  = self.options.customWidth,
					target       = self.picker.closest( '.wp-picker-container' ).find( '.wp-color-result' );

				// Generate background slider alpha, only for CSS3 old browser fuck!! :)
				controls.aContainer.css( { 'background' : 'linear-gradient(to bottom, ' + gradient.join( ', ' ) + '), url(' + image + ')' } );

				if ( target.hasClass( 'wp-picker-open' ) ) {
					// Update alpha value
					controls.aSlider.slider( 'value', alpha );

					/**
					 * Disabled change opacity in default slider Saturation ( only is alpha enabled )
					 * and change input width for view all value
					 */
					if ( self._color._alpha < 1 ) {
						controls.strip.attr( 'style', controls.strip.attr( 'style' ).replace( /rgba\(([0-9]+,)(\s+)?([0-9]+,)(\s+)?([0-9]+)(,(\s+)?[0-9\.]+)\)/g, 'rgb($1$3$5)' ) );
						el.width( parseInt( 88 ) );
					} else {
						el.width( defaultWidth );
					}
				}
			}

			var reset = el.data( 'reset-alpha' ) || false;

			if ( reset ) {
				self.picker.find( '.iris-palette-container' ).on( 'click.palette', '.iris-palette', function() {
					self._color._alpha = 1;
					self.active        = 'external';
					self._change();
				} );
			}
			el.trigger( 'change' );
		},
		_addInputListeners: function( input ) {
			var self            = this,
				debounceTimeout = 100,
				callback        = function( event ) {
					var color = new Color( input.val() ),
						val   = input.val();

					input.removeClass( 'iris-error' );
					// we gave a bad color
					if ( color.error ) {
						// don't error on an empty input
						if ( val !== '' )
							input.addClass( 'iris-error' );
					} else {
						if ( color.toString() !== self._color.toString() ) {
							// let's not do this on keyup for hex shortcodes
							if ( ! ( event.type === 'keyup' && val.match( /^[0-9a-fA-F]{3}$/ ) ) )
								self._setOption( 'color', color.toString() );
						}
					}
				};

			input.on( 'change', callback ).on( 'keyup', self._debounce( callback, debounceTimeout ) );

			// If we initialized hidden, show on first focus. The rest is up to you.
			if ( self.options.hide ) {
				input.on( 'focus', function() {
					self.show();
				} );
			}
		}
	} );
}( jQuery ) );

// Auto Call plugin is class is color-picker
jQuery( document ).ready( function( $ ) {
	$( '.color-picker' ).wpColorPicker();
} );PK      l[X    >  consultstreet/inc/customizer/controls/scss/modules/_color.scssnu [        li[class|="customize-control-consultstreet-"] {
	.wp-picker-container {

		.wp-color-result.button {
			width: 100%;
			max-width: 255px;
			height: 30px;
			margin: 0 6px 6px 0;
			padding: 0 0 0 30px;
			font-size: 11px;
			box-shadow: none;
			border: 1px solid rgba(0, 0, 0, 0.1);
		}

		.wp-color-result-text {
			background: rgba(0, 0, 0, 0.1);
			border-radius: 0 2px 2px 0;
			border-left: 1px solid rgba(0, 0, 0, 0.06);
			color: $c-white;
			display: flex;
			justify-content: center;
			align-items: center;
			height: 100%;
		}

		span.color-alpha {
			width: 30px;
			height: 24px;
			position: absolute;
			top: 0;
			left: 0;
			border-top-left-radius: 2px;
			border-bottom-left-radius: 2px;
		}
	}
}
PK      l[htI  I  G  consultstreet/inc/customizer/controls/scss/modules/_control-colors.scssnu [        $c-background: rgba(0, 0, 0, 0.15);
$c-background-hover: rgba(0, 0, 0, 0.2);
$c-primary: #13a1dc;
$c-white: #fff;
$c-shadow: rgba(0, 0, 0, 0.3);
$c-sortable-bd: #333;
$c-sortable-ds: #aaa;
$c-bg-label: rgba(255, 255, 255, 0.7);
$c-bg-checked: rgba(0, 0, 0, 0.25);
$c-bg-switch: #b4b9be;
$c-switch-ds: #777;
$c-light-bg: #e4f2fc;
PK      l[    H  consultstreet/inc/customizer/controls/scss/modules/_radio-buttonset.scssnu [        .customize-control-consultstreet-radio-buttonset .buttonset {
	display: flex;
	flex-wrap: wrap;

	.switch-label {
		background: rgba(0, 0, 0, 0.1);
		border: 1px rgba(0, 0, 0, 0.1);
		color: rgba(50, 55, 60, 0.5);
		margin: 0;
		text-align: center;
		padding: 0.5em 1em;
		flex-grow: 1;
	}

	.switch-input:checked + .switch-label {
		background: $c-primary;
		color: rgba(255, 255, 255, 0.8);
	}
}
PK      l[x    D  consultstreet/inc/customizer/controls/scss/modules/_radio-image.scssnu [        /* Control: Radio image. */

.customize-control-consultstreet-radio-image {

	> .image {
		display: flex;
		flex-wrap: wrap;
	}

	.image-select {
		+ label {
			position: relative;
			display: inline-block;
			width: 32%;
			margin-right: 2%;

			&:nth-of-type( 3n ) {
				margin-right: 0;
			}

			.image-label {
				display: none;
				position: absolute;
				top: 0;
				left: 0;
				width: 100%;
				height: 100%;
				background: $c-bg-label;
				font-weight: 700;

				.inner {
					width: 100%;
					height: 100%;
					text-align: center;
					padding: 0.5em;
					vertical-align: middle;
				}
			}

			&:hover .image-label {
				display: block;
			}
		}
	}


	input {
		display: none;

		img {
			border: 1px solid transparent;
		}

		&:checked + label img {
			box-shadow: 0 0 5px 2px $c-bg-checked;
			border: 1px solid $c-primary;
		}

		+ label .image-clickable {
			position: absolute;
			top: 0;
			bottom: 0;
			left: 0;
			right: 0;
			width: 100%;
			height: 100%;
		}
	}
}
PK      l[&E  E  ?  consultstreet/inc/customizer/controls/scss/modules/_slider.scssnu [        .customize-control-consultstreet-slider {

	.customize-control-content {
		display: flex;
		align-items: center;
		justify-content: space-between;
	}

	.ui-slider {
		background-color: rgba(0, 0, 0, 0.1);
		width: 63%;
		height: 6px;
		position: relative;
		display: flex;
		align-items: center;
		justify-content: space-between;
		border-radius: 3px;

		.ui-slider-handle {
			height: 15px;
			width: 15px;
			background-color: #fff;
			position: absolute;
			cursor: pointer;
			box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
			border-radius: 3px;
		}

		.ui-slider-range {
			background-color: $c-primary;
			height: 100%;
			border-top-left-radius: 3px;
			border-bottom-left-radius: 3px;
		}
	}

	.consultstreet-slider-input {
		display: flex;
		align-items: center;

		.slider-reset {
			padding-left: 5px;
			cursor: pointer;
		}
	}
}
PK      l[x    A  consultstreet/inc/customizer/controls/scss/modules/_sortable.scssnu [        /* Control: Sortable. */

.customize-control-consultstreet-sortable ul.ui-sortable li {
	padding: 5px 10px;
	border: 1px solid $c-sortable-bd;
	background: $c-white;

	.dashicons {

		&.dashicons-menu {
			float: right;
		}

		&.visibility {
			margin-right: 10px;
		}
	}

	&.invisible {
		color: $c-sortable-ds;
		border: 1px dashed $c-sortable-ds;

		.dashicons.visibility {
			color: $c-sortable-ds;
		}
	}
}
PK      l[_E[  [  ?  consultstreet/inc/customizer/controls/scss/modules/_toggle.scssnu [        /* Control: Switch. */

.customize-control-consultstreet-toggle {
	position: relative;

	label {
		display: flex;
		flex-wrap: wrap;

		.customize-control-title {
			width: calc(100% - 55px);
		}

		.description {
			order: 99;
		}
	}

	.switch {
		border: 1px solid #b4b9be;
		display: inline-block;
		width: 35px;
		height: 12px;
		border-radius: 8px;
		background: #b4b9be;
		vertical-align: middle;
		position: relative;
		top: 4px;
		cursor: pointer;
		user-select: none;
		transition: background 350ms ease;

		&::after {
			content: "";
			display: block;
			width: 20px;
			height: 20px;
			border-radius: 50%;
			position: absolute;
			top: 50%;
			left: -3px;
			transition:
				all 350ms cubic-bezier(0, 0.95, 0.38, 0.98),
				background 150ms ease;
			background: #999;
			border: 1px solid rgba(0, 0, 0, 0.1);
			transform: translate3d(0, -50%, 0);
		}

		&::before {
			content: "";
			display: block;
			width: 20px;
			height: 20px;
			border-radius: 50%;
			position: absolute;
			top: 50%;
			left: -3px;
			transition:
				all 350ms cubic-bezier(0, 0.95, 0.38, 0.98),
				background 150ms ease;
			background: rgba(0, 0, 0, 0.2);
			transform: translate3d(0, -50%, 0) scale(0);
		}

		&:active::before {
			transform: translate3d(0, -50%, 0) scale(3);
		}
	}

	input:checked + .switch {

		&::before {
			background: rgba(0, 115, 170, 0.075);
			transform: translate3d(100%, -50%, 0) scale(1);
		}

		&::after {
			background: $c-primary;
			transform: translate3d(100%, -50%, 0);
		}

		&:active::before {
			background: rgba(0, 115, 170, 0.075);
			transform: translate3d(100%, -50%, 0) scale(3);
		}
	}
}
PK      l[=      8  consultstreet/inc/customizer/controls/scss/controls.scssnu [        @import "modules/control-colors";
@import "modules/color";
@import "modules/radio-buttonset";
@import "modules/radio-image";
@import "modules/slider";
@import "modules/sortable";
@import "modules/toggle";PK      l[.    Q  consultstreet/inc/customizer/custom-customizer/consultstreet-customizer-panel.phpnu [        <?php
/**
 * Extend default customizer panel.
 *
 * @package consultstreet
 *
 * @see     WP_Customize_Panel
 * @access  public
 */

if ( class_exists( 'WP_Customize_Panel' ) ) {
	/**
	 * Class ConsultStreet_Customize_Panel
	 */
	class ConsultStreet_Customize_Panel extends WP_Customize_Panel {

		/**
		 * Panel
		 *
		 * @var string
		 */
		public $panel;

		/**
		 * Control type.
		 *
		 * @var string
		 */
		public $type = 'consultstreet_panel';

		/**
		 * Get section parameters for JS.
		 *
		 * @return array Exported parameters.
		 */
		public function json() {

			$array                   = wp_array_slice_assoc( (array) $this, array(
				'id',
				'description',
				'priority',
				'type',
				'panel',
			) );
			$array['title']          = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
			$array['content']        = $this->get_content();
			$array['active']         = $this->active();
			$array['instanceNumber'] = $this->instance_number;

			return $array;
		}
	}

}
PK      l[HM  M  S  consultstreet/inc/customizer/custom-customizer/consultstreet-customizer-section.phpnu [        <?php
/**
 * Extend default customizer section.
 *
 * @package consultstreet
 *
 * @see     WP_Customize_Section
 * @access  public
 */

if ( class_exists( 'WP_Customize_Section' ) ) {

	/**
	 * Class ConsultStreet_Customize_Section
	 */
	class ConsultStreet_Customize_Section extends WP_Customize_Section {

		/**
		 * Section.
		 *
		 * @var string
		 */
		public $section;

		/**
		 * Type of this section.
		 *
		 * @var string
		 */
		public $type = 'consultstreet_section';

		/**
		 * Gather the parameters passed to client JavaScript via JSON.
		 *
		 * @return array The array to be exported to the client as JSON.
		 */
		public function json() {
			$array                   = wp_array_slice_assoc( (array) $this, array(
				'id',
				'description',
				'priority',
				'panel',
				'type',
				'description_hidden',
				'section',
			) );
			$array['title']          = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
			$array['content']        = $this->get_content();
			$array['active']         = $this->active();
			$array['instanceNumber'] = $this->instance_number;

			if ( $this->panel ) {
				$array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
			} else {
				$array['customizeAction'] = 'Customizing';
			}

			return $array;
		}
	}
}
PK      l[w{$  $  V  consultstreet/inc/customizer/customizer-notice/css/consultstreet-customizer-notify.cssnu [        .consultstreet-customizer-plugin-notify-actions-count {
	display: inline-block;
	z-index: 26;
	margin: 1px 0 0 2px;
	padding: 0 6px;
	border-radius: 10px;
	color: #fff;
	background-color: #d54e21;
	font-size: 9px;
	font-weight: 600;
	line-height: 17px;
	vertical-align: top;
}

div.consultstreet-theme-recomended-actions_container {
	margin-bottom: 2em;
	padding: 0 10px;
}

.consultstreet-theme-recomended-actions_container p.succes {
	margin: 1em 0;
}

.consultstreet-epsilon-recommeded-actions p.title {
	margin-bottom: 0;
	color: #555d66;
	font-size: 14px;
	font-weight: 600;
}

.consultstreet-epsilon-recommeded-actions div.description {
	font-size: 12px;
}

.consultstreet-epsilon-recommeded-actions .custom-action {
	margin-top: 1em;
	padding-top: 1em;
	border-top: 1px solid #fafafa;
}

.consultstreet-epsilon-recommeded-actions .custom-action p {
	margin-top: 0;
}

.consultstreet-theme-recomended-actions_container .consultstreet-recommeded-actions-container:not(:first-child) {
	overflow: hidden;
	height: 0;
	opacity: 0;
}

.consultstreet-theme-recomended-actions_container .consultstreet-recommeded-actions-container:first-child {
	height: auto;
	opacity: 1;
}

.consultstreet-theme-recomended-actions_container .consultstreet-recommeded-actions-container {
	-webkit-transition: opacity 2s;
	/* Safari */
	transition: opacity 2s;
}

.consultstreet-theme-recomended-actions_container .hide {
	display: none;
}

.consultstreet-customizer-plugin-notify-actions-count.complete {
	background-color: #79ba49;
}

.consultstreet-theme-recomended-actions_container #demo_content .button {
	display: block;
	margin-bottom: 1em;
	text-align: center;
}

.consultstreet-theme-recomended-actions_container .succes a {
	display: inline-block;
	width: 100%;
	text-align: center;
}

.consultstreet-theme-recomended-actions_container .succes a.social {
	width: 49%;
	margin-bottom: 1em;
	padding-top: 4px;
	line-height: 20px;
}

.consultstreet-theme-recomended-actions_container .succes a.social span,
.consultstreet-theme-recomended-actions_container .succes  span {
	margin-right: 5px;
}

.consultstreet-theme-recomended-actions_container .succes {
	padding-top: 4px;
	line-height: 20px;
}

.consultstreet-customizer-notify-dismiss-button-recommended-plugin,
.consultstreet-customizer-notify-dismiss-recommended-action {
	position: absolute;
	top: 10px;
	right: 10px;
	border-radius: 50%;
	color: #d54e21;
	text-decoration: none;
	cursor: pointer;
}

.consultstreet-epsilon-recommeded-actions {
	position: relative;
}

.consultstreet-customizer-notify-dismiss-recommended-action,
.consultstreet-epsilon-recommeded-actions .consultstreet-customizer-notify-dismiss-button-recommended-plugin {
	top: 0;
	right: 0;
}

.consultstreet-epsilon-recommeded-actions #temp_load {
	display: -webkit-box;
	display: -webkit-flex;
	display: -ms-flexbox;
	display: flex;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	height: 100%;

	-webkit-align-items: center;
	align-items: center;
	-webkit-box-align: center;
	-ms-flex-align: center;
}

.consultstreet-epsilon-recommeded-actions #temp_load img {
	margin: 0 auto;
}
PK      l[!i    T  consultstreet/inc/customizer/customizer-notice/js/consultstreet-customizer-notify.jsnu [        /**
 * Customizer notification system
 */


(function (api) {

	api.sectionConstructor['consultstreet-customizer-notify-section'] = api.Section.extend(
		{

			// No events for this type of section.
			attachEvents: function () {
			},

			// Always make the section active.
			isContextuallyActive: function () {
				return true;
			}
		}
	);

})( wp.customize );

					jQuery( document ).ready(
						function () {

							jQuery( '.consultstreet-customizer-notify-dismiss-recommended-action' ).click(
								function () {

									var id = jQuery( this ).attr( 'id' ),
									action = jQuery( this ).attr( 'data-action' );
									jQuery.ajax(
										{
											type: 'GET',
											data: {action: 'consultstreet_customizer_notify_dismiss_action', id: id, todo: action},
											dataType: 'html',
											url: consultstreetCustomizercompanionObject.ajaxurl,
											beforeSend: function () {
												jQuery( '#' + id ).parent().append( '<div id="temp_load" style="text-align:center"><img src="' + consultstreetCustomizercompanionObject.base_path + '/images/spinner-2x.gif" /></div>' );
											},
											success: function (data) {
												var container          = jQuery( '#' + data ).parent().parent();
												var index              = container.next().data( 'index' );
												var recommended_sction = jQuery( '#accordion-section-ti_customizer_notify_recomended_actions' );
												var actions_count      = recommended_sction.find( '.consultstreet-customizer-plugin-notify-actions-count' );
												var section_title      = recommended_sction.find( '.section-title' );
												jQuery( '.consultstreet-customizer-plugin-notify-actions-count .current-index' ).text( index );
												container.slideToggle().remove();
												if (jQuery( '.consultstreet-theme-recomended-actions_container > .epsilon-recommended-actions' ).length === 0) {

													actions_count.remove();

													if (jQuery( '.consultstreet-theme-recomended-actions_container > .epsilon-recommended-plugins' ).length === 0) {
														jQuery( '.control-section-ti-customizer-notify-recomended-actions' ).remove();
													} else {
														section_title.text( section_title.data( 'plugin_text' ) );
													}

												}
											},
											error: function (jqXHR, textStatus, errorThrown) {
												console.log( jqXHR + ' :: ' + textStatus + ' :: ' + errorThrown );
											}
										}
									);
								}
							);

										jQuery( '.consultstreet-customizer-notify-dismiss-button-recommended-plugin' ).click(
											function () {
												var id = jQuery( this ).attr( 'id' ),
												action = jQuery( this ).attr( 'data-action' );
												jQuery.ajax(
													{
														type: 'GET',
														data: {action: 'ti_customizer_notify_dismiss_recommended_plugins', id: id, todo: action},
														dataType: 'html',
														url: consultstreetCustomizercompanionObject.ajaxurl,
														beforeSend: function () {
															jQuery( '#' + id ).parent().append( '<div id="temp_load" style="text-align:center"><img src="' + consultstreetCustomizercompanionObject.base_path + '/images/spinner-2x.gif" /></div>' );
														},
														success: function (data) {
															var container = jQuery( '#' + data ).parent().parent();
															var index     = container.next().data( 'index' );
															jQuery( '.consultstreet-customizer-plugin-notify-actions-count .current-index' ).text( index );
															container.slideToggle().remove();

															if (jQuery( '.consultstreet-theme-recomended-actions_container > .epsilon-recommended-plugins' ).length === 0) {
																jQuery( '.control-section-ti-customizer-notify-recomended-section' ).remove();
															}
														},
														error: function (jqXHR, textStatus, errorThrown) {
															console.log( jqXHR + ' :: ' + textStatus + ' :: ' + errorThrown );
														}
													}
												);
											}
										);

										// Remove activate button and replace with activation in progress button.
										jQuery( document ).on(
											'DOMNodeInserted','.activate-now', function () {
												var activateButton = jQuery( '.activate-now' );
												if (activateButton.length) {
													var url = jQuery( activateButton ).attr( 'href' );
													if (typeof url !== 'undefined') {
														// Request plugin activation.
														jQuery.ajax(
															{
																beforeSend: function () {
																	jQuery( activateButton ).replaceWith( '<a class="button updating-message">' + consultstreetCustomizercompanionObject.activating_string + '...</a>' );
																},
																async: true,
																type: 'GET',
																url: url,
																success: function () {
																	// Reload the page.
																	location.reload();
																}
															}
														);
													}
												}
											}
										);
						}
					);
					
					
					
/**
 * Remove activate button and replace with activation in progress button.
 *
 * @package consultstreet
 */


jQuery( document ).ready(
	function ($) {
		$( 'body' ).on(
			'click', ' .consultstreet-install-plugin ', function () {
				var slug = $( this ).attr( 'data-slug' );

				wp.updates.installPlugin(
					{
						slug: slug
					}
				);
				return false;
			}
		);

		$( '.activate-now' ).on(
			'click', function (e) {
				
				var activateButton = $( this );
				e.preventDefault();
				if ($( activateButton ).length) {
					var url = $( activateButton ).attr( 'href' );

					if (typeof url !== 'undefined') {
						// Request plugin activation.
						$.ajax(
							{
								beforeSend: function () {
									$( activateButton ).replaceWith( '<a class="button updating-message">'+"activating"+'...</a>' );
								},
								async: true,
								type: 'GET',
								url: url,
								success: function () {
									// Reload the page.
									location.reload();
								}
							}
						);
					}
				}
			}
		);
	}
);
PK      l[+qN/  N/  Z  consultstreet/inc/customizer/customizer-notice/consultstreet-customizer-notify-section.phpnu [        <?php

class ConsultStreet_Customizer_Notify_Section extends WP_Customize_Section {
	
	public $type = 'consultstreet-customizer-notify-section';
	
	public $recommended_actions = '';
	
	public $recommended_plugins = '';
	
	public $total_actions = '';
	
	public $plugin_text = '';
	
	public $dismiss_button = '';

	
	public function check_active( $slug ) {
		if ( file_exists( ABSPATH . 'wp-content/plugins/' . $slug . '/' . $slug . '.php' ) ) {
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

			$needs = is_plugin_active( $slug . '/' . $slug . '.php' ) ? 'deactivate' : 'activate';

			return array(
				'status' => is_plugin_active( $slug . '/' . $slug . '.php' ),
				'needs'  => $needs,
			);
		}

		return array(
			'status' => false,
			'needs'  => 'install',
		);
	}

	
	public function create_action_link( $state, $slug ) {
		switch ( $state ) {
			case 'install':
				return wp_nonce_url(
					add_query_arg(
						array(
							'action' => 'install-plugin',
							'plugin' => $slug,
						),
						network_admin_url( 'update.php' )
					),
					'install-plugin_' . $slug
				);
				break;
			case 'deactivate':
				return add_query_arg(
					array(
						'action'        => 'deactivate',
						'plugin'        => rawurlencode( $slug . '/' . $slug . '.php' ),
						'plugin_status' => 'all',
						'paged'         => '1',
						'_wpnonce'      => wp_create_nonce( 'deactivate-plugin_' . $slug . '/' . $slug . '.php' ),
					), network_admin_url( 'plugins.php' )
				);
				break;
			case 'activate':
				return add_query_arg(
					array(
						'action'        => 'activate',
						'plugin'        => rawurlencode( $slug . '/' . $slug . '.php' ),
						'plugin_status' => 'all',
						'paged'         => '1',
						'_wpnonce'      => wp_create_nonce( 'activate-plugin_' . $slug . '/' . $slug . '.php' ),
					), network_admin_url( 'plugins.php' )
				);
				break;
		}// End switch().
	}

	
	public function call_plugin_api( $slug ) {
		include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
		$call_api = get_transient( 'consultstreet_cust_notify_plugin_info_' . $slug );
		if ( false === $call_api ) {
			$call_api = plugins_api(
				'plugin_information', array(
					'slug'   => $slug,
					'fields' => array(
						'downloaded'        => false,
						'rating'            => false,
						'description'       => false,
						'short_description' => true,
						'donate_link'       => false,
						'tags'              => false,
						'sections'          => false,
						'homepage'          => false,
						'added'             => false,
						'last_updated'      => false,
						'compatibility'     => false,
						'tested'            => false,
						'requires'          => false,
						'downloadlink'      => false,
						'icons'             => false,
					),
				)
			);
			set_transient( 'consultstreet_cust_notify_plugin_info_' . $slug, $call_api, 30 * MINUTE_IN_SECONDS );
		}

		return $call_api;
	}

	
	public function json() {
		$json = parent::json();
		global $consultstreet_customizer_notify_recommended_actions;
		global $consultstreet_customizer_notify_recommended_plugins;

		global $install_button_label;
		global $activate_button_label;
		global $consultstreet_deactivate_button_label;

		$formatted_array                               = array();
		$consultstreet_customizer_notify_show_recommended_actions = get_option( 'consultstreet_customizer_notify_show' );
		foreach ( $consultstreet_customizer_notify_recommended_actions as $key => $consultstreet_lite_customizer_notify_recommended_action ) {
			if ( $consultstreet_customizer_notify_show_recommended_actions[ $consultstreet_lite_customizer_notify_recommended_action['id'] ] === false ) {
				continue;
			}
			if ( $consultstreet_lite_customizer_notify_recommended_action['check'] ) {
				continue;
			}

			$consultstreet_lite_customizer_notify_recommended_action['index'] = $key + 1;

			if ( isset( $consultstreet_lite_customizer_notify_recommended_action['plugin_slug'] ) ) {
				$active = $this->check_active( $consultstreet_customizer_notify_recommended_action['plugin_slug'] );
				$consultstreet_lite_customizer_notify_recommended_action['url'] = $this->create_action_link( $active['needs'], $consultstreet_lite_customizer_notify_recommended_action['plugin_slug'] );
				if ( $active['needs'] !== 'install' && $active['status'] ) {
					$consultstreet_lite_customizer_notify_recommended_action['class'] = 'active';
				} else {
					$consultstreet_lite_customizer_notify_recommended_action['class'] = '';
				}

				switch ( $active['needs'] ) {
					case 'install':
						$consultstreet_lite_customizer_notify_recommended_action['button_class'] = 'install-now button';
						$consultstreet_lite_customizer_notify_recommended_action['button_label'] = $install_button_label;
						break;
					case 'activate':
						$consultstreet_lite_customizer_notify_recommended_action['button_class'] = 'activate-now button button-primary';
						$consultstreet_lite_customizer_notify_recommended_action['button_label'] = $activate_button_label;
						break;
					case 'deactivate':
						$consultstreet_lite_customizer_notify_recommended_action['button_class'] = 'deactivate-now button';
						$consultstreet_lite_customizer_notify_recommended_action['button_label'] = $consultstreet_deactivate_button_label;
						break;
				}
			}
			$formatted_array[] = $consultstreet_lite_customizer_notify_recommended_action;
		}// End foreach().

		$customize_plugins = array();

		$consultstreet_lite_customizer_notify_show_recommended_plugins = get_option( 'consultstreet_customizer_notify_show_recommended_plugins' );

		foreach ( $consultstreet_customizer_notify_recommended_plugins as $slug => $plugin_opt ) {

			if ( ! $plugin_opt['recommended'] ) {
				continue;
			}

			if ( isset( $consultstreet_lite_customizer_notify_show_recommended_plugins[ $slug ] ) && $consultstreet_lite_customizer_notify_show_recommended_plugins[ $slug ] ) {
				continue;
			}

			$active = $this->check_active( $slug );

			if ( ! empty( $active['needs'] ) && ( $active['needs'] == 'deactivate' ) ) {
				continue;
			}

			$ti_customizer_notify_recommended_plugin['url'] = $this->create_action_link( $active['needs'], $slug );
			if ( $active['needs'] !== 'install' && $active['status'] ) {
				$ti_customizer_notify_recommended_plugin['class'] = 'active';
			} else {
				$ti_customizer_notify_recommended_plugin['class'] = '';
			}

			switch ( $active['needs'] ) {
				case 'install':
					$ti_customizer_notify_recommended_plugin['button_class'] = 'install-now button';
					$ti_customizer_notify_recommended_plugin['button_label'] = $install_button_label;
					break;
				case 'activate':
					$ti_customizer_notify_recommended_plugin['button_class'] = 'activate-now button button-primary';
					$ti_customizer_notify_recommended_plugin['button_label'] = $activate_button_label;
					break;
				case 'deactivate':
					$ti_customizer_notify_recommended_plugin['button_class'] = 'deactivate-now button';
					$ti_customizer_notify_recommended_plugin['button_label'] = $consultstreet_deactivate_button_label;
					break;
			}
			$info = $this->call_plugin_api( $slug );
			$ti_customizer_notify_recommended_plugin['id']          = $slug;
			$ti_customizer_notify_recommended_plugin['plugin_slug'] = $slug;

			if ( ! empty( $plugin_opt['description'] ) ) {
				$ti_customizer_notify_recommended_plugin['description'] = $plugin_opt['description'];
			} else {
				$ti_customizer_notify_recommended_plugin['description'] = $info->short_description;
			}

			$ti_customizer_notify_recommended_plugin['title'] = $info->name;

			$customize_plugins[] = $ti_customizer_notify_recommended_plugin;

		}// End foreach().

		$json['recommended_actions'] = $formatted_array;
		$json['recommended_plugins'] = $customize_plugins;
		$json['total_actions']       = count( $consultstreet_customizer_notify_recommended_actions );
		$json['plugin_text']         = $this->plugin_text;
		$json['dismiss_button']      = $this->dismiss_button;
		return $json;

	}
	
	protected function render_template() {
	?>
		<# if( data.recommended_actions.length > 0 || data.recommended_plugins.length > 0 ){ #>
			<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

				<h3 class="accordion-section-title">
					<span class="section-title" data-plugin_text="{{ data.plugin_text }}">
						<# if( data.recommended_actions.length > 0 ){ #>
							{{ data.title }}
						<# }else{ #>
							<# if( data.recommended_plugins.length > 0 ){ #>
								{{ data.plugin_text }}
							<# }#>
						<# } #>
					</span>
					<# if( data.recommended_actions.length > 0 ){ #>
						<span class="consultstreet-customizer-plugin-notify-actions-count">
							<span class="current-index">{{ data.recommended_actions[0].index }}</span>
							{{ data.total_actions }}
						</span>
					<# } #>
				</h3>
				<div class="consultstreet-theme-recomended-actions_container" id="plugin-filter">
					<# if( data.recommended_actions.length > 0 ){ #>
						<# for (action in data.recommended_actions) { #>
							<div class="consultstreet-recommeded-actions-container epsilon-required-actions" data-index="{{ data.recommended_actions[action].index }}">
								<# if( !data.recommended_actions[action].check ){ #>
									<div class="consultstreet-epsilon-recommeded-actions">
										<p class="title">{{ data.recommended_actions[action].title }}</p>
										<span data-action="dismiss" class="dashicons dashicons-no consultstreet-customizer-notify-dismiss-recommended-action" id="{{ data.recommended_actions[action].id }}"></span>
										<div class="description">{{{ data.recommended_actions[action].description }}}</div>
										<# if( data.recommended_actions[action].plugin_slug ){ #>
											<div class="custom-action">
												<p class="plugin-card-{{ data.recommended_actions[action].plugin_slug }} action_button {{ data.recommended_actions[action].class }}">
													<a data-slug="{{ data.recommended_actions[action].plugin_slug }}" class="{{ data.recommended_actions[action].button_class }}" href="{{ data.recommended_actions[action].url }}">{{ data.recommended_actions[action].button_label }}</a>
												</p>
											</div>
										<# } #>
										<# if( data.recommended_actions[action].help ){ #>
											<div class="custom-action">{{{ data.recommended_actions[action].help }}}</div>
										<# } #>
									</div>
								<# } #>
							</div>
						<# } #>
					<# } #>

					<# if( data.recommended_plugins.length > 0 ){ #>
						<# for (action in data.recommended_plugins) { #>
							<div class="consultstreet-recommeded-actions-container epsilon-recommended-plugins" data-index="{{ data.recommended_plugins[action].index }}">
								<# if( !data.recommended_plugins[action].check ){ #>
									<div class="consultstreet-epsilon-recommeded-actions">
										<p class="title">{{ data.recommended_plugins[action].title }}</p>
										<span data-action="dismiss" class="dashicons dashicons-no consultstreet-customizer-notify-dismiss-button-recommended-plugin" id="{{ data.recommended_plugins[action].id }}"></span>
										<div class="description">{{{ data.recommended_plugins[action].description }}}</div>
										<# if( data.recommended_plugins[action].plugin_slug ){ #>
											<div class="custom-action">
												<p class="plugin-card-{{ data.recommended_plugins[action].plugin_slug }} action_button {{ data.recommended_plugins[action].class }}">
													<a data-slug="{{ data.recommended_plugins[action].plugin_slug }}" class="{{ data.recommended_plugins[action].button_class }}" href="{{ data.recommended_plugins[action].url }}">{{ data.recommended_plugins[action].button_label }}</a>
												</p>
											</div>
										<# } #>
										<# if( data.recommended_plugins[action].help ){ #>
											<div class="custom-action">{{{ data.recommended_plugins[action].help }}}</div>
										<# } #>
									</div>
								<# } #>
							</div>
						<# } #>
					<# } #>
				</div>
			</li>
		<# } #>
	<?php
	}
}PK      l[Qw8    R  consultstreet/inc/customizer/customizer-notice/consultstreet-customizer-notify.phpnu [        <?php

class ConsultStreet_Customizer_Notify {

	private $recommended_actions;

	
	private $recommended_plugins;

	
	private static $instance;

	
	private $recommended_actions_title;

	
	private $recommended_plugins_title;

	
	private $dismiss_button;

	
	private $install_button_label;

	
	private $activate_button_label;

	
	private $consultstreet_deactivate_button_label;
	
	private $config;

	
	public static function init( $config ) {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof ConsultStreet_Customizer_Notify ) ) {
			self::$instance = new ConsultStreet_Customizer_Notify;
			if ( ! empty( $config ) && is_array( $config ) ) {
				self::$instance->config = $config;
				self::$instance->setup_config();
				self::$instance->setup_actions();
			}
		}

	}

	
	public function setup_config() {

		global $consultstreet_customizer_notify_recommended_plugins;
		global $consultstreet_customizer_notify_recommended_actions;

		global $install_button_label;
		global $activate_button_label;
		global $consultstreet_deactivate_button_label;

		$this->recommended_actions = isset( $this->config['recommended_actions'] ) ? $this->config['recommended_actions'] : array();
		$this->recommended_plugins = isset( $this->config['recommended_plugins'] ) ? $this->config['recommended_plugins'] : array();

		$this->recommended_actions_title = isset( $this->config['recommended_actions_title'] ) ? $this->config['recommended_actions_title'] : '';
		$this->recommended_plugins_title = isset( $this->config['recommended_plugins_title'] ) ? $this->config['recommended_plugins_title'] : '';
		$this->dismiss_button            = isset( $this->config['dismiss_button'] ) ? $this->config['dismiss_button'] : '';

		$consultstreet_customizer_notify_recommended_plugins = array();
		$consultstreet_customizer_notify_recommended_actions = array();

		if ( isset( $this->recommended_plugins ) ) {
			$consultstreet_customizer_notify_recommended_plugins = $this->recommended_plugins;
		}

		if ( isset( $this->recommended_actions ) ) {
			$consultstreet_customizer_notify_recommended_actions = $this->recommended_actions;
		}

		$install_button_label    = isset( $this->config['install_button_label'] ) ? $this->config['install_button_label'] : '';
		$activate_button_label   = isset( $this->config['activate_button_label'] ) ? $this->config['activate_button_label'] : '';
		$consultstreet_deactivate_button_label = isset( $this->config['consultstreet_deactivate_button_label'] ) ? $this->config['consultstreet_deactivate_button_label'] : '';

	}

	
	public function setup_actions() {

		// Register the section
		add_action( 'customize_register', array( $this, 'consultstreet_plugin_notification_customize_register' ) );

		// Enqueue scripts and styles
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'consultstreet_customizer_notify_scripts_for_customizer' ), 0 );

		/* ajax callback for dismissable recommended actions */
		add_action( 'wp_ajax_quality_customizer_notify_dismiss_action', array( $this, 'consultstreet_customizer_notify_dismiss_recommended_action_callback' ) );

		add_action( 'wp_ajax_ti_customizer_notify_dismiss_recommended_plugins', array( $this, 'consultstreet_customizer_notify_dismiss_recommended_plugins_callback' ) );

	}

	
	public function consultstreet_customizer_notify_scripts_for_customizer() {

		wp_enqueue_style( 'consultstreet-customizer-notify-css', get_template_directory_uri() . '/inc/customizer/customizer-notice/css/consultstreet-customizer-notify.css', array());

		wp_enqueue_style( 'plugin-install' );
		wp_enqueue_script( 'plugin-install' );
		wp_add_inline_script( 'plugin-install', 'var pagenow = "customizer";' );

		wp_enqueue_script( 'updates' );

		wp_enqueue_script( 'consultstreet-customizer-notify-js', get_template_directory_uri() . '/inc/customizer/customizer-notice/js/consultstreet-customizer-notify.js', array( 'customize-controls' ));
		wp_localize_script(
			'consultstreet-customizer-notify-js', 'consultstreetCustomizercompanionObject', array(
				'ajaxurl'            => admin_url( 'admin-ajax.php' ),
				'template_directory' => get_template_directory_uri(),
				'base_path'          => admin_url(),
				'activating_string'  => __( 'Activating', 'consultstreet' ),
			)
		);

	}

	
	public function consultstreet_plugin_notification_customize_register( $wp_customize ) {

		
		require_once get_template_directory() . '/inc/customizer/customizer-notice/consultstreet-customizer-notify-section.php';

		$wp_customize->register_section_type( 'ConsultStreet_Customizer_Notify_Section' );

		$wp_customize->add_section(
			new consultstreet_Customizer_Notify_Section(
				$wp_customize,
				'ConsultStreet-customizer-notify-section',
				array(
					'title'          => $this->recommended_actions_title,
					'plugin_text'    => $this->recommended_plugins_title,
					'dismiss_button' => $this->dismiss_button,
					'priority'       => 0,
				)
			)
		);

	}

	
	public function consultstreet_customizer_notify_dismiss_recommended_action_callback() {

		global $consultstreet_customizer_notify_recommended_actions;

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */ 

		if ( ! empty( $action_id ) ) {
			
			if ( get_option( 'consultstreet_customizer_notify_show' ) ) {

				$consultstreet_customizer_notify_show_recommended_actions = get_option( 'consultstreet_customizer_notify_show' );
				switch ( $_GET['todo'] ) {
					case 'add':
						$consultstreet_customizer_notify_show_recommended_actions[ $action_id ] = true;
						break;
					case 'dismiss':
						$consultstreet_customizer_notify_show_recommended_actions[ $action_id ] = false;
						break;
				}
				update_option( 'consultstreet_customizer_notify_show', $consultstreet_customizer_notify_show_recommended_actions );

				
			} else {
				$consultstreet_customizer_notify_show_recommended_actions = array();
				if ( ! empty( $consultstreet_customizer_notify_recommended_actions ) ) {
					foreach ( $consultstreet_customizer_notify_recommended_actions as $consultstreet_lite_customizer_notify_recommended_action ) {
						if ( $consultstreet_lite_customizer_notify_recommended_action['id'] == $action_id ) {
							$consultstreet_customizer_notify_show_recommended_actions[ $consultstreet_lite_customizer_notify_recommended_action['id'] ] = false;
						} else {
							$consultstreet_customizer_notify_show_recommended_actions[ $consultstreet_lite_customizer_notify_recommended_action['id'] ] = true;
						}
					}
					update_option( 'consultstreet_customizer_notify_show', $consultstreet_customizer_notify_show_recommended_actions );
				}
			}
		}
		die(); 
	}

	
	public function consultstreet_customizer_notify_dismiss_recommended_plugins_callback() {

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */

		if ( ! empty( $action_id ) ) {

			$consultstreet_lite_customizer_notify_show_recommended_plugins = get_option( 'consultstreet_customizer_notify_show_recommended_plugins' );

			switch ( $_GET['todo'] ) {
				case 'add':
					$consultstreet_lite_customizer_notify_show_recommended_plugins[ $action_id ] = false;
					break;
				case 'dismiss':
					$consultstreet_lite_customizer_notify_show_recommended_plugins[ $action_id ] = true;
					break;
			}
			update_option( 'consultstreet_customizer_notify_show_recommended_plugins', $consultstreet_lite_customizer_notify_show_recommended_plugins );
		}
		die(); 
	}

}
PK      l[0q    N  consultstreet/inc/customizer/customizer-notice/consultstreet-notify-plugin.phpnu [        <?php

/*
 *  Customizer Notifications
 */

require get_template_directory() . '/inc/customizer/customizer-notice/consultstreet-customizer-notify.php';

$consultstreet_config_customizer = array(
    'recommended_plugins' => array( 
        'arile-extra' => array(
            'recommended' => true,
            'description' => sprintf( 
                /* translators: %s: plugin name */
                esc_html__( 'If you want to show all the features and business sections of the FrontPage. please install and activate %s plugin', 'consultstreet' ), '<strong>Arile Extra</strong>' 
            ),
        ),
    ),
	'recommended_actions'       => array(),
	'recommended_actions_title' => esc_html__( 'Recommended Actions', 'consultstreet' ),
	'recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'consultstreet' ),
	'install_button_label'      => esc_html__( 'Install and Activate', 'consultstreet' ),
	'activate_button_label'     => esc_html__( 'Activate', 'consultstreet' ),
	'consultstreet_deactivate_button_label'   => esc_html__( 'Deactivate', 'consultstreet' ),
);
ConsultStreet_Customizer_Notify::init( apply_filters( 'consultstreet_customizer_notify_array', $consultstreet_config_customizer ) );PK      l[ԐJr  r  V  consultstreet/inc/customizer/customizer-repeater/class/customizer-repeater-control.phpnu [        <?php if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return null;
}

class ConsultStreet_Repeater extends WP_Customize_Control {

	public $id;
	private $boxtitle = array();
	private $add_field_label = array();
	private $customizer_repeater_title_control = false;
	private $customizer_repeater_subtitle_control = false;
	private $customizer_repeater_button_text_control = false;
	private $customizer_repeater_link_control = false;
	private $customizer_repeater_slide_format = false;
	private $customizer_repeater_video_url_control = false;
	private $customizer_repeater_image_control = false;
	private $customizer_repeater_icon_control = false;
	private $customizer_repeater_color_control = false;
	private $customizer_repeater_text_control = false;
	private $customizer_repeater_designation_control = false;
	private $customizer_repeater_shortcode_control = false;
	private $customizer_repeater_repeater_control = false;
	private $customizer_repeater_checkbox_control = false;
	
    private $customizer_icon_container = '';
    private $allowed_html = array();


	/*Class constructor*/
	public function __construct( $manager, $id, $args = array() ) {
		parent::__construct( $manager, $id, $args );
		/*Get options from customizer.php*/
		$this->add_field_label = esc_html__( 'Add new field', 'consultstreet' );
		if ( ! empty( $args['add_field_label'] ) ) {
			$this->add_field_label = $args['add_field_label'];
		}

		$this->boxtitle = esc_html__( 'Customizer Repeater', 'consultstreet' );
		if ( ! empty ( $args['item_name'] ) ) {
			$this->boxtitle = $args['item_name'];
		} elseif ( ! empty( $this->label ) ) {
			$this->boxtitle = $this->label;
		}

		if ( ! empty( $args['customizer_repeater_image_control'] ) ) {
			$this->customizer_repeater_image_control = $args['customizer_repeater_image_control'];
		}
	

		if ( ! empty( $args['customizer_repeater_icon_control'] ) ) {
			$this->customizer_repeater_icon_control = $args['customizer_repeater_icon_control'];
		}

		if ( ! empty( $args['customizer_repeater_color_control'] ) ) {
			$this->customizer_repeater_color_control = $args['customizer_repeater_color_control'];
		}

		if ( ! empty( $args['customizer_repeater_title_control'] ) ) {
			$this->customizer_repeater_title_control = $args['customizer_repeater_title_control'];
		}

		if ( ! empty( $args['customizer_repeater_subtitle_control'] ) ) {
			$this->customizer_repeater_subtitle_control = $args['customizer_repeater_subtitle_control'];
		}

		if ( ! empty( $args['customizer_repeater_text_control'] ) ) {
			$this->customizer_repeater_text_control = $args['customizer_repeater_text_control'];
		}
		
		if ( ! empty( $args['customizer_repeater_designation_control'] ) ) {
			$this->customizer_repeater_designation_control = $args['customizer_repeater_designation_control'];
		}
		
		if ( ! empty( $args['customizer_repeater_button_text_control'] ) ) {
			$this->customizer_repeater_button_text_control = $args['customizer_repeater_button_text_control'];
		}

		if ( ! empty( $args['customizer_repeater_link_control'] ) ) {
			$this->customizer_repeater_link_control = $args['customizer_repeater_link_control'];
		}
		
		if ( ! empty( $args['customizer_repeater_checkbox_control'] ) ) {
			$this->customizer_repeater_checkbox_control = $args['customizer_repeater_checkbox_control'];
		}
		
		if ( ! empty( $args['customizer_repeater_slide_format'] ) ) {
			$this->customizer_repeater_slide_format = $args['customizer_repeater_slide_format'];
		}
		
		if ( ! empty( $args['customizer_repeater_video_url_control'] ) ) {
			$this->customizer_repeater_video_url_control = $args['customizer_repeater_video_url_control'];
		}
		

		if ( ! empty( $args['customizer_repeater_shortcode_control'] ) ) {
			$this->customizer_repeater_shortcode_control = $args['customizer_repeater_shortcode_control'];
		}

		if ( ! empty( $args['customizer_repeater_repeater_control'] ) ) {
			$this->customizer_repeater_repeater_control = $args['customizer_repeater_repeater_control'];
		}
		

		if ( ! empty( $id ) ) {
			$this->id = $id;
		}

		if ( file_exists( get_template_directory() . '/inc/customizer/customizer-repeater/inc/icons.php' ) ) {
			$this->customizer_icon_container =  'inc/customizer/customizer-repeater/inc/icons';
		}

		$allowed_array1 = wp_kses_allowed_html( 'post' );
		$allowed_array2 = array(
			'input' => array(
				'type'        => array(),
				'class'       => array(),
				'placeholder' => array()
			)
		);

		$this->allowed_html = array_merge( $allowed_array1, $allowed_array2 );
	}

	/*Enqueue resources for the control*/
	public function enqueue() {
		wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome/css/font-awesome.min.css', array(), 999 );

		wp_enqueue_style( 'consultstreet_customizer-repeater-admin-stylesheet', get_template_directory_uri() . '/inc/customizer/customizer-repeater/css/admin-style.css', array(), 999 );

		wp_enqueue_style( 'wp-color-picker' );

		wp_enqueue_script( 'consultstreet_customizer-repeater-script', get_template_directory_uri() . '/inc/customizer/customizer-repeater/js/customizer_repeater.js', array('jquery', 'jquery-ui-draggable', 'wp-color-picker' ), 999, true  );

		wp_enqueue_script( 'consultstreet_customizer-repeater-fontawesome-iconpicker', get_template_directory_uri() . '/inc/customizer/customizer-repeater/js/fontawesome-iconpicker.js', array( 'jquery' ), 999, true );

		wp_enqueue_style( 'consultstreet_customizer-repeater-fontawesome-iconpicker-script', get_template_directory_uri() . '/inc/customizer/customizer-repeater/css/fontawesome-iconpicker.min.css', array(), 999 );
	}

	public function render_content() {

		/*Get default options*/
		$this_default = json_decode( $this->setting->default );

		/*Get values (json format)*/
		$values = $this->value();

		/*Decode values*/
		$json = json_decode( $values );

		if ( ! is_array( $json ) ) {
			$json = array( $values );
		} ?>

		<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
		<div class="customizer-repeater-general-control-repeater customizer-repeater-general-control-droppable">
			<?php
			if ( ( count( $json ) == 1 && '' === $json[0] ) || empty( $json ) ) {
				if ( ! empty( $this_default ) ) {
					$this->iterate_array( $this_default ); ?>
					<input type="hidden"
					       id="customizer-repeater-<?php echo esc_attr( $this->id ); ?>-colector" <?php esc_attr( $this->link() ); ?>
					       class="customizer-repeater-colector"
					       value="<?php echo esc_textarea( json_encode( $this_default ) ); ?>"/>
					<?php
				} else {
					$this->iterate_array(); ?>
					<input type="hidden"
					       id="customizer-repeater-<?php echo esc_attr( $this->id ); ?>-colector" <?php esc_attr( $this->link() ); ?>
					       class="customizer-repeater-colector"/>
					<?php
				}
			} else {
				$this->iterate_array( $json ); ?>
				<input type="hidden" id="customizer-repeater-<?php echo esc_attr( $this->id ); ?>-colector" <?php esc_attr( $this->link() ); ?>
				       class="customizer-repeater-colector" value="<?php echo esc_textarea( $this->value() ); ?>"/>
				<?php
			} ?>
			</div>
		<button type="button" class="button add_field customizer-repeater-new-field">
			<?php echo esc_html( $this->add_field_label ); ?>
		</button>
		<?php
	}

	private function iterate_array($array = array()){
		
		/*Counter that helps checking if the box is first and should have the delete button disabled*/
		$it = 0;
		if(!empty($array)){
			foreach($array as $icon){ ?>
				<div class="customizer-repeater-general-control-repeater-container customizer-repeater-draggable">
					<div class="customizer-repeater-customize-control-title">
						<?php echo esc_html( $this->boxtitle ) ?>
					</div>
					<div class="customizer-repeater-box-content-hidden">
						<?php
						$choice = $image_url = $icon_value = $title = $subtitle = $text = $slide_format = $link = $designation = $button = $open_new_tab = $shortcode = $repeater = $color = $video_url = '';
						if(!empty($icon->id)){
							$id = $icon->id;
						}
						if(!empty($icon->choice)){
							$choice = $icon->choice;
						}
						if(!empty($icon->image_url)){
							$im