street/inc/customizer/controls/code/consultstreet-customize-typography-control.phpnu [        <?php

// Exit if accessed directly.
if ( ! class_exists( 'WP_Customize_Control' ) )
    return NULL;
/**
 * Typography control
 */
class ConsultStreet_Customizer_Typography_Control extends WP_Customize_Control {

	/**
	 * The control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'consultstreet-typography';

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper in $this->render().
	 *
	 * @access protected
	 */
	protected function render_content() {
		$this_val = $this->value(); ?>
		<label>
			<?php if ( ! empty( $this->label ) ) : ?>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<?php endif; ?>
			<?php if ( ! empty( $this->description ) ) : ?>
				<span class="description customize-control-description"><?php echo wp_kses_post( $this->description ); ?></span>
			<?php endif; ?>

			<select class="consultstreet-typography-select" <?php $this->link(); ?>>
				<?php
				// Get Standard font options
				if ( $std_fonts = consultstreet_standard_fonts() ) { ?>
					<optgroup label="<?php esc_attr_e( 'Standard Fonts', 'consultstreet' ); ?>">
						<?php
						// Loop through font options and add to select
						foreach ( $std_fonts as $font ) { ?>
							<option value="<?php echo esc_html( $font ); ?>" <?php selected( $font, $this_val ); ?>><?php echo esc_html( $font ); ?></option>
						<?php } ?>
					</optgroup>
				<?php }

				// Google font options
				if ( $google_fonts = consultstreet_google_fonts_array() ) { ?>
					<optgroup label="<?php esc_attr_e( 'Google Fonts', 'consultstreet' ); ?>">
						<?php
						// Loop through font options and add to select
						foreach ( $google_fonts as $font ) { ?>
							<option value="<?php echo esc_html( $font ); ?>" <?php selected( $font, $this_val ); ?>><?php echo esc_html( $font ); ?></option>
						<?php } ?>
					</optgroup>
				<?php } ?>
			</select>

		</label>

		<?php
	}
}PK      l[    V  consultstreet/inc/customizer/controls/code/consultstreet-customize-upgrade-control.phpnu [        <?php
/** 
 * Customize Heading control class.
 *
 * @package consultstreet
 * 
 * @see     WP_Customize_Control
 * @access  public
 */

/**
 * Class ConsultStreet_Customize_Upgrade_Control
 */
class ConsultStreet_Customize_Upgrade_Control extends ConsultStreet_Customize_Base_Control {

	/**
	 * Customize control type.
	 *
	 * @access public
	 * @var    string
	 */
	public $type = 'consultstreet-upgrade';

	/**
	 * Renders the Underscore template for this control.
	 *
	 * @see    WP_Customize_Control::print_template()
	 * @access protected
	 * @return void
	 */
	protected function content_template() {
		$upgrade_to_pro_link = 'https://themearile.com/consultstreet-pro-theme/';
		?>

		<div class="consultstreet-upgrade-pro-message" style="display:none;";>
			<# if ( data.label ) { #><h4 class="customize-control-title"><?php echo wp_kses_post( 'Upgrade to <a href="'.$upgrade_to_pro_link.'" target="_blank" > ConsultStreet Pro </a> to be add more', 'consultstreet'); ?> {{{ data.label }}} <?php esc_html_e( 'and get the other pro features.', 'consultstreet') ?></h4><# } #>
		</div>

		<?php
	}

	/**
	 * Render content is still called, so be sure to override it with an empty function in your subclass as well.
	 */
	protected function render_content() {

	}

}PK      l[L><"  <"  6  consultstreet/inc/customizer/controls/css/controls.cssnu [        li[class|="customize-control-consultstreet-"] .wp-picker-container .wp-color-result.button {
	width: 100%;
	max-width: 255px;
	height: 30px;
	margin: 0 6px 6px 0;
	padding: 0 0 0 30px;
	font-size: 11px;
	-webkit-box-shadow: none;
	box-shadow: none;
	border: 1px solid rgba(0, 0, 0, 0.1);
}

li[class|="customize-control-consultstreet-"] .wp-picker-container .wp-color-result-text {
	background: rgba(0, 0, 0, 0.1);
	border-radius: 0 2px 2px 0;
	border-left: 1px solid rgba(0, 0, 0, 0.06);
	color: #fff;
	display: -webkit-box;
	display: -ms-flexbox;
	display: flex;
	-webkit-box-pack: center;
	-ms-flex-pack: center;
	justify-content: center;
	-webkit-box-align: center;
	-ms-flex-align: center;
	align-items: center;
	height: 100%;
}

li[class|="customize-control-consultstreet-"] .wp-picker-container span.color-alpha {
	width: 30px;
	height: 24px;
	position: absolute;
	top: 0;
	left: 0;
	border-top-left-radius: 2px;
	border-bottom-left-radius: 2px;
}

.customize-control-consultstreet-radio-buttonset .buttonset {
	display: -webkit-box;
	display: -ms-flexbox;
	display: flex;
	-ms-flex-wrap: wrap;
	flex-wrap: wrap;
}

.customize-control-consultstreet-radio-buttonset .buttonset .switch-label {
	background: rgba(0, 0, 0, 0.1);
	border: 1px rgba(0, 0, 0, 0.1);
	color: rgba(50, 55, 60, 0.5);
	margin: 0;
	text-align: center;
	padding: 0.5em 1em;
	-webkit-box-flex: 1;
	-ms-flex-positive: 1;
	flex-grow: 1;
}

.customize-control-consultstreet-radio-buttonset .buttonset .switch-input:checked + .switch-label {
	background: #13a1dc;
	color: rgba(255, 255, 255, 0.8);
}

/* Control: Radio image. */
.customize-control-consultstreet-radio-image > .image {
	display: -webkit-box;
	display: -ms-flexbox;
	display: flex;
	-ms-flex-wrap: wrap;
	flex-wrap: wrap;
}

.customize-control-consultstreet-radio-image .image-select + label {
	position: relative;
	display: inline-block;
	width: 32%;
	margin-right: 2%;
}

#customize-control-consultstreet_theme_color .image-select + label, #customize-control-consultstreet_theme_background_image .image-select + label{ 	
    width: 22% !important;
	margin-right: 0% !important; 
}

#customize-control-consultstreet_page_header_layout .image-select + label {
    width: 47%;
}

.customize-control-consultstreet-radio-image .image-select + label:nth-of-type(3n) {
	margin-right: 0;
}

.customize-control-consultstreet-radio-image .image-select + label .image-label {
	display: none;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	height: 100%;
	background: rgba(255, 255, 255, 0.7);
	font-weight: 700;
}

.customize-control-consultstreet-radio-image .image-select + label .image-label .inner {
	width: 100%;
	height: 100%;
	text-align: center;
	padding: 0.5em;
	vertical-align: middle;
}

.customize-control-consultstreet-radio-image .image-select + label:hover .image-label {
	display: block;
}

.customize-control-consultstreet-radio-image input {
	display: none;
}

.customize-control-consultstreet-radio-image input img {
	border: 1px solid transparent;
}

.customize-control-consultstreet-radio-image input:checked + label img {
	-webkit-box-shadow: 0 0 5px 2px rgba(0, 0, 0, 0.25);
	box-shadow: 0 0 5px 2px rgba(0, 0, 0, 0.25);
	border: 1px solid #13a1dc;
}

.customize-control-consultstreet-radio-image input + label .image-clickable {
	position: absolute;
	top: 0;
	bottom: 0;
	left: 0;
	right: 0;
	width: 100%;
	height: 100%;
}

.customize-control-consultstreet-slider .customize-control-content {
	display: -webkit-box;
	display: -ms-flexbox;
	display: flex;
	-webkit-box-align: center;
	-ms-flex-align: center;
	align-items: center;
	-webkit-box-pack: justify;
	-ms-flex-pack: justify;
	justify-content: space-between;
}

.customize-control-consultstreet-slider .ui-slider {
	background-color: rgba(0, 0, 0, 0.1);
	width: 63%;
	height: 6px;
	position: relative;
	display: -webkit-box;
	display: -ms-flexbox;
	display: flex;
	-webkit-box-align: center;
	-ms-flex-align: center;
	align-items: center;
	-webkit-box-pack: justify;
	-ms-flex-pack: justify;
	justif