

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'ConsultStreet_Customize_Blog_General_Option' ) ) :

	/**
	 * General Blog..
	 */
	class ConsultStreet_Customize_Blog_General_Option extends ConsultStreet_Customize_Base_Option {

		public function elements() {

			return array(
			
			    'consultstreet_general_arcive_single_blog_heading'     => array(
					'setting' => array(),
					'control' => array(
						'type'    => 'heading',
				   		'priority'        => 1,
						'label'   => esc_html__( 'Blog/Archive/Single', 'consultstreet' ),
						'section' => 'consultstreet_blog_general',
					),
				),

				'consultstreet_general_blog_arcive_single_content_ordering'        => array(
					'setting' => array(
						'default'           => array(
							'meta-one',
							'title',
							'meta-two',
							'image',
						),
						'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_sortable' ),
					),
					'control' => array(
						'type'        => 'sortable',
						'priority'    => 5,
						'label'       => esc_html__( 'General Post', 'consultstreet' ),
						'description' => esc_html__( 'Drag & Drop post items to re-arrange the order', 'consultstreet' ),
						'section'     => 'consultstreet_blog_general',
						'choices'     => array(
							'meta-one' => esc_attr__( 'Meta One', 'consultstreet' ),
							'title'          => esc_attr__( 'Title', 'consultstreet' ),
							'meta-two'           => esc_attr__( 'Meta Two', 'consultstreet' ),
							'image'           => esc_attr__( 'Image', 'consultstreet' ),
						),
					),
				),
				
				'consultstreet_archive_blog_heading'     => array(
					'setting' => array(),
					'control' => array(
						'type'    => 'heading',
				   		'priority'        => 15,
						'label'   => esc_html__( 'Archive Blog Pages', 'consultstreet' ),
						'section' => 'consultstreet_blog_general',
					),
				),  
				
				
					'consultstreet_archive_blog_pages_layout'                    => array(
						'setting' => array(
							'default'           => 'consultstreet_right_sidebar',
							'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_radio' ),
						),
						'control' => array(
							'type'            => 'radio_image',
							'priority'        => 20,
							'label'           => esc_html__( 'Layout', 'consultstreet' ),
							'section'         => 'consultstreet_blog_general',
							'choices'         => array(
								'consultstreet_right_sidebar'   => CONSULTSTREET_PARENT_INC_ICON_URI . '/theme-right-sidebar.png',
								'consultstreet_left_sidebar'   => CONSULTSTREET_PARENT_INC_ICON_URI . '/theme-left-sidebar.png',
								'consultstreet_no_sidebar' => CONSULTSTREET_PARENT_INC_ICON_URI . '/theme-fullwidth.png',
							),
						),
					),
				
				'consultstreet_single_blog_heading'     => array(
					'setting' => array(),
					'control' => array(
						'type'    => 'heading',
				   		'priority'        => 30,
						'label'   => esc_html__( 'Single Blog Pages', 'consultstreet' ),
						'section' => 'consultstreet_blog_general',
					),
				),
				
				    'consultstreet_single_blog_pages_layout'                    => array(
						'setting' => array(
							'default'           => 'consultstreet_right_sidebar',
							'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_radio' ),
						),
						'control' => array(
							'type'            => 'radio_image',
							'priority'        => 35,
							'label'           => esc_html__( 'Layout', 'consultstreet' ),
							'section'         => 'consultstreet_blog_general',
							'choices'         => array(
								'consultstreet_right_sidebar'   => CONSULTSTREET_PARENT_INC_ICON_URI . '/theme-right-sidebar.png',
								'consultstreet_left_sidebar'   => CONSULTSTREET_PARENT_INC_ICON_URI . '/theme-left-sidebar.png',
								'consultstreet_no_sidebar' => CONSULTSTREET_PARENT_INC_ICON_URI . '/theme-fullwidth.png',
							),
						),
					),
					
				'consultstreet_custom_logo_size' => array(
					'setting' => array(
						'default'           => array(
							'slider' => 257,
							'suffix' => 'px',
						),
						'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_slider' ),
					),
					'control' => array(
						'type'        => 'slider',
						'priority'    => 55,
						'label'       => esc_html__( 'Logo Width', 'consultstreet' ),
						'section'     => 'title_tagline',
						'input_attrs' => array(
							'min'  => 0,
							'max'  => 600,
							'step' => 3,
						),
					),
				),
				

			);

		}

	}

	new ConsultStreet_Customize_Blog_General_Option();

endif;
PK      l[~    v  consultstreet/inc/customizer/customizer-settings/theme-settings/consultstreet-footer-copyright-customizer-settings.phpnu [        <?php
/**
 * Footer Copyright.
 *
 * @package     consultstreet
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'ConsultStreet_Customize_Footer_Copyright_Option' ) ) :

	/**
	 * Footer Copyright.
	 */
	class ConsultStreet_Customize_Footer_Copyright_Option extends ConsultStreet_Customize_Base_Option {

		public function elements() {

			return array(

				'consultstreet_footer_copright_enabled'                  => array(
					'setting' => array(
						'default'           => true,
						'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_checkbox' ),
					),
					'control' => array(
						'type'     => 'toggle',
						'priority' => 5,
						'label'    => esc_html__( 'Footer Copyright Enable/Disable', 'consultstreet' ),
						'section'  => 'consultstreet_footer_copyright',
					),
				),		
				
				
			);

		}

	}

	new ConsultStreet_Customize_Footer_Copyright_Option();

endif;
PK      l[S	    s  consultstreet/inc/customizer/customizer-settings/theme-settings/consultstreet-footer-widget-customizer-settings.phpnu [        <?php
/**
 * Footer widgets.
 *
 * @package     consultstreet
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'ConsultStreet_Customize_Footer_Widget_Option' ) ) :

	/**
	 * Option: Footer widget.
	 */
	class ConsultStreet_Customize_Footer_Widget_Option extends ConsultStreet_Customize_Base_Option {

		public function elements() {

			return array(

				'consultstreet_footer_widgets_enabled'                  => array(
					'setting' => array(
						'default'           => true,
						'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_checkbox' ),
					),
					'control' => array(
						'type'     => 'toggle',
						'priority' => 10,
						'label'    => esc_html__( 'Footer Widget Area Enable/Disable', 'consultstreet' ),
						'section'  => 'consultstreet_footer_widgets',
					),
				),
				
								
				'consultstreet_footer_container_size'     => array(
						'setting' => array(
							'default'           => 'container-full',
							'sanitize_callback' => array( 'ConsultStreet_Customizer_Sanitize', 'sanitize_radio' ),
						),
						'control' => array(
							'type'            => 'radio',
							'priority'        => 25,
							'is_default_type' => true,
							'label'           => esc_html__( 'Container Width', 'consultstreet' ),
							'section'         => 'consultstreet_footer_widgets',
							'choices'         => array(
								'container'  => esc_html__( 'Container', 'consultstreet' ),
								'container-full' => esc_html__( 'Container Full', 'consultstreet' ),
							),
						),
				),	
				
				

			);

		}

	}

	new ConsultStreet_Customize_Footer_Widget_Option();

endif;
PK      l[_    m  consultstreet/inc/customizer/customizer-settings/theme-settin