PATH . 'wp-admin/includes/plugin-install.php' );

	// Includes necessary for Plugin_Upgrader and Plugin_Installer_Skin
	include_once( ABSPATH . 'wp-admin/includes/file.php' );
	include_once( ABSPATH . 'wp-admin/includes/misc.php' );
	include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );

	// Filter to prevent the activate text
	add_filter('install_plugin_complete_actions', 'popularfx_install_pagelayer_complete_actions', 10, 3);
	
	echo '<h2>'.__('Install Pagelayer Free Version', 'popularfx').'</h2>';

	$upgrader = new Plugin_Upgrader( new Plugin_Installer_Skin(  ) );
	$installed = $upgrader->install('https://downloads.wordpress.org/plugin/pagelayer.zip');
	
	if(is_wp_error( $installed ) || empty($installed)){
		return $installed;
	}
	
	if ( !is_wp_error( $installed ) && $installed ) {
		echo __('Activating Pagelayer Plugin !', 'popularfx');
		$installed = activate_plugin('pagelayer/pagelayer.php');
		
		if ( is_null($installed)) {
			$installed = true;
			echo '<div id="message" class="updated"><p>'. sprintf(__('Done! Pagelayer is now installed and activated.  Please click <a href="%s">here</a> to import your themes content', 'popularfx'), esc_url(admin_url('admin.php?page=pagelayer_import'))). '</p></div><br />';
			echo '<br><br><b>'.__('Done! Pagelayer is now installed and activated', 'popularfx').'.</b>';
		}
	}
	
	return $installed;
	
}

// Prevent pro activate text for installer
function popularfx_install_pagelayer_complete_actions($install_actions, $api, $plugin_file){
	
	if($plugin_file == 'pagelayer-pro/pagelayer-pro.php'){
		return array();
	}
	
	if($plugin_file == 'pagelayer/pagelayer.php'){
		return array();
	}
	
	return $install_actions;
	
}

}

if(!function_exists('popularfx_admin_menu')){

// This adds the left menu in WordPress Admin page
add_action('admin_menu', 'popularfx_admin_menu', 5);
function popularfx_admin_menu() {
	
	if(defined('PFX_FILE')){
		return;
	}
	
	$capability = 'edit_theme_options';// TODO : Capability for accessing this page

	add_theme_page('PopularFX', __('PopularFX Options', 'popularfx'), $capability, 'popularfx', 'popularfx_page_handler');

	/*// Add the menu page
	add_menu_page('PopularFX', 'PopularFX', $capability, 'popularfx', 'popularfx_page_handler', POPULARFX_URL.'/images/popularfx-logo-menu.png');

	// Options Page
	add_submenu_page('po