size = get_theme_mod( 'popularfx_site_title_size', 30 );
	$styles.= '.site-title a { font-size: ' . esc_attr( $site_title_size ) .' px; }'.PHP_EOL;
	
	// Site Description Color
	$description_color = get_theme_mod('popularfx_site_tagline_color', '#171717');
	$styles .= '.site-description {color:'.esc_attr($description_color).' !important;}'.PHP_EOL;
	
	// Site Description size
	$tagline_size = get_theme_mod( 'popularfx_tagline_size', 15 );
	$styles .= '.site-description {font-size: ' . esc_attr($tagline_size) . 'px;}'.PHP_EOL;
	
	// Footer Background Color
	$footer_bg_color = get_theme_mod('popularfx_footer_bg_color', '#171717');
	$styles .= '.site-footer {background-color:'.esc_attr($footer_bg_color).'! important;}'.PHP_EOL;
	
	if ( get_header_image() ){
		$styles .= '.site-header {background-image: url("'.esc_url(get_header_image()).'");}'.PHP_EOL;
	}
	
	// Scroll to Top
	if( get_theme_mod( 'pfx_enable_scrolltop' ) ){
		$pfx_scrolltop_iconsize = get_theme_mod('pfx_scrolltop_iconsize', 15);
		$styles .= 'a#pfx-scroll-top.pfx-scroll-top { left: '. get_theme_mod('pfx_scrolltop_position', 95) . '%;  padding: '. get_theme_mod('pfx_scrolltop_padding', 10) . 'px; border: '. get_theme_mod('pfx_scrolltop_borderwidth', 2) . 'px solid; border-radius: '. get_theme_mod('pfx_scrolltop_borderradius', 15) . 'px; background-color: '. get_theme_mod('pfx_scrolltop_bg_color', '#ffffff') . ';  border-color: '. get_theme_mod('pfx_scrolltop_border_color', '#000000') . ' !important; }'.PHP_EOL;
		$styles .= 'a#pfx-scroll-top span.dashicons.dashicons-arrow-up-alt2 { width: '. $pfx_scrolltop_iconsize . 'px; height: '. $pfx_scrolltop_iconsize . 'px; font-size: '. $pfx_scrolltop_iconsize . 'px;  color: '. get_theme_mod('pfx_scrolltop_color', '#000000') . '; }'.PHP_EOL;
		$styles .= 'a#pfx-scroll-top:hover { background-color: '. get_theme_mod('pfx_scrolltop_bg_hover_color', '#000000') . ';  border-color: '. get_theme_mod('pfx_scrolltop_hover_border_color', '#000000') . ' !important; } ';
		$styles .= 'a#pfx-scroll-top:hover span.dashicons.dashicons-arrow-up-alt2 { color: '. get_theme_mod('pfx_scrolltop_hover_color', '#ffffff') . '; }'.PHP_EOL;
		$styles .= 'a#pfx-scroll-top {position: fixed;	left: 95%;	bottom: 30px; z-index: 9999999;	line-height: 1;	cursor: pointer; display:none;}';

	}
	
	$styles .= PHP_EOL.'</style>';
	
	echo $styles;
	
	//pagelayer_print($pagelayer->settings);
}

add_filter('body_class', 'popularfx_body_class', 10, 2);
function popularfx_body_class($classes, $class){
	$classes[] = 'popularfx-body';
	return $classes;
}

// Load the google fonts
add_action('wp_footer', 'popularfx_enqueue_fonts', 4);
function popularfx_enqueue_fonts(){
	
	global $pagelayer, $popularfx;
	
	if(empty($popularfx['runtime_fonts'])){
		return;
	}
	
	$url = [];
	
	foreach($popularfx['runtime_fonts'] as $font => $weights){
		$url[] = $font.':'.implode(',', $weights);
	}
	
	// If no fonts are to be set, then we dont set
	if(empty($url)){
		return false;
	}
	
	wp_register_style('popularfx-google-font', 'https://fonts.googleapis.com/css?family='.rawurlencode(implode('|', $url)), array(), POPULARFX_VERSION);
	wp_enqueue_style('popularfx-google-font');
	
}

if(class_exists('WP_Customize_Section')){
		
	class WP_Customize_No_Pagelayer_Section extends WP_Customize_Section { 
		public function render(){

			echo '<li id="accordion-section-no_pagelayer" class="accordion-section control-section control-section-install-pgl">
			<a href="'.admin_url('plugin-install.php?s=pagelayer&tab=search&type=term').'" target="_blank"><span class="dashicons dashicons-megaphone"></span>'.__('Install Pagelayer to get full access !', 'popularfx').'</a>
			</li>';
		
		}
		
	}

	class WP_Customize_PFX_Pro_Section extends WP_Customize_Section {
		public $type = 'pfxpro';

		public function render() {
		?>
		<li id="accordion-section-popularfx_pro_link" class="accordion-section control-section control-section-<?php echo esc_html( $this->type ); ?>">
				<a href="<?php echo POPULARFX_WWW_URL; ?>/pricing?from=pfx-customizer" target="_blank"><?php _e('Get More Options with PopularFX Pro', 'popularfx'); ?><span class="dashicons dashicons-arrow-right-alt2"></span></a>
			</li>
		<?php
		}
	}

}

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function popularfx_customize_register( $wp_customize ) {
	
	global $popularfx;
	
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if(empty($popularfx['license']['status'])){
		
		$wp_customize->add_section( new WP_Customize_PFX_Pro_Section($wp_customize, 'popularfx_pro_link', array(
			'capability' => 'edit_theme_options',
			'priority'   => 1,
			'title'      => __('Get More Options with PopularFX Pro', 'popularfx')
		) ) );
	
		// Install Pagelayer PRO if PRO user not installed already
		$wp_customize->add_setting('popularfx_pro_show', array(
			'capability' => 'edit_theme_options',
			'type'       => 'hidden',
			'autoload'   => false,
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control('popularfx_pro_show', array(
			'label'   => __('See Pro Features', 'popularfx'),
			'description' => 'test',
			'section' => 'popularfx_pro_link',
			'type'    => 'hidden',
		) );
	
	// Suggest to install Pagelayer
	}elseif(!defined('PAGELAYER_VERSION')){
		
		$wp_customize->add_section( new WP_Customize_No_Pagelayer_Section($wp_customize, 'popularfx_no_pagelayer', array(
			'capability' => 'edit_theme_options',
			'priority'   => 1,
			'title'      => __('Install Pagelayer', 'popularfx')
		) ) );

		// Install Pagelayer if not installed already
		$wp_customize->add_setting('popularfx_pagelayer_show', array(
			'capability' => 'edit_theme_options',
			'type'       => 'hidden',
			'autoload'   => false,
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control('popularfx_pagelayer_show', array(
			'label'   => __('Install Pagelayer', 'popularfx'),
			'description' => 'test',
			'section' => 'popularfx_no_pagelayer',
			'type'    => 'hidden',
		) );
	}
	
	// Loads for the left panel
	wp_register_style('popularfx-customizer', get_template_directory_uri().'/customizer.css', POPULARFX_VERSION);
	wp_enqueue_style('popularfx-customizer');
	
	// Loads for the left pane
	wp_register_script('popularfx-customizer-controls', get_template_directory_uri().'/js/customizer-controls.js', array(), POPULARFX_VERSION, true);
	
	// Add custom Controls
	require_once dirname( __FILE__ ) . '/customizer-controls.php';
	
	$pages = '';
	$templates = '';
	$html = '';	
	
	//---------------------------------
	// Edit Header Footer Pages option
	//---------------------------------
	
	$theme = wp_get_theme();

	$template = popularfx_get_template_name();
	
	// If there is a template in use
	if(!empty($template) && defined('PAGELAYER_VERSION')){
		
		$wp_customize->add_section( 'popularfx_edit_links', array(
			'capability' => 'edit_theme_options',
			'priority'   => 1,
			'title'      => __( 'Header, Footer, Templates, Pages', 'popularfx' )
		) );
		 
		// Get list of pages and pagelayer templates to edit
		$args = array(
			'post_type' => ['page', 'pagelayer-template'],
			'posts_per_page' => -1,
			'meta_query' => array(
				array(
					'key' => 'pagelayer_imported_content',
					'value' => $template,
					'compare' => '='
				)
			)
		);
		
		$query = new WP_Query($args);

		foreach($query->posts as $k => $v){
			$a = '<a href="'.pagelayer_livelink($v->ID).'" class="popularfx-edit-link" target="_blank">'.$v->post_title.'</a>';
			
			if($v->post_type == 'page'){
				$pages .= $a;
			}else{
				
				$temp_type = get_post_meta( $v->ID, 'pagelayer_template_type', true );
				
				if(in_array($temp_type, ['header', 'footer'])){
					$html .= $a;
				}else{
					$templates .= $a;
				}
				
			}
		}
		
		$pages .= '<p>'.__('<b>Note:</b> The Pagelayer editor will open to edit these pages', 'popularfx').'</p>';
	
		// Theme Header Footer Edit option of Pagelayer
		$wp_customize->add_setting('popularfx_hf', array(
			'capability' => 'edit_theme_options',
			'type'       => 'hidden',
			'autoload'   => false,
			'transport' => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
		) );	

		$wp_customize->add_control('popularfx_hf', array(
			'label'   => __('Edit Header / Footer', 'popularfx'),
			'description' => $html,
			'section' => 'popularfx_edit_links',
			'type'    => 'hidden',
		) );
		
		if(!empty($templates)){
		
			// Template edit options of Pagelayer
			$wp_customize->add_setting('popularfx_tem