<?php
/**
 * The template part for displaying related posts.
 *
 * @package Ef Practical
 */

global $post;

$numbers_related = absint( get_theme_mod( 'practical_numbers_related_post', 4 ) );
$column_related  = get_theme_mod( 'practical_columns_related_post', 'col-md-6' );

$orderby_post = 'rand';
if ( get_theme_mod( 'practical_related_orderby' ) && 'rand' != get_theme_mod( 'practical_related_orderby' ) ):
	$orderby_post = get_theme_mod( 'practical_related_orderby' );
endif;

$categories = get_the_category( get_the_ID() );

if ( 'tags' == get_theme_mod( 'practical_related_by' ) ):
	$categories = wp_get_post_terms( get_the_ID(), 'post_tag', array( 'fields' => 'ids' ) );
endif;

if ( $categories ) {
	if ( 'tags' == get_theme_mod( 'practical_related_by' ) ) {
		$args = array(
			'post_type'           => 'post',
			'ignore_sticky_posts' => 1,
			'posts_per_page'      => $numbers_related,
			'tax_query'           => array(
				array(
					'taxonomy' => 'post_tag',
					'terms'    => $categories
				),
			),
			'post__not_in'        => array( get_the_ID() ),
			'orderby'             => $orderby_post
		);
	} else {
		$category_ids = array();
		foreach ( $categories as $individual_category ) {
			$term_related = $individual_category->term_id;
            $category_ids[] = $term_related;
		}
        
		$args = array(
			'category__in'        => $category_ids,
			'post__not_in'        => array( get_the_ID() ),
			'posts_per_page'      => $numbers_related,
			'ignore_sticky_posts' => 1,
			'orderby'             => $orderby_post
		);
	}
    
	$my_query = new wp_query( $args );
    
	if ( $my_query->have_posts() ) { ?>
        
		<div class="related-posts cf">
            
            <div class="row no-gutters">
            
            <?php
                $related_post_title = get_theme_mod( 'practical_related_posts_title', esc_html__( 'You make also like', 'ef-practical' ) );
                if ( '' != $related_post_title ) echo '<h3 class="related-posts-title col-12">' . esc_html( $related_post_title ) . '</h3>';
            ?>
            
            <?php while ( $my_query->have_posts() ) : $my_query->the_post(); ?>
                
                <div class="<?php echo esc_attr( $column_related ); ?>">
                    
                    <div class="related-posts-item cf">
                        <a href="<?php the_permalink(); ?>">
                            <?php if ( ( function_exists( 'has_post_thumbnail' ) ) && ( has_post_thumbnail() ) ) : ?>
                                <div class="related-item-thumb">
                                    <?php the_post_thumbnail( 'full' ); ?>
                                </div>
                            <?php endif; ?>
                            <div class="related-item-content">
                                <h4 class="related-item-title"><?php the_title(); ?></h4>
                                <?php if ( 0 == get_theme_mod( 'practical_date_related_posts', 0 ) ) : ?>
                                    <span class="related-date"><?php the_time( get_option( 'date_format' ) ); ?></span>
                                <?php endif; ?>
                            </div>
                        </a>
                    </div>
                    
                </div>
                
            <?php
            endwhile;
            
        echo '</div></div>';
	}
}
wp_reset_postdata();
?>