<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package Ef Practical
 */

$posts_display = get_theme_mod( 'practical_search_results_display_posts', 'list' );
$col_number    = absint( get_theme_mod( 'practical_search_results_columns', 2 ) );

get_header(); ?>

<div id="content" class="site-content cf">
    
    <?php
        if ( '' != get_the_archive_title() && 1 == get_theme_mod( 'practical_header_title_bar', 1 ) ) :
            get_template_part( '/template-parts/title-bar' );
        endif;
    ?>
    
    <div class="ef-container">
        <div class="row">
            
            <div id="primary" class="content-area col-md-9 order-md-2">
                <main id="main" class="site-main" role="main">
                    
                    <?php if ( have_posts() ) : ?>
                        
                        <?php if ( 0 != get_theme_mod( 'practical_search_page_title', 0 ) ) : ?>
                            <header class="page-header">
                                <h1 class="page-title"><?php echo get_the_archive_title(); /* WPCS: xss ok. */ ?></h1>
                            </header>
                        <?php endif; ?>
                        
                        <?php if ( 'grid' == $posts_display ) : ?>
                            
                            <div class="grid-posts">
                                <?php while ( have_posts() ) : the_post(); ?>
                                    <div class="ef-col-<?php echo esc_attr( $col_number ); ?> wow fadeInUp">
                                        <?php get_template_part( 'template-parts/content', 'search' ); ?>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                            
                        <?php else: ?>
                            
                            <?php while ( have_posts() ) : the_post(); ?>
                                <?php get_template_part( 'template-parts/content', 'search' ); ?>
                            <?php endwhile; ?>
                            
                        <?php endif; ?>
                        
                        <?php
                            if ( 'pagination' == get_theme_mod( 'practical_paged_type', 'pagination' ) ) :
                                the_posts_pagination(); // WPCS: xss ok. 
                            else :
                                practical_posts_navigation();
                            endif;
                        ?>
                        
                    <?php else: ?>
                        
                        <?php get_template_part( 'template-parts/content', 'none' ); ?>
                        
                    <?php endif; ?>
                    
                </main><!-- #main -->
            </div><!-- #primary -->
            
            <?php practical_sidebar(); ?>
            
        </div>
    </div>
</div><!-- #content -->

<?php get_footer(); ?>