<?php
/**
 * The template for displaying all pages.
 * This is the template that displays all pages by default.
 *
 * @package Ef Practical
 */

get_header(); ?>

<div id="content" class="site-content cf">
    
    <?php
        $title_bar = get_post_meta( $post->ID, 'practical-title-bar', true );
        if ( ! $title_bar) { $title_bar = 'default'; }
        if ( $title_bar == 'default' ) :
            if ( '' != get_the_archive_title() && 1 == get_theme_mod( 'practical_header_title_bar', 1 ) ) :
                get_template_part( '/template-parts/title-bar' );
            endif;
        elseif ( $title_bar == 'show' ) :
            get_template_part( '/template-parts/title-bar' );
        endif;
    ?>
    
    <div class="ef-container">
        <div class="row">
            
            <div id="primary" class="content-area col-md-9 order-md-2">
                <main id="main" class="site-main" role="main">
                    
                    <?php while ( have_posts() ) : the_post(); ?>
                        
                        <?php get_template_part( 'template-parts/content', 'page' ); ?>
                        
                        <?php
                            if ( 0 != get_theme_mod( 'practical_page_comments', 0 ) && ( comments_open() || get_comments_number() ) ) :
                                comments_template( '', true );
                            endif;
                        ?>
                        
                    <?php endwhile; ?>
                    
                </main><!-- #main -->
            </div><!-- #primary -->
            
            <?php practical_sidebar(); ?>
            
        </div>
    </div>
</div><!-- #content -->

<?php get_footer(); ?>