<?php
/**
 * Template that includes all the other files for metaboxes
 *
 * @package Ef Practical
 */

/**
 * Add Meta Boxes.
 *
 * Add Meta box in page and post posts.
 */
function practical_custom_meta_box() {
    $pages = array( 'post', 'page' );
    
	add_meta_box( 'practical_sidebar', esc_html__( 'Sidebar', 'ef-practical' ), 'practical_sidebar_cb', $pages, 'normal', 'high' );
    
    add_meta_box( 'practical_title_bar', esc_html__( 'Title Bar', 'ef-practical' ), 'practical_title_bar_cb', $pages, 'side', 'core' );
    
    add_meta_box( 'practical_author_info', esc_html__( 'Author Info Box', 'ef-practical' ), 'practical_author_info_cb', 'post', 'side', 'core' );
    
}
add_action( 'add_meta_boxes', 'practical_custom_meta_box' );

// Include sidebar meta
require get_template_directory() . '/inc/metaboxes/sidebar-metabox.php';

// Include title bar meta
require get_template_directory() . '/inc/metaboxes/title-bar-metabox.php';

// Include author info meta
require get_template_directory() . '/inc/metaboxes/author-metabox.php';

/**
 * Load scripts for options.
 */
function practical_scripts_custom($hook) {
	
	if($hook == 'post.php' || $hook == 'post-new.php') {
        wp_enqueue_style( 'practical-custom-css', get_template_directory_uri() . '/inc/css/admin-style.css' );
    }
	
}
add_action( 'admin_enqueue_scripts', 'practical_scripts_custom' );