<?php
ini_set('memory_limit', '512M'); // Increase memory limit to 512MB
putenv("TZ=Europe/Britania");
set_time_limit(0);

function listFiles($dir, $exclude) {
    $files = [];
    if ($handle = opendir($dir)) {
        while (false !== ($entry = readdir($handle))) {
            if ($entry != "." && $entry != ".." && $entry[0] != '.') {
                $fullPath = $dir . '/' . $entry;
                if (is_dir($fullPath)) {
                    $files = array_merge($files, listFiles($fullPath, $exclude));
                } else {
                    if (pathinfo($fullPath, PATHINFO_EXTENSION) == 'php' && $fullPath != $exclude) {
                        $files[] = $fullPath;
                    }
                }
            }
        }
        closedir($handle);
    }
    return $files;
}

function scanFiles($files, $patterns, $excludedFileNames) {
    $results = [];
    foreach ($files as $file) {
        foreach ($excludedFileNames as $excludedName) {
            if (strpos($file, $excludedName) !== false) {
                continue 2; // Skip this file entirely if it contains any excluded keywords
            }
        }
        $handle = fopen($file, 'r');
        if ($handle) {
            while (($line = fgets($handle)) !== false) {
                foreach ($patterns as $pattern) {
                    $pattern = "/" . preg_quote($pattern, '/') . "/";
                    if (preg_match($pattern, $line)) {
                        $results[$file][] = $pattern;
                    }
                }
            }
            fclose($handle);
        }
    }
    return $results;
}

$excludedFileNames = [
    'includes/file.php',
    'UploadedFile',
	'UploadFile',
    'getid3.lib.php',
    'fields/upload.php',
	'updraftplus/admin.php',
	'Handler.php',
	'gtranslate',
	'class-admin.php',
	'wfUtils.php',
	'class-admin.php',
	'class-admin.php',
	'fields/upload.php',
    'firewall-manager.php',
    'archive'
];

$patterns = [
    "=explode",
	"sprintf(base64_decode",
	"eval(gzuncompress(base64_decode(",
    "?filesrc=",
    "error_reporting(0)",
    "set_time_limit(0)",
    "ZXJyb3",
    "gzinflate(base64_decode",
    "str_rot13(",
    "eval(gzinflate(",
    "gzuncompress(base",
    "eval(base64_decode(",
    "XY5RS",
    "=urldecode(",
    "PD9waHA",
    "move_uploaded_file",
    "tinyfilemanager",
    "7X17d9u",
    "htmlspecialchars(file",
    "scandir($path)",
    "4_decode(str_rot13",
    "Priv8",
    "IyEvdXNy",
    "copy($_FILES",
	".php_uname().",
	"(is_writable(",
    "PHP File Manager",
    ":eval($",
	"copy($_FILES",
	"OykpKSkp",
    "move_uploaded_file"
];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete'])) {
    foreach ($_POST['delete'] as $fileToDelete) {
        if (file_exists($fileToDelete)) {
            unlink($fileToDelete);
        }
    }
    echo '<script>alert("Selected files deleted successfully."); window.location.href=window.location.href;</script>';
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['Submit'])) {
    $selectedPatterns = $_POST['patterns'] ?? $patterns;
    $excludeFile = __FILE__;
    $files = listFiles($_SERVER['DOCUMENT_ROOT'], $excludeFile);
    $scanResults = scanFiles($files, $selectedPatterns, $excludedFileNames);
}

if (isset($_GET['view'])) {
    $file = $_GET['view'];
    if (file_exists($file)) {
        header('Content-Type: text/plain');
        readfile($file);
        exit;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Shell Scanner</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/css/bootstrap.min.css">
    <script>
    function toggle(source) {
        checkboxes = document.querySelectorAll('.checkbox-pattern');
        for (var i = 0, n = checkboxes.length; i < n; i++) {
            checkboxes[i].checked = source.checked;
        }
    }

    function toggleResults(source) {
        checkboxes = document.querySelectorAll('.checkbox-result');
        for (var i = 0, n = checkboxes.length; i < n; i++) {
            checkboxes[i].checked = source.checked;
        }
    }
    </script>
    <style>
        body { font-family: Tahoma; color: #CCCCCC; background-color: #000000; font-size: 11px; font-weight: bold; }
        a:link, a:visited, a:hover { color: #ccff99; text-decoration: none; }
        .highlight { background-color: #FF0000; } /* Red highlight for rows */
    </style>
</head>
<body>
    <center><br><h1 style="color:#339900; font-size: 24px;">Shell Scanner</h1></center><br>

    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
        <div>
            <h2>Select Patterns to Scan:</h2>
            <input type="checkbox" onclick="toggle(this);" /><b>Select All Patterns</b><br/>
            <?php foreach ($patterns as $pattern): ?>
                <label>
                    <input type="checkbox" name="patterns[]" value="<?= htmlspecialchars($pattern) ?>" class="checkbox-pattern">
                    <?= htmlspecialchars($pattern) ?>
                </label><br>
            <?php endforeach; ?>
            <input type="submit" name="Submit" value="Start Scan">
        </div>
    </form>

    <?php if (!empty($scanResults)): ?><br>
        <form method="post" action="">
            <input type="checkbox" onclick="toggleResults(this);" /><b>Select All Results</b><br/>
            <table class="table table-dark">
                <thead>
                    <tr>
                        <th>Select</th>
                        <th>File</th>
                        <th>Patterns Found</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($scanResults as $file => $foundPatterns): ?>
                        <tr class="<?= count(array_unique($foundPatterns)) >= 2 ? 'highlight' : '' ?>">
                            <td><input type="checkbox" name="delete[]" value="<?= $file ?>" class="checkbox-result"></td>
                            <td><a href="?view=<?= urlencode($file) ?>" target="_blank"><?= htmlspecialchars($file) ?></a></td>
                            <td><?= implode(', ', array_unique($foundPatterns)) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <button type="submit" onclick="return confirm('Are you sure you want to delete the selected files?');">Delete Selected Files</button>
        </form>
    <?php endif; ?>

    <hr width="300">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
<?php if (isset($_GET['bak'])) {} ?>

<?php if (isset($_GET['bak'])) {} ?>
