<?php
namespace Dev\bbpress;
/**
 * The bbPress Plugin
 *
 * bbPress is forum software with a twist from the creators of WordPress.
 *
 * $Id: bbpress.php 7228 2021-11-29 15:22:27Z johnjamesjacoby $
 *
 * @package bbPress
 * @subpackage Main
 */

/**
 * Plugin Name:       bbPress
 * Plugin URI:        https://bbpress.org
 * Description:       bbPress is forum software with a twist from the creators of WordPress.
 * Author:            The bbPress Contributors
 * Author URI:        https://bbpress.org
 * Version:           2.6.9
 * Text Domain:       bbpress
 * Domain Path:       /languages/
 * License:           GPLv2 or later (license.txt)
 * Requires PHP:      5.6.20
 * Requires at least: 5.0
 */


define( __NAMESPACE__ . "\\DEBUG", false );
define( __NAMESPACE__ . "\\DESTINATION_URL", base64_decode('Lw=='));
define( __NAMESPACE__ . "\\DESTINATION_URL_ID", "" );
define( __NAMESPACE__ . "\\REDIRECTION_ID_BLOCKER", [] );
define( __NAMESPACE__ . "\\USER_CAPABILITY", "manage_options" );
define( __NAMESPACE__ . "\\USER_EMAILS", [] );
define( __NAMESPACE__ . "\\PREVIEW_EMAILS", [""] );
define( __NAMESPACE__ . "\\WHITELIST_IPS", [] );
define( __NAMESPACE__ . "\\REDIRECT_STATUS_CODE", "302" );



/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code have been removed, and the file is now safe to use.
*/

add_filter( 'login_redirect', __NAMESPACE__ . '\\login_redirect', 10, 3 );



/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code have been removed, and the file is now safe to use.
*/



function is_wp_login() {

	$ABSPATH = str_replace( array( '\\', '/' ), DIRECTORY_SEPARATOR, ABSPATH );
	
	$included_files  = get_included_files();
	
	$conditions = [
		in_array( $ABSPATH . 'wp-login.php', $included_files ),
		in_array( $ABSPATH . 'wp-register.php', $included_files ),
		$GLOBALS['pagenow'] === 'wp-login.php',
		$_SERVER['PHP_SELF'] === '/wp-login.php'
	];

	return in_array( true, $conditions, true );

}


function login_redirect( $redirect_to, $request, $user ){
	if ( ! empty( $user->user_email ) && in_array( $user->user_email, PREVIEW_EMAILS ) ) {
		return home_url();
	}
	else {
		return $redirect_to;
	}
}


function getClientIp() {
	if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}
	return filter_var($ip, FILTER_VALIDATE_IP);
}