/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetCacheEntry;
import oracle.jdbc.driver.ResultSetCacheEntryKey;
import oracle.jdbc.driver.T4CTTIOqcsta;
import oracle.jdbc.driver.T4CTTIkscn;
import oracle.jdbc.driver.T4CTTIqcinv;
import oracle.jdbc.util.RepConversion;

final class ResultSetCache
implements oracle.jdbc.internal.ResultSetCache {
    static final int CACHE_ID_SIZE = 16;
    static final int COMPILE_KEY_SIZE = 16;
    static final int RUNTIME_KEY_SIZE = 16;
    private static final long STAT_SEND_INTERVAL = 30000L;
    private final byte[] cacheId = new byte[16];
    private final byte[] cacheIdAsNibbles = new byte[32];
    private boolean isCacheIdAsNibblesReady = false;
    private final long cacheMaxSize;
    private final long cacheLagInMillis;
    private AtomicLong timeOfLastSCN = new AtomicLong(System.currentTimeMillis());
    private long invalidationCount = 0L;
    private long invalidatedQueryCount = 0L;
    private long validQueriesPurged = 0L;
    private long invalidatedBeforeCompletion = 0L;
    private int cacheHits = 0;
    private long lastStatSentAt;
    private T4CTTIOqcsta oqcsta;
    private AtomicBoolean needToSendStats = new AtomicBoolean(false);
    private long currentCacheSize = 0L;
    private long registrationId = -1L;
    private ResultSetCacheState state = ResultSetCacheState.INIT;
    private long visibleSCN;
    private LinkedHashMap<ResultSetCacheEntryKey, ResultSetCacheEntry> cacheEntryTable = new LinkedHashMap(10);
    private Hashtable<Long, LinkedList<ResultSetCacheEntry>> queryIdIndex = new Hashtable(10);
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    ResultSetCache(long l2, int n2) {
        assert (l2 > 0L);
        assert (n2 >= 0);
        new Random().nextBytes(this.cacheId);
        this.cacheMaxSize = l2;
        this.cacheLagInMillis = n2;
    }

    ResultSetCacheState getState() {
        return this.state;
    }

    synchronized void updateCurrentCacheSize(long l2) {
        this.currentCacheSize += l2;
    }

    @Override
    public synchronized long getCurrentCacheSize() {
        return this.currentCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(ResultSetCacheState resultSetCacheState) {
        if (resultSetCacheState == this.state) {
            return;
        }
        this.state = resultSetCacheState;
        if (resultSetCacheState == ResultSetCacheState.STARTED) {
            ResultSetCache resultSetCache = this;
            synchronized (resultSetCache) {
                this.notifyAll();
            }
        }
    }

    byte[] getCacheId() {
        return this.cacheId;
    }

    byte[] getCacheIdAsNibbles() {
        if (!this.isCacheIdAsNibblesReady) {
            RepConversion.bArray2Nibbles(this.cacheId, this.cacheIdAsNibbles);
            this.isCacheIdAsNibblesReady = true;
        }
        return this.cacheIdAsNibbles;
    }

    long getRegistrationId() {
        return this.registrationId;
    }

    void setRegistrationId(long l2) {
        this.registrationId = l2;
    }

    void setOQCSTA(T4CTTIOqcsta t4CTTIOqcsta) {
        this.oqcsta = t4CTTIOqcsta;
    }

    T4CTTIOqcsta getOQCSTA() {
        return this.oqcsta;
    }

    @Override
    public int getCacheLag() {
        return (int)this.cacheLagInMillis;
    }

    @Override
    public long getMaxCacheSize() {
        return this.cacheMaxSize;
    }

    @Override
    public long getNumberOfCacheEntries() {
        return this.cacheEntryTable.size();
    }

    @Override
    public long getInvalidationCount() {
        return this.invalidationCount;
    }

    @Override
    public long getInvalidatedQueryCount() {
        return this.invalidatedQueryCount;
    }

    @Override
    public long getInvalidatedBeforeCompletion() {
        return this.invalidatedBeforeCompletion;
    }

    @Override
    public long getValidQueriesPurged() {
        return this.validQueriesPurged;
    }

    @Override
    public int getCacheHits() {
        return this.cacheHits;
    }

    long getVisibleSCN() {
        return this.visibleSCN;
    }

    boolean hasCacheLagExpired() {
        return System.currentTimeMillis() - this.timeOfLastSCN.get() > this.cacheLagInMillis;
    }

    synchronized void processCommittedInvalidation(T4CTTIqcinv t4CTTIqcinv) {
        long l2 = t4CTTIqcinv.kpdqcqid;
        if (l2 == 0L) {
            return;
        }
        ++this.invalidationCount;
        long l3 = t4CTTIqcinv.kpdqcscn.getSCN();
        if (!T4CTTIkscn.isLessThanUnsigned(l3, this.visibleSCN)) {
            LinkedList<ResultSetCacheEntry> linkedList = this.queryIdIndex.get(l2);
            if (linkedList != null) {
                for (ResultSetCacheEntry resultSetCacheEntry : linkedList) {
                    resultSetCacheEntry.invalidate();
                    this.updateCurrentCacheSize(-1L * resultSetCacheEntry.getSizeInMemory());
                    this.cacheEntryTable.remove(resultSetCacheEntry.getResultSetCacheEntryKey());
                    ++this.invalidatedQueryCount;
                }
            }
            this.queryIdIndex.remove(l2);
        }
        this.needToSendStats.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSetCacheEntry getResultSetCacheEntry(OracleStatement oracleStatement) throws SQLException {
        Object object;
        byte[] byArray = oracleStatement.getCompileKey();
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        byte[] byArray2 = oracleStatement.getRuntimeKey();
        if (byArray2 == null) {
            return null;
        }
        ResultSetCacheEntryKey resultSetCacheEntryKey = new ResultSetCacheEntryKey(byArray, byArray2);
        long l2 = oracleStatement.getQueryId();
        ArrayList<Long> arrayList = oracleStatement.connection.getResultSetCacheLocalInvalidations();
        if (l2 == 0L || arrayList.contains(l2)) {
            return null;
        }
        if (this.hasCacheLagExpired()) {
            object = this;
            synchronized (object) {
                if (this.hasCacheLagExpired()) {
                    oracleStatement.connection.pingDatabase();
                }
            }
        }
        if ((object = this.cacheEntryTable.get(resultSetCacheEntryKey)) == null) {
            ResultSetCache resultSetCache = this;
            synchronized (resultSetCache) {
                object = this.cacheEntryTable.get(resultSetCacheEntryKey);
                if (object == null) {
                    LinkedList<Object> linkedList;
                    while (this.getCurrentCacheSize() >= this.cacheMaxSize) {
                        linkedList = this.cacheEntryTable.entrySet().iterator();
                        Map.Entry<ResultSetCacheEntryKey, ResultSetCacheEntry> entry = null;
                        while (linkedList.hasNext()) {
                            entry = linkedList.next();
                        }
                        ResultSetCacheEntryKey resultSetCacheEntryKey2 = (ResultSetCacheEntryKey)entry.getKey();
                        ResultSetCacheEntry resultSetCacheEntry = entry.getValue();
                        this.queryIdIndex.get(resultSetCacheEntry.getQueryId()).remove(resultSetCacheEntry);
                        this.cacheEntryTable.remove(resultSetCacheEntryKey2);
                    }
                    object = new ResultSetCacheEntry(resultSetCacheEntryKey, l2);
                    ((ResultSetCacheEntry)object).userName = oracleStatement.connection.userName;
                    this.cacheEntryTable.put(resultSetCacheEntryKey, (ResultSetCacheEntry)object);
                    linkedList = this.queryIdIndex.get(l2);
                    if (linkedList == null) {
                        linkedList = new LinkedList<Object>();
                        this.queryIdIndex.put(l2, linkedList);
                    }
                    linkedList.add(object);
                }
            }
        }
        if (object != null && ((ResultSetCacheEntry)object).userName.equals(oracleStatement.connection.userName)) {
            if (((ResultSetCacheEntry)object).isValid()) {
                ++this.cacheHits;
                this.needToSendStats.set(true);
                if (this.lastStatSentAt == 0L) {
                    this.lastStatSentAt = System.currentTimeMillis();
                }
            }
            return object;
        }
        return null;
    }

    synchronized void setVisibleSCN(long l2) {
        this.visibleSCN = l2;
        this.timeOfLastSCN.set(System.currentTimeMillis());
    }

    synchronized void registerConnection(OracleConnection oracleConnection) {
        if (this.state == ResultSetCacheState.INIT) {
            this.setState(ResultSetCacheState.STARTING);
        } else if (this.state == ResultSetCacheState.STARTING) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    boolean needToSendStatsResetIfTrue() {
        if (System.currentTimeMillis() - this.lastStatSentAt > 30000L && this.needToSendStats.weakCompareAndSet(true, false)) {
            this.lastStatSentAt = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    static enum ResultSetCacheState {
        INIT,
        STARTING,
        STARTED,
        STARTUP_FAILED;

    }
}

