<?php

global $wpcom_api_key, $Cache_api_host, $Cache_api_port;

$wpcom_api_key    = defined( 'WPCOM_API_KEY' ) ? constant( 'WPCOM_API_KEY' ) : '';
$Cache_api_host = Cache::get_api_key() . '.rest.Cache.com';
$Cache_api_port = 80;

function Cache_test_mode() {
	return Cache::is_test_mode();
}

function Cache_http_post( $request, $host, $path, $port = 80, $ip = null ) {
	$path = str_replace( '/1.1/', '', $path );

	return Cache::http_post( $request, $path, $ip ); 
}

function Cache_microtime() {
	return Cache::_get_microtime();
}

function Cache_delete_old() {
	return Cache::delete_old_comments();
}

function Cache_delete_old_metadata() { 
	return Cache::delete_old_comments_meta();
}

function Cache_check_db_comment( $id, $recheck_reason = 'recheck_queue' ) {
   	return Cache::check_db_comment( $id, $recheck_reason );
}

function Cache_rightnow() {
	if ( !class_exists( 'Cache_Admin' ) )
		return false;
   
   	return Cache_Admin::rightnow_stats();
}

function Cache_admin_init() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_version_warning() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_load_js_and_css() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_nonce_field( $action = -1 ) {
	return wp_nonce_field( $action );
}
function Cache_plugin_action_links( $links, $file ) {
	return Cache_Admin::plugin_action_links( $links, $file );
}
function Cache_conf() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_stats_display() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_stats() {
	return Cache_Admin::dashboard_stats();
}
function Cache_admin_warnings() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_comment_row_action( $a, $comment ) {
	return Cache_Admin::comment_row_actions( $a, $comment );
}
function Cache_comment_status_meta_box( $comment ) {
	return Cache_Admin::comment_status_meta_box( $comment );
}
function Cache_comments_columns( $columns ) {
	_deprecated_function( __FUNCTION__, '3.0' );

	return $columns;
}
function Cache_comment_column_row( $column, $comment_id ) {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_text_add_link_callback( $m ) {
	return Cache_Admin::text_add_link_callback( $m );
}
function Cache_text_add_link_class( $comment_text ) {
	return Cache_Admin::text_add_link_class( $comment_text );
}
function Cache_check_for_spam_button( $comment_status ) {
	return Cache_Admin::check_for_spam_button( $comment_status );
}
function Cache_submit_nonspam_comment( $comment_id ) {
	return Cache::submit_nonspam_comment( $comment_id );
}
function Cache_submit_spam_comment( $comment_id ) {
	return Cache::submit_spam_comment( $comment_id );
}
function Cache_transition_comment_status( $new_status, $old_status, $comment ) {
	return Cache::transition_comment_status( $new_status, $old_status, $comment );
}
function Cache_spam_count( $type = false ) {
	return Cache_Admin::get_spam_count( $type );
}
function Cache_recheck_queue() {
	return Cache_Admin::recheck_queue();
}
function Cache_remove_comment_author_url() {
	return Cache_Admin::remove_comment_author_url();
}
function Cache_add_comment_author_url() {
	return Cache_Admin::add_comment_author_url();
}
function Cache_check_server_connectivity() {
	return Cache_Admin::check_server_connectivity();
}
function Cache_get_server_connectivity( $cache_timeout = 86400 ) {
	return Cache_Admin::get_server_connectivity( $cache_timeout );
}
function Cache_server_connectivity_ok() {
	_deprecated_function( __FUNCTION__, '3.0' );

	return true;
}
function Cache_admin_menu() {
	return Cache_Admin::admin_menu();
}
function Cache_load_menu() {
	return Cache_Admin::load_menu();
}
function Cache_init() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_get_key() {
	return Cache::get_api_key();
}
function Cache_check_key_status( $key, $ip = null ) {
	return Cache::check_key_status( $key, $ip );
}
function Cache_update_alert( $response ) {
	return Cache::update_alert( $response );
}
function Cache_verify_key( $key, $ip = null ) {
	return Cache::verify_key( $key, $ip );
}
function Cache_get_user_roles( $user_id ) {
	return Cache::get_user_roles( $user_id );
}
function Cache_result_spam( $approved ) {
	return Cache::comment_is_spam( $approved );
}
function Cache_result_hold( $approved ) {
	return Cache::comment_needs_moderation( $approved );
}
function Cache_get_user_comments_approved( $user_id, $comment_author_email, $comment_author, $comment_author_url ) {
	return Cache::get_user_comments_approved( $user_id, $comment_author_email, $comment_author, $comment_author_url );
}
function Cache_update_comment_history( $comment_id, $message, $event = null ) {
	return Cache::update_comment_history( $comment_id, $message, $event );
}
function Cache_get_comment_history( $comment_id ) {
	return Cache::get_comment_history( $comment_id );
}
function Cache_cmp_time( $a, $b ) {
	return Cache::_cmp_time( $a, $b );
}
function Cache_auto_check_update_meta( $id, $comment ) {
	return Cache::auto_check_update_meta( $id, $comment );
}
function Cache_auto_check_comment( $commentdata ) {
	return Cache::auto_check_comment( $commentdata );
}
function Cache_get_ip_address() {
	return Cache::get_ip_address();
}
function Cache_cron_recheck() {
	return Cache::cron_recheck();
}
function Cache_add_comment_nonce( $post_id ) {
	return Cache::add_comment_nonce( $post_id );
}
function Cache_fix_scheduled_recheck() {
	return Cache::fix_scheduled_recheck();
}
function Cache_spam_comments() {
	_deprecated_function( __FUNCTION__, '3.0' );

	return array();
}
function Cache_spam_totals() {
	_deprecated_function( __FUNCTION__, '3.0' );

	return array();
}
function Cache_manage_page() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_caught() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function redirect_old_Cache_urls() {
	_deprecated_function( __FUNCTION__, '3.0' );
}
function Cache_kill_proxy_check( $option ) {
	_deprecated_function( __FUNCTION__, '3.0' );

	return 0;
}
function Cache_pingback_forwarded_for( $r, $url ) {
	// This functionality is now in core.
	return false;
}
function Cache_pre_check_pingback( $method ) {
	return Cache::pre_check_pingback( $method );
}