;
        var settings = self.settings;
        var textHtml = '', ariaPressed;
        image = settings.image;
        if (image) {
          icon = 'none';
          if (typeof image !== 'string') {
            image = domGlobals.window.getSelection ? image[0] : image[1];
          }
          image = ' style="background-image: url(\'' + image + '\')"';
        } else {
          image = '';
        }
        icon = settings.icon ? prefix + 'ico ' + prefix + 'i-' + icon : '';
        if (text) {
          self.classes.add('btn-has-text');
          textHtml = '<span class="' + prefix + 'txt">' + self.encode(text) + '</span>';
        }
        ariaPressed = typeof settings.active === 'boolean' ? ' aria-pressed="' + settings.active + '"' : '';
        return '<div id="' + id + '" class="' + self.classes + '" role="button"' + ariaPressed + ' tabindex="-1">' + '<button type="button" hidefocus="1" tabindex="-1">' + (icon ? '<i class="' + icon + '"' + image + '></i>' : '') + textHtml + '</button>' + '<button type="button" class="' + prefix + 'open" hidefocus="1" tabindex="-1">' + (self._menuBtnText ? (icon ? '\xA0' : '') + self._menuBtnText : '') + ' <i class="' + prefix + 'caret"></i>' + '</button>' + '</div>';
      },
      postRender: function () {
        var self = this, onClickHandler = self.settings.onclick;
        self.on('click', function (e) {
          var node = e.target;
          if (e.control === this) {
            while (node) {
              if (e.aria && e.aria.key !== 'down' || node.nodeName === 'BUTTON' && node.className.indexOf('open') === -1) {
                e.stopImmediatePropagation();
                if (onClickHandler) {
                  onClickHandler.call(this, e);
                }
                return;
              }
              node = node.parentNode;
            }
          }
        });
        delete self.settings.onclick;
        return self._super();
      }
    });

    var StackLayout = FlowLayout.extend({
      Defaults: {
        containerClass: 'stack-layout',
        controlClass: 'stack-layout-item',
        endClass: 'break'
      },
      isNative: function () {
        return true;
      }
    });

    var TabPanel = Panel.extend({
      Defaults: {
        layout: 'absolute',
        defaults: { type: 'panel' }
      },
      activateTab: function (idx) {
        var activeTabElm;
        if (this.activeTabId) {
          activeTabElm = this.getEl(this.activeTabId);
          global$7(activeTabElm).removeClass(this.classPrefix + 'active');
          activeTabElm.setAttribute('aria-selected', 'false');
        }
        this.activeTabId = 't' + idx;
        activeTabElm = this.getEl('t' + idx);
        activeTabElm.setAttribute('aria-selected', 'true');
        global$7(activeTabElm).addClass(this.classPrefix + 'active');
        this.items()[idx].show().fire('showtab');
        this.reflow();
        this.items().each(function (item, i) {
          if (idx !== i) {
            item.hide();
          }
        });
      },
      renderHtml: function () {
        var self = this;
        var layout = self._layout;
        var tabsHtml = '';
        var prefix = self.classPrefix;
        self.preRender();
        layout.preRender(self);
        self.items().each(function (ctrl, i) {
          var id = self._id + '-t' + i;
          ctrl.aria('role', 'tabpanel');
          ctrl.aria('labelledby', id);
          tabsHtml += '<div id="' + id + '" class="' + prefix + 'tab" ' + 'unselectable="on" role="tab" aria-controls="' + ctrl._id + '" aria-selected="false" tabIndex="-1">' + self.encode(ctrl.settings.title) + '</div>';
        });
        return '<div id="' + self._id + '" class="' + self.classes + '" hidefocus="1" tabindex="-1">' + '<div id="' + self._id + '-head" class="' + prefix + 'tabs" role="tablist">' + tabsHtml + '</div>' + '<div id="' + self._id + '-body" class="' + self.bodyClasses + '">' + layout.renderHtml(self) + '</div>' + '</div>';
      },
      postRender: function () {
        var self = this;
        self._super();
        self.settings.activeTab = self.settings.activeTab || 0;
        self.activateTab(self.settings.activeTab);
        this.on('click', function (e) {
          var targetParent = e.target.parentNode;
          if (targetParent && targetParent.id === self._id + '-head') {
            var i = targetParent.childNodes.length;
            while (i--) {
              if (targetParent.childNodes[i] === e.target) {
                self.activateTab(i);
              }
            }
          }
        });
      },
      initLayoutRect: function () {
        var self = this;
        var rect, minW, minH;
        minW = funcs.getSize(self.getEl('head')).width;
        minW = minW < 0 ? 0 : minW;
        minH = 0;
        self.items().each(function (item) {
          minW = Math.max(minW, item.layoutRect().minW);
          minH = Math.max(minH, item.layoutRect().minH);
        });
        self.items().each(function (ctrl) {
          ctrl.settings.x = 0;
          ctrl.settings.y = 0;
          ctrl.settings.w = minW;
          ctrl.settings.h = minH;
          ctrl.layoutRect({
            x: 0,
            y: 0,
            w: minW,
            h: minH
          });
        });
        var headH = funcs.getSize(self.getEl('head')).height;
        self.settings.minWidth = minW;
        self.settings.minHeight = minH + headH;
        rect = self._super();
        rect.deltaH += headH;
        rect.innerH = rect.h - rect.deltaH;
        return rect;
      }
    });

    var TextBox = Widget.extend({
      init: function (settings) {
        var self = this;
        self._super(settings);
        self.classes.add('textbox');
        if (settings.multiline) {
          self.classes.add('multiline');
        } else {
          self.on('keydown', function (e) {
            var rootControl;
            if (e.keyCode === 13) {
              e.preventDefault();
              self.parents().reverse().each(function (ctrl) {
                if (ctrl.toJSON) {
                  rootControl = ctrl;
                  return false;
                }
              });
              self.fire('submit', { data: rootControl.toJSON() });
            }
          });
          self.on('keyup', function (e) {
            self.state.set('value', e.target.value);
          });
        }
      },
      repaint: function () {
        var self = this;
        var style, rect, borderBox, borderW, borderH = 0, lastRepaintRect;
        style = self.getEl().style;
        rect = self._layoutRect;
        lastRepaintRect = self._lastRepaintRect || {};
        var doc = domGlobals.document;
        if (!self.settings.multiline && doc.all && (!doc.documentMode || doc.documentMode <= 8)) {
          style.lineHeight = rect.h - borderH + 'px';
        }
        borderBox = self.borderBox;
        borderW = borderBox.left + borderBox.right + 8;
        borderH = borderBox.top + borderBox.bottom + (self.settings.multiline ? 8 : 0);
        if (rect.x !== lastRepaintRect.x) {
          style.left = rect.x + 'px';
          lastRepaintRect.x = rect.x;
        }
        if (rect.y !== lastRepaintRect.y) {
          style.top = rect.y + 'px';
          lastRepaintRect.y = rect.y;
        }
        if (rect.w !== lastRepaintRect.w) {
          style.width = rect.w - borderW + 'px';
          lastRepaintRect.w = rect.w;
        }
        if (rect.h !== lastRepaintRect.h) {
          style.height = rect.h - borderH + 'px';
          lastRepaintRect.h = rect.h;
        }
        self._lastRepaintRect = lastRepaintRect;
        self.fire('repaint', {}, false);
        return self;
      },
      renderHtml: function () {
        var self = this;
        var settings = self.settings;
        var attrs, elm;
        attrs = {
          id: self._id,
          hidefocus: '1'
        };
        global$4.each([
          'rows',
          'spellcheck',
          'maxLength',
          'size',
          'readonly',
          'min',
          'max',
          'step',
          'list',
          'pattern',
          'placeholder',
          'required',
          'multiple'
        ], function (name) {
          attrs[name] = settings[name];
        });
        if (self.disabled()) {
          attrs.disabled = 'disabled';
        }
        if (settings.subtype) {
          attrs.type = settings.subtype;
        }
        elm = funcs.create(settings.multiline ? 'textarea' : 'input', attrs);
        elm.value = self.state.get('value');
        elm.className = self.classes.toString();
        return elm.outerHTML;
      },
      value: function (value) {
        if (arguments.length) {
          this.state.set('value', value);
          return this;
        }
        if (this.state.get('rendered')) {
          this.state.set('value', this.getEl().value);
        }
        return this.state.get('value');
      },
      postRender: function () {
        var self = this;
        self.getEl().value = self.state.get('value');
        self._super();
        self.$el.on('change', function (e) {
          self.state.set('value', e.target.value);
          self.fire('change', e);
        });
      },
      bindStates: function () {
        var self = this;
        self.state.on('change:value', function (e) {
          if (self.getEl().value !== e.value) {
            self.getEl().value = e.value;
          }
        });
        self.state.on('change:disabled', function (e) {
          self.getEl().disabled = e.value;
        });
        return self._super();
      },
      remove: function () {
        this.$el.off();
        this._super();
      }
    });

    var getApi = function () {
      return {
        Selector: Selector,
        Collection: Collection$2,
        ReflowQueue: ReflowQueue,
        Control: Control$1,
        Factory: global$b,
        KeyboardNavigation: KeyboardNavigation,
        Container: Container,
        DragHelper: DragHelper,
        Scrollable: Scrollable,
        Panel: Panel,
        Movable: Movable,
        Resizable: Resizable,
        FloatPanel: FloatPanel,
        Window: Window,
        MessageBox: MessageBox,
        Tooltip: Tooltip,
        Widget: Widget,
        Progress: Progress,
        Notification: Notification,
        Layout: Layout$1,
        AbsoluteLayout: AbsoluteLayout,
        Button: Button,
        ButtonGroup: ButtonGroup,
        Checkbox: Checkbox,
        ComboBox: ComboBox,
        ColorBox: ColorBox,
        PanelButton: PanelButton,
        ColorButton: ColorButton,
        ColorPicker: ColorPicker,
        Path: Path,
        ElementPath: ElementPath,
        FormItem: FormItem,
        Form: Form,
        FieldSet: FieldSet,
        FilePicker: FilePicker,
        FitLayout: FitLayout,
        FlexLayout: FlexLayout,
        FlowLayout: FlowLayout,
        FormatControls: FormatControls,
        GridLayout: GridLayout,
        Iframe: Iframe,
        InfoBox: InfoBox,
        Label: Label,
        Toolbar: Toolbar$1,
        MenuBar: MenuBar,
        MenuButton: MenuButton,
        MenuItem: MenuItem,
        Throbber: Throbber,
        Menu: Menu,
        ListBox: ListBox,
        Radio: Radio,
        ResizeHandle: ResizeHandle,
        SelectBox: SelectBox,
        Slider: Slider,
        Spacer: Spacer,
        SplitButton: SplitButton,
        StackLayout: StackLayout,
        TabPanel: TabPanel,
        TextBox: TextBox,
        DropZone: DropZone,
        BrowseButton: BrowseButton
      };
    };
    var appendTo = function (target) {
      if (target.ui) {
        global$4.each(getApi(), function (ref, key) {
          target.ui[key] = ref;
        });
      } else {
        target.ui = getApi();
      }
    };
    var registerToFactory = function () {
      global$4.each(getApi(), function (ref, key) {
        global$b.add(key, ref);
      });
    };
    var Api = {
      appendTo: appendTo,
      registerToFactory: registerToFactory
    };

    Api.registerToFactory();
    Api.appendTo(window.tinymce ? window.tinymce : {});
    global.add('inlite', function (editor) {
      var panel = create$3();
      FormatControls.setup(editor);
      Buttons.addToEditor(editor, panel);
      return ThemeApi.get(editor, panel);
    });
    function Theme () {
    }

    return Theme;

}(window));
})();
PK      ꤖ[@)# # "  tinymce/themes/inlite/theme.min.jsnu [        !function(_){"use strict";var u,t,e,n,i,r=tinymce.util.Tools.resolve("tinymce.ThemeManager"),h=tinymce.util.Tools.resolve("tinymce.Env"),v=tinymce.util.Tools.resolve("tinymce.dom.DOMUtils"),c=tinymce.util.Tools.resolve("tinymce.util.Delay"),o=function(t){return t.reduce(function(t,e){return Array.isArray(e)?t.concat(o(e)):t.concat(e)},[])},s={flatten:o},a=function(t,e){for(var n=0;n<e.length;n++){var i=(0,e[n])(t);if(i)return i}return null},l=function(t,e){return{id:t,rect:e}},d=function(t){return{x:t.left,y:t.top,w:t.width,h:t.height}},f=function(t){return{left:t.x,top:t.y,width:t.w,height:t.h,right:t.x+t.w,bottom:t.y+t.h}},m=function(t){var e=v.DOM.getViewPort();return{x:t.x+e.x,y:t.y+e.y,w:t.w,h:t.h}},g=function(t){var e=t.getBoundingClientRect();return m({x:e.left,y:e.top,w:Math.max(t.clientWidth,t.offsetWidth),h:Math.max(t.clientHeight,t.offsetHeight)})},p=function(t,e){return g(e)},b=function(t){return g(t.getContentAreaContainer()||t.getBody())},y=function(t){var e=t.selection.getBoundingClientRect();return e?m(d(e)):null},x=function(n,i){return function(t){for(var e=0;e<i.length;e++)if(i[e].predicate(n))return l(i[e].id,p(t,n));return null}},w=function(i,r){return function(t){for(var e=0;e<i.length;e++)for(var n=0;n<r.length;n++)if(r[n].predicate(i[e]))return l(r[n].id,p(t,i[e]));return null}},R=tinymce.util.Tools.resolve("tinymce.util.Tools"),C=function(t,e){return{id:t,predicate:e}},k=function(t){return R.map(t,function(t){return C(t.id,t.predicate)})},E=function(e){return function(t){return t.selection.isCollapsed()?null:l(e,y(t))}},H=function(i,r){return function(t){var e,n=t.schema.getTextBlockElements();for(e=0;e<i.length;e++)if("TABLE"===i[e].nodeName)return null;for(e=0;e<i.length;e++)if(i[e].nodeName in n)return t.dom.isEmpty(i[e])?l(r,y(t)):null;return null}},T=function(t){t.fire("SkinLoaded")},S=function(t){return t.fire("BeforeRenderUI")},M=tinymce.util.Tools.resolve("tinymce.EditorManager"),N=function(e){return function(t){return typeof t===e}},O=function(t){return Array.isArray(t)},W=function(t){return N("string")(t)},P=function(t){return N("number")(t)},D=function(t){return N("boolean")(t)},A=function(t){return N("function")(t)},B=(N("object"),O),L=function(t,e){if(e(t))return!0;throw new Error("Default value doesn't match requested type.")},I=function(r){return function(t,e,n){var i=t.settings;return L(n,r),e in i&&r(i[e])?i[e]:n}},z={getStringOr:I(W),getBoolOr:I(D),getNumberOr:I(P),getHandlerOr:I(A),getToolbarItemsOr:(u=B,function(t,e,n){var i,r,o,s,a,l=e in t.settings?t.settings[e]:n;return L(n,u),r=n,B(i=l)?i:W(i)?"string"==typeof(s=i)?(a=/[ ,]/,s.split(a).filter(function(t){return 0<t.length})):s:D(i)?(o=r,!1===i?[]:o):r})},F=tinymce.util.Tools.resolve("tinymce.geom.Rect"),U=function(t,e){return{rect:t,position:e}},V=function(t,e){return{x:e.x,y:e.y,w:t.w,h:t.h}},q=function(t,e,n,i,r){var o,s,a,l={x:i.x,y:i.y,w:i.w+(i.w<r.w+n.w?r.w:0),h:i.h+(i.h<r.h+n.h?r.h:0)};return o=F.findBestRelativePosition(r,n,l,t),n=F.clamp(n,l),o?(s=F.relativePosition(r,n,o),a=V(r,s),U(a,o)):(n=F.intersect(l,n))?((o=F.findBestRelativePosition(r,n,l,e))?(s=F.relativePosition(r,n,o),a=V(r,s)):a=V(r,n),U(a,o)):null},Y=function(t,e,n){return q(["cr-cl","cl-cr"],["bc-tc","bl-tl