/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

( function( $ ) {

	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );
				$( '.site-title a, .site-description' ).css( {
					'color': to
				} );
			}
		} );
	} );
    
    /**
     * Dynamic Internal/Embedded Style for a Control
     */
    function practical_add_dynamic_css( control, style ) {
        control = control.replace( '[', '-' );
        control = control.replace( ']', '' );
        $( 'style#' + control ).remove();
        $( 'head' ).append( '<style id="' + control + '">' + style + '</style>' );
    }
    
    /**
     * Sidebar Width
     */
    wp.customize( 'practical_sidebar_width', function( setting ) {
		setting.bind( function( width ) {
            var dynamicStyle = '@media (min-width: 768px) {';
            dynamicStyle += '#primary.col-md-9 { -ms-flex: 0 0 ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '#primary.col-md-9 { flex: 0 0 ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '#primary.col-md-9 { max-width: ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '.sidebar.col-md-3 { -ms-flex: 0 0 ' + width + '% } ';
            dynamicStyle += '.sidebar.col-md-3 { flex: 0 0 ' + width + '% } ';
            dynamicStyle += '.sidebar.col-md-3 { max-width: ' + width + '% } ';
            dynamicStyle += '.two-sidebar #primary.col-md-9 { -ms-flex: 0 0 ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '.two-sidebar #primary.col-md-9 { flex: 0 0 ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '.two-sidebar #primary.col-md-9 { max-width: ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '}';
            practical_add_dynamic_css( 'practical_sidebar_width', dynamicStyle );
		} );
	} );
    
    /**
     * Pages Sidebar Width
     */
    wp.customize( 'practical_pages_sidebar_width', function( setting ) {
		setting.bind( function( width ) {
            var dynamicStyle = '@media (min-width: 768px) {';
            dynamicStyle += '.page #primary.col-md-9 { -ms-flex: 0 0 ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '.page #primary.col-md-9 { flex: 0 0 ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '.page #primary.col-md-9 { max-width: ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '.page .sidebar.col-md-3 { -ms-flex: 0 0 ' + width + '% } ';
            dynamicStyle += '.page .sidebar.col-md-3 { flex: 0 0 ' + width + '% } ';
            dynamicStyle += '.page .sidebar.col-md-3 { max-width: ' + width + '% } ';
            dynamicStyle += '.page.two-sidebar #primary.col-md-9 { -ms-flex: 0 0 ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '.page.two-sidebar #primary.col-md-9 { flex: 0 0 ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '.page.two-sidebar #primary.col-md-9 { max-width: ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '}';
            practical_add_dynamic_css( 'practical_pages_sidebar_width', dynamicStyle );
		} );
	} );
    
    /**
     * Single Posts Sidebar Width
     */
    wp.customize( 'practical_single_sidebar_width', function( setting ) {
		setting.bind( function( width ) {
            var dynamicStyle = '@media (min-width: 768px) {';
            dynamicStyle += '.single #primary.col-md-9 { -ms-flex: 0 0 ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '.single #primary.col-md-9 { flex: 0 0 ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '.single #primary.col-md-9 { max-width: ' + ( 100 - parseInt( width ) ) + '% } ';
            dynamicStyle += '.single .sidebar.col-md-3 { -ms-flex: 0 0 ' + width + '% } ';
            dynamicStyle += '.single .sidebar.col-md-3 { flex: 0 0 ' + width + '% } ';
            dynamicStyle += '.single .sidebar.col-md-3 { max-width: ' + width + '% } ';
            dynamicStyle += '.single.two-sidebar #primary.col-md-9 { -ms-flex: 0 0 ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '.single.two-sidebar #primary.col-md-9 { flex: 0 0 ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '.single.two-sidebar #primary.col-md-9 { max-width: ' + ( 100 - parseInt( width ) - parseInt( width ) ) + '% } ';
            dynamicStyle += '}';
            practical_add_dynamic_css( 'practical_pages_sidebar_width', dynamicStyle );
		} );
	} );
    
} )( jQuery );
