<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Ef Practical
 */

get_header(); ?>

<div id="content" class="site-content cf">
    
    <?php
        $title_bar = get_post_meta( $post->ID, 'practical-title-bar', true );
        if ( ! $title_bar) { $title_bar = 'default'; }
        if ( $title_bar == 'default' ) :
            if ( '' != get_the_archive_title() && 1 == get_theme_mod( 'practical_header_title_bar', 1 ) ) :
                get_template_part( '/template-parts/title-bar' );
            endif;
        elseif ( $title_bar == 'show' ) :
            get_template_part( '/template-parts/title-bar' );
        endif;
    ?>
    
    <div class="ef-container">
        <div class="row">
            
            <div id="primary" class="content-area col-md-9 order-md-2">
                <main id="main" class="site-main" role="main">
                    
                   <?php while ( have_posts() ) : the_post(); ?>
                        
                        <?php get_template_part( 'template-parts/content', 'single' ); ?>
                        
                        <?php
                            global $post;
                            $author_info = get_post_meta( $post->ID, 'practical-author-info', true );
                            if( ! $author_info) { $author_info = 'default'; }
                            if( $author_info == 'default' ) :
                                if ( 0 != get_theme_mod( 'practical_single_post_author_info', 0 ) ) :
                                    get_template_part( 'template-parts/author-info' );
                                endif;
                            elseif( $author_info == 'show' ) :
                                get_template_part( 'template-parts/author-info' );
                            endif;
                        ?>
                        
                        <?php
                            if ( 0 == get_theme_mod( 'practical_single_post_post_nav', 0 ) ) :
                                practical_post_navigation();
                            endif;
                        ?>
                        
                        <?php
                            if ( 0 == get_theme_mod( 'practical_related_posts', 0 ) ) :
                                get_template_part( 'template-parts/related-posts' );
                            endif;
                        ?>
                        
                        <?php
                            // Comments
                            if ( comments_open() || get_comments_number() ) :
                                comments_template( '', true );
                            endif;
                        ?>
                    
                    <?php endwhile; ?>
                    
                </main><!-- #main -->
            </div><!-- #primary -->
            
            <?php practical_sidebar(); ?>
            
        </div>
    </div>
</div><!-- #content -->

<?php get_footer(); ?>