<?php
/**
 * Sidebar metabox.
 *
 * Prints the box content.
 *
 * @package Ef Practical
 * 
 * @param WP_Post $post The object for the current post/page.
 */
function practical_sidebar_cb( $post ) {
    
    // Add a nonce field so we can check for it later.
	wp_nonce_field( 'practical_sidebar_save', 'practical_sidebar_nonce' );
    
    /*
	 * Use get_post_meta() to retrieve an existing value
	 * from the database and use the value for the form.
	 */
    $practical_sidebar = get_post_meta( $post->ID, 'practical_page_sidebar', true );
    if( ! $practical_sidebar ) { $practical_sidebar = 'default_sidebar'; }
    
?>
    <p>
        <label>
            <input type="radio" name="practical_page_sidebar" value="default_sidebar" <?php echo checked( $practical_sidebar, 'default_sidebar', false ); ?>>
            <?php esc_html_e( 'Default (from Theme Options)', 'ef-practical' ); ?>
        </label>
    </p>
    <p>
        <label>
            <input type="radio" name="practical_page_sidebar" value="right_sidebar" <?php echo checked( $practical_sidebar, 'right_sidebar', false ); ?>>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/images/layout/2cr.png' ); /* WPCS: xss ok. */ ?>">
        </label>
    </p>
    <p>
        <label>
            <input type="radio" name="practical_page_sidebar" value="left_sidebar" <?php echo checked( $practical_sidebar, 'left_sidebar', false ); ?>>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/images/layout/2cl.png' ); /* WPCS: xss ok. */ ?>">
        </label>
    </p>
    <p>
        <label>
            <input type="radio" name="practical_page_sidebar" value="two_sidebar" <?php echo checked( $practical_sidebar, 'two_sidebar', false ); ?>>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/images/layout/3cm.png' ); /* WPCS: xss ok. */ ?>">
        </label>
    </p>
    <p>
        <label>
            <input type="radio" name="practical_page_sidebar" value="no_sidebar" <?php echo checked( $practical_sidebar, 'no_sidebar', false ); ?>>
            <img src="<?php echo esc_url( get_template_directory_uri() . '/images/layout/1c.png' ); /* WPCS: xss ok. */ ?>">
        </label>
    </p>
<?php
}

/**
 * When the post is saved, saves our custom data.
 *
 * @param int $post_id The ID of the post being saved.
 */
function practical_sidebar_save( $post_id ) {
    
    // Check if our nonce is set.
	if ( ! isset( $_POST['practical_sidebar_nonce'] ) ) {
		return;
	}
    
    // Verify that the nonce is valid.
	if ( ! wp_verify_nonce( sanitize_key( $_POST[ 'practical_sidebar_nonce' ] ), 'practical_sidebar_save' ) ) {
		return;
	}
    
    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
    
    // Check the user's permissions.
	if ( ! current_user_can( 'edit_post', $post_id ) ) {
		return;
	}
    
	if ( isset( $_POST['practical_page_sidebar'] ) ) {
		
		$practical_data = sanitize_text_field( wp_unslash( $_POST[ 'practical_page_sidebar' ] ) );
		
		update_post_meta( $post_id, 'practical_page_sidebar', $practical_data );
	}
    
}
add_action( 'save_post', 'practical_sidebar_save' );