/**
 * Ef Practical Theme Custom Functionality
 *
 */
jQuery(function($) {
    
    // Sticky header
    if ( practical_js_settings.sticky_header != 0 ) {
        
        $(document).ready(function() {
            
            $('body').addClass('sticky-header');
            
            $('#masthead').before($('.site-header').clone().addClass('sticky'));
            
            $(window).scroll(function(){
                if($(window).scrollTop() >= 200){
                    $('body').addClass('small-header');
                    $('.header-top-bar').addClass('hide-top-bar');
                } else {
                    $('body').removeClass('small-header');
                    $('.header-top-bar').removeClass('hide-top-bar');
                }
            });
            
        });
        
    }
    
    // Menu not fly off the right of the screen
    $( document ).ready( function() {
        $('.main-navigation').find('li ul.sub-menu li.menu-item-has-children').mouseenter( function() {
            if ( $(this).children('ul.sub-menu').offset().left + 232 > $(window).width() ) {
                $(this).children('ul.sub-menu').css( { right: '100%', left: 'auto' } );
            }
        });
        $('.main-navigation').find('li ul.children li.page_item_has_children').mouseenter( function() {
            if ( $(this).children('ul.children').offset().left + 232 > $( window ).width() ) {
                $(this).children('ul.children').css( { right: '100%', left: 'auto' } );
            }
        });
    });
    
    // Mobile Nav
    $( document ).ready( function() {
        
        var mobileNav = $('.mobile-nav');
        
        function mobileNavigation() {
            
            $('.main-navigation ul').first().clone().appendTo(mobileNav);
            
            mobileNav.prepend('<div class="cmb"><div class="close-menu-button"></div></div>');
            
            $('.menu-toggle').click(function(e){
                $('body').toggleClass('open-mobile-nav');
                $(this).find('.fa:first').toggleClass('fa-bars').toggleClass('fa-times');
                e.preventDefault();
            });
            
            if ( practical_js_settings.sticky_header != 0 ) {
                $('.close-menu-button').click(function(e){
                    $('.menu-toggle').click();
                    $('body').toggleClass('open-mobile-nav');
                    e.preventDefault();
                });
                
                // Toggles Search Field on and off
                $('.search-toggle').click(function () {
                    $('.search-container').slideToggle('300ms');
                    $(this).toggleClass('closed');
                });
                
            } else {
                $('.close-menu-button').click(function(e){
                    $('.menu-toggle').click();
                    e.preventDefault();
                });
            }
            
            // Add button to sub-menu parent to show nested pages on the mobile menu
            mobileNav.find('.page_item_has_children > a, .menu-item-has-children > a').after('<div class="dropdown-toggle" aria-expanded="false"><i class="fa fa-chevron-down"></i></div>');
            
            // Sub-menu toggle button
            mobileNav.find('.page_item_has_children .dropdown-toggle, .menu-item-has-children .dropdown-toggle').bind( 'click', function(e) {
                $(this).find('.fa:first').toggleClass('fa-chevron-down').toggleClass('fa-chevron-up');
                e.preventDefault();
            });
            mobileNav.on( 'click', '.menu-item-has-children .dropdown-toggle', function(e) {
                $(this).next('ul.sub-menu').slideToggle('300ms');
                $(this).next('ul.children').slideToggle('300ms');
                e.preventDefault();
            } );
            
        }
        mobileNavigation();
        
    });
    
    if ( practical_js_settings.sticky_header == 0 ) {
        // Toggles Search Field on and off
        $('.search-toggle').click(function () {
            $('.search-container').slideToggle('300ms');
            $(this).toggleClass('closed');
        });
    }
    
    // Lightbox
    if ( practical_js_settings.enable_lightbox != 0 ) {
        $(document).ready(function() {
            
            var animationEffect    = practical_js_settings.animation_effect_lightbox;
            var transitionEffect   = practical_js_settings.transition_effect_lightbox;
            var transitionDuration = practical_js_settings.transition_duration_lightbox;
            var autoStart          = practical_js_settings.lightbox_auto_play_lightbox;
            var speed              = practical_js_settings.transition_speed_lightbox;
            
            // Featured image lightbox
            if ( practical_js_settings.featured_img_lightbox != 0 ) {
                $('.entry-thumbnail a.fancybox').fancybox({
                    protect : true,
                    animationEffect: animationEffect,
                });
            }
            
            // Content image lightbox
            if ( practical_js_settings.content_img_lightbox != 0 ) {
                
                // Single image lightbox
                $('a[href*=".jpg"], a[href*=".jpeg"], a[href*=".png"], a[href*=".gif"]').each(function(){
                    if ( $(this).parents('.gallery').length == 0 ) {
                        $(this).fancybox({
                            protect: true,
                            animationEffect: animationEffect,
                        });
                    }
                });
                
                // Gallery lightbox
                $('a[href*=".jpg"], a[href*=".jpeg"], a[href*=".png"], a[href*=".gif"]').each(function(){
                    if ( $(this).parents('.gallery').length > 0 ) {
                        
                        $('.gallery-icon a').fancybox().attr('data-fancybox', 'gallery').fancybox({
                            protect: true,
                            loop: true,
                            infobar: true,
                            animationEffect: animationEffect,
                            animationDuration : 600,
                            transitionEffect: transitionEffect,
                            transitionDuration: transitionDuration,
                            slideShow: {
                                autoStart: autoStart,
                                speed: speed
                            },
                        });
                    }
                });
                
            }
            
        });
    }
    
    // Comments Tabs
    $(document).ready(function() {
        $('.comments-tabs a').click(function(event) {
            event.preventDefault();
            $(this).parent().addClass('active-tab');
            $(this).parent().siblings().removeClass('active-tab');
            var tab = $(this).attr('href');
            $('.tab-content').not(tab).css('display', 'none');
            $(tab).fadeIn();
        });
    });
    
    // Reveal Animations When Scrolling
    if ( practical_js_settings.animation != 0 ) {
        $(document).ready(function() {
            var wow = new WOW( {
                offset: 50,
                mobile: false,
                live:   false
            } );
            wow.init();
        });
    }
    
    // Back to top button
    if ( practical_js_settings.go_top_button != 0 ) {
        $('.float-scroll-top').click(function() {
            $('html, body').animate({
                scrollTop: '0px'
            }, 600);
            return false;
        });
        $('.scroll-top').click(function() {
            $('html, body').animate({
                scrollTop: '0px'
            }, 600);
            return false;
        });
        $(window).scroll(function() {
            var scrollTop = $('html, body').scrollTop();
            if (scrollTop > 240) {
                $('.float-scroll-top').css({ bottom: 25, });
            } else {
                $('.float-scroll-top').css({ bottom: -100, });
            }
        });
    }
    
    // Sticky Footer
    if ( practical_js_settings.sticky_footer != 0 ) {
        $(document).ready(function() {
            var wp = $('#wpadminbar').height();
            var sh = $('.site-header').outerHeight();
            var hi = $('.header-image').outerHeight();
            var sf = $('.site-footer').outerHeight();
            var wh = $(window).outerHeight();
            var ch = wh - (sh + hi + sf + wp);
            $('#content').css('min-height', ch);
        });
    }
    
});