<?php
/**
 * Ef Practical Social Widget.
 *
 * @package Ef Practical
 */

/**
 * Widget class.
 */
if ( ! class_exists( 'Practical_Social_Widget' ) ) {
	class Practical_Social_Widget extends WP_Widget {
        
		/**
		 * Register widget
		 */
		public function __construct() {
            $widget_ops = array(
                'classname' => 'ef_social_widget',
                'description' => esc_html__( 'Display social icons.', 'ef-practical' ),
            );
    		parent::__construct( 'practical_social_widget', esc_html__( 'Practical: Social', 'ef-practical' ), $widget_ops );
		}
		
		/**
		 * Output the content of the widget
		 */
		public function widget( $args, $instance ) {
            
			// vars
			$output = '';
			$title = ! empty( $instance['title'] ) ? $instance['title'] : '';
			$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
			$target = isset( $instance['target'] ) ? $instance['target'] : 0;
            $show	= isset( $instance['show'] ) ? $instance['show'] : 'icon';
			
			// Before widget
			$output .= $args['before_widget'];
            
			// Widget title
			if ( $title ) {
				$output .= $args['before_title'];
					$output .= $title;
				$output .= $args['after_title'];
			}
            
            // Target
            if ( $target ) {
                $new_tab = 'target="_blank"';
            } else {
                $new_tab = '';
            }
			
			$output .= '<div class="ef-social-widget ef-social-'. esc_attr( $show ) .'">';
                
                $socials = array( 'facebook', 'twitter', 'google-plus', 'youtube', 'pinterest', 'instagram', 'linkedin', 'flickr', 'rss' );
                
				foreach( $socials as $social_icon ) {
                    
                    if ( 'icon' == $show ) {
                        $icon_text = '<i class="fa fa-'.strtolower( $social_icon ).'"></i>';
                    } elseif ( 'text' == $show ) {
                        $icon_text = '<div class="text-social-widget">'. esc_html( ucfirst( $social_icon ) ) .'</div>';
                    } else {
                        $icon_text = '<i class="fa fa-'.strtolower( $social_icon ).'"></i><div class="text-social-widget">'.esc_html( ucfirst( $social_icon ) ).'</div>';
                    }
                    
                    if ( ! empty( $instance[ ''.$social_icon.'' ] ) ) {
                        $output .= '<a class="social-icon '.esc_attr( $social_icon ).'" href="'.esc_url($instance[''.$social_icon.'']).'" '.$new_tab.' rel="nofollow">'.$icon_text.'<span></span></a>';
                    }
                    
				}
                
			$output .= '</div>';
            
			// After widget
			$output .= $args['after_widget'];
            
			// output echo
			echo $output; // WPCS: XSS ok.
            
		}
        
		/**
		 *  Update the information in the WordPress database
		 */	
		public function update( $new_instance, $old_instance ) {
            
			$instance = $old_instance;
            $instance['title']   = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
			$instance['target']  = ! empty( $new_instance['target'] ) ? true : false;
            $instance['show']    = ! empty( $new_instance['show'] ) ? sanitize_text_field( $new_instance['show'] ) : 'icon';
            $instance[ 'facebook' ] = sanitize_text_field( $new_instance[ 'facebook' ] );
            $instance[ 'twitter' ] = sanitize_text_field( $new_instance[ 'twitter' ] );
            $instance[ 'google-plus' ] = sanitize_text_field( $new_instance[ 'google-plus' ] );
            $instance[ 'youtube' ] = sanitize_text_field( $new_instance[ 'youtube' ] );
            $instance[ 'pinterest' ] = sanitize_text_field( $new_instance[ 'pinterest' ] );
            $instance[ 'instagram' ] = sanitize_text_field( $new_instance[ 'instagram' ] );
            $instance[ 'linkedin' ] = sanitize_text_field( $new_instance[ 'linkedin' ] );
            $instance[ 'flickr' ] = sanitize_text_field( $new_instance[ 'flickr' ] );
            $instance[ 'rss' ] = sanitize_text_field( $new_instance[ 'rss' ] );
            
			return $instance;
            
		}
        
		/**
		 * Add form fields to the widget which will be displayed in the WordPress admin area.
		 */
		public function form( $instance ) {
            
            $instance = wp_parse_args( ( array ) $instance, 
                array( 
                    'title'      => esc_html__( 'Social', 'ef-practical' ),
                    'target'     => 0,
                    'show'       => 'icon',
                    'facebook'   => '',
                    'twitter'    => '',
                    'google-plus' => '',
                    'youtube'    => '',
                    'pinterest'  => '',
                    'instagram'  => '',
                    'linkedin'   => '',
                    'flickr'     => '',
                    'rss'        => '',
                ) 
            );
            
            if ( $instance ) { $title = $instance[ 'title' ]; }
            if ( isset( $instance[ 'target' ] ) ) { $target = $instance[ 'target' ]; }
            if ( isset( $instance[ 'show' ] ) ) { $show = $instance[ 'show' ]; }
            if ( isset( $instance[ 'facebook' ] ) ) { global $facebook; $facebook = $instance[ 'facebook' ]; }
            if ( isset( $instance[ 'twitter' ] ) ) { $twitter = $instance[ 'twitter' ]; }
            if ( isset( $instance[ 'google-plus' ] ) ) { $googleplus = $instance[ 'google-plus' ]; }
            if ( isset( $instance[ 'youtube' ] ) ) { $youtube = $instance[ 'youtube' ]; }
            if ( isset( $instance[ 'pinterest' ] ) ) { $pinterest = $instance[ 'pinterest' ]; }
            if ( isset( $instance[ 'instagram' ] ) ) { $instagram = $instance[ 'instagram' ]; }
            if ( isset( $instance[ 'linkedin' ] ) ) { $linkedin = $instance[ 'linkedin' ]; }
            if ( isset( $instance[ 'flickr' ] ) ) { $flickr = $instance[ 'flickr' ]; }
            if ( isset( $instance['rss'] ) ) { $rss = $instance['rss']; }
            
        ?>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" id="<?php echo $this->get_field_id( 'title' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <input id="<?php echo $this->get_field_id( 'target' ); /* WPCS: xss ok. */ ?>" name="<?php echo $this->get_field_name( 'target' ); /* WPCS: xss ok. */ ?>" type="checkbox" value="1" <?php checked( '1', $target ); ?>/>
            <label for="<?php echo $this->get_field_id( 'target' ); /* WPCS: xss ok. */ ?>"><?php esc_html_e( 'Check to open in a new window', 'ef-practical' ); ?></label>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'show' ) ); ?>">
                <?php esc_html_e( 'Show:', 'ef-practical' ); ?>
            </label>
            <select class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'show' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'show' ) ); ?>">
                <option value="icon" <?php selected( $show, 'icon' ); ?>>
                <?php esc_html_e( 'Icon', 'ef-practical' ); ?>
                </option>
                <option value="text" <?php selected( $show, 'text' ); ?>>
                <?php esc_html_e( 'Text', 'ef-practical' ); ?>
                </option>
                <option value="icon-text" <?php selected( $show, 'icon-text' ); ?>>
                <?php esc_html_e( 'Icon - Text', 'ef-practical' ); ?>
                </option>
            </select>
        </p>
        <h3 style="margin:20px 0 0 0;">
            <?php esc_attr_e( 'Social Links', 'ef-practical' ); ?>
        </h3>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'facebook' ) ); ?>"><?php esc_attr_e( 'Facebook:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'facebook' ) ); ?>" type="text" value="<?php echo esc_attr( $facebook ); ?>" id="<?php echo $this->get_field_id( 'facebook' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'twitter' ) ); ?>"><?php esc_attr_e( 'Twitter:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'twitter' ) ); ?>" type="text" value="<?php echo esc_attr( $twitter ); ?>" id="<?php echo $this->get_field_id( 'twitter' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'google-plus' ) ); ?>"><?php esc_attr_e( 'Google Plus:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'google-plus' ) ); ?>" type="text" value="<?php echo esc_attr( $googleplus ); ?>" id="<?php echo $this->get_field_id( 'google-plus' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'youtube' ) ); ?>"><?php esc_attr_e( 'Youtube:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'youtube' ) ); ?>" type="text" value="<?php echo esc_attr( $youtube ); ?>" id="<?php echo $this->get_field_id( 'youtube' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'pinterest' ) ); ?>"><?php esc_attr_e( 'Pinterest:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'pinterest' ) ); ?>" type="text" value="<?php echo esc_attr( $pinterest ); ?>" id="<?php echo $this->get_field_id( 'pinterest' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'instagram' ) ); ?>"><?php esc_attr_e( 'Instagram:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'instagram' ) ); ?>" type="text" value="<?php echo esc_attr( $instagram ); ?>" id="<?php echo $this->get_field_id( 'instagram' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'linkedin' ) ); ?>"><?php esc_attr_e( 'Linkedin:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'linkedin' ) ); ?>" type="text" value="<?php echo esc_attr( $linkedin ); ?>" id="<?php echo $this->get_field_id( 'linkedin' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'flickr' ) ); ?>"><?php esc_attr_e( 'Flickr:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'flickr' ) ); ?>" type="text" value="<?php echo esc_attr( $flickr ); ?>" id="<?php echo $this->get_field_id( 'flickr' ); /* WPCS: xss ok. */ ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'rss' ) ); ?>"><?php esc_attr_e( 'RSS:', 'ef-practical' ); ?></label>
            <input class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'rss' ) ); ?>" type="text" value="<?php echo esc_attr( $rss ); ?>" id="<?php echo $this->get_field_id( 'rss' ); /* WPCS: xss ok. */ ?>">
        </p>
        
    <?php
		}
	}
}