<?php
/**
 * Template part for displaying single posts.
 *
 * @package Ef Practical
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    
    <?php if ( has_post_thumbnail() && 0 == get_theme_mod( 'practical_single_post_featured_img', 0 ) ) : ?>
        <?php get_template_part( '/template-parts/entry/entry-thumbnail' ); ?>
    <?php endif; ?>
    
    <?php if ( 0 != get_theme_mod( 'practical_post_entry_title', 0 ) ) : ?>
        <?php get_template_part( '/template-parts/entry/entry-header' ); ?>
    <?php endif; ?>
    
    <?php get_template_part( '/template-parts/entry/entry-meta' ); ?>
    
    <?php get_template_part( '/template-parts/entry/entry-content' ); ?>
    
    <?php
        if ( 0 == get_theme_mod( 'practical_single_post_edit_link', 0 ) ) :
            edit_post_link( esc_html__( 'Edit Post', 'ef-practical' ), '<span class="edit-link cf">', '</span>' );
        endif;
    ?>
    
    <?php get_template_part( '/template-parts/entry/entry-footer' ); ?>
    
</article><!-- #post-## -->