<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Ef Practical
 */

$posts_display = get_theme_mod( 'practical_blog_home_display_posts', 'list' );
$col_number    = absint( get_theme_mod( 'practical_blog_home_columns', 2 ) );

get_header(); ?>

<div id="content" class="site-content cf">
    
    <?php
        if ( is_home() && ! is_front_page() ) {
            $title_bar = get_post_meta( get_queried_object_id(), 'practical-title-bar', true );
            if ( ! $title_bar) { $title_bar = 'default'; }
            if ( $title_bar == 'default' ) :
                if ( '' != get_the_archive_title() && 1 == get_theme_mod( 'practical_header_title_bar', 1 ) ) :
                    get_template_part( '/template-parts/title-bar' );
                endif;
            elseif ( $title_bar == 'show' ) :
                get_template_part( '/template-parts/title-bar' );
            endif;
        }
    ?>
    
    <div class="ef-container">
        <div class="row">
            
            <div id="primary" class="content-area col-md-9 order-md-2">
                <main id="main" class="site-main" role="main">
                    
                    <?php if ( have_posts() ) : ?>
                        
                        <?php if ( 0 != get_theme_mod( 'practical_blog_home_page_title', 0 ) && is_home() ) : ?>
                            <header class="page-header">
                                <h1 class="page-title">
                                    <?php
                                        if ( '' != get_theme_mod( 'practical_blog_home_change_title', '' ) ) :
                                            echo esc_html( get_theme_mod( 'practical_blog_home_change_title' ) );
                                        else:
                                            echo get_the_archive_title(); /* WPCS: xss ok. */
                                        endif;
                                    ?>
                                </h1>
                            </header>
                        <?php endif; ?>
                        
                        <?php if ( 'grid' == $posts_display ) : ?>
                            
                            <div class="grid-posts">
                                <?php while ( have_posts() ) : the_post(); ?>
                                    <div class="ef-col-<?php echo esc_attr( $col_number ); ?> wow fadeInUp">
                                        <?php get_template_part( 'template-parts/content', get_post_format() ); ?>
                                    </div>
                                <?php endwhile; ?>
                            </div>
                            
                        <?php else: ?>
                            
                            <?php while ( have_posts() ) : the_post(); ?>
                                <?php get_template_part( 'template-parts/content', get_post_format() ); ?>
                            <?php endwhile; ?>
                            
                        <?php endif; ?>
                        
                        <?php
                            if ( 'pagination' == get_theme_mod( 'practical_paged_type', 'pagination' ) ) :
                                the_posts_pagination(); // WPCS: xss ok. 
                            else :
                                practical_posts_navigation();
                            endif;
                        ?>
                        
                    <?php else: ?>
                        
                        <?php get_template_part( 'template-parts/content', 'none' ); ?>
                        
                    <?php endif; ?>
                    
                </main><!-- #main practical_pagination-->
            </div><!-- #primary -->
            
            <?php practical_sidebar(); ?>
            
        </div>
    </div>
</div><!-- #content -->

<?php get_footer(); ?>