<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @package Ef Practical
 */

$footer_social = get_theme_mod( 'practical_footer_social', 0 );
if ( 0 != $footer_social ) :
    $class = 'col-md-7';
else:
    $class = 'col-md-12';
endif;

?>
    
	<footer id="colophon" class="site-footer" role="contentinfo">
        
        <?php get_sidebar( 'footer' ); ?>
        
        <div class="site-info">
            
            <div class="ef-container">
                <div class="row row-grid align-items-center">
                    
                    <div class="<?php echo esc_attr( $class ); ?>">
                        <div class="site-info-inner">
                            <div class="footer-copyright">
                                <?php if ( '' != get_theme_mod( 'practical_footer_copyright', '' ) ) : ?>
                                    <?php echo wp_kses_post( get_theme_mod( 'practical_footer_copyright' ) ); ?>
                                <?php else: ?>
                                    <?php bloginfo(); ?> &copy; <?php echo esc_html( date_i18n( 'Y' ) ); ?>. <?php esc_html_e( 'All Rights Reserved.', 'ef-practical' ); ?>	
                                <?php endif; ?>
                            </div>
                            <?php if ( 0 != get_theme_mod( 'practical_footer_credit', 1 ) ) : ?>
                                <div class="footer-credit">
									<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'ef-practical' ) ); ?>" target="_blank"><?php
										/* translators: %s: CMS name, i.e. WordPress. */
										printf( esc_html__( 'Proudly powered by %s', 'ef-practical' ), 'WordPress' );
									?></a>
									<span class="sep"> | </span>
									<?php 
										/* translators: %1$s: Theme author. */
										printf( esc_html__( 'Theme by: %1$s', 'ef-practical' ), '<a href="https://profiles.wordpress.org/effpandim" rel="nofollow" target="_blank">Dimitrakopoulos</a>' );
									?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <?php if ( 0 != $footer_social ) : ?>
                        <div class="col-md-5">
                            <?php practical_social_links(); ?>
                        </div>
                    <?php endif; ?>
                    
                </div>
                
                <?php if ( 0 != get_theme_mod( 'practical_go_top_button', 1 ) && 0 != get_theme_mod( 'practical_go_top_footer', 0 ) ) : ?>
                    <a id="gotop" class="scroll-top" href="#page"><?php esc_html_e( 'Back To Top', 'ef-practical' ); ?></a>
                <?php endif; ?>
                
            </div>
            
        </div><!-- .site-info -->
        
	</footer><!-- #colophon -->
    
    <?php if ( 0 != get_theme_mod( 'practical_go_top_button', 1 ) && 0 == get_theme_mod( 'practical_go_top_footer', 0 ) ) : ?>
        <a id="gotop" class="float-scroll-top" href="#page"></a>
    <?php endif; ?>
    
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>