<?php
/**
 * Ef Practical Theme Customizer
 *
 * @package Ef Practical
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function practical_customize_register( $wp_customize ) {
    
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    $wp_customize->get_section( 'title_tagline' )->title        = esc_html__( 'Site title - Tagline - Logo', 'ef-practical' );
    $wp_customize->get_section( 'title_tagline' )->priority     = 5;
    $wp_customize->get_section( 'header_image' )->panel         = 'practical_header_panel';
    $wp_customize->get_section( 'header_image' )->priority      = 3;
    $wp_customize->get_section( 'colors' )->panel               = 'practical_design_panel';
    $wp_customize->get_section( 'colors' )->priority            = 4;
    $wp_customize->get_section( 'background_image' )->panel     = 'practical_design_panel';
    $wp_customize->get_section( 'background_image' )->priority  = 6;
    
    function priority_customizer_nav_menus( $wp_customize ) {
        $panel = $wp_customize->get_panel( 'nav_menus' );
        if ( $panel ) {
            $panel->priority = 20;
        }
    }
    add_action( 'customize_register', 'priority_customizer_nav_menus', 12 );
    
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'practical_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'practical_customize_partial_blogdescription',
		) );
	}
}
add_action( 'customize_register', 'practical_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function practical_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function practical_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Add the theme configuration
 */
Practical_Kirki::add_config( 'practical_config', array(
	'option_type' => 'theme_mod',
    'capability'  => 'edit_theme_options',
) );

// Site Identity
Practical_Kirki::add_field( 'practical_config', array(
	'type'     => 'radio',
	'settings' => 'practical_site_logo',
	'label'    => esc_html__( 'Choice to show', 'ef-practical' ),
	'section'  => 'title_tagline',
	'default'  => 'logo_text',
	'choices'  => array(
        'logo_text'  => esc_html__( 'Title - Tagline', 'ef-practical' ),
		'logo_image' => esc_html__( 'Logo Image', 'ef-practical' ),
	),
) );

/* General settings
---------------------------------*/
Practical_Kirki::add_section( 'practical_general_settings', array(
    'title'      => esc_html__( 'General settings', 'ef-practical' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
) );
    
    // Animation
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_animation',
        'label'    => esc_html__( 'Animation', 'ef-practical' ),
        'section'  => 'practical_general_settings',
        'default'  => 1,
        'choices'  => array(
            'on'  => esc_html__( 'Enable', 'ef-practical' ),
            'off' => esc_html__( 'Disable', 'ef-practical' ),
        ),
    ) );
    
    // Smooth Scrolling
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_smoothscroll',
        'label'    => esc_html__( 'Smooth Scrolling', 'ef-practical' ),
        'section'  => 'practical_general_settings',
        'default'  => 1,
        'choices'  => array(
            'on'  => esc_html__( 'Enable', 'ef-practical' ),
            'off' => esc_html__( 'Disable', 'ef-practical' ),
        ),
    ) );
    
    // Sticky Footer
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_sticky_footer',
        'label'    => esc_html__( 'Sticky Footer', 'ef-practical' ),
        'section'  => 'practical_general_settings',
        'default'  => 1,
        'choices'  => array(
            'on'  => esc_html__( 'Enable', 'ef-practical' ),
            'off' => esc_html__( 'Disable', 'ef-practical' ),
        ),
    ) );
    
    // Go To Top
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_go_top_button',
        'label'    => esc_html__( 'Go To Top Button', 'ef-practical' ),
        'section'  => 'practical_general_settings',
        'default'  => 1,
        'choices'  => array(
            'on'  => esc_html__( 'Show', 'ef-practical' ),
            'off' => esc_html__( 'Hide', 'ef-practical' ),
        ),
    ) );
    
    // Go To Top Footer
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_go_top_footer',
        'label'    => esc_html__( 'Show go to top button in footer.', 'ef-practical' ),
        'section'  => 'practical_general_settings',
        'default'  => 0,
        'choices'  => array(
            'on'  => esc_html__( 'Show', 'ef-practical' ),
            'off' => esc_html__( 'Hide', 'ef-practical' ),
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_go_top_button',
                'operator' => '==',
                'value'    => 1,
            ),
        ),
    ) );
    
/* Header
-----------------------------------------------------*/
Practical_Kirki::add_panel( 'practical_header_panel', array(
    'priority' => 15,
    'title'    => esc_html__( 'Header', 'ef-practical' ),
) );
    
    /* Header Settings
    ---------------------------------*/
    Practical_Kirki::add_section( 'practical_header_settings', array(
        'title'      => esc_html__( 'Header settings', 'ef-practical' ),
        'panel'      => 'practical_header_panel',
        'priority'   => 1,
        'capability' => 'edit_theme_options',
    ) );
        
        // Header layout
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'select',
            'settings' => 'practical_header_layout',
            'label'    => esc_html__( 'Header layout', 'ef-practical' ),
            'section'  => 'practical_header_settings',
            'default'  => 'left_logo',
            'multiple' => 1,
            'choices'  => array(
                'left_logo'   => esc_html__( 'Left logo - Right navigation', 'ef-practical' ),
                'right_logo'  => esc_html__( 'Right logo - Left navigation', 'ef-practical' ),
                'center_logo' => esc_html__( 'Center logo - Center navigation', 'ef-practical' ),
            ),
        ) );
        
        // Header Search
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_header_search',
            'label'    => esc_html__( 'Search', 'ef-practical' ),
            'section'  => 'practical_header_settings',
            'default'  => 0,
            'choices'  => array(
                'on'  => esc_html__( 'Show', 'ef-practical' ),
                'off' => esc_html__( 'Hide', 'ef-practical' ),
            ),
        ) );
        
        // Mobile Menu Search
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_mobile_search',
            'label'    => esc_html__( 'Mobile Menu Search', 'ef-practical' ),
            'section'  => 'practical_header_settings',
            'default'  => 0,
            'choices'  => array(
                'on'  => esc_html__( 'Show', 'ef-practical' ),
                'off' => esc_html__( 'Hide', 'ef-practical' ),
            ),
        ) );
        
        // Sticky Header
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_sticky_header',
            'label'    => esc_html__( 'Sticky Header', 'ef-practical' ),
            'section'  => 'practical_header_settings',
            'default'  => 0,
            'choices'  => array(
                'on'  => esc_html__( 'Enable', 'ef-practical' ),
                'off' => esc_html__( 'Disable', 'ef-practical' ),
            ),
        ) );
        
        // Tablet Sticky Header
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_tablet_sticky_header',
            'label'    => esc_html__( 'Tablet Sticky Header', 'ef-practical' ),
            'section'  => 'practical_header_settings',
            'default'  => 0,
            'choices'  => array(
                'on'  => esc_html__( 'Enable', 'ef-practical' ),
                'off' => esc_html__( 'Disable', 'ef-practical' ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_sticky_header',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ) );
        
        // Mobile Sticky Header
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_mobile_sticky_header',
            'label'    => esc_html__( 'Mobile Sticky Header', 'ef-practical' ),
            'section'  => 'practical_header_settings',
            'default'  => 0,
            'choices'  => array(
                'on'  => esc_html__( 'Enable', 'ef-practical' ),
                'off' => esc_html__( 'Disable', 'ef-practical' ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_sticky_header',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ) );
        
    /* Header Top Bar
    ---------------------------------*/
    Practical_Kirki::add_section( 'practical_header_topbar_settings', array(
        'title'      => esc_html__( 'Header Top Bar', 'ef-practical' ),
        'panel'      => 'practical_header_panel',
        'priority'   => 2,
        'capability' => 'edit_theme_options',
    ) );
        
        // Top Bar
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_header_top_bar',
            'label'    => esc_html__( 'Top Bar', 'ef-practical' ),
            'section'  => 'practical_header_topbar_settings',
            'default'  => 1,
            'choices'  => array(
                'on'  => esc_html__( 'Enable', 'ef-practical' ),
                'off' => esc_html__( 'Disable', 'ef-practical' ),
            ),
        ) );
        
        // Top Bar Social
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_top_bar_social',
            'label'    => esc_html__( 'Social', 'ef-practical' ),
            'section'  => 'practical_header_topbar_settings',
            'default'  => 0,
            'choices'  => array(
                'on'  => esc_html__( 'Show', 'ef-practical' ),
                'off' => esc_html__( 'Hide', 'ef-practical' ),
            ),
        ) );
        
        // Contact Phone
        Practical_Kirki::add_field( 'practical_config',  array(
            'type'     => 'text',
            'settings' => 'practical_contact_phone',
            'label'    => esc_html__( 'Phone', 'ef-practical' ),
            'section'  => 'practical_header_topbar_settings',
            'default'  => '9876543210',
        ));
        
        // Contact E-mail
        Practical_Kirki::add_field( 'practical_config',  array(
            'type'     => 'text',
            'settings' => 'practical_contact_email',
            'label'    => esc_html__( 'E-mail', 'ef-practical' ),
            'section'  => 'practical_header_topbar_settings',
            'default'  => 'youremail@example.com',
        ));
        
    /* Header Image
    ---------------------------------*/
        // All pages image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_header_img_pages',
            'label'    => esc_html__( 'Show image only in front page.', 'ef-practical' ),
            'section'  => 'header_image',
            'default'  => 0,
        ) );
        
    /* Header Image Content
    ---------------------------------*/
    Practical_Kirki::add_section( 'practical_header_img_content', array(
        'title'      => esc_html__( 'Header Image Content', 'ef-practical' ),
        'panel'      => 'practical_header_panel',
        'priority'   => 4,
        'capability' => 'edit_theme_options',
    ) );
        
        // Padding Top
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_header_img_top_padding',
            'label'     => esc_html__( 'Padding Top (%)', 'ef-practical' ),
            'section'   => 'practical_header_img_content',
            'transport' => 'auto',
            'default'   => 12,
            'choices'   => array(
                'min'  => '5',
                'max'  => '100',
                'step' => '1',
            ),
            'output' => array(
                array(
                    'element'  => '.header-image .ef-container',
                    'property' => 'padding-top',
                    'units'    => '%',
                ),
            ),
        ) );
        
        // Padding Bottom
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_header_img_bottom_padding',
            'label'     => esc_html__( 'Padding Bottom (%)', 'ef-practical' ),
            'section'   => 'practical_header_img_content',
            'transport' => 'auto',
            'default'   => 12,
            'choices'   => array(
                'min'  => '5',
                'max'  => '100',
                'step' => '1',
            ),
            'output' => array(
                array(
                    'element'  => '.header-image .ef-container',
                    'property' => 'padding-bottom',
                    'units'    => '%',
                ),
            ),
        ) );
        
        // Title
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'text',
            'settings'  => 'practical_header_img_title',
            'label'     => esc_html__( 'Title', 'ef-practical' ),
            'section'   => 'practical_header_img_content',
            'default'   => '',
            'transport' => 'postMessage',
        ) );
        
        // Description
        Practical_Kirki::add_field( 'practical_config', array(
            'type'	   => 'textarea',
            'settings' => 'practical_header_img_desc',
            'label'	   => esc_html__( 'Description', 'ef-practical' ),
            'section'  => 'practical_header_img_content',
            'default'  => '',
            'transport' => 'postMessage',
            'js_vars'   => array(
                array(
                    'element'  => '.header-img-desc',
                    'function' => 'html'
                )
            )
        ));
        
        // Button Text
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'text',
            'settings' => 'practical_header_img_text',
            'label'    => esc_html__( 'Button Text', 'ef-practical' ),
            'section'  => 'practical_header_img_content',
            'default'  => '',
        ) );
        
        // Button Url
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'url',
            'settings' => 'practical_header_img_url',
            'label'    => esc_html__( 'Button Url', 'ef-practical' ),
            'section'  => 'practical_header_img_content',
            'default'  => '',
        ));
        
    /* Header Image Content Typography
    ---------------------------------*/
    Practical_Kirki::add_section( 'practical_header_img_content_typography', array(
        'title'      => esc_html__( 'Header Image Content Typography', 'ef-practical' ),
        'panel'      => 'practical_header_panel',
        'priority'   => 5,
        'capability' => 'edit_theme_options',
    ) );
        
        // Title Typography
        Practical_Kirki::add_field( 'practical_config', array(
            'type'        => 'typography',
            'settings'    => 'practical_header_img_title_typog',
            'label'       => esc_html__( 'Title Typography', 'ef-practical' ),
            'section'     => 'practical_header_img_content_typography',
            'transport'   => 'auto',
            'default'     => array(
                'font-family' => 'Playfair Display',
                'variant'     => 'regular',
                'font-size'   => '32px',
                'color'       => '#ffffff',
                'text-align'  => 'center',
            ),
            'output' => array(
                array(
                    'element' => '.header-img-title',
                ),
            ),
        ) );
        
        // Font Size Title on Tablet
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_header_img_size_title_tablet',
            'label'     => esc_html__( 'Font Size Title on Tablet (px)', 'ef-practical' ),
            'section'   => 'practical_header_img_content_typography',
            'transport' => 'auto',
            'default'   => 32,
            'choices'   => array(
                'min'  => '24',
                'max'  => '52',
                'step' => '1',
            ),
            'output' => array(
                array(
                    'media_query' => '@media (max-width: 991px)',
                    'element'     => '.header-img-title',
                    'property'    => 'font-size',
                    'units'       => 'px',
                ),
            ),
        ) );
        
        // Font Size Title on Mobile
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_header_img_size_title_mobile',
            'label'     => esc_html__( 'Font Size Title on Mobile (px)', 'ef-practical' ),
            'section'   => 'practical_header_img_content_typography',
            'transport' => 'auto',
            'default'   => 32,
            'choices'   => array(
                'min'  => '18',
                'max'  => '42',
                'step' => '1',
            ),
            'output' => array(
                array(
                    'media_query' => '@media (max-width: 767px)',
                    'element'     => '.header-img-title',
                    'property'    => 'font-size',
                    'units'       => 'px',
                ),
            ),
        ) );
        
        // Description Typography
        Practical_Kirki::add_field( 'practical_config', array(
            'type'        => 'typography',
            'settings'    => 'practical_header_img_desc_typog',
            'label'       => esc_html__( 'Description Typography', 'ef-practical' ),
            'section'     => 'practical_header_img_content_typography',
            'transport'   => 'auto',
            'default'     => array(
                'font-family' => 'PT Serif',
                'variant'     => 'regular',
                'font-size'   => '18px',
                'color'       => '#ffffff',
                'text-align'  => 'center',
            ),
            'output' => array(
                array(
                    'element' => '.header-img-desc',
                ),
            ),
        ) );
        
        // Font Size Description on Tablet
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_header_img_size_desc_tablet',
            'label'     => esc_html__( 'Font Size Description on Tablet (px)', 'ef-practical' ),
            'section'   => 'practical_header_img_content_typography',
            'transport' => 'auto',
            'default'   => 18,
            'choices'   => array(
                'min'  => '14',
                'max'  => '26',
                'step' => '1',
            ),
            'output' => array(
                array(
                    'media_query' => '@media (max-width: 991px)',
                    'element'     => '.header-img-desc',
                    'property'    => 'font-size',
                    'units'       => 'px',
                ),
            ),
        ) );
        
        // Font Size Description on Mobile
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_header_img_size_desc_mobile',
            'label'     => esc_html__( 'Font Size Description on Mobile (px)', 'ef-practical' ),
            'section'   => 'practical_header_img_content_typography',
            'transport' => 'auto',
            'default'   => 18,
            'choices'   => array(
                'min'  => '12',
                'max'  => '20',
                'step' => '1',
            ),
            'output' => array(
                array(
                    'media_query' => '@media (max-width: 767px)',
                    'element'     => '.header-img-desc',
                    'property'    => 'font-size',
                    'units'       => 'px',
                ),
            ),
        ) );
        
/* Title Bar
---------------------------------*/
Practical_Kirki::add_section( 'practical_title_bar_settings', array(
    'title'      => esc_html__( 'Title Bar', 'ef-practical' ),
    'priority'   => 25,
    'capability' => 'edit_theme_options',
) );
    
    // Enable / Disable
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_header_title_bar',
        'label'    => esc_html__( 'Enable / Disable title bar', 'ef-practical' ),
        'section'  => 'practical_title_bar_settings',
        'default'  => 1,
        'choices'  => array(
            'on'  => esc_html__( 'Enable', 'ef-practical' ),
            'off' => esc_html__( 'Disable', 'ef-practical' ),
        ),
    ) );
    
    // Align Title
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'radio-buttonset',
        'settings'  => 'practical_header_title_align',
        'label'     => esc_html__( 'Align Title', 'ef-practical' ),
        'section'   => 'practical_title_bar_settings',
        'default'   => 'left',
        'transport' => 'auto',
        'choices'   => array(
            'left'   => esc_html__( 'Left', 'ef-practical' ),
            'center' => esc_html__( 'Center', 'ef-practical' ),
            'right'  => esc_html__( 'Right', 'ef-practical' ),
        ),
        'output' => array(
            array(
                'element'  => '#content > .page-header .page-title',
                'property' => 'text-align',
            ),
	    ),
    ) );
    
    // Title Color
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'color',
        'settings'  => 'practical_color_title_bar',
        'label'     => esc_html__( 'Title Color', 'ef-practical' ),
        'section'   => 'practical_title_bar_settings',
        'default'   => '#222222',
        'transport' => 'auto',
        'output' => array(
            array(
                'element'  => '#content > .page-header .page-title',
                'property' => 'color',
            ),
	    ),
    ) );
    
    // Background
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'background',
        'settings'  => 'practical_bg_title_bar',
        'label'     => esc_html__( 'Background', 'ef-practical' ),
        'section'   => 'practical_title_bar_settings',
        'transport' => 'auto',
        'default'   => array(
            'background-color'      => '#eeeeee',
            'background-image'      => '',
            'background-repeat'     => 'repeat',
            'background-position'   => 'center center',
            'background-size'       => 'cover',
            'background-attachment' => 'scroll',
        ),
        'output' => array(
            array(
                'element' => '#content > .page-header',
            ),
	    ),
    ) );
    
/* Pages Settings
---------------------------------*/
Practical_Kirki::add_section( 'practical_pages_settings', array(
    'title'      => esc_html__( 'Pages', 'ef-practical' ),
    'priority'   => 30,
    'capability' => 'edit_theme_options',
) );
    
    // Align Featured Image
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'radio-buttonset',
        'settings' => 'practical_page_align_featured_img',
        'label'    => esc_html__( 'Align Featured Image', 'ef-practical' ),
        'section'  => 'practical_pages_settings',
        'default'  => 'center',
        'choices'  => array(
            'left'   => esc_html__( 'Left', 'ef-practical' ),
            'center' => esc_html__( 'Center', 'ef-practical' ),
            'right'  => esc_html__( 'Right', 'ef-practical' ),
        ),
        'transport' => 'auto',
        'output'    => array(
            array(
                'element'  => '.page .featured-image',
                'property' => 'text-align'
            ),
        ),
    ) );
    
    // Entry Title
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'checkbox',
        'settings' => 'practical_page_entry_title',
        'label'    => esc_html__( 'Show entry title', 'ef-practical' ),
        'section'  => 'practical_pages_settings',
        'default'  => 0,
    ) );
    
    // Edit Page
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'checkbox',
        'settings' => 'practical_page_edit_link',
        'label'    => esc_html__( 'Hide edit page link', 'ef-practical' ),
        'section'  => 'practical_pages_settings',
        'default'  => 0,
    ) );
    
    // Comments
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'checkbox',
        'settings' => 'practical_page_comments',
        'label'    => esc_html__( 'Show comments', 'ef-practical' ),
        'section'  => 'practical_pages_settings',
        'default'  => 0,
    ) );
    
/* Blog
-----------------------------------------------------*/
Practical_Kirki::add_panel( 'practical_blog_panel', array(
    'priority' => 35,
    'title'    => esc_html__( 'Blog', 'ef-practical' ),
) );
    
    /* Blog Home Page
    ----------------------------------------*/
    Practical_Kirki::add_section( 'practical_blog_home_settings', array(
        'title'      => esc_html__( 'Blog Home Page', 'ef-practical' ),
        'panel'      => 'practical_blog_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Display Posts
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_blog_home_display_posts',
            'label'    => esc_html__( 'Display Posts', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 'list',
            'choices'  => array(
                'list' => esc_html__( 'Default (List)', 'ef-practical' ),
                'grid' => esc_html__( 'Grid', 'ef-practical' ),
            ),
        ) );
        
        // Columns
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_blog_home_columns',
            'label'    => esc_html__( 'Columns', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => '2',
            'choices'  => array(
                '1' => '1',
                '2' => '2',
                '3' => '3',
                '4' => '4',
                '5' => '5',
                '6' => '6',
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_blog_home_display_posts',
                    'operator' => '==',
                    'value'    => 'grid',
                ),
            ),
        ) );
        
        // Posts Content
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_blog_posts_content',
            'label'    => esc_html__( 'Posts Content', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 'excerpt',
            'choices'  => array(
                'excerpt' => esc_html__( 'Excerpt', 'ef-practical' ),
                'content' => esc_html__( 'Full Content', 'ef-practical' ),
            ),
        ) );
        
        // Read More
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_blog_home_read_more',
            'label'    => esc_html__( 'Read More', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 1,
            'choices'  => array(
                'on'  => esc_html__( 'Show', 'ef-practical' ),
                'off' => esc_html__( 'Hide', 'ef-practical' ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_blog_posts_content',
                    'operator' => '==',
                    'value'    => 'excerpt',
                ),
            ),
        ) );
        
        // Featured Image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'select',
            'settings' => 'practical_blog_posts_featured_img',
            'label'    => esc_html__( 'Featured Image', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 'above',
            'multiple' => 1,
            'choices'  => array(
                'above'  => esc_html__( 'Show featured image above content', 'ef-practical' ),
                'beside' => esc_html__( 'Show featured image beside content', 'ef-practical' ),
                'hide'   => esc_html__( 'Hide', 'ef-practical' ),
            ),
        ) );
        
        // Align Featured Image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_blog_align_featured_img',
            'label'    => esc_html__( 'Align Featured Image', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 'center',
            'choices'  => array(
                'left'   => esc_html__( 'Left', 'ef-practical' ),
                'center' => esc_html__( 'Center', 'ef-practical' ),
                'right'  => esc_html__( 'Right', 'ef-practical' ),
            ),
            'transport' => 'auto',
            'output'    => array(
                array(
                    'element'  => '.blog .hentry > .featured-image',
                    'property' => 'text-align'
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_blog_posts_featured_img',
                    'operator' => '==',
                    'value'    => 'above',
                ),
            ),
        ) );
        
        // Change Page Title
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'text',
            'settings'  => 'practical_blog_home_change_title',
            'label'     => esc_html__( 'Change blog page title', 'ef-practical' ),
            'section'   => 'practical_blog_home_settings',
            'default'   => '',
            'transport' => 'postMessage',
            'js_vars'   => array(
                array(
                    'element'  => '.page-header .page-title',
                    'function' => 'html'
                )
            )
        ) );
        
        // Page Title
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_blog_home_page_title',
            'label'    => esc_html__( 'Show blog page title', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 0,
        ) );
        
        // Author Name
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_blog_posts_author_name',
            'label'    => esc_html__( 'Hide Author Name', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 0,
        ) );
        
        // Date
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_blog_posts_date',
            'label'    => esc_html__( 'Hide Date', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 0,
        ) );
        
        // Comments Number
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_blog_posts_comments_number',
            'label'    => esc_html__( 'Hide Comments Number', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 0,
        ) );
        
        // Categories
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_blog_posts_categories',
            'label'    => esc_html__( 'Hide Categories', 'ef-practical' ),
            'section'  => 'practical_blog_home_settings',
            'default'  => 0,
        ) );
        
    /* Archive Pages
    ----------------------------------------*/
    Practical_Kirki::add_section( 'practical_archives_settings', array(
        'title'      => esc_html__( 'Archive Pages', 'ef-practical' ),
        'panel'      => 'practical_blog_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Display Posts
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_archives_display_posts',
            'label'    => esc_html__( 'Display Posts', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 'list',
            'choices'  => array(
                'list' => esc_html__( 'Default (List)', 'ef-practical' ),
                'grid' => esc_html__( 'Grid', 'ef-practical' ),
            ),
        ) );
        
        // Columns
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_archives_columns',
            'label'    => esc_html__( 'Columns', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => '2',
            'choices'  => array(
                '1' => '1',
                '2' => '2',
                '3' => '3',
                '4' => '4',
                '5' => '5',
                '6' => '6',
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_archives_display_posts',
                    'operator' => '==',
                    'value'    => 'grid',
                ),
            ),
        ) );
        
        // Posts Content
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_archives_content',
            'label'    => esc_html__( 'Posts Content', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 'excerpt',
            'choices'  => array(
                'excerpt' => esc_html__( 'Excerpt', 'ef-practical' ),
                'content' => esc_html__( 'Full Content', 'ef-practical' ),
            ),
        ) );
        
        // Read More
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_archives_read_more',
            'label'    => esc_html__( 'Read More', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 1,
            'choices'  => array(
                'on'  => esc_html__( 'Show', 'ef-practical' ),
                'off' => esc_html__( 'Hide', 'ef-practical' ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_archives_content',
                    'operator' => '==',
                    'value'    => 'excerpt',
                ),
            ),
        ) );
        
        // Featured Image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'select',
            'settings' => 'practical_archives_featured_img',
            'label'    => esc_html__( 'Featured Image', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 'above',
            'multiple' => 1,
            'choices'  => array(
                'above'  => esc_html__( 'Show featured image above content', 'ef-practical' ),
                'beside' => esc_html__( 'Show featured image beside content', 'ef-practical' ),
                'hide'   => esc_html__( 'Hide', 'ef-practical' ),
            ),
        ) );
        
        // Align Featured Image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_archives_align_featured_img',
            'label'    => esc_html__( 'Align Featured Image', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 'center',
            'choices'  => array(
                'left'   => esc_html__( 'Left', 'ef-practical' ),
                'center' => esc_html__( 'Center', 'ef-practical' ),
                'right'  => esc_html__( 'Right', 'ef-practical' ),
            ),
            'transport' => 'auto',
            'output'    => array(
                array(
                    'element'  => '.archive .hentry > .featured-image',
                    'property' => 'text-align'
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_archives_featured_img',
                    'operator' => '==',
                    'value'    => 'above',
                ),
            ),
        ) );
        
        // Page Title
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_archives_page_title',
            'label'    => esc_html__( 'Show archives page title', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 0,
        ) );
        
        // Author Name
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_archives_author_name',
            'label'    => esc_html__( 'Hide Author Name', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 0,
        ) );
        
        // Date
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_archives_date',
            'label'    => esc_html__( 'Hide Date', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 0,
        ) );
        
        // Comments Number
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_archives_comments_number',
            'label'    => esc_html__( 'Hide Comments Number', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 0,
        ) );
        
        // Categories
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_archives_categories',
            'label'    => esc_html__( 'Hide Categories', 'ef-practical' ),
            'section'  => 'practical_archives_settings',
            'default'  => 0,
        ) );
        
    /* Search Results Page
    ----------------------------------------*/
    Practical_Kirki::add_section( 'practical_search_results_settings', array(
        'title'      => esc_html__( 'Search Results Page', 'ef-practical' ),
        'panel'      => 'practical_blog_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Display Posts
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_search_results_display_posts',
            'label'    => esc_html__( 'Display Posts', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 'list',
            'choices'  => array(
                'list' => esc_html__( 'Default (List)', 'ef-practical' ),
                'grid' => esc_html__( 'Grid', 'ef-practical' ),
            ),
        ) );
        
        // Columns
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_search_results_columns',
            'label'    => esc_html__( 'Columns', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => '2',
            'choices'  => array(
                '1' => '1',
                '2' => '2',
                '3' => '3',
                '4' => '4',
                '5' => '5',
                '6' => '6',
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_archives_display_posts',
                    'operator' => '==',
                    'value'    => 'grid',
                ),
            ),
        ) );
        
        // Posts Content
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_search_results_content',
            'label'    => esc_html__( 'Posts Content', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 'excerpt',
            'choices'  => array(
                'excerpt' => esc_html__( 'Excerpt', 'ef-practical' ),
                'content' => esc_html__( 'Full Content', 'ef-practical' ),
            ),
        ) );
        
        // Read More
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'switch',
            'settings' => 'practical_search_results_read_more',
            'label'    => esc_html__( 'Read More', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 1,
            'choices'  => array(
                'on'  => esc_html__( 'Show', 'ef-practical' ),
                'off' => esc_html__( 'Hide', 'ef-practical' ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_search_results_content',
                    'operator' => '==',
                    'value'    => 'excerpt',
                ),
            ),
        ) );
        
        // Featured Image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'select',
            'settings' => 'practical_search_results_featured_img',
            'label'    => esc_html__( 'Featured Image', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 'above',
            'multiple' => 1,
            'choices'  => array(
                'above'  => esc_html__( 'Show featured image above content', 'ef-practical' ),
                'beside' => esc_html__( 'Show featured image beside content', 'ef-practical' ),
                'hide'   => esc_html__( 'Hide', 'ef-practical' ),
            ),
        ) );
        
        // Align Featured Image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_search_results_align_featured_img',
            'label'    => esc_html__( 'Align Featured Image', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 'center',
            'choices'  => array(
                'left'   => esc_html__( 'Left', 'ef-practical' ),
                'center' => esc_html__( 'Center', 'ef-practical' ),
                'right'  => esc_html__( 'Right', 'ef-practical' ),
            ),
            'transport' => 'auto',
            'output'    => array(
                array(
                    'element'  => '.search .hentry > .featured-image',
                    'property' => 'text-align'
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_search_results_featured_img',
                    'operator' => '==',
                    'value'    => 'above',
                ),
            ),
        ) );
        
        // Page Title
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_search_page_title',
            'label'    => esc_html__( 'Show search results page title', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 0,
        ) );
        
        // Author Name
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_search_results_author_name',
            'label'    => esc_html__( 'Hide Author Name', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 0,
        ) );
        
        // Date
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_search_results_date',
            'label'    => esc_html__( 'Hide Date', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 0,
        ) );
        
        // Comments Number
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_search_results_comments_number',
            'label'    => esc_html__( 'Hide Comments Number', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 0,
        ) );
        
        // Categories
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_search_results_categories',
            'label'    => esc_html__( 'Hide Categories', 'ef-practical' ),
            'section'  => 'practical_search_results_settings',
            'default'  => 0,
        ) );
        
    /* Single Post Page
    ----------------------------------------*/
    Practical_Kirki::add_section( 'practical_single_post_settings', array(
        'title'      => esc_html__( 'Single Post Page', 'ef-practical' ),
        'panel'      => 'practical_blog_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Featured Image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_featured_img',
            'label'    => esc_html__( 'Hide featured image', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Align Featured Image
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_single_post_align_featured_img',
            'label'    => esc_html__( 'Align Featured Image', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 'center',
            'choices'  => array(
                'left'   => esc_html__( 'Left', 'ef-practical' ),
                'center' => esc_html__( 'Center', 'ef-practical' ),
                'right'  => esc_html__( 'Right', 'ef-practical' ),
            ),
            'transport' => 'auto',
            'output'    => array(
                array(
                    'element'  => '.single .hentry > .featured-image',
                    'property' => 'text-align'
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_single_post_featured_img',
                    'operator' => '==',
                    'value'    => 0,
                ),
            ),
        ) );
        
        // Entry Title
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_post_entry_title',
            'label'    => esc_html__( 'Show entry title', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Author Name
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_author_name',
            'label'    => esc_html__( 'Hide Author Name', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Date
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_date',
            'label'    => esc_html__( 'Hide Date', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Comments Number
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_comments_number',
            'label'    => esc_html__( 'Hide Comments Number', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Categories
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_categories',
            'label'    => esc_html__( 'Hide Categories', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Tags
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_tags',
            'label'    => esc_html__( 'Hide Tags', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Edit Link
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_edit_link',
            'label'    => esc_html__( 'Hide Edit Link', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Author Box
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_author_info',
            'label'    => esc_html__( 'Show Author Box', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Prev/Next Navigation
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_single_post_post_nav',
            'label'    => esc_html__( 'Hide Prev/Next Navigation', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Navigation type
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio',
            'settings' => 'practical_single_post_nav_type',
            'label'    => esc_html__( 'Navigation type', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 'below',
            'choices'  => array(
                'below' => esc_html__( 'Below a post content', 'ef-practical' ),
                'side'  => esc_html__( 'On sides of the screen', 'ef-practical' ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_single_post_post_nav',
                    'operator' => '==',
                    'value'    => 0,
                ),
            ),
        ) );
        
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'custom',
            'settings' => 'practical_related_posts_info',
            'section'  => 'practical_single_post_settings',
            'default'  => '<h1 style="text-align:center; padding:0;">' . esc_html__( 'Related Posts', 'ef-practical' ) . '</h1>',
        ) );
        
        // Related Posts
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_related_posts',
            'label'    => esc_html__( 'Hide Related Posts', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
        // Related Posts Title
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'text',
            'settings' => 'practical_related_posts_title',
            'label'    => esc_html__( 'Related Posts Title', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => esc_html__( 'You make also like', 'ef-practical' ),
        ) );
        
        // Display Related Posts By
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_related_by',
            'label'    => esc_html__( 'Display Related Posts By:', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 'categories',
            'choices'  => array(
                'categories' => esc_html__( 'Categories', 'ef-practical' ),
                'tags'       => esc_html__( 'Tags', 'ef-practical' ),
            ),
        ) );
        
        // Amount of Related Posts
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'select',
            'settings' => 'practical_numbers_related_post',
            'label'    => esc_html__( 'Amount of Related Posts', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => '4',
            'multiple' => 1,
            'choices'  => array(
                '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6', '7' => '7', '8' => '8',
            ),
        ) );
        
        // Column Related Posts
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_columns_related_post',
            'label'    => esc_html__( 'Columns', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 'col-md-6',
            'multiple' => 1,
            'choices'  => array(
                'col-md-12' => '1',
                'col-md-6'  => '2',
            ),
        ) );
        
        // Order Related Posts
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'select',
            'settings' => 'practical_related_orderby',
            'label'    => esc_html__( 'Order Related Posts', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 'rand',
            'multiple' => 1,
            'choices'  => array(
                'rand'  => esc_html__( 'Random', 'ef-practical' ),
                'date'  => esc_html__( 'Date', 'ef-practical' ),
                'title' => esc_html__( 'Title', 'ef-practical' ),
            ),
        ) );
        
        // Date
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => 'practical_date_related_posts',
            'label'    => esc_html__( 'Hide date from related posts', 'ef-practical' ),
            'section'  => 'practical_single_post_settings',
            'default'  => 0,
        ) );
        
    /* More Settings
    ----------------------------------------*/
    Practical_Kirki::add_section( 'practical_blog_more_settings', array(
        'title'      => esc_html__( 'More Settings', 'ef-practical' ),
        'panel'      => 'practical_blog_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Excerpt length
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'number',
            'settings' => 'practical_excerpt_length',
            'label'    => esc_html__( 'Excerpt length', 'ef-practical' ),
            'section'  => 'practical_blog_more_settings',
            'default'  => 50,
            'choices'  => array(
                'min'  => 0,
                'step' => 1,
            ),
        ) );
        
        // Read More Label
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'text',
            'settings'  => 'practical_read_more_label',
            'label'     => esc_html__( 'Read More Label', 'ef-practical' ),
            'section'   => 'practical_blog_more_settings',
            'default'   => esc_html__( 'Continue Reading', 'ef-practical' ),
            'transport' => 'postMessage',
        ) );
        
        // Read more type
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_read_more_type',
            'label'    => esc_html__( 'Read more type', 'ef-practical' ),
            'section'  => 'practical_blog_more_settings',
            'default'  => 'link',
            'choices'  => array(
                'link'   => esc_html__( 'Default (Text link)', 'ef-practical' ),
                'button' => esc_html__( 'Button', 'ef-practical' ),
            ),
        ) );
        
        // Paged
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_paged_type',
            'label'    => esc_html__( 'Paged', 'ef-practical' ),
            'section'  => 'practical_blog_more_settings',
            'default'  => 'pagination',
            'choices'  => array(
                'pagination' => esc_html__( 'Pagination', 'ef-practical' ),
                'navigation' => esc_html__( 'Nav (Previous / Next)', 'ef-practical' ),
            ),
        ) );
        
/* Footer
----------------------------------------*/
Practical_Kirki::add_section( 'practical_footer_settings', array(
    'title'      => esc_html__( 'Footer', 'ef-practical' ),
    'priority'   => 40,
    'capability' => 'edit_theme_options',
) );
    
    // Footer Social
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_footer_social',
        'label'    => esc_html__( 'Show social in footer.', 'ef-practical' ),
        'section'  => 'practical_footer_settings',
        'default'  => 0,
        'choices'  => array(
            'on'  => esc_html__( 'Show', 'ef-practical' ),
            'off' => esc_html__( 'Hide', 'ef-practical' ),
        ),
    ) );
    
    // Footer layout
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'radio',
        'settings' => 'practical_footer_layout',
        'label'    => esc_html__( 'Footer layout', 'ef-practical' ),
        'section'  => 'practical_footer_settings',
        'default'  => 'right_social',
        'choices'  => array(
            'right_social' => esc_html__( 'Left Info - Right Social', 'ef-practical' ),
            'left_social'  => esc_html__( 'Right Info - Left Social', 'ef-practical' ),
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_footer_social',
                'operator' => '==',
                'value'    => 1,
            ),
        ),
    ) );
    
    // Credit
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_footer_credit',
        'label'    => esc_html__( 'Credit', 'ef-practical' ),
        'section'  => 'practical_footer_settings',
        'default'  => 1,
        'choices'  => array(
            'on'  => esc_html__( 'Show', 'ef-practical' ),
            'off' => esc_html__( 'Hide', 'ef-practical' ),
        ),
    ) );
    
    // Copyright
    Practical_Kirki::add_field( 'practical_config', array(
       'type'     => 'textarea',
       'settings' => 'practical_footer_copyright',
       'label'    => esc_html__( 'Copyright', 'ef-practical' ),
       'section'  => 'practical_footer_settings',
       'default'  => '',
    ));
    
/* Lightbox
---------------------------------*/
Practical_Kirki::add_section( 'practical_lightbox_settings', array(
    'title'      => esc_html__( 'Lightbox', 'ef-practical' ),
    'priority'   => 45,
    'capability' => 'edit_theme_options',
) );
    
    // Enable lightbox
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_enable_lightbox',
        'label'    => esc_html__( 'Enable lightbox', 'ef-practical' ),
        'section'  => 'practical_lightbox_settings',
        'default'  => 0,
        'choices'  => array(
            'on'  => esc_html__( 'Enable', 'ef-practical' ),
            'off' => esc_html__( 'Disable', 'ef-practical' ),
        ),
    ) );
    
    // Enable lightbox for featured image post
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_lightbox_featured_img',
        'label'    => esc_html__( 'Lightbox for pages and single post featured images.', 'ef-practical' ),
        'section'  => 'practical_lightbox_settings',
        'default'  => 0,
        'choices'  => array(
            'on'  => esc_html__( 'Enable', 'ef-practical' ),
            'off' => esc_html__( 'Disable', 'ef-practical' ),
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );
    
    // Enable lightbox for image on content area
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_lightbox_content_area_img',
        'label'    => esc_html__( 'Lightbox for post images that are inside the post content area and galleries.', 'ef-practical' ),
        'section'  => 'practical_lightbox_settings',
        'default'  => 0,
        'choices'  => array(
            'on'  => esc_html__( 'Enable', 'ef-practical' ),
            'off' => esc_html__( 'Disable', 'ef-practical' ),
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );
    
    // Animation effect
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'select',
        'settings' => 'practical_lightbox_animation_effect',
        'label'    => esc_html__( 'Open/close animation type', 'ef-practical' ),
        'section'  => 'practical_lightbox_settings',
        'default'  => 'zoom-in-out',
        'multiple' => 1,
        'choices'  => array(
            'zoom-in-out' => esc_html__( 'Zoom In Out', 'ef-practical' ),
            'zoom'        => esc_html__( 'Zoom', 'ef-practical' ),
            'fade'        => esc_html__( 'Fade', 'ef-practical' ),
            'false'       => esc_html__( 'Disable', 'ef-practical' ),
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );
    
    // Transition effect
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'select',
        'settings' => 'practical_lightbox_transition_effect',
        'label'    => esc_html__( 'Transition effect between slides', 'ef-practical' ),
        'section'  => 'practical_lightbox_settings',
        'default'  => 'circular',
        'multiple' => 1,
        'choices'  => array(
            'circular'    => esc_html__( 'Circular', 'ef-practical' ),
            'fade'        => esc_html__( 'Fade', 'ef-practical' ),
            'rotate'      => esc_html__( 'Rotate', 'ef-practical' ),
            'slide'       => esc_html__( 'Slide', 'ef-practical' ),
            'tube'        => esc_html__( 'Tube', 'ef-practical' ),
            'zoom-in-out' => esc_html__( 'Zoom In Out', 'ef-practical' ),
            'false'       => esc_html__( 'Disable', 'ef-practical' ),
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );

    // Transition duration
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'slider',
        'settings'  => 'practical_lightbox_transition_duration',
        'label'     => esc_html__( 'Duration in ms for transition animation', 'ef-practical' ),
        'section'   => 'practical_lightbox_settings',
        'default'   => 1000,
        'transport' => 'auto',
        'choices'  => array(
            'min'  => '100',
            'max'  => '5000',
            'step' => '50',
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );
    
    // Autoplay
    Practical_Kirki::add_field( 'practical_config', array(
        'type'     => 'switch',
        'settings' => 'practical_lightbox_auto_play',
        'label'    => esc_html__( 'Enable autoplay the lightbox gallery.', 'ef-practical' ),
        'section'  => 'practical_lightbox_settings',
        'default'  => 0,
        'choices'  => array(
            'on'  => esc_html__( 'Enable', 'ef-practical' ),
            'off' => esc_html__( 'Disable', 'ef-practical' ),
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );
    
    // Slideshow Speed
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'slider',
        'settings'  => 'practical_lightbox_slideshow_speed',
        'label'     => esc_html__( 'Slideshow Speed', 'ef-practical' ),
        'section'   => 'practical_lightbox_settings',
        'default'   => 4000,
        'transport' => 'auto',
        'choices'   => array(
            'min'  => '100',
            'max'  => '10000',
            'step' => '100',
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
            array(
                'setting'  => 'practical_lightbox_auto_play',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );
    
    // Background
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'color',
        'settings'  => 'practical_lightbox_bg',
        'label'     => esc_html__( 'Background', 'ef-practical' ),
        'section'   => 'practical_lightbox_settings',
        'default'   => '#ffffff',
        'transport' => 'auto',
        'output'    => array(
            array(
                'element'  => '.fancybox-container .fancybox-bg',
                'property' => 'background',
            ),
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );
    
    // Opacity background
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'slider',
        'settings'  => 'practical_opacity_bg_lightbox',
        'label'     => esc_html__( 'Opacity background behind the lightbox.', 'ef-practical' ),
        'section'   => 'practical_lightbox_settings',
        'default'   => 0.5,
        'transport' => 'auto',
        'choices'   => array(
            'min'  => '0',
            'max'  => '1',
            'step' => '0.1',
        ),
        'output' => array(
            array(
                'element'  => '.fancybox-is-open .fancybox-bg',
                'property' => 'opacity',
            )
        ),
        'active_callback' => array(
            array(
                'setting'  => 'practical_enable_lightbox',
                'operator' => '!=',
                'value'    => 0,
            ),
        ),
    ) );

/* Social
----------------------------------------*/
Practical_Kirki::add_section( 'practical_social_settings', array(
    'title'       => esc_html__( 'Social Links', 'ef-practical' ),
    'description' => esc_html__( 'Icons will not be shown if left blank.', 'ef-practical' ),
    'priority'    => 50,
    'capability'  => 'edit_theme_options',
) );
    
    $social_links = array(
        'social_facebook' => array(
            'id'      => 'social_facebook',
            'title'   => esc_html__( 'Facebook', 'ef-practical' ),
            'default' => ''
        ),
        'social_twitter' => array(
            'id'      => 'social_twitter',
            'title'   => esc_html__( 'Twitter', 'ef-practical' ),
            'default' => ''
        ),
        'social_googleplus' => array(
            'id'      => 'social_googleplus',
            'title'   => esc_html__( 'Google-Plus', 'ef-practical' ),
            'default' => ''
        ),
        'social_youtube' => array(
            'id'      => 'social_youtube',
            'title'   => esc_html__( 'Youtube', 'ef-practical' ),
            'default' => ''
        ),
        'social_pinterest' => array(
            'id'      => 'social_pinterest',
            'title'   => esc_html__( 'Pinterest', 'ef-practical' ),
            'default' => ''
        ),
        'social_instagram' => array(
            'id'      => 'social_instagram',
            'title'   => esc_html__( 'Instagram', 'ef-practical' ),
            'default' => ''
        ),
        'social_linkedin' => array(
            'id'      => 'social_linkedin',
            'title'   => esc_html__( 'Linkedin', 'ef-practical' ),
            'default' => ''
        ),
        'social_flickr' => array(
            'id'      => 'social_flickr',
            'title'   => esc_html__( 'Flickr', 'ef-practical' ),
            'default' => ''
        ),
        'social_rss' => array(
            'id'      => 'social_rss',
            'title'   => esc_html__( 'RSS', 'ef-practical' ),
            'default' => ''
        ),
    );
    
    foreach( $social_links as $social_link ) {
        
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'url',
            'settings' => $social_link['id'],
            'label'    => $social_link['title'],
            'section'  => 'practical_social_settings',
            'default'  => $social_link['default'],
        ));
        
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'checkbox',
            'settings' => $social_link['id'].'_check',
            'label'    => esc_html__( 'Check to open in a new window', 'ef-practical' ),
            'section'  => 'practical_social_settings',
            'default'  => 0,
        ) );
        
    }
    
/* Desing
-----------------------------------------------------*/
Practical_Kirki::add_panel( 'practical_design_panel', array(
    'priority' => 55,
    'title'    => esc_html__( 'Design', 'ef-practical' ),
) );
    
    /* Site Layout
    ---------------------------------*/
    Practical_Kirki::add_section( 'practical_layout_settings', array(
        'title'      => esc_html__( 'Site Layout', 'ef-practical' ),
        'priority'   => 1,
        'panel'      => 'practical_design_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Layout
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-buttonset',
            'settings' => 'practical_site_layout',
            'label'    => esc_html__( 'Choose your site layout.', 'ef-practical' ),
            'section'  => 'practical_layout_settings',
            'default'  => 'wide',
            'choices'  => array(
                'wide'  => esc_html__( 'Wide', 'ef-practical' ),
                'boxed' => esc_html__( 'Boxed', 'ef-practical' ),
            ),
        ) );
        
        // Layout width
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_layout_width',
            'label'     => esc_html__( 'Layout width (px)', 'ef-practical' ),
            'section'   => 'practical_layout_settings',
            'default'   => '1270',
            'transport' => 'auto',
            'choices'   => array(
                'min'  => '1000',
                'max'  => '1920',
                'step' => '10',
            ),
            'output' => array(
                array(
                    'element'  => '.ef-container, .boxed #page, .boxed.sticky-header #masthead.sticky',
                    'property' => 'max-width',
                    'units'    => 'px',
                ),
            ),
        ) );
        
        // Default Layout
        Practical_Kirki::add_field( 'practical_config', array(
            'type'        => 'radio-image',
            'settings'    => 'practical_default_layout',
            'label'       => esc_html__( 'Default Layout', 'ef-practical' ),
            'description' => esc_html__( 'This layout will be reflected in whole site archives, search etc.', 'ef-practical' ),
            'section'     => 'practical_layout_settings',
            'default'     => 'right-sidebar',
            'choices'     => array(
                'right-sidebar' => get_template_directory_uri() . '/images/layout/2cr.png',
                'left-sidebar'  => get_template_directory_uri() . '/images/layout/2cl.png',
                'two-sidebar'   => get_template_directory_uri() . '/images/layout/3cm.png',
                'no-sidebar'    => get_template_directory_uri() . '/images/layout/1c.png',
            ),
        ) );
        
        // Sidebar Width
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_sidebar_width',
            'label'     => esc_html__( 'Sidebar Width (%)', 'ef-practical' ),
            'section'   => 'practical_layout_settings',
            'default'   => 25,
            'transport' => 'postMessage',
            'choices'   => array(
                'min'  => '15',
                'max'  => '50',
                'step' => '1',
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_default_layout',
                    'operator' => '!=',
                    'value'    => 'no-sidebar',
                ),
            ),
        ) );
        
    /* Pages Layout
    ---------------------------------*/
    Practical_Kirki::add_section( 'practical_pages_layout_settings', array(
        'title'      => esc_html__( 'Layout Pages', 'ef-practical' ),
        'priority'   => 2,
        'panel'      => 'practical_design_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Layout Select
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-image',
            'settings' => 'practical_pages_layout',
            'label'    => esc_html__( 'Select layout for pages.', 'ef-practical' ),
            'section'  => 'practical_pages_layout_settings',
            'default'  => 'right-sidebar',
            'choices'  => array(
                'right-sidebar' => get_template_directory_uri() . '/images/layout/2cr.png',
                'left-sidebar'  => get_template_directory_uri() . '/images/layout/2cl.png',
                'two-sidebar'   => get_template_directory_uri() . '/images/layout/3cm.png',
                'no-sidebar'    => get_template_directory_uri() . '/images/layout/1c.png',
            ),
        ) );
        
        // Sidebar Width
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_pages_sidebar_width',
            'label'     => esc_html__( 'Sidebar Width (%)', 'ef-practical' ),
            'section'   => 'practical_pages_layout_settings',
            'default'   => 25,
            'transport' => 'postMessage',
            'choices'   => array(
                'min'  => '15',
                'max'  => '50',
                'step' => '1',
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_pages_layout',
                    'operator' => '!=',
                    'value'    => 'no-sidebar',
                ),
            ),
        ) );
        
    /* Single Posts Layout
    ---------------------------------*/
    Practical_Kirki::add_section( 'practical_single_layout_settings', array(
        'title'      => esc_html__( 'Layout Single Posts', 'ef-practical' ),
        'priority'   => 3,
        'panel'      => 'practical_design_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Layout Select
        Practical_Kirki::add_field( 'practical_config', array(
            'type'     => 'radio-image',
            'settings' => 'practical_single_posts_layout',
            'label'    => esc_html__( 'Select layout for single posts.', 'ef-practical' ),
            'section'  => 'practical_single_layout_settings',
            'default'  => 'right-sidebar',
            'choices'  => array(
                'right-sidebar' => get_template_directory_uri() . '/images/layout/2cr.png',
                'left-sidebar'  => get_template_directory_uri() . '/images/layout/2cl.png',
                'two-sidebar'   => get_template_directory_uri() . '/images/layout/3cm.png',
                'no-sidebar'    => get_template_directory_uri() . '/images/layout/1c.png',
            ),
        ) );
        
        // Sidebar Width
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'slider',
            'settings'  => 'practical_single_sidebar_width',
            'label'     => esc_html__( 'Sidebar Width (%)', 'ef-practical' ),
            'section'   => 'practical_single_layout_settings',
            'default'   => 25,
            'transport' => 'postMessage',
            'choices'   => array(
                'min'  => '15',
                'max'  => '40',
                'step' => '1',
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'practical_single_posts_layout',
                    'operator' => '!=',
                    'value'    => 'no-sidebar',
                ),
            ),
        ) );
        
    /* Colors
    ---------------------------------*/
        // Primary Color
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'color',
            'settings'  => 'practical_primary_color',
            'label'     => esc_html__( 'Primary Color', 'ef-practical' ),
            'section'   => 'colors',
            'default'   => '#919191',
            'transport' => 'auto',
            'output' => array(
                array(
                    'element'  => 'a, .menu-toggle, .close-menu-button, .related-item-title, .search-toggle',
                    'property' => 'color',
                ),
                array(
                    'element'  => '.button, button, input[type="button"], input[type="reset"], input[type="submit"], .pagination a, .pagination .current, .entry-thumbnail:hover > a, .float-scroll-top',
                    'property' => 'background',
                ),
                array(
                    'element'  => '.tagcloud a, .comment-reply-link, .comment-edit-link',
                    'property' => 'border-color',
                ),
            ),
        ) );
        
        // Secondary Color
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'color',
            'settings'  => 'practical_second_color',
            'label'     => esc_html__( 'Secondary Color', 'ef-practical' ),
            'section'   => 'colors',
            'default'   => '#0b6baa',
            'transport' => 'auto',
            'output' => array(
                array(
                    'element'  => 'a:hover, .main-navigation a:hover, .main-navigation li:hover > a, .main-navigation li.current_page_item > a, .main-navigation li.current-menu-item > a, .main-navigation li.current_page_ancestor > a, .main-navigation li.current-menu-ancestor > a, .menu-toggle:hover, .close-menu-button:hover, .menu-toggle .fa-times, .mobile-nav a:hover, .mobile-nav li:hover > a, .mobile-nav li.current_page_item > a, .mobile-nav li.current-menu-item > a, .mobile-nav li.current_page_ancestor > a, .mobile-nav li.current-menu-ancestor > a, .entry-title a:hover, .page-links a:hover .page-number, .page-links > .page-number, .related-posts-item:hover .related-item-title, ul.comments li.bypostauthor .comment-author:after, ul.comments li.comment-author-admin .comment-author:after, .site-title a:hover, .search-toggle:hover',
                    'property' => 'color',
                ),
                array(
                    'element'  => '.button:hover, button:hover, button:focus, button:active, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, input[type="button"]:focus, input[type="reset"]:focus, input[type="submit"]:focus, input[type="button"]:active, input[type="reset"]:active, input[type="submit"]:active, .pagination a:hover, .pagination .current, .entry-thumbnail a:hover, .float-scroll-top:hover, .comments-tabs li a:hover, .comments-tabs li.active-tab a',
                    'property' => 'background',
                ),
                array(
                    'element'  => 'blockquote, .tagcloud a:hover, .comment-reply-link:hover, .comment-edit-link:hover',
                    'property' => 'border-color',
                ),
            ),
        ) );
        
        // Buttons Font Color
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'color',
            'settings'  => 'practical_buttons_font_color',
            'label'     => esc_html__( 'Buttons Font Color', 'ef-practical' ),
            'section'   => 'colors',
            'default'   => '#ffffff',
            'transport' => 'auto',
            'output' => array(
                array(
                    'element'  => '.button, .button:hover, button, input[type="button"], input[type="reset"], input[type="submit"], .pagination a, .pagination a:hover, .pagination .current, .entry-thumbnail a, .entry-thumbnail a:hover, .float-scroll-top, .float-scroll-top:hover, .comments-tabs li a:hover, .comments-tabs li.active-tab a',
                    'property' => 'color',
                ),
            ),
        ) );
        
    /* Footer Colors
    ---------------------------------*/
    Practical_Kirki::add_section( 'practical_footer_colors', array(
        'title'      => esc_html__( 'Footer Colors', 'ef-practical' ),
        'priority'   => 5,
        'panel'      => 'practical_design_panel',
        'capability' => 'edit_theme_options',
    ) );
        
        // Primary Color
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'color',
            'settings'  => 'practical_footer_primary_color',
            'label'     => esc_html__( 'Primary Color', 'ef-practical' ),
            'section'   => 'practical_footer_colors',
            'default'   => '#919191',
            'transport' => 'auto',
            'output' => array(
                array(
                    'element'  => '.site-footer a',
                    'property' => 'color',
                ),
                array(
                    'element'  => '.site-footer .button, .site-footer button, .site-footer input[type="button"], .site-footer input[type="reset"], .site-footer input[type="submit"]',
                    'property' => 'background',
                ),
                array(
                    'element'  => '.site-footer .tagcloud a',
                    'property' => 'border-color',
                ),
            ),
        ) );
        
        // Secondary Color
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'color',
            'settings'  => 'practical_footer_second_color',
            'label'     => esc_html__( 'Secondary Color', 'ef-practical' ),
            'section'   => 'practical_footer_colors',
            'default'   => '#0b6baa',
            'transport' => 'auto',
            'output' => array(
                array(
                    'element'  => '.site-footer a:hover, .site-footer .widget_pages .page_item.current_page_item > a, .site-footer .widget_nav_menu .menu-item.current-menu-item > a',
                    'property' => 'color',
                ),
                array(
                    'element'  => '.site-footer .button:hover, .site-footer button:hover, .site-footer button:focus, .site-footer button:active, .site-footer input[type="button"]:hover, .site-footer input[type="reset"]:hover, .site-footer input[type="submit"]:hover, .site-footer input[type="button"]:focus, .site-footer input[type="reset"]:focus, .site-footer input[type="submit"]:focus, .site-footer input[type="button"]:active, .site-footer input[type="reset"]:active, .site-footer input[type="submit"]:active',
                    'property' => 'background',
                ),
                array(
                    'element'  => '.site-footer .tagcloud a:hover',
                    'property' => 'border-color',
                ),
            ),
        ) );
        
        // Buttons Font Color
        Practical_Kirki::add_field( 'practical_config', array(
            'type'      => 'color',
            'settings'  => 'practical_footer_buttons_font_color',
            'label'     => esc_html__( 'Buttons Font Color', 'ef-practical' ),
            'section'   => 'practical_footer_colors',
            'default'   => '#ffffff',
            'transport' => 'auto',
            'output' => array(
                array(
                    'element'  => '.site-footer .button, .site-footer .button:hover, .site-footer button, .site-footer input[type="button"], .site-footer input[type="reset"], .site-footer input[type="submit"]',
                    'property' => 'color',
                ),
            ),
        ) );

/* Typography
----------------------------------------*/
Practical_Kirki::add_section( 'practical_typography_settings', array(
    'title'      => esc_html__( 'Typography', 'ef-practical' ),
    'priority'   => 60,
    'capability' => 'edit_theme_options',
) );
    
    // Body
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'typography',
        'settings'  => 'practical_typography_body',
        'label'     => esc_html__( 'Body', 'ef-practical' ),
        'section'   => 'practical_typography_settings',
        'transport' => 'auto',
        'default'   => array(
            'font-family' => 'PT Serif',
        ),
        'output' => array(
            array(
                'element' => 'body',
            ),
        ),
    ) );
    
    // Site Title
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'typography',
        'settings'  => 'practical_typography_site_title',
        'label'     => esc_html__( 'Site Title', 'ef-practical' ),
        'section'   => 'practical_typography_settings',
        'transport' => 'auto',
        'default'   => array(
            'font-family' => 'Playfair Display',
            'variant'     => '700',
            'subsets'     => array( 'latin-ext' ),
        ),
        'output' => array(
            array(
                'element' => '.site-title',
            ),
        ),
    ) );
    
    // Headings
    Practical_Kirki::add_field( 'practical_config', array(
        'type'        => 'typography',
        'settings'    => 'practical_typography_headings',
        'label'       => esc_html__( 'Headings', 'ef-practical' ),
        'description' => 'h1, h2, h3, h4, h5, h6',
        'section'     => 'practical_typography_settings',
        'transport'   => 'auto',
        'default'     => array(
            'font-family' => 'Playfair Display',
            'variant'     => 'regular',
            'subsets'     => array( 'latin-ext' ),
        ),
        'output' => array(
            array(
                'element' => 'h1, h2, h3, h4, h5, h6',
            ),
        ),
    ) );
    
    // Menu
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'typography',
        'settings'  => 'practical_typography_menu',
        'label'     => esc_html__( 'Menu', 'ef-practical' ),
        'section'   => 'practical_typography_settings',
        'transport' => 'auto',
        'default'   => array(
            'font-family' => 'PT Serif',
            'variant'     => '700',
            'subsets'     => array( 'latin-ext' ),
        ),
        'output' => array(
            array(
                'element' => '.main-navigation a, .mobile-nav a',
            ),
        ),
    ) );
    
    // Forms
    Practical_Kirki::add_field( 'practical_config', array(
        'type'      => 'typography',
        'settings'  => 'practical_forms_typography',
        'label'     => esc_html__( 'Forms', 'ef-practical' ),
        'section'   => 'practical_typography_settings',
        'transport' => 'auto',
        'default'   => array(
            'font-family' => 'PT Serif',
            'variant'     => 'regular',
            'subsets'     => array( 'latin-ext' ),
        ),
        'output' => array(
            array(
                'element' => 'input, select, textarea',
            ),
        ),
    ) );

function practical_custom_styles( $custom ) {
    
    $custom = '';
    
    /* Header Layout
    -----------------------------------------------------*/
    $header_layout = get_theme_mod( 'practical_header_layout', 'left_logo' );
    if ( 'right_logo' == $header_layout ) {
        $custom .= ".header-bottom .row {
            -ms-flex-direction: row-reverse !important;
            flex-direction: row-reverse !important;
        }"."\n";
        $custom .= ".site-branding { float: right; }"."\n";
        $custom .= ".main-navigation ul, .menu-toggle { float: left; }"."\n";
        $custom .= ".mobile-nav {
            left: unset;
            right: 0;
            -webkit-transform: translateX(100%);
            -ms-transform: translateX(100%);
            transform: translateX(100%);
        }"."\n";
    }
    if ( 'center_logo' == $header_layout ) {
        $custom .= ".main-navigation { padding: 5px 0; }"."\n";
        $custom .= ".main-navigation ul, .menu-toggle { float: none; text-align: center; }"."\n";
        $custom .= ".main-navigation ul { font-size: 0; }"."\n";
        $custom .= ".main-navigation li { float: none; display: inline-block; vertical-align: top; }"."\n";
        $custom .= ".main-navigation ul ul { text-align: left; }"."\n";
    }
    
    /* Sticky Header
    -----------------------------------------------------*/
    $sticky_header = get_theme_mod( 'practical_sticky_header', 0 );
    $sticky_tablet_header = get_theme_mod( 'practical_tablet_sticky_header', 0 );
    $sticky_mobile_header = get_theme_mod( 'practical_mobile_sticky_header', 0 );
    if ( 0 != $sticky_header && 0 == $sticky_tablet_header ) {
        $custom .= "@media only screen and (min-width: 768px) and (max-width: 991px) {
            .sticky-header.small-header .header-top-bar { height: 36px; line-height: 36px; }
            .sticky-header #masthead.sticky { display: none; }
            .sticky-header #masthead { opacity: 1; visibility: visible; }
        }"."\n";
    }
    if ( 0 != $sticky_header && 0 == $sticky_mobile_header ) {
        $custom .= "@media only screen and (max-width: 767px) {
            .sticky-header #masthead.sticky { display: none; }
            .sticky-header #masthead { opacity: 1; visibility: visible; }
        }"."\n";
    }
    if ( 0 != $sticky_header && 0 != $sticky_mobile_header ) {
        $custom .= "@media only screen and (max-width: 600px) {
            #wpadminbar { position: fixed; }
        }"."\n";
    }
    if ( 0 != $sticky_header && 0 != $sticky_mobile_header && 'center_logo' == $header_layout ) {
        $custom .= "@media only screen and (max-width: 768px) {
            .sticky-header.small-header #masthead.sticky .header-bottom .row { padding-top: 0; padding-bottom: 0; height: 0; }
            .sticky-header.small-header #masthead.sticky .site-title { font-size: 0; }
            .sticky-header.small-header #masthead.sticky .custom-logo { max-height: 0; }
        }"."\n";
        
    }
    
    /* Sidebars width
    -----------------------------------------------------*/
    $sidebar_width  = get_theme_mod( 'practical_sidebar_width', 25 );
    $primary_width  = 100 - $sidebar_width;
    $sidebars_width = $sidebar_width + $sidebar_width;
    $primarys_width = 100 - $sidebars_width;
    $custom .= "@media only screen and (min-width: 768px) {
        #primary.col-md-9 {
            -ms-flex: 0 0 " . absint( $primary_width ) . "%;
            flex: 0 0 " . absint( $primary_width ) . "%;
            max-width:" . absint( $primary_width ) . "%;
        }
        .sidebar.col-md-3 {
            -ms-flex: 0 0 " . absint( $sidebar_width ) . "%;
            flex: 0 0 " . absint( $sidebar_width ) . "%;
            max-width:" . absint( $sidebar_width ) . "%;
        }
        .two-sidebar #primary.col-md-9 {
            -ms-flex: 0 0 " . absint( $primarys_width ) . "%;
            flex: 0 0 " . absint( $primarys_width ) . "%;
            max-width:" . absint( $primarys_width ) . "%;
        }
    }"."\n";
    
    /* Pages Sidebars width
    -----------------------------------------------------*/
    $pages_sidebar_width = get_theme_mod( 'practical_pages_sidebar_width', 25 );
    $pages_primary_width = 100 - $pages_sidebar_width;
    $pages_sidebars_width = $pages_sidebar_width + $pages_sidebar_width;
    $pages_primarys_width  = 100 - $pages_sidebars_width;
    $custom .= "@media only screen and (min-width: 768px) {
        .page #primary.col-md-9 {
            -ms-flex: 0 0 " . absint( $pages_primary_width ) . "%;
            flex: 0 0 " . absint( $pages_primary_width ) . "%;
            max-width:" . absint( $pages_primary_width ) . "%;
        }
        .page .sidebar.col-md-3 {
            -ms-flex: 0 0 " . absint( $pages_sidebar_width ) . "%;
            flex: 0 0 " . absint( $pages_sidebar_width ) . "%;
            max-width:" . absint( $pages_sidebar_width ) . "%;
        }
        .page.two-sidebar #primary.col-md-9 {
            -ms-flex: 0 0 " . absint( $pages_primarys_width ) . "%;
            flex: 0 0 " . absint( $pages_primarys_width ) . "%;
            max-width:" . absint( $pages_primarys_width ) . "%;
        }

    }"."\n";
    
    /* Single Posts Sidebars width
    -----------------------------------------------------*/
    $single_sidebar_width = get_theme_mod( 'practical_single_sidebar_width', 25 );
    $single_primary_width = 100 - $single_sidebar_width;
    $single_sidebars_width = $single_sidebar_width + $single_sidebar_width;
    $single_primarys_width  = 100 - $single_sidebars_width;
    $custom .= "@media only screen and (min-width: 768px) {
        .single #primary.col-md-9 {
            -ms-flex: 0 0 " . absint( $single_primary_width ) . "%;
            flex: 0 0 " . absint( $single_primary_width ) . "%;
            max-width:" . absint( $single_primary_width ) . "%;
        }
        .single .sidebar.col-md-3 {
            -ms-flex: 0 0 " . absint( $single_sidebar_width ) . "%;
            flex: 0 0 " . absint( $single_sidebar_width ) . "%;
            max-width:" . absint( $single_sidebar_width ) . "%;
        }
        .single.two-sidebar #primary.col-md-9 {
            -ms-flex: 0 0 " . absint( $single_primarys_width ) . "%;
            flex: 0 0 " . absint( $single_primarys_width ) . "%;
            max-width:" . absint( $single_primarys_width ) . "%;
        }
    }"."\n";
    
    /* Footer
    -----------------------------------------------------*/
    $footer_layout = get_theme_mod( 'practical_footer_layout', 'right_social' );
    $footer_social = get_theme_mod( 'practical_footer_social', 0 );
    if ( 0 == $footer_social ) {
        $custom .= ".site-info .row { text-align: center; }"."\n";
    }
    if ( 'left_social' == $footer_layout && 0 != $footer_social) {
        $custom .= ".site-info .row {
            -ms-flex-direction: row-reverse !important;
            flex-direction: row-reverse !important;
        }"."\n";
        $custom .= "@media only screen and (min-width: 768px) {
            .site-info .social-links { text-align: left; }
            .site-info .site-info-inner { float: right; text-align: center; }
        }"."\n";
    }
    
    // Output styles
	wp_add_inline_style( 'practical-style', $custom );	
}
add_action( 'wp_enqueue_scripts', 'practical_custom_styles' );




/*
 * Custom Scripts
 */
function practical_customizer_custom_scripts() { ?>
    <style>
        .wp-customizer #customize-theme-controls .accordion-section-content {
            background: #ffffff;
        }
        
        li[id*="customize-control-"] {
            padding: 2%;
            margin: 10px 0;
            width: 95%;
            background: #eeeeee;
            border: 1px solid #e0e0e0;
        }
        
        .customize-section-description-container + #customize-control-custom_css:last-child {
            margin: 0;
            width: 96%;
        }
        
        .customize-control-kirki-radio-image label {
            width: 23%;
            padding: 0 5px 5px 0;
        }
        
        label.customizer-text {
            width: auto;
        }
        
        .customize-control-kirki-generic textarea {
            min-height: 150px;
        }
    </style>
<?php
}
add_action( 'customize_controls_print_footer_scripts', 'practical_customizer_custom_scripts' );



/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function practical_customize_preview_js() {
	wp_enqueue_script( 'practical-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'practical_customize_preview_js' );