<?php
/**
 * Sample implementation of the Custom Header feature
 * http://codex.wordpress.org/Custom_Headers
 *
 * You can add an optional custom header image to header.php like so ...
 *
 * @package Ef Practical
 */

/**
 * Setup the WordPress core custom header feature.
 *
 * @uses practical_header_style()
 *
 */
function practical_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'practical_custom_header_args', array(
		'default-image'          => '%s/images/pexels-photo-326243.jpeg',
		'default-text-color'     => '919191',
		'width'                  => 1920,
		'height'                 => 600,
		'flex-width'			 => true,
		'flex-height'			 => true,
        // 'video'				 => true,
		'wp-head-callback'       => 'practical_header_style',
	) ) );
    
    /*
	 * Default custom headers packaged with the theme.
	 * %s is a placeholder for the theme template directory URI.
	 */
	register_default_headers( array(
		'lake' => array(
			'url'           => '%s/images/pexels-photo-326243.jpeg',
			'thumbnail_url' => '%s/images/pexels-photo-326243.jpeg',
			'description'   => 'Lake'
		),
	) );
    
}
add_action( 'after_setup_theme', 'practical_custom_header_setup' );

if ( ! function_exists( 'practical_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog.
 *
 * @see practical_custom_header_setup().
 */
function practical_header_style() {
	$header_text_color = get_header_textcolor();

	// If no custom options for text are set, let's bail
	// get_header_textcolor() options: HEADER_TEXTCOLOR is default, hide text (returns 'blank') or any hex value
	if ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color ) {
		return;
	}

	// If we get this far, we have custom styles. Let's do this.
	?>
	<style type="text/css">
	<?php
		// Has the text been hidden?
		if ( 'blank' == $header_text_color ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		// If the user has set a custom color for the text use that
		else :
	?>
		.site-title a {
			color: #<?php echo esc_attr( $header_text_color ); /* WPCS: xss ok. */ ?>;
		}
		.site-description {
			color: #<?php echo esc_attr( $header_text_color ); /* WPCS: xss ok. */ ?>;
		}
	<?php endif; ?>
	</style>
	<?php
}
endif;