<?php
/**
 * Entry thumbnail part.
 *
 * @package Ef Practical
 */

if ( is_singular() ) :

?>
    
    <div class="featured-image">
        <?php
            if ( 0 != get_theme_mod( 'practical_lightbox_featured_img', 0 ) ) :
                $image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
                echo '<div class="entry-thumbnail">'; 
        
                    the_post_thumbnail( 'full' );
                    echo '<a class="fancybox" href="' . $image_url[0] . '" title="' . the_title_attribute('echo=0') . '" ><i class="fa fa-search"></i></a>'; // WPCS: XSS ok.
        
                echo '</div>';
            else:
                the_post_thumbnail( 'full' );
            endif;
        ?>
    </div>
    
<?php else: ?>
    
    <div class="featured-image">
        <div class="entry-thumbnail">
            <?php the_post_thumbnail( 'full' ); ?>
            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute('echo=0'); ?>"><i class="fa fa-link"></i></a>
        </div>
    </div>
    
<?php endif; ?>