<?php
/**
 * Custom functions that act independently of the theme templates
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 * @package Ef Practical
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function practical_body_classes( $classes ) {
    
    global $post;
    
	if ( $post ) { $meta_layout = get_post_meta( $post->ID, 'practical_page_sidebar', true ); }
    
    if ( is_home() ) {
		$query_id    = get_option( 'page_for_posts' );
		$meta_layout = get_post_meta( $query_id, 'practical_page_sidebar', true );
	}
    
    if ( empty( $meta_layout ) || is_archive() || is_search() ) { $meta_layout = 'default_sidebar'; }
    
    $layout = get_theme_mod( 'practical_default_layout', 'right-sidebar' );
    $pages_layout = get_theme_mod( 'practical_pages_layout', 'right-sidebar' );
    $post_layout = get_theme_mod( 'practical_single_posts_layout', 'right-sidebar' );
    
    if ( $meta_layout == 'default_sidebar' ) {
        if ( is_page() ) {
            if( $pages_layout == 'right-sidebar' ) { $classes[] = 'right-sidebar'; }
            elseif ( $pages_layout == 'left-sidebar' ) { $classes[] = 'left-sidebar'; }
            elseif ( $pages_layout == 'two-sidebar' ) { $classes[] = 'two-sidebar'; }
            elseif ( $pages_layout == 'no-sidebar' ) { $classes[] = 'no-sidebar'; }
        } elseif ( is_single() ) {
            if ( $post_layout == 'right-sidebar' ) { $classes[] = 'right-sidebar'; }
            elseif ( $post_layout == 'left-sidebar' ) { $classes[] = 'left-sidebar'; }
            elseif ( $post_layout == 'two-sidebar' ) { $classes[] = 'two-sidebar'; }
            elseif ( $post_layout == 'no-sidebar' ) { $classes[] = 'no-sidebar'; }
        }
        elseif ( $layout == 'right-sidebar' ) { $classes[] = 'right-sidebar'; }
        elseif ( $layout == 'left-sidebar' ) { $classes[] = 'left-sidebar'; }
        elseif ( $layout == 'two-sidebar' ) { $classes[] = 'two-sidebar'; }
        elseif ( $layout == 'no-sidebar' ) { $classes[] = 'no-sidebar'; }
    }
    elseif( $meta_layout == 'right_sidebar' ) { $classes[] = 'right-sidebar'; }
	elseif( $meta_layout == 'left_sidebar' ) { $classes[] = 'left-sidebar'; }
	elseif( $meta_layout == 'two_sidebar' ) { $classes[] = 'two-sidebar'; }
	elseif( $meta_layout == 'no_sidebar' ) { $classes[] = 'no-sidebar'; }
    
    // Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
    
    // Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}
    
    if ( 'boxed' == get_theme_mod( 'practical_site_layout', 'wide' ) ) {
		$classes[] = 'boxed';
	} else {
        $classes[] = 'wide';
    }
    
    $classes[] = get_theme_mod( 'practical_header_layout', 'left_logo' );
    
	return $classes;
    
}
add_filter( 'body_class', 'practical_body_classes' );

if ( ! function_exists( 'practical_sidebar' ) ) :
    /**
     * Fucntion to select the sidebar
     */
    function practical_sidebar() {
        
        global $post;
        
        if ( $post ) { $meta_layout = get_post_meta( $post->ID, 'practical_page_sidebar', true ); }
        
        if ( is_home() ) {
            $query_id    = get_option( 'page_for_posts' );
            $meta_layout = get_post_meta( $query_id, 'practical_page_sidebar', true );
        }
        
        if ( empty( $meta_layout ) || is_archive() || is_search() ) { $meta_layout = 'default_sidebar'; }
        
        $layout = get_theme_mod( 'practical_default_layout', 'right-sidebar' );
        $pages_layout = get_theme_mod( 'practical_pages_layout', 'right-sidebar' );
        $post_layout = get_theme_mod( 'practical_single_posts_layout', 'right-sidebar' );
        
        if ( $meta_layout == 'default_sidebar' ) {
            if ( is_page() ) {
                if ( $pages_layout == 'right-sidebar' ) { get_sidebar(); }
                if ( $pages_layout == 'left-sidebar' ) { get_sidebar( 'left' ); }
                if ( $pages_layout == 'two-sidebar' ) { array(
                    get_sidebar( 'left' ),
                    get_sidebar()
                ); }
            } elseif ( is_single() ) {
                if ( $post_layout == 'right-sidebar' ) { get_sidebar(); }
                if ( $post_layout == 'left-sidebar' ) { get_sidebar( 'left' ); }
                if ( $post_layout == 'two-sidebar' ) { array(
                    get_sidebar( 'left' ),
                    get_sidebar()
                ); }
            }
            elseif( $layout == 'right-sidebar' ) { get_sidebar(); }
            elseif( $layout == 'left-sidebar' ) { get_sidebar( 'left' ); }
            elseif( $layout == 'two-sidebar' ) { array(
                get_sidebar( 'left' ),
                get_sidebar()
            ); }
        }
        elseif( $meta_layout == 'right_sidebar' ) { get_sidebar(); }
	    elseif( $meta_layout == 'left_sidebar' ) { get_sidebar( 'left' ); }
        elseif( $meta_layout == 'two_sidebar' ) { array(
            get_sidebar( 'left' ),
            get_sidebar()
        ); }
        
    }
endif;

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function practical_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'practical_pingback_header' );