<?php
/**
 * The template for displaying comments.
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Ef Practical
 */

if ( post_password_required() ) : 
    if (comments_open() ) :
	?>
		<p class="protected"><?php esc_html_e( 'This post is password protected. Enter the password to view any comments.', 'ef-practical' ); ?></p>
	<?php
    endif;
return;
endif;

?>

<section id="comments" class="comments-area cf">
    
	<?php
        if ( have_comments() ) : 
        global $wp_query;
    ?>
        
        <h2 class="comments-title"><i class="fa fa-comments-o"></i>
            <?php comments_number( esc_html__( '0 Responses', 'ef-practical' ), esc_html__( 'One Responses', 'ef-practical' ), '% ' . esc_html__( 'Responses', 'ef-practical' ) ); ?>
        </h2>
        
        <ul class="comments-tabs cf">
            <li class="active-tab"><a href="#comments-list"><i class="fa fa-comments-o"></i> <?php esc_html_e( 'Comments', 'ef-practical' ); ?> <?php echo count($wp_query->comments_by_type['comment']); ?></a></li>
            <li><a href="#pings-list"><i class="fa fa-share"></i> <?php esc_html_e( 'Pingbacks', 'ef-practical' ); ?> <?php echo count($wp_query->comments_by_type['pings']); ?></a></li>
        </ul>
        
		<?php if ( ! empty( $comments_by_type['comment'] ) ) : ?>
            
            <div id="comments-list" class="tab-content">
                
                <?php if ( get_comment_pages_count() > 1 && get_option('page_comments') ) : ?>
                    <div class="comments-navigation navigation comments-nav-top" role="navigation">
                        <div class="nav-links cf">
                            <?php previous_comments_link( '<div class="comments-nav nav-prev"><i class="fa fa-angle-double-left"></i> ' . esc_html__( 'Older Comments', 'ef-practical' ) . '</div>' ); ?>
                            <?php next_comments_link( '<div class="comments-nav nav-next">' . esc_html__( 'Newer Comments', 'ef-practical' ) . ' <i class="fa fa-angle-double-right"></i></div>' ); ?>
                        </div>
                    </div>
                <?php endif; ?>
                
                <ul class="comments">
                    <?php
                        wp_list_comments( array(
                            'avatar_size' => 60,
                            'type'        => 'comment',
                            'callback'    => 'practical_comment'
                        ) );
                    ?>
                </ul>
                
                <?php if ( get_comment_pages_count() > 1 && get_option('page_comments') ) : ?>
                    <div class="comments-navigation navigation comments-nav-bottom" role="navigation">
                        <div class="nav-links cf">
                            <?php previous_comments_link( '<div class="comments-nav nav-prev"><i class="fa fa-angle-double-left"></i> ' . esc_html__( 'Older Comments', 'ef-practical' ) . '</div>' ); ?>
                            <?php next_comments_link( '<div class="comments-nav nav-next">' . esc_html__( 'Newer Comments', 'ef-practical' ) . ' <i class="fa fa-angle-double-right"></i></div>' ); ?>
                        </div>
                    </div>
                <?php endif; ?>
                
            </div>
            
		<?php endif; ?>
        
		<?php if ( ! empty( $comments_by_type['pings'] ) ) : ?>
            
            <div id="pings-list" class="tab-content">
                
                <ol class="ping-list">
                    <?php
                        wp_list_comments( array(
                            'type'     => 'pings',
                            'callback' => 'practical_pings'
                        ) );
                    ?>
                </ol>
                
            </div>
            
		<?php endif; ?>
        
	<?php else: ?>
        
		<?php if (comments_open()) : ?>
            <h2 class="comments-title"><i class="fa fa-comments-o"></i>
                <?php comments_number( esc_html__( '0 Comments', 'ef-practical' ), esc_html__( 'One Comment', 'ef-practical' ), '% ' . esc_html__( 'Comments', 'ef-practical' ) ); ?>
            </h2>	
		<?php endif; ?>
        
	<?php endif; ?>
    
    <?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="nocomments"><?php esc_html_e( 'Comments are closed.', 'ef-practical' ); ?></p>
	<?php endif; ?>
    
	<?php if ( comments_open() ) { comment_form(); } ?>
    
</section><!-- #comments -->