<?php
/**
 * Entry content part.
 *
 * @package Ef Practical
 */

if ( is_archive() ) {
    $content   = get_theme_mod( 'practical_archives_content', 'excerpt' );
    $read_more = get_theme_mod( 'practical_archives_read_more', 1 );
} elseif ( is_search() ) {
    $content   = get_theme_mod( 'practical_search_results_content', 'excerpt' );
    $read_more = get_theme_mod( 'practical_search_results_read_more', 1 );
} else {
    $content   = get_theme_mod( 'practical_blog_posts_content', 'excerpt' );
    $read_more = get_theme_mod( 'practical_blog_home_read_more', 1 );
}

$readmore_label = get_theme_mod( 'practical_read_more_label', esc_html__( 'Continue Reading', 'ef-practical' ) );
$readmore_type  = get_theme_mod( 'practical_read_more_type', 'link' );

?>

<div class="entry-content">
    <?php
        if ( is_singular() ) :
            
            the_content();
            
            //Checks for and uses wp_pagenavi to display page navigation for multi-page posts.
            if ( function_exists( 'wp_pagenavi' ) )
                wp_pagenavi( array( 'type' => 'multipart' ) );
            else
                practical_link_pages();
                
        else:
            
            if ( 'excerpt' == $content ) :
                
                the_excerpt();
                
                if ( 0 != $read_more ) : ?>
                    <a class="<?php if ( 'button' == $readmore_type ) echo esc_attr( $readmore_type ); ?> read-more" href="<?php the_permalink(); ?>">
                        <?php
                            if ( '' != $readmore_label ) :
                                echo esc_html( $readmore_label );
                            else:
                                esc_html_e( 'Continue Reading', 'ef-practical' );
                            endif;
                        ?>
                         <i class="fa fa-angle-right"></i></a>
                <?php
                endif;
                
            else :
                
                the_content();
                
                //Checks for and uses wp_pagenavi to display page navigation for multi-page posts.
                if ( function_exists( 'wp_pagenavi' ) )
                    wp_pagenavi( array( 'type' => 'multipart' ) );
                else
                    practical_link_pages();
                    
            endif;
            
        endif;
    ?>
</div>