<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Ef Practical
 */

$thumbnail = get_theme_mod( 'practical_search_results_featured_img', 'above' );

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    
    <?php
        if ( has_post_thumbnail() && 'hide' != $thumbnail ) :
           if ( 'beside' == $thumbnail ) { echo '<div class="small-featured-img">'; }
           get_template_part( '/template-parts/entry/entry-thumbnail' );
           if ( 'beside' == $thumbnail ) { echo '</div>'; }
        endif;
    ?>
    
    <div class="blog-post-body">
        <?php get_template_part( '/template-parts/entry/entry-header' ); ?>
        
        <?php
            if ( 'post' == get_post_type() ) :
                get_template_part( '/template-parts/entry/entry-meta' );
            endif;
        ?>
        
        <?php get_template_part( '/template-parts/entry/entry-content' ); ?>
        
        <?php
            if ( 'post' == get_post_type() ) :
                get_template_part( '/template-parts/entry/entry-footer' );
            endif;
        ?>
    </div>
    
</article><!-- #post- -->