<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Ef Practical
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    
    <?php
        if ( has_post_thumbnail() ) :
            get_template_part( '/template-parts/entry/entry-thumbnail' );
        endif;
    ?>
    
    <?php if ( 0 != get_theme_mod( 'practical_page_entry_title', 0 ) ) : ?>
        <?php get_template_part( '/template-parts/entry/entry-header' ); ?>
    <?php endif; ?>
    
    <?php get_template_part( '/template-parts/entry/entry-content' ); ?>
    
    <?php
        if ( 0 == get_theme_mod( 'practical_page_edit_link', 0 ) ) :
            edit_post_link( esc_html__( 'Edit Page', 'ef-practical' ), '<span class="edit-link cf">', '</span>' );
        endif;
    ?>
    
</article><!-- #post -->
